/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XString;
import com.neeve.lang.XStringIterator;
import com.neeve.quark.QuarkBuffer;
import com.neeve.quark.QuarkString;
import com.neeve.quark.QuarkStringArrayDeserializer;
import com.neeve.quark.QuarkStringIterator;
import java.util.NoSuchElementException;

public final class XStringSequence
implements QuarkStringIterator {
    private static final byte FLG_INITIALIZED = 1;
    private static final byte FLG_OWNED = 2;
    private byte _flags;
    private long _addr;
    private int _offset;
    private int _len;
    private int _index;

    private XStringSequence() {
    }

    public static final XStringSequence create() {
        return new XStringSequence();
    }

    private final XStringSequence setInitialized(boolean val) {
        this._flags = val ? (byte)(this._flags | 1) : (byte)(this._flags & 0xFFFFFFFE);
        return this;
    }

    public final boolean isInitialized() {
        return (this._flags & 1) != 0;
    }

    private final XStringSequence setOwned(boolean val) {
        this._flags = val ? (byte)(this._flags | 2) : (byte)(this._flags & 0xFFFFFFFD);
        return this;
    }

    public final boolean isOwned() {
        return (this._flags & 2) != 0;
    }

    public QuarkStringIterator toFirst() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        this._index = 0;
        return this;
    }

    public final boolean hasNext() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._index < this._len;
    }

    public final String next() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        StringBuilder sb = new StringBuilder();
        int len = QuarkBuffer.getShort((long)this._addr, (int)this._index);
        short strSerializedLength = (short)(len + 2);
        for (int i = 0; i < len; ++i) {
            sb.append((char)QuarkBuffer.getByte((long)this._addr, (int)(this._index + 2 + i)));
        }
        this._index += strSerializedLength;
        return sb.toString();
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public final int nextLength(boolean advance) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        short len = QuarkBuffer.getShort((long)this._addr, (int)this._index);
        if (advance) {
            short strSerializedLength = (short)(len + 2);
            this._index += strSerializedLength;
        }
        return len;
    }

    public final int nextLength() {
        return this.nextLength(true);
    }

    public final void nextInto(XString to) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        short len = QuarkBuffer.getShort((long)this._addr, (int)this._index);
        short strSerializedLength = (short)(len + 2);
        to.setValueFromMemory(this._addr + (long)this._index + 2L, (int)len);
        this._index += strSerializedLength;
    }

    public final short nextInto(QuarkString to) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        short len = QuarkBuffer.getShort((long)this._addr, (int)this._index);
        short strSerializedLength = (short)(len + 2);
        to.setFrom(this._addr, this._index + 2, (int)len);
        this._index += strSerializedLength;
        return strSerializedLength;
    }

    public final short nextInto(long addr, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._len) {
            throw new NoSuchElementException("no more elements");
        }
        short len = QuarkBuffer.getShort((long)this._addr, (int)this._index);
        short strSerializedLength = (short)(len + 2);
        QuarkBuffer.copy((long)this._addr, (int)(this._index + 2), (long)addr, (int)offset, (int)len);
        this._index += strSerializedLength;
        return strSerializedLength;
    }

    public final XStringSequence wrap(long addr, int offset, int len) {
        this.reset();
        this._addr = addr;
        this._offset = offset;
        this._len = len;
        this._index = 0;
        this.setInitialized(true).setOwned(false);
        return this;
    }

    public final XStringSequence wrap(QuarkBuffer buffer, int offset, int len) {
        return this.wrap(buffer.getNativeAddress(), offset, len);
    }

    public final XStringSequence setFrom(long addr, int offset, int len) {
        this.reset();
        this._addr = QuarkBuffer.allocateMemoryBlock((long)len, (boolean)false);
        QuarkBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)0, (int)len);
        this._len = len;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XStringSequence setFrom(QuarkBuffer buffer, int offset, int len) {
        this.reset();
        this._addr = QuarkBuffer.allocateMemoryBlock((long)len, (boolean)false);
        QuarkBuffer.copy((long)buffer.getNativeAddress(), (int)offset, (long)this._addr, (int)0, (int)len);
        this._len = len;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XStringSequence setFrom(XStringSequence sequence) {
        this.reset();
        if (sequence.isInitialized()) {
            int serializedLength = sequence.serializedLength();
            this._addr = QuarkBuffer.allocateMemoryBlock((long)serializedLength, (boolean)false);
            QuarkBuffer.copy((long)sequence._addr, (int)0, (long)this._addr, (int)0, (int)serializedLength);
            this._len = sequence.serializedLength();
            this._offset = 0;
            this._index = 0;
            this.setInitialized(true).setOwned(true);
        }
        return this;
    }

    public final XStringSequence setFrom(XStringIterator iterator) {
        this.reset();
        if (iterator instanceof XStringSequence) {
            return this.setFrom((XStringSequence)iterator);
        }
        if (!(iterator instanceof QuarkStringArrayDeserializer)) {
            throw new IllegalArgumentException("iterator implementations other than XStringSequence and QuarkStringArrayDeserializer are not currently supported");
        }
        QuarkStringArrayDeserializer deserializer = (QuarkStringArrayDeserializer)iterator;
        this._addr = QuarkBuffer.allocateMemoryBlock((long)deserializer.serializedLength(), (boolean)false);
        deserializer.getTo(this._addr, 0);
        this._len = deserializer.serializedLength();
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final int serializedLength() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._len;
    }

    public final int getTo(byte[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        QuarkBuffer.getTo((long)this._addr, (int)this._offset, (byte[])val, (int)offset, (int)this._len);
        return this._len;
    }

    public final int getTo(long addr, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        QuarkBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
        return this._len;
    }

    public final int getTo(QuarkBuffer val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        val.putFrom(offset, this._addr, this._offset, this._len);
        return this._len;
    }

    public final QuarkStringIterator iterator() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this.toFirst();
    }

    public final XStringSequence reset() {
        if (this.isInitialized()) {
            if (this.isOwned() && this._addr != 0L) {
                QuarkBuffer.freeMemoryBlock((long)this._addr, (long)this.serializedLength());
            }
            this.setInitialized(false);
        }
        return this;
    }
}

