/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit;

import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmFactoryType;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmModelImport;
import com.neeve.adm.AdmPooledString;
import com.neeve.adm.AdmXMLParser;
import com.neeve.adm.EAdmException;
import com.neeve.build.codegen.CgCodeSource;
import com.neeve.build.codegen.CgResourceChangeTracker;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.ci.XRuntime;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlText;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AdmXMLParserTest
extends UnitTest {
    private static File testSoureDir = null;
    private static final ProductInfo productInfo = ManifestProductInfo.loadProductInfo((String)"nvx-rumi-adm");

    @BeforeClass
    public static void setup() throws IOException {
        testSoureDir = new File(AdmXMLParserTest.getProjectBaseDirectory(), "test/java/" + AdmXMLParserTest.class.getPackage().getName().replace(".", "/")).getCanonicalFile();
    }

    @Test
    public void testFullModelParse() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("full_model.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        Assert.assertNull((String)"Default factory should be null in model", (Object)((Object)model.getDefaultFactory()));
    }

    @Test
    public void testXMLParseAttachesSrcInfo() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("full_model.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        CgCodeSource modelSource = model.getCodeSource();
        Assert.assertNotNull((Object)modelSource);
        Assert.assertNotNull((Object)modelSource.getUrl());
        Assert.assertEquals((long)1L, (long)modelSource.getLine());
        Assert.assertEquals((long)1L, (long)modelSource.getColumnStart());
        Assert.assertEquals((long)model.getFactories().size(), (long)1L);
        AdmFactory factory = model.getFactories().iterator().next();
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 5, 42), (Object)factory.getCodeSource());
        Assert.assertEquals((long)4L, (long)model.getEnumerationCount());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 27, 50), (Object)model.getEnumeration("CharEnumeration").getCodeSource());
        Assert.assertEquals((long)3L, (long)model.getSemanticTypeCount());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 51, 81), (Object)model.getSemanticType("SocialSecurityNumber").getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 52, 28), (Object)model.getSemanticType("SocialSecurityNumber").getDocumentation().getCodeSource());
        Assert.assertEquals((long)43L, (long)model.getFieldCount());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 316, 90), (Object)model.lookupField("ssn", true).getField().getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 317, 28), (Object)model.lookupField("ssn", true).getField().getDocumentation().getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 307, 43), (Object)model.lookupField("deprecatedByteField", true).getField().getDeprecation().getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 311, 28), (Object)model.lookupField("deprecatedByteField", true).getField().getDocumentation().getCodeSource());
        Assert.assertEquals((long)4L, (long)model.getMessageCount());
        AdmMessage msg = model.getMessage("Message");
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 325, 54), (Object)msg.getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 326, 28), (Object)msg.getDocumentation().getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 336, 98), (Object)msg.getField("booleanArrayField").getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 360, 91), (Object)msg.getField("ssn").getCodeSource());
        AdmEntity entity = model.getEntity("Parent");
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 535, 69), (Object)entity.getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 536, 93), (Object)entity.getField("fixlenField").getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 536, 93), (Object)entity.getField("fixlenField").getDocumentation().getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 542, 91), (Object)entity.getField("ssn").getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 542, 91), (Object)entity.getField("ssn").getDocumentation().getCodeSource());
        Assert.assertEquals((long)10L, (long)model.getCollectionCount());
        AdmCollection collection = model.getCollection("ChildLongMap");
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 746, 60), (Object)collection.getCodeSource());
        Assert.assertEquals((Object)new CgCodeSource(modelSource.getUrl(), 746, 60), (Object)collection.getDocumentation().getCodeSource());
    }

    @Test
    public void testParseErrorFormat() {
        try {
            this.parseModel("unknown_type.xml");
            Assert.fail((String)"parsing should have generated error");
        }
        catch (EAdmException ex) {
            String expected = "unknown type";
            Assert.assertTrue((String)("Expected exception to contain: '" + expected + "' but was '" + ex.getMessage()), (ex.getMessage().indexOf(expected) >= 0 ? 1 : 0) != 0);
            if (!ex.getCodeSource().toString().endsWith("/unknown_type.xml [14:74]")) {
                Assert.fail((String)("Wrong source code info " + ex.getCodeSource()));
            }
        }
        catch (Throwable ex) {
            Assert.fail((String)("Parsing generated wrong type of error " + ex.getMessage()));
        }
    }

    @Test
    public void testNamespaceParseErrorFormat() {
        try {
            this.parseModel("malformed_namespace.xml");
            Assert.fail((String)"parsing should have generated error");
        }
        catch (EAdmException ex) {
            this.assertErrorInAggregatedErrors(ex.getAggregatedErrors(), "Ensure that model's target XML namespace is as required by ADM XSD schema.", "malformed_namespace.xml", 3, 52);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            Assert.fail((String)("Parsing generated wrong type of error: " + ex.getMessage()));
        }
    }

    @Test
    public void testModelFieldOrdering() throws IOException, EAdmException {
        AdmEntity.FieldOrderingPolicy policy3;
        int n;
        AdmModel model = this.parseModel("full_model.xml");
        for (AdmEntity admEntity : model.getEntities()) {
            for (AdmEntity.FieldOrderingPolicy policy2 : AdmEntity.FieldOrderingPolicy.values()) {
                AdmXMLParserTest.verifyFieldSort(admEntity, policy2);
            }
        }
        for (AdmEntity admEntity : model.getMessages()) {
            for (AdmEntity.FieldOrderingPolicy policy2 : AdmEntity.FieldOrderingPolicy.values()) {
                AdmXMLParserTest.verifyFieldSort(admEntity, policy2);
            }
        }
        HashMap<String, String> apexDirectives = new HashMap<String, String>();
        apexDirectives.put("apexStyle", "true");
        apexDirectives.put("generateAllStringsPoolable", "true");
        URL uRL = ((Object)((Object)this)).getClass().getResource("full_model.xml");
        model = AdmXMLParser.parse(uRL, null, null, apexDirectives, null);
        for (AdmEntity admEntity : model.getEntities()) {
            AdmEntity.FieldOrderingPolicy[] fieldOrderingPolicyArray = AdmEntity.FieldOrderingPolicy.values();
            int n2 = fieldOrderingPolicyArray.length;
            for (n = 0; n < n2; ++n) {
                AdmEntity.FieldOrderingPolicy policy3 = fieldOrderingPolicyArray[n];
                AdmXMLParserTest.verifyFieldSort(admEntity, policy3);
            }
        }
        for (AdmEntity admEntity : model.getMessages()) {
            AdmEntity.FieldOrderingPolicy[] fieldOrderingPolicyArray = AdmEntity.FieldOrderingPolicy.values();
            int n3 = fieldOrderingPolicyArray.length;
            for (n = 0; n < n3; ++n) {
                policy3 = fieldOrderingPolicyArray[n];
                AdmXMLParserTest.verifyFieldSort(admEntity, policy3);
            }
        }
        URL uRL2 = ((Object)((Object)this)).getClass().getResource("testFieldComparator.xml");
        model = AdmXMLParser.parse(uRL2, null, null, apexDirectives, null);
        model = this.parseModel("testFieldComparator.xml");
        for (AdmEntity admEntity : model.getEntities()) {
            AdmEntity.FieldOrderingPolicy[] fieldOrderingPolicyArray = AdmEntity.FieldOrderingPolicy.values();
            int n4 = fieldOrderingPolicyArray.length;
            for (n = 0; n < n4; ++n) {
                policy3 = fieldOrderingPolicyArray[n];
                AdmXMLParserTest.verifyFieldSort(admEntity, policy3);
            }
        }
        for (AdmEntity admEntity : model.getMessages()) {
            for (AdmEntity.FieldOrderingPolicy policy3 : AdmEntity.FieldOrderingPolicy.values()) {
                AdmXMLParserTest.verifyFieldSort(admEntity, policy3);
            }
        }
    }

    private static final void verifyFieldSort(AdmEntity entity, AdmEntity.FieldOrderingPolicy policy) {
        try {
            ArrayList<AdmField> fields = new ArrayList<AdmField>(entity.fields().values());
            AdmGenerator.sortFields(policy, fields);
            Iterator<AdmField> sorted = fields.iterator();
            switch (policy) {
                case AsBuilt: {
                    for (AdmField field : entity.fields().values()) {
                        AdmField next = sorted.next();
                        Assert.assertSame((String)("Expected sorted field to be '" + field + "' but was '" + next + "' with ordering policy of " + (Object)((Object)policy)), (Object)field, (Object)next);
                    }
                    break;
                }
                case ByFieldId: {
                    AdmField last = null;
                    while (sorted.hasNext()) {
                        AdmField next = sorted.next();
                        if (last != null) {
                            Assert.assertTrue((String)("Detected field sorted by id out of order field '" + last + "' was before '" + next + "'!"), (last.getId() < next.getId() ? 1 : 0) != 0);
                        }
                        last = next;
                    }
                    break;
                }
                case FixedLengthFirst: {
                    AdmField last = null;
                    while (sorted.hasNext()) {
                        AdmField next = sorted.next();
                        if (last != null && !last.isFixedLength() && next.isFixedLength()) {
                            Assert.fail((String)("Detected fixed length field after a non fixed length field: '" + last + "' was before '" + next + "' with a field ordering policy of FixedLengthFirst!"));
                        }
                        last = next;
                    }
                    break;
                }
                case OptimizeForSpeed: {
                    AdmField last = null;
                    while (sorted.hasNext()) {
                        AdmField next = sorted.next();
                        if (last != null) {
                            if (!last.isPinned() && next.isPinned()) {
                                Assert.fail((String)("Detected pinned field after a non pinned field: '" + last + "' was before '" + next + "' with a field ordering policy of FixedLengthFirst!"));
                            }
                            if (!last.isFixedLength() && next.isFixedLength()) {
                                Assert.fail((String)("Detected fixed length field after a non fixed length field: '" + last + "' was before '" + next + "' with a field ordering policy of FixedLengthFirst!"));
                            }
                        }
                        last = next;
                    }
                    break;
                }
            }
        }
        catch (Throwable t) {
            entity.getModel().dump();
            throw new RuntimeException("Failed to sort fields for entity: " + (Object)((Object)entity) + ": " + t.getMessage(), t);
        }
    }

    @Test
    public void testFieldRefImports() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("test_imported_fieldrefs.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
    }

    @Test
    public void testFieldOrigin() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("field_origin_level_0.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmField field = model.getMessage("ImportingMessage").getField("enumField");
        Assert.assertNotNull((Object)((Object)field.getOriginModel()));
        Assert.assertEquals((Object)"field_origin_level_2", (Object)field.getOriginModel().getName());
        Assert.assertEquals((long)2L, (long)field.getImportPath().size());
        AdmModelImport level1 = field.getImportPath().get(0);
        Assert.assertEquals((Object)((Object)model), (Object)((Object)level1.getParentModel()));
        Assert.assertEquals((Object)"field_origin_level_1", (Object)level1.getModel().getName());
        Assert.assertEquals((Object)new CgCodeSource(level1.getParentModel().getCodeSource().getUrl(), 5, 48), (Object)level1.getCodeSource());
        AdmModelImport level2 = field.getImportPath().get(1);
        Assert.assertEquals((Object)((Object)level1.getModel()), (Object)((Object)level2.getParentModel()));
        Assert.assertEquals((Object)"field_origin_level_2", (Object)level2.getModel().getName());
        Assert.assertEquals((Object)new CgCodeSource(level2.getParentModel().getCodeSource().getUrl(), 6, 48), (Object)level2.getCodeSource());
    }

    @Test
    public void testAmbiguousFieldNameImports() throws IOException, EAdmException {
        boolean exception = false;
        try {
            AdmModel model = this.parseModel("ambiguous_field_name_import_level_0.xml");
            StringBuilder sb = new StringBuilder();
            if (!model.validateModel(sb)) {
                Assert.fail((String)("Model validation failed: " + sb.toString()));
            }
        }
        catch (EAdmException ex) {
            exception = true;
            String expected = "Field lookup error: Ambiguous field name resolution enumField found in: com.neeve.adm.test.unit.full_model, com.neeve.adm.test.unit.ambiguous_name_import_level_1";
            Assert.assertTrue((String)("Expected exception to contain: '" + expected + "' but was '" + ex.getMessage()), (ex.getMessage().indexOf(expected) >= 0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)ex.getCodeSource());
            Assert.assertEquals((long)24L, (long)ex.getCodeSource().getLine());
            Assert.assertEquals((long)90L, (long)ex.getCodeSource().getColumnStart());
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testAmbiguousTypeNameImports() throws IOException, EAdmException {
        boolean exception = false;
        try {
            AdmModel model = this.parseModel("ambiguous_type_name_import_level_0.xml");
            StringBuilder sb = new StringBuilder();
            if (!model.validateModel(sb)) {
                Assert.fail((String)("Model validation failed: " + sb.toString()));
            }
        }
        catch (EAdmException ex) {
            exception = true;
            String expected = "Type resolution error: Ambiguous type resolution 'Enumeration' found in : com.neeve.adm.test.unit.full_model, com.neeve.adm.test.unit.ambiguous_name_import_level_1";
            Assert.assertTrue((String)("Expected exception to contain: '" + expected + "' but was '" + ex.getMessage()), (ex.getMessage().indexOf(expected) >= 0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)ex.getCodeSource());
            Assert.assertEquals((long)17L, (long)ex.getCodeSource().getLine());
            Assert.assertEquals((long)63L, (long)ex.getCodeSource().getColumnStart());
        }
        Assert.assertTrue((String)"Expected parse to faile with exception", (boolean)exception);
    }

    @Test
    public void testAmbiguousFieldAndTypeName() throws IOException, EAdmException {
        try {
            this.parseModel("ambiguous_field_and_type_name.xml");
        }
        catch (EAdmException ex) {
            String expected = "pooled string type name of 'AlreadyUsedNameForType' for field 'AlreadyUsedNameForType' defined in <fields> conflicts with an already defined type 'com.neeve.importingmodel.AlreadyUsedNameForType'";
            Assert.assertTrue((String)("Expected excpeption to contain: '" + expected + "' but was '" + ex.getMessage()), (ex.getMessage().indexOf(expected) >= 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Wrong exception type" + ex.getMessage()));
        }
    }

    @Test
    public void testUnambiguousTypeNameImports() throws IOException, EAdmException {
        try {
            AdmModel model = this.parseModel("unambiguous_name_import_level_0.xml");
            StringBuilder sb = new StringBuilder();
            if (!model.validateModel(sb)) {
                Assert.fail((String)("Model validation failed: " + sb.toString()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testUnambiguousNameResolutionWithLocalPrecedence() throws IOException, EAdmException {
        try {
            AdmModel model = this.parseModel("unambiguous_name_local_precedence_import_level_0.xml");
            StringBuilder sb = new StringBuilder();
            if (!model.validateModel(sb)) {
                Assert.fail((String)("Model validation failed: " + sb.toString()));
            }
            AdmMessage msg1 = model.getMessage("ImportingMessage");
            Assert.assertEquals((Object)"level_0", (Object)msg1.getField("inlineEntityField").getDocumentation().getBrief());
            Assert.assertEquals((Object)"level_0", (Object)msg1.getField("semanticTypedField").getType().getDocumentation().getBrief());
            Assert.assertEquals((Object)"level_0", (Object)msg1.getField("embeddedEntityField").getType().getDocumentation().getBrief());
            AdmMessage msg2 = model.getMessage("ImportingMessage2");
            Assert.assertEquals((Object)"level_0", (Object)msg2.getField("semanticField").getDocumentation().getBrief());
            Assert.assertEquals((Object)"level_0", (Object)msg2.getField("embeddedEntityField").getDocumentation().getBrief());
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testUnambiguousNameResolutionWithFullNamePrecedence() throws IOException, EAdmException {
        try {
            AdmModel model = this.parseModel("unambiguous_name_full_name_import_precedence_import_level_0.xml");
            StringBuilder sb = new StringBuilder();
            if (!model.validateModel(sb)) {
                Assert.fail((String)("Model validation failed: " + sb.toString()));
            }
            AdmMessage msg1 = model.getMessage("ImportingMessage");
            Assert.assertEquals((Object)"level_1", (Object)msg1.getField("inlineEntityField").getDocumentation().getBrief());
            Assert.assertEquals((Object)"level_1", (Object)msg1.getField("semanticTypedField").getType().getDocumentation().getBrief());
            Assert.assertEquals((Object)"level_1", (Object)msg1.getField("embeddedEntityField").getType().getDocumentation().getBrief());
            AdmMessage msg2 = model.getMessage("ImportingMessage2");
            Assert.assertEquals((Object)"level_1", (Object)msg2.getField("semanticField").getDocumentation().getBrief());
            Assert.assertEquals((Object)"level_1", (Object)msg2.getField("embeddedEntityField").getDocumentation().getBrief());
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testMessageFieldInlining() throws IOException, EAdmException {
        try {
            AdmModel model = this.parseModel("test_message_inlined_message_field.xml");
            StringBuilder sb = new StringBuilder();
            if (model.validateModel(sb)) {
                Assert.fail((String)"Model validation should have failed.");
            }
        }
        catch (EAdmException ex) {
            if (!ex.getCodeSource().toString().endsWith("test_message_inlined_message_field.xml [59:62]")) {
                Assert.fail((String)("Wrong source code info " + ex.getCodeSource()));
            }
            String expected = "'InliningMessage' can't inline type 'Message', only embedded entities can be inlined.";
            Assert.assertTrue((String)("Expected exception to contain: '" + expected + "' but was '" + ex.getMessage()), (ex.getMessage().indexOf(expected) >= 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testEntityFieldInlining() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("test_entity_inlined_field.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmEntity importedEnitity = (AdmEntity)model.lookupType("com.neeve.adm.test.unit.Child2", false);
        AdmEntity importedImportingEntity = (AdmEntity)model.lookupType("com.neeve.importingmodel.ImportingChild2", false);
        AdmEntity localEntity = (AdmEntity)model.lookupType("Child2", true);
        AdmEntity inliningEntity = (AdmEntity)model.lookupType("InliningChild1", true);
        this.assertHasFields(importedEnitity, inliningEntity);
        this.assertHasFields(importedImportingEntity, inliningEntity);
        this.assertHasFields(localEntity, inliningEntity);
        Assert.assertTrue((String)"intField should be key", (boolean)inliningEntity.getField("intField").isKey());
        Assert.assertTrue((String)"intField should be pinned", (boolean)inliningEntity.getField("intField").isPinned());
        Assert.assertFalse((String)"intField should not be required", (boolean)inliningEntity.getField("intField").isRequired());
        Assert.assertTrue((String)"longField should be required", (boolean)inliningEntity.getField("longField").isRequired());
        Assert.assertFalse((String)"longField should not be pinned", (boolean)inliningEntity.getField("longField").isPinned());
        Assert.assertFalse((String)"longField should not be key", (boolean)inliningEntity.getField("longField").isKey());
    }

    @Test
    public void testEmbeddedEntityFieldInlining() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("test_entity_inlined_field.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmEntity importedEnitity = (AdmEntity)model.lookupType("com.neeve.adm.test.unit.Child2", false);
        AdmEntity importedImportingEntity = (AdmEntity)model.lookupType("com.neeve.importingmodel.ImportingChild2", false);
        AdmEntity localEntity = (AdmEntity)model.lookupType("Child2", true);
        AdmEntity inliningEntity = (AdmEntity)model.lookupType("InliningChild2", true);
        this.assertHasFields(importedEnitity, inliningEntity);
        this.assertHasFields(importedImportingEntity, inliningEntity);
        this.assertHasFields(localEntity, inliningEntity);
        Assert.assertTrue((String)"intField should be key", (boolean)inliningEntity.getField("intField").isKey());
        Assert.assertTrue((String)"intField should be pinned", (boolean)inliningEntity.getField("intField").isPinned());
        Assert.assertFalse((String)"intField should not be required", (boolean)inliningEntity.getField("intField").isRequired());
        Assert.assertTrue((String)"longField should be required", (boolean)inliningEntity.getField("longField").isRequired());
        Assert.assertFalse((String)"longField should not be pinned", (boolean)inliningEntity.getField("longField").isPinned());
        Assert.assertFalse((String)"longField should not be key", (boolean)inliningEntity.getField("longField").isKey());
    }

    private void assertHasFields(AdmEntity inlined, AdmEntity inliner) {
        inliner.fields().keySet().containsAll(inlined.fields().keySet());
    }

    @Test
    public void testCyclicFieldError() throws IOException {
        block3: {
            try {
                this.parseModel("testCyclicFieldError.xml");
                Assert.fail((String)"Modle shouldn't have parsed successfully ... expected cyclic field cycle error");
            }
            catch (EAdmException e) {
                if (e.getMessage().toLowerCase().indexOf("cycle") == -1) {
                    e.printStackTrace();
                    Assert.fail((String)("Didn't get expected cycle detected exception, instead got " + e.getMessage()));
                }
                if (!AdmXMLParserTest.verbose()) break block3;
                System.out.println("GOT EXPECTED PARSER EXCEPTION:\n" + UtlThrowable.prepareStackTrace((Throwable)((Object)e)));
            }
        }
    }

    @Test
    public void testCyclicFieldReferenceError() throws IOException {
        block3: {
            try {
                this.parseModel("testCyclicFieldReferenceError.xml");
                Assert.fail((String)"Modle shouldn't have parsed successfully ... expected cyclic field cycle error");
            }
            catch (EAdmException e) {
                if (e.getMessage().toLowerCase().indexOf("cycle") == -1) {
                    e.printStackTrace();
                    Assert.fail((String)("Didn't get expected cycle detected excpetion, instead got " + e.getMessage()));
                }
                if (!AdmXMLParserTest.verbose()) break block3;
                System.out.println("GOT EXPECTED PARSER EXCEPTION:\n" + UtlThrowable.prepareStackTrace((Throwable)((Object)e)));
            }
        }
    }

    @Test
    public void testEntityFieldIdConflict() throws IOException, EAdmException {
        AdmModel model = this.parseModel("testEntityFieldIdConflict.xml");
        StringBuilder sb = new StringBuilder();
        CgSourceCodeErrorAggregator errorAggregator = new CgSourceCodeErrorAggregator();
        Assert.assertFalse((String)"Model should have detected field id conflict", (boolean)model.validateModel(sb, errorAggregator));
        this.assertErrorInAggregatedErrors(errorAggregator, "fields 'IntField2' and 'IntField' both have a field id of '1'", "testEntityFieldIdConflict.xml", 12, 60);
    }

    @Test
    public void testMessageFieldIdConflict() throws IOException, EAdmException {
        AdmModel model = this.parseModel("testMessageFieldIdConflict.xml");
        StringBuilder sb = new StringBuilder();
        CgSourceCodeErrorAggregator errorAggregator = new CgSourceCodeErrorAggregator();
        Assert.assertFalse((String)"Model should have detected field id conflict", (boolean)model.validateModel(sb, errorAggregator));
        this.assertErrorInAggregatedErrors(errorAggregator, "fields 'IntField2' and 'IntField' both have a field id of '1'", "testMessageFieldIdConflict.xml", 12, 60);
    }

    @Test
    public void testMessageRefFieldIdConflict() throws IOException, EAdmException {
        AdmModel model = this.parseModel("testMessageRefFieldIdConflict.xml");
        StringBuilder sb = new StringBuilder();
        Assert.assertFalse((String)"Model should have detected field id conflict", (boolean)model.validateModel(sb));
        CgSourceCodeErrorAggregator aggregator = new CgSourceCodeErrorAggregator();
        model.validateModel(sb, aggregator);
        this.assertErrorInAggregatedErrors(aggregator, "Conflict", "testMessageRefFieldIdConflict.xml", 16, 56);
    }

    @Test
    public void testMissingDefaultFactory() throws IOException, EAdmException {
        block3: {
            try {
                this.parseModel("testMissingDefaultFactory.xml");
                Assert.fail((String)"Model shouldn't have parsed successfully ... expected missing default factory error");
            }
            catch (EAdmException e) {
                if (e.getMessage().indexOf("no defaultFactoryId") == -1) {
                    e.printStackTrace();
                    Assert.fail((String)("Didn't get expected no defaultFactoryId excpetion, instead got " + e.getMessage()));
                }
                if (!AdmXMLParserTest.verbose()) break block3;
                System.out.println("GOT EXPECTED PARSER EXCEPTION:\n" + UtlThrowable.prepareStackTrace((Throwable)((Object)e)));
            }
        }
    }

    @Test
    public void testModelDefaultFactory() throws Exception {
        StringBuilder sb;
        AdmModel model = this.parseModel("testModelDefaultFactory.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        Assert.assertNotNull((String)"Default factory should not be null in model", (Object)((Object)model.getDefaultFactory()));
        Assert.assertEquals((String)"Default factory has wrong id in model", (long)1L, (long)model.getDefaultFactory().getId());
        Assert.assertEquals((String)"Default factory has wrong name in model", (Object)"DefaultFactoryTestFactory", (Object)model.getDefaultFactory().getName());
        String[] factoryNames = new String[]{"DefaultFactoryTestFactory", "Factory2", "Factory3"};
        for (int i = 1; i <= 3; ++i) {
            AdmFactory factory = model.getFactoryLocal(factoryNames[i - 1]);
            Assert.assertNotNull((String)(factoryNames[i - 1] + " not created"), (Object)((Object)factory));
            this.verifyInFactory(model, factory, "Message" + i);
            this.verifyInFactory(model, factory, "Entity" + i);
            this.verifyInFactory(model, factory, "EmbeddedEntity" + i);
            this.verifyInFactory(model, factory, "Collection" + i);
        }
    }

    @Test
    public void testDefaultFactoryId() throws Exception {
        StringBuilder sb;
        AdmModel model = this.parseModel("testDefaultFactoryId.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        Assert.assertNotNull((String)"Default factory should not be null in model", (Object)((Object)model.getDefaultFactory()));
        Assert.assertEquals((String)"Default factory has wrong id in model", (long)1L, (long)model.getDefaultFactory().getId());
        Assert.assertEquals((String)"Default factory has wrong name in model", (Object)"Factory1", (Object)model.getDefaultFactory().getName());
        String[] factoryNames = new String[]{"Factory1", "Factory2", "Factory3"};
        for (int i = 1; i <= 3; ++i) {
            AdmFactory factory = model.getFactoryLocal(factoryNames[i - 1]);
            Assert.assertNotNull((String)(factoryNames[i - 1] + " not created"), (Object)((Object)factory));
            this.verifyInFactory(model, factory, "Message" + i);
            this.verifyInFactory(model, factory, "Entity" + i);
            this.verifyInFactory(model, factory, "EmbeddedEntity" + i);
            this.verifyInFactory(model, factory, "Collection" + i);
        }
    }

    @Test
    public void testEnumDeprecation() throws IOException, EAdmException {
        AdmEnumeration.ConstEntry constEntry;
        StringBuilder sb;
        AdmModel model = this.parseModel("deprecationTestModel.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmEnumeration enumeration = model.getEnumeration("CharEnumeration");
        Assert.assertTrue((String)(enumeration.getName() + " should have been deprecated."), (boolean)enumeration.isDeprecated());
        Assert.assertNotNull((String)(enumeration.getName() + " should have a deprecation element."), (Object)((Object)enumeration.getDeprecation()));
        Assert.assertEquals((String)(enumeration.getName() + " Wrong deprecated since"), (Object)"1.5 Beta", (Object)enumeration.getDeprecation().getSince());
        Assert.assertEquals((String)(enumeration.getName() + " Wrong deprecated reason"), (Object)"This has been deprecated for test purposes", (Object)UtlText.removeLineBreaks((String)enumeration.getDeprecation().getReason()).trim());
        Iterator<AdmEnumeration.ConstEntry> constIterator = enumeration.constIterator();
        while (constIterator.hasNext()) {
            constEntry = constIterator.next();
            Assert.assertFalse((String)(enumeration.getName() + "." + constEntry.name + " should not have been deprecated."), (boolean)constEntry.isDeprecated());
            Assert.assertNull((String)(enumeration.getName() + "." + constEntry.name + " should not have a deprecation element."), (Object)((Object)constEntry.getDeprecation()));
        }
        enumeration = model.getEnumeration("IntEnumeration");
        Assert.assertFalse((String)(enumeration.getName() + " should not have been deprecated."), (boolean)enumeration.isDeprecated());
        Assert.assertNull((String)(enumeration.getName() + " should not have been deprecated."), (Object)((Object)enumeration.getDeprecation()));
        constIterator = enumeration.constIterator();
        while (constIterator.hasNext()) {
            constEntry = constIterator.next();
            Assert.assertFalse((String)(enumeration.getName() + "." + constEntry.name + " should not have been deprecated."), (boolean)constEntry.isDeprecated());
            Assert.assertNull((String)(enumeration.getName() + "." + constEntry.name + " should not have a deprecation element."), (Object)((Object)constEntry.getDeprecation()));
        }
        enumeration = model.getEnumeration("Enumeration");
        Assert.assertFalse((String)(enumeration.getName() + " should not have been deprecated."), (boolean)enumeration.isDeprecated());
        Assert.assertNull((String)(enumeration.getName() + " should not have been deprecated."), (Object)((Object)enumeration.getDeprecation()));
        constIterator = enumeration.constIterator();
        while (constIterator.hasNext()) {
            constEntry = constIterator.next();
            if (constEntry.name.equals("Value2")) {
                Assert.assertTrue((String)(enumeration.getName() + "." + constEntry.name + " should have been deprecated."), (boolean)constEntry.isDeprecated());
                Assert.assertNotNull((String)(enumeration.getName() + "." + constEntry.name + " should have a deprecation element."), (Object)((Object)constEntry.getDeprecation()));
                Assert.assertEquals((String)(enumeration.getName() + "." + constEntry.name + " Wrong deprecated since"), (Object)"1.5 Beta", (Object)constEntry.getDeprecation().getSince());
                Assert.assertEquals((String)(enumeration.getName() + "." + constEntry.name + " Wrong deprecated reason"), (Object)"This has been deprecated for test purposes", (Object)UtlText.removeLineBreaks((String)constEntry.getDeprecation().getReason()).trim());
                continue;
            }
            Assert.assertFalse((String)(enumeration.getName() + "." + constEntry.name + " should not have been deprecated."), (boolean)constEntry.isDeprecated());
            Assert.assertNull((String)(enumeration.getName() + "." + constEntry.name + " should not have a deprecation element."), (Object)((Object)constEntry.getDeprecation()));
        }
    }

    @Test
    public void testFieldsDeprecation() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("deprecationTestModel.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmField field = model.lookupField("byteField", true).getField();
        Assert.assertTrue((String)(field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
        Assert.assertNotNull((String)(field.getName() + " should have a deprecation element."), (Object)((Object)field.getDeprecation()));
        Assert.assertEquals((String)(field.getName() + " Wrong deprecated since"), null, (Object)field.getDeprecation().getSince());
        Assert.assertEquals((String)(field.getName() + " Wrong deprecated reason"), (Object)"Deprecated for test purposes with multiple lines that should be converted to a single line", (Object)UtlText.removeLineBreaks((String)field.getDeprecation().getReason()).trim());
    }

    @Test
    public void testFactoryDeprecation() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("deprecationTestModel.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmFactory factory = model.getFactoryLocal("DeprecatedFactory");
        Assert.assertTrue((String)(factory.getName() + " should have been deprecated."), (boolean)factory.isDeprecated());
        Assert.assertNotNull((String)(factory.getName() + " should have a deprecation element."), (Object)((Object)factory.getDeprecation()));
        Assert.assertEquals((String)(factory.getName() + " Wrong deprecated since"), (Object)"1.5 Beta", (Object)factory.getDeprecation().getSince());
        Assert.assertEquals((String)(factory.getName() + " Wrong deprecated reason"), (Object)"This has been deprecated for test purposes", (Object)UtlText.removeLineBreaks((String)factory.getDeprecation().getReason()).trim());
        factory = model.getFactoryLocal("Factory");
        Assert.assertFalse((String)(factory.getName() + " should have been deprecated."), (boolean)factory.isDeprecated());
        Assert.assertNull((String)(factory.getName() + " should have a deprecation element."), (Object)((Object)factory.getDeprecation()));
    }

    @Test
    public void testMessageDeprecation() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("deprecationTestModel.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmMessage message = model.getMessage("MessageWithEnumArrayField");
        Assert.assertFalse((String)(message.getName() + " should not have been deprecated."), (boolean)message.isDeprecated());
        Assert.assertNull((String)(message.getName() + " should not have a deprecation element."), (Object)((Object)message.getDeprecation()));
        for (AdmField field : message.fields().values()) {
            if (field.getName().equals("charEnumField") || field.getName().equals("charEnumArrayField")) {
                Assert.assertTrue((String)(message.getName() + "." + field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
                continue;
            }
            Assert.assertFalse((String)(message.getName() + "." + field.getName() + " should not have been deprecated."), (boolean)field.isDeprecated());
            Assert.assertNull((String)(message.getName() + "." + field.getName() + " should not have a deprecation element."), (Object)((Object)field.getDeprecation()));
        }
        message = model.getMessage("MessageWithFieldRefs");
        Assert.assertTrue((String)(message.getName() + " should have been deprecated."), (boolean)message.isDeprecated());
        Assert.assertNotNull((String)(message.getName() + " should have a deprecation element."), (Object)((Object)message.getDeprecation()));
        Assert.assertEquals((String)(message.getName() + " Wrong deprecated since"), (Object)"1.5 Beta", (Object)message.getDeprecation().getSince());
        Assert.assertEquals((String)(message.getName() + " Wrong deprecated reason"), (Object)"This has been deprecated for test purposes", (Object)UtlText.removeLineBreaks((String)message.getDeprecation().getReason()).trim());
        for (AdmField field : message.fields().values()) {
            if (field.getName().equals("charEnumField") || field.getName().equals("charEnumArrayField")) {
                Assert.assertTrue((String)(message.getName() + "." + field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
                continue;
            }
            if (field.getName().equals("byteField")) {
                Assert.assertTrue((String)(message.getName() + "." + field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
                Assert.assertNotNull((String)(message.getName() + "." + field.getName() + " should have a deprecation element."), (Object)((Object)field.getDeprecation()));
                Assert.assertEquals((String)(message.getName() + field.getName() + " Wrong deprecated since"), (Object)"1.5.0", (Object)field.getDeprecation().getSince());
                Assert.assertEquals((String)(message.getName() + field.getName() + " Wrong deprecated reason"), (Object)"This should override the byte field deprecation.", (Object)UtlText.removeLineBreaks((String)field.getDeprecation().getReason()).trim());
                continue;
            }
            Assert.assertFalse((String)(message.getName() + "." + field.getName() + " should not have been deprecated."), (boolean)field.isDeprecated());
            Assert.assertNull((String)(message.getName() + "." + field.getName() + " should not have a deprecation element."), (Object)((Object)field.getDeprecation()));
        }
    }

    @Test
    public void testEntityDeprecation() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("deprecationTestModel.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmEntity entity = model.getEntity("Child1");
        Assert.assertFalse((String)(entity.getName() + " should not have been deprecated."), (boolean)entity.isDeprecated());
        Assert.assertNull((String)(entity.getName() + " should not have a deprecation element."), (Object)((Object)entity.getDeprecation()));
        for (AdmField field : entity.fields().values()) {
            if (field.getName().equals("charEnumField") || field.getName().equals("charEnumArrayField")) {
                Assert.assertTrue((String)(entity.getName() + "." + field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
                continue;
            }
            if (field.getName().equals("longMapField")) {
                Assert.assertTrue((String)(entity.getName() + "." + field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
                continue;
            }
            Assert.assertFalse((String)(entity.getName() + "." + field.getName() + " should not have been deprecated."), (boolean)field.isDeprecated());
            Assert.assertNull((String)(entity.getName() + "." + field.getName() + " should not have a deprecation element."), (Object)((Object)field.getDeprecation()));
        }
        entity = model.getEntity("Child1WithFieldRefs");
        Assert.assertTrue((String)(entity.getName() + " should have been deprecated."), (boolean)entity.isDeprecated());
        Assert.assertNotNull((String)(entity.getName() + " should have a deprecation element."), (Object)((Object)entity.getDeprecation()));
        Assert.assertEquals((String)(entity.getName() + " Wrong deprecated since"), (Object)"1.5 Beta", (Object)entity.getDeprecation().getSince());
        Assert.assertEquals((String)(entity.getName() + " Wrong deprecated reason"), (Object)"This has been deprecated for test purposes", (Object)UtlText.removeLineBreaks((String)entity.getDeprecation().getReason()).trim());
        for (AdmField field : entity.fields().values()) {
            if (field.getName().equals("charEnumField") || field.getName().equals("charEnumArrayField")) {
                Assert.assertTrue((String)(entity.getName() + "." + field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
                continue;
            }
            if (field.getName().equals("byteField")) {
                Assert.assertTrue((String)(entity.getName() + "." + field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
                Assert.assertNotNull((String)(entity.getName() + "." + field.getName() + " should have a deprecation element."), (Object)((Object)field.getDeprecation()));
                Assert.assertEquals((String)(entity.getName() + field.getName() + " Wrong deprecated since"), (Object)"1.5.0", (Object)field.getDeprecation().getSince());
                Assert.assertEquals((String)(entity.getName() + field.getName() + " Wrong deprecated reason"), (Object)"This should override the byte field deprecation.", (Object)UtlText.removeLineBreaks((String)field.getDeprecation().getReason()).trim());
                continue;
            }
            Assert.assertFalse((String)(entity.getName() + "." + field.getName() + " should not have been deprecated."), (boolean)field.isDeprecated());
            Assert.assertNull((String)(entity.getName() + "." + field.getName() + " should not have a deprecation element."), (Object)((Object)field.getDeprecation()));
        }
    }

    @Test
    public void testEmbeddedEntityDeprecation() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("deprecationTestModel.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmEntity entity = model.getEntity("Child2");
        Assert.assertFalse((String)(entity.getName() + " should not have been deprecated."), (boolean)entity.isDeprecated());
        Assert.assertNull((String)(entity.getName() + " should not have a deprecation element."), (Object)((Object)entity.getDeprecation()));
        for (AdmField field : entity.fields().values()) {
            if (field.getName().equals("charEnumField") || field.getName().equals("charEnumArrayField")) {
                Assert.assertTrue((String)(entity.getName() + "." + field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
                continue;
            }
            Assert.assertFalse((String)(entity.getName() + "." + field.getName() + " should not have been deprecated."), (boolean)field.isDeprecated());
            Assert.assertNull((String)(entity.getName() + "." + field.getName() + " should not have a deprecation element."), (Object)((Object)field.getDeprecation()));
        }
        entity = model.getEntity("Child2WithFieldRefs");
        Assert.assertTrue((String)(entity.getName() + " should have been deprecated."), (boolean)entity.isDeprecated());
        Assert.assertNotNull((String)(entity.getName() + " should have a deprecation element."), (Object)((Object)entity.getDeprecation()));
        Assert.assertEquals((String)(entity.getName() + " Wrong deprecated since"), (Object)"1.5 Beta", (Object)entity.getDeprecation().getSince());
        Assert.assertEquals((String)(entity.getName() + " Wrong deprecated reason"), (Object)"This has been deprecated for test purposes", (Object)UtlText.removeLineBreaks((String)entity.getDeprecation().getReason()).trim());
        for (AdmField field : entity.fields().values()) {
            if (field.getName().equals("charEnumField") || field.getName().equals("charEnumArrayField")) {
                Assert.assertTrue((String)(entity.getName() + "." + field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
                continue;
            }
            if (field.getName().equals("byteField")) {
                Assert.assertTrue((String)(entity.getName() + "." + field.getName() + " should have been deprecated."), (boolean)field.isDeprecated());
                Assert.assertNotNull((String)(entity.getName() + "." + field.getName() + " should have a deprecation element."), (Object)((Object)field.getDeprecation()));
                Assert.assertEquals((String)(entity.getName() + field.getName() + " Wrong deprecated since"), (Object)"1.5.0", (Object)field.getDeprecation().getSince());
                Assert.assertEquals((String)(entity.getName() + field.getName() + " Wrong deprecated reason"), (Object)"This should override the byte field deprecation.", (Object)UtlText.removeLineBreaks((String)field.getDeprecation().getReason()).trim());
                continue;
            }
            Assert.assertFalse((String)(entity.getName() + "." + field.getName() + " should not have been deprecated."), (boolean)field.isDeprecated());
            Assert.assertNull((String)(entity.getName() + "." + field.getName() + " should not have a deprecation element."), (Object)((Object)field.getDeprecation()));
        }
    }

    @Test
    public void testCollectionDeprecation() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("deprecationTestModel.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmCollection collection = model.getCollection("ChildLongMap");
        Assert.assertFalse((String)(collection.getName() + " should not have been deprecated."), (boolean)collection.isDeprecated());
        Assert.assertNull((String)(collection.getName() + " should not have a deprecation element."), (Object)((Object)collection.getDeprecation()));
        collection = model.getCollection("ChildQueue");
        Assert.assertTrue((String)(collection.getName() + " should have been deprecated."), (boolean)collection.isDeprecated());
        Assert.assertNotNull((String)(collection.getName() + " should have a deprecation element."), (Object)((Object)collection.getDeprecation()));
        Assert.assertEquals((String)(collection.getName() + " Wrong deprecated since"), (Object)"1.6 Beta", (Object)collection.getDeprecation().getSince());
        Assert.assertEquals((String)(collection.getName() + " Wrong deprecated reason"), (Object)"This has been deprecated for test purposes", (Object)UtlText.removeLineBreaks((String)collection.getDeprecation().getReason()).trim());
    }

    @Test
    public void testModelDocumentation() throws EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("documentationTestModel.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        Assert.assertNotNull((String)"Model should not have a documentation element.", (Object)((Object)model.getDocumentation()));
        Assert.assertEquals((String)"Wrong brief model documentation", (Object)"This model is used to test model element documentation", (Object)model.getDocumentation().getBrief());
        Assert.assertEquals((String)"Wrong full model documentation", (Object)"<h1>This section describes full model documentation</h1>", (Object)UtlText.removeLineBreaks((String)model.getDocumentation().getFull()).trim());
    }

    @Test
    public void testCollectionDocumentation() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("documentationTestModel.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmCollection collection = model.getCollection("ChildLongMap");
        Assert.assertNull((String)(collection.getName() + " should not have a documentation element."), (Object)((Object)collection.getDocumentation()));
        collection = model.getCollection("ChildQueue");
        Assert.assertNotNull((String)(collection.getName() + " should have a documentation element."), (Object)((Object)collection.getDocumentation()));
        Assert.assertEquals((String)(collection.getName() + " Wrong brief documentation"), (Object)"Brief documentation", (Object)collection.getDocumentation().getBrief());
        Assert.assertEquals((String)(collection.getName() + " Wrong full documentation"), (Object)"<b>Full Documentation</b>", (Object)UtlText.removeLineBreaks((String)collection.getDocumentation().getFull()).trim());
    }

    @Test
    public void testRequiredFields() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("full_model.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmMessage message = model.getMessage("Message");
        Assert.assertTrue((String)"intField should be required", (boolean)message.getField("intField").isRequired());
        Assert.assertTrue((String)"childField should be required", (boolean)message.getField("childField").isRequired());
        AdmEntity entity = model.getEntity("Child2");
        Assert.assertTrue((String)"intField should be required", (boolean)entity.getField("intField").isRequired());
        Assert.assertTrue((String)"childField should be required", (boolean)entity.getField("childField").isRequired());
        entity = model.getEntity("Child3");
        Assert.assertTrue((String)"intField should be required", (boolean)entity.getField("intField").isRequired());
    }

    @Test
    public void testSemanticTypes() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("test_semantic_types.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmMessage message = model.getMessage("OrderMessage");
        Assert.assertEquals((String)"ParentOrderId is wrong type", (Object)"OrderId", (Object)message.getField("parentOrderId").getType().getName());
        Assert.assertEquals((String)"OrderId is wrong type", (Object)"OrderId", (Object)message.getField("orderId").getType().getName());
        Assert.assertNotNull((String)"lastName should have semantic type", (Object)((Object)message.getField("lastName").getSemanticType()));
        Assert.assertEquals((String)"lastName is wrong semantic type", (Object)"LastName", (Object)message.getField("lastName").getSemanticType().getName());
        Assert.assertEquals((String)"lastName is wrong type", (Object)"String", (Object)message.getField("lastName").getType().getName());
        Assert.assertEquals((String)"lastName should be required", (Object)true, (Object)message.getField("lastName").isRequired());
        Assert.assertNotNull((String)"priority should have semantic type", (Object)((Object)message.getField("priority").getSemanticType()));
        Assert.assertEquals((String)"priority is wrong semantic type", (Object)"Priority", (Object)message.getField("priority").getSemanticType().getName());
        Assert.assertEquals((String)"priority is wrong type", (Object)"Integer", (Object)message.getField("priority").getType().getName());
        Assert.assertEquals((String)"priority should be pinned", (Object)true, (Object)message.getField("priority").isPinned());
        Assert.assertEquals((String)"ssn ", (Object)"SocialSecurityNumber", (Object)message.getField("ssn").getType().getName());
    }

    @Test
    public void testSemanticTypesWithPoolableStrings() throws IOException, EAdmException {
        HashMap<String, String> directives = new HashMap<String, String>();
        directives.put("generateAllStringsPoolable", "true");
        URL modelUrl = ((Object)((Object)this)).getClass().getResource("test_semantic_types.xml");
        CgResourceChangeTracker parseContext = CgResourceChangeTracker.forNewCodeGeneration((File)testSoureDir.getAbsoluteFile(), (URL)modelUrl, null, (ProductInfo)productInfo);
        AdmModel model = AdmXMLParser.parse(modelUrl, null, null, directives, parseContext);
        StringBuilder sb = new StringBuilder();
        if (!model.validateModel(sb)) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        AdmMessage message = model.getMessage("OrderMessage");
        Assert.assertEquals((String)"ParentOrderId is wrong type", (Object)"OrderId", (Object)message.getField("parentOrderId").getType().getName());
        Assert.assertEquals((String)"OrderId is wrong type", (Object)"OrderId", (Object)message.getField("orderId").getType().getName());
        Assert.assertNotNull((String)"lastName should have semantic type", (Object)((Object)message.getField("lastName").getSemanticType()));
        Assert.assertEquals((String)"lastName is wrong semantic type", (Object)"LastName", (Object)message.getField("lastName").getSemanticType().getName());
        Assert.assertEquals((String)"lastName is wrong type", (Object)"LastName", (Object)message.getField("lastName").getType().getName());
        Assert.assertEquals((String)"lastName should be required", (Object)true, (Object)message.getField("lastName").isRequired());
        Assert.assertNotNull((String)"priority should have semantic type", (Object)((Object)message.getField("priority").getSemanticType()));
        Assert.assertEquals((String)"priority is wrong semantic type", (Object)"Priority", (Object)message.getField("priority").getSemanticType().getName());
        Assert.assertEquals((String)"priority is wrong type", (Object)"Integer", (Object)message.getField("priority").getType().getName());
        Assert.assertEquals((String)"priority should be pinned", (Object)true, (Object)message.getField("priority").isPinned());
        Assert.assertEquals((String)"ssn ", (Object)"SocialSecurityNumber", (Object)message.getField("ssn").getType().getName());
    }

    @Test
    public void testSemanticCycleFails() throws IOException, EAdmException {
        try {
            this.parseModel("test_semantic_type_nonprimitivebase.xml");
            Assert.fail((String)"Model parse should have failed");
        }
        catch (EAdmException eae) {
            this.assertErrorInAggregatedErrors(eae.getAggregatedErrors(), "primitiveType", "test_semantic_type_nonprimitivebase.xml", 8, 72);
        }
    }

    @Test
    public void testModelDirectives() throws IOException, EAdmException {
        StringBuilder sb;
        AdmModel model = this.parseModel("testModelDirectives.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        Assert.assertEquals((String)"Wrong POOLED_STRING_FIELD_TYPE_NAME_SUFFIX", (Object)"Type", (Object)model.getStringDirective("pooledStringFieldTypeNameSuffix"));
        Assert.assertEquals((String)"Wrong GENERATE_ALL_STRING_POOLABLE", (Object)true, (Object)model.getBooleanDirective("generateAllStringsPoolable"));
        Assert.assertEquals((String)"Wrong PooledStringFieldTypeNameSuffixPolicy", (Object)((Object)AdmModel.PooledStringFieldTypeNameSuffixPolicy.Always), (Object)((Object)model.getPooledStringFieldTypeNameSuffixPolicy()));
        AdmMessage message = model.getMessage("Message1");
        Assert.assertNotNull((String)"Message1 was not found in the parsed model", (Object)((Object)message));
        AdmField currencyField = message.getField("Currency");
        Assert.assertNotNull((String)"currencyField was not found in the parsed model", (Object)((Object)message));
        Assert.assertEquals((String)"currencyField should have been a pooled string", (Object)"AdmPooledString", (Object)((Object)((Object)currencyField.getType())).getClass().getSimpleName());
        Assert.assertEquals((String)"currencyField was not of the expected type", (Object)"CurrencyType", (Object)((AdmPooledString)currencyField.getType()).getPooledTypeName());
    }

    @Test
    public void testDuplicateSemanthicType() throws IOException, EAdmException {
        try {
            this.parseModel("test_duplicate_semanthic_type.xml");
            Assert.fail((String)"Model parse should have failed");
        }
        catch (EAdmException ex) {
            this.assertErrorInAggregatedErrors(ex.getAggregatedErrors(), "Duplicate type name 'SemanticType' defined in <types>", "test_duplicate_semanthic_type.xml", 16, 42);
        }
    }

    @Test
    public void testDuplicateField() throws IOException, EAdmException {
        try {
            this.parseModel("test_duplicate_field.xml");
            Assert.fail((String)"Model parse should have failed");
        }
        catch (EAdmException ex) {
            this.assertErrorInAggregatedErrors(ex.getAggregatedErrors(), "Duplicate field name 'TheField' defined in fields", "test_duplicate_field.xml", 21, 73);
        }
    }

    @Test
    public void testDuplicateEntityOrMessageName() throws IOException, EAdmException {
        try {
            this.parseModel("test_duplicate_entity_or_message_name.xml");
            Assert.fail((String)"Model parse should have failed");
        }
        catch (EAdmException ex) {
            this.assertErrorInAggregatedErrors(ex.getAggregatedErrors(), "Two types (Message and Message) have the same name [com.neeve.adm.tests.import_tests_11_ns_relative.SomeMessage]", "test_duplicate_entity_or_message_name.xml", 17, 75);
            this.assertErrorInAggregatedErrors(ex.getAggregatedErrors(), "Two types (Entity and Entity) have the same name [com.neeve.adm.tests.import_tests_11_ns_relative.EmbeddedEntity]", "test_duplicate_entity_or_message_name.xml", 26, 95);
        }
    }

    @Test
    public void testDuplicateEntityAndMessageName() throws IOException, EAdmException {
        try {
            this.parseModel("test_duplicate_entity_and_message_name.xml");
            Assert.fail((String)"Model parse should have failed");
        }
        catch (EAdmException ex) {
            this.assertErrorInAggregatedErrors(ex.getAggregatedErrors(), "Two types (Entity and Message) have the same name [com.neeve.adm.tests.import_tests_11_ns_relative.SameName]", "test_duplicate_entity_and_message_name.xml", 26, 89);
        }
    }

    @Test
    public void testRedefiningInlinedFieldRef() throws IOException, EAdmException {
        try {
            this.parseModel("test_redefining_fieldref.xml");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Model parse shouldn't fail.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContextClassLoaderModelResolution() {
        Properties props;
        block12: {
            block11: {
                String expectedErrorMessage = "Error parsing model import 'this path makes no sense without custom class loader.";
                try {
                    this.parseModel("custom_ctx_cls_loader_level_0.xml");
                }
                catch (EAdmException e) {
                    boolean found = false;
                    for (CgSourceCodeErrorAggregator.Message message : e.getAggregatedErrors().getErrors()) {
                        if (message.getMessage() == null || message.getMessage().indexOf("Error parsing model import 'this path makes no sense without custom class loader.") < 0) continue;
                        found = true;
                    }
                    if (found) break block11;
                    Assert.fail((String)("Did not get expected error message 'Error parsing model import 'this path makes no sense without custom class loader.' in reported parse errors:\n" + e.getAggregatedErrors()));
                }
            }
            props = new Properties();
            props.setProperty("nv.adm.contextclassloaderfirst", "true");
            XRuntime.updateProps((Properties)props);
            try {
                this.parseModel("custom_ctx_cls_loader_level_0.xml");
            }
            catch (EAdmException e) {
                boolean found = false;
                for (CgSourceCodeErrorAggregator.Message message : e.getAggregatedErrors().getErrors()) {
                    if (message.getMessage() == null || message.getMessage().indexOf("Error parsing model import 'this path makes no sense without custom class loader.") < 0) continue;
                    found = true;
                }
                if (found) break block12;
                Assert.fail((String)("Did not get expected error message 'Error parsing model import 'this path makes no sense without custom class loader.' in reported parse errors:\n " + e.getAggregatedErrors()));
            }
        }
        final ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader myClassLoader = new ClassLoader(){

                @Override
                public URL getResource(String path) {
                    URL result = null;
                    result = path.equals("this path makes no sense without custom class loader.") ? AdmXMLParserTest.class.getResource("custom_ctx_cls_loader_level_1.xml") : currentLoader.getResource(path);
                    return result;
                }
            };
            Thread.currentThread().setContextClassLoader(myClassLoader);
            this.parseModel("custom_ctx_cls_loader_level_0.xml");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Exception was thrown");
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
            props.setProperty("nv.adm.contextclassloaderfirst", "false");
            XRuntime.updateProps((Properties)props);
        }
    }

    @Test
    public void testModelSelfImport() throws IOException, EAdmException {
        block2: {
            try {
                this.parseModel("test_selfimport_model.xml");
                Assert.fail((String)"Excepted model parse to fail.");
            }
            catch (EAdmException ex) {
                String expected = "Model import cycle detected: com.neeve.adm.test.unit.selfimport.test_selfimport_model->com.neeve.adm.test.unit.selfimport.test_selfimport_model";
                Assert.assertTrue((String)("Expected exception to contain: '" + expected + "' but was '" + ex.getMessage()), (ex.getMessage().indexOf(expected) >= 0 ? 1 : 0) != 0);
                if (ex.getCodeSource().toString().endsWith("/test_selfimport_model.xml [5:48]")) break block2;
                Assert.fail((String)("Wrong source code info " + ex.getCodeSource()));
            }
        }
    }

    @Test
    public void testCyclicModelImport() throws IOException, EAdmException {
        block2: {
            try {
                this.parseModel("test_cyclic_model_import_0.xml");
                Assert.fail((String)"Excepted model parse to fail.");
            }
            catch (EAdmException ex) {
                String expected = "Model import cycle detected: com.neeve.adm.test.unit.cyclicimport0.test_cyclic_model_import_0->com.neeve.adm.test.unit.cyclicimport1.test_cyclic_model_import_1";
                Assert.assertTrue((String)("Expected exception to contain: '" + expected + "' but was '" + ex.getMessage()), (ex.getMessage().indexOf(expected) >= 0 ? 1 : 0) != 0);
                if (ex.getCodeSource().toString().endsWith("/test_cyclic_model_import_1.xml [5:53]")) break block2;
                Assert.fail((String)("Wrong source code info " + ex.getCodeSource()));
            }
        }
    }

    private void assertErrorInAggregatedErrors(CgSourceCodeErrorAggregator agg, String errorText, String sourceFile, int line, int column) {
        CgSourceCodeErrorAggregator.Message matched = null;
        block0: for (URL source : agg.getErrorMessages().keySet()) {
            if (!source.toString().endsWith(sourceFile)) continue;
            for (CgSourceCodeErrorAggregator.Message message : (Set)agg.getErrorMessages().get(source)) {
                if (!message.getMessage().contains(errorText)) continue;
                matched = message;
                break block0;
            }
        }
        if (matched == null) {
            Assert.fail((String)("Expected error '" + errorText + "' not reported in aggregated errors: " + agg));
        } else {
            Assert.assertEquals((String)("Expected error '" + errorText + "' at wrong line"), (long)line, (long)matched.getSrcInfo().getLine());
            Assert.assertEquals((String)("Expected error '" + errorText + "' at wrong column"), (long)column, (long)matched.getSrcInfo().getColumnStart());
        }
        if (AdmXMLParserTest.verbose()) {
            System.out.println("GOT EXPECTED VALIDATION ERROR '" + errorText + "' in: \n" + agg);
        }
    }

    private final void verifyInFactory(AdmModel model, AdmFactory factory, String typeName) throws Exception {
        AdmFactoryType entity = (AdmFactoryType)model.lookupType(typeName, true);
        Assert.assertNotNull((String)(typeName + " not created"), (Object)((Object)factory));
        Assert.assertEquals((String)("Wrong factory for " + entity.getName()), (Object)factory.getFullName(), (Object)entity.getFactory().getFullName());
    }

    private final AdmModel parseModel(String modelFileName) throws EAdmException {
        URL modelUrl = ((Object)((Object)this)).getClass().getResource(modelFileName);
        CgResourceChangeTracker parseContext = CgResourceChangeTracker.forNewCodeGeneration((File)testSoureDir.getAbsoluteFile(), (URL)modelUrl, null, (ProductInfo)productInfo);
        try {
            return AdmXMLParser.parse(((Object)((Object)this)).getClass().getResource(modelFileName), testSoureDir, null, parseContext);
        }
        catch (EAdmException e) {
            if (e.getCodeSource() != null) {
                throw new EAdmException("Model parse failed: " + e.getCodeSource() + " - " + e.getMessage(), (Throwable)((Object)e), e.getCodeSource());
            }
            if (e.getAggregatedErrors() != null) {
                throw new EAdmException("Model parse failed: " + e.getMessage() + " Errors:\n" + e.getAggregatedErrors().toString(), (Throwable)((Object)e), e.getAggregatedErrors());
            }
            throw e;
        }
    }
}

