/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AdmSourceCodeBuilder {
    private static final char NEW_LINE_CHAR = '\n';
    private static final String MARKER_PREFIX = "    // ----- marker ";
    private static final boolean includeMarkers = false;
    private ArrayList<UtlExStringBuilder> codeSegments = new ArrayList();
    private TreeSet<String> imports = new TreeSet();
    private UtlExStringBuilder header = new UtlExStringBuilder();
    private String packageName;

    private Set<String> initLocalImportedNames() {
        HashSet<String> retVal = new HashSet<String>(Arrays.asList("Appendable", "CharSequence", "Cloneable", "Comparable", "Iterable", "Readable", "Runnable", "Thread", "Class", "Boolean", "Byte", "Character", "Class", "ClassLoader", "Compiler", "Double", "Enum", "Float", "InheritableThreadLocal", "Integer", "Long", "Math", "Number", "Object", "Package", "Process", "ProcessBuilder", "Runtime", "RuntimePermission", "SecurityManager", "Short", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "System", "Thread", "ThreadGroup", "ThreadLocal", "Throwable", "Void"));
        return retVal;
    }

    private Set<String> initImplicitImports() {
        HashSet<String> retVal = new HashSet<String>();
        for (String javaLangName : this.initLocalImportedNames()) {
            retVal.add("java.lang." + javaLangName);
        }
        return retVal;
    }

    private void processCodeSegments(PrintWriter pw) {
        UtlExStringBuilder finalCodeSegment = new UtlExStringBuilder();
        Set<String> importedLocalNames = this.initLocalImportedNames();
        Set<String> implicitImports = this.initImplicitImports();
        StringBuilder typeName = new StringBuilder();
        for (UtlExStringBuilder exSb : this.codeSegments) {
            TypeParseState state = TypeParseState.DEFAULT;
            typeName.setLength(0);
            StringBuilder sb = exSb.getSbInstance();
            block6: for (int i = 0; i < sb.length(); ++i) {
                char chr = sb.charAt(i);
                switch (state) {
                    case DEFAULT: {
                        if (chr == '%') {
                            state = TypeParseState.PRE_TYPE;
                            continue block6;
                        }
                        finalCodeSegment.append(chr);
                        continue block6;
                    }
                    case PRE_TYPE: {
                        if (chr == '{') {
                            state = TypeParseState.TYPE;
                            continue block6;
                        }
                        state = TypeParseState.DEFAULT;
                        finalCodeSegment.append('%');
                        finalCodeSegment.append(chr);
                        continue block6;
                    }
                    case TYPE: {
                        if (chr == '}') {
                            int packageAndNameSeparatorIdx = typeName.lastIndexOf(".");
                            String fullName = typeName.toString();
                            if (packageAndNameSeparatorIdx > -1) {
                                String localName = typeName.substring(packageAndNameSeparatorIdx + 1);
                                if (this.imports.contains(fullName) || implicitImports.contains(fullName)) {
                                    finalCodeSegment.append(localName);
                                } else if (importedLocalNames.contains(localName)) {
                                    finalCodeSegment.append(fullName);
                                } else {
                                    this.imports.add(fullName);
                                    importedLocalNames.add(localName);
                                    finalCodeSegment.append(localName);
                                }
                            } else {
                                finalCodeSegment.append("%{ERROR WRONG TYPE " + fullName + "}");
                            }
                            state = TypeParseState.DEFAULT;
                            typeName.setLength(0);
                            continue block6;
                        }
                        typeName.append(chr);
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("This should never happen");
                    }
                }
            }
        }
        TreeSet<String> finalImports = new TreeSet<String>((SortedSet<String>)this.imports);
        for (String importName : finalImports) {
            pw.format("import %s;", importName);
            pw.println();
        }
        pw.write(finalCodeSegment.toString());
    }

    public void write(Writer w) throws IOException {
        PrintWriter pw = null;
        if (w instanceof PrintWriter) {
            pw = (PrintWriter)w;
        } else {
            BufferedWriter bw = new BufferedWriter(w);
            pw = new PrintWriter(bw);
        }
        if (this.header.length() > 0) {
            pw.println(this.header.toString());
        }
        if (this.packageName == null) {
            throw new IllegalStateException("Package name is not set.");
        }
        pw.format("package %s;", this.packageName);
        pw.println();
        pw.println();
        this.processCodeSegments(pw);
        pw.flush();
    }

    public UtlExStringBuilder newCodeSegment(String marker) {
        UtlExStringBuilder sb = new UtlExStringBuilder();
        if (marker == null || marker.isEmpty()) {
            throw new IllegalArgumentException("'marker' cannot be null or emtpy string.");
        }
        this.codeSegments.add(sb);
        return sb;
    }

    public UtlExStringBuilder newCodeSegment() {
        UtlExStringBuilder sb = new UtlExStringBuilder();
        this.codeSegments.add(sb);
        return sb;
    }

    public UtlExStringBuilder last() {
        if (this.codeSegments.size() > 0) {
            return this.codeSegments.get(this.codeSegments.size() - 1);
        }
        return this.newCodeSegment();
    }

    public void write(File file) throws IOException, FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("'file' cannot be null.");
        }
        try (PrintWriter w = new PrintWriter(file);){
            this.write(w);
        }
    }

    public UtlExStringBuilder header() {
        return this.header;
    }

    public AdmSourceCodeBuilder packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public static final class UtlExStringBuilder {
        private StringBuilder sb = new StringBuilder();

        public UtlExStringBuilder append(String str) {
            this.sb.append(str);
            return this;
        }

        public UtlExStringBuilder append(char c) {
            this.sb.append(c);
            return this;
        }

        public UtlExStringBuilder append(Object obj) {
            this.sb.append(obj);
            return this;
        }

        public UtlExStringBuilder appendln() {
            this.sb.append('\n');
            return this;
        }

        public UtlExStringBuilder appendln(String str) {
            this.sb.append(str);
            this.appendln();
            return this;
        }

        public UtlExStringBuilder appendln(Object obj) {
            this.sb.append(obj);
            return this;
        }

        public UtlExStringBuilder format(String format, Object ... args) {
            this.sb.append(String.format(format, args));
            return this;
        }

        public UtlExStringBuilder formatln(String format, Object ... args) {
            this.format(format, args);
            this.appendln();
            return this;
        }

        public int length() {
            return this.sb.length();
        }

        public String toString() {
            return this.sb.toString();
        }

        public final StringBuilder getSbInstance() {
            return this.sb;
        }
    }

    private static enum TypeParseState {
        DEFAULT,
        PRE_TYPE,
        TYPE;

    }
}

