/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventSource;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.IStorePersisterStats;
import com.neeve.ods.IStoreReader;
import com.neeve.ods.IStoreWriter;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsExpectationNotMetException;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.impl.StorePacketPersisterBase;
import com.neeve.ods.impl.StorePersisterCompactionErrorEvent;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.log.EPktLogCorruptException;
import com.neeve.pkt.log.EPktLogExpectationNotMetException;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.quark.QuarkBuffer;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxFieldResolver;
import com.neeve.rog.IRogChangeDataCaptureHandler;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogMessageLogger;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogNode;
import com.neeve.rog.RogConfig;
import com.neeve.rog.impl.RogDirectMetadata;
import com.neeve.rog.impl.RogUtil;
import com.neeve.rog.log.RogLogCdcProcessor;
import com.neeve.rog.log.RogLogCompactor;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogMetadata;
import com.neeve.rog.log.RogLogReader;
import com.neeve.rog.log.RogLogRepository;
import com.neeve.rog.log.RogLogRepositoryImpl;
import com.neeve.rog.log.RogLogStats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class RogLog
extends StorePacketPersisterBase
implements IStorePersister,
IRogMessageLogger,
IEventSource {
    public static final String PROP_STORE_ROOT = "storeRoot";
    public static final String PROP_INITIAL_LOG_LENGTH = "initialLogLength";
    public static final float PROP_INITIAL_LOG_LENGTH_DEFAULT = 1.0f;
    public static final String PROP_ZERO_OUT_INITIAL = "zeroOutInitial";
    public static final String PROP_TRANSACTIONAL_INTEGRITY_CHECK = "txnIntegrityCheck";
    public static final boolean PROP_TRANSACTIONAL_INTEGRITY_CHECK_DEFAULT = true;
    public static final String PROP_AUTO_REPAIR = "autoRepair";
    public static final String PROP_CDC_ENABLED = "cdcEnabled";
    public static final String PROP_LOG_SCAVENGE_POLICY = "logScavengePolicy";
    public static final String PROP_LOG_BACKUP_RETENTION_COUNT = "logBackupRetentionCount";
    public static final String PROP_IS_PURE_MESSAGE_LOGGER = "isPureMessageLogger";
    public static final String PROP_DETACHED_MESSAGE_SERIALIZATION = "detachedMessageSerialization";
    public static final String PROP_LOG_MODE = "logMode";
    public static final String PROP_FLUSH_USING_MAPPED_MEMORY = "flushUsingMappedMemory";
    public static final String PROP_AUTO_FLUSH_SIZE = "autoFlushSize";
    public static final String PROP_PAGE_SIZE = "pageSize";
    private static final AtomicInteger counter = new AtomicInteger();
    private final StorePersisterDescriptor descriptor;
    private final Properties props;
    private final StoreReader storeReader;
    private final RogLogCompactor.Params compactorParams;
    private final RogLogCdcProcessor.Params cdcParams;
    private final boolean autoRepair;
    private final File root;
    private final RogLogMetadata metadata;
    private final RogLogStats stats;
    private final RogLogCompactor compactor;
    private final ReentrantLock compactionSynchronizer;
    private final LogScavengePolicy logScavengePolicy;
    private final int logBackupRetentionCount;
    private final UtlPool<Entry> entryPool;
    private final boolean flushUsingMappedMemory;
    private String name;
    private boolean compactOnNextWrite;
    private IStorePersister.LogEmptinessExpectation logEmptinessStartupExpectation;
    private IStorePersister.LogPresenceExpectation logPresenceStartupExpectation;
    private PktRecoveryLog log;
    private static boolean failOpen;
    private volatile IStorePersister.ErrorHandler errorHandler;
    private volatile IEventHandler eventHandler;
    private Exception failure;
    private boolean isPureMessageLogger;
    private boolean detachedMessageSerialization;
    private CheckpointState checkpointState;
    private boolean closed;
    private final ThreadLocal<StoreCommitEntry> threadLocalCommitEntry = new ThreadLocal();

    private RogLog(String name, StorePersisterDescriptor descriptor, Properties props) {
        super(RogConfig.getConfig(), "Log-" + name + "-" + counter.incrementAndGet(), props);
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Creating store persister '" + name + "...", Tracer.Level.DEBUG);
        }
        this.name = name;
        this.descriptor = descriptor;
        this.props = props;
        this.autoRepair = UtlProps.getValue((Properties)props, (String)PROP_AUTO_REPAIR, (boolean)false);
        this.root = new File(UtlProps.getValue((Properties)props, (String)PROP_STORE_ROOT, (String)XRuntime.getDataDirectory((boolean)false)));
        this.storeReader = new StoreReader();
        this.metadata = new RogLogMetadata(this.root, this.name);
        this.logScavengePolicy = LogScavengePolicy.valueOf(UtlProps.getValue((Properties)props, (String)PROP_LOG_SCAVENGE_POLICY, (String)String.valueOf((Object)LogScavengePolicy.Delete)));
        this.logBackupRetentionCount = UtlProps.getValue((Properties)props, (String)PROP_LOG_BACKUP_RETENTION_COUNT, (int)1);
        this.entryPool = UtlPool.create((String)"rog.log.entry", (String)name, (UtlPool.Factory)new Entry.Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
        this.compactorParams = RogLogCompactor.Params.create(props);
        this.compactor = new RogLogCompactor(this, this.compactorParams);
        this.compactionSynchronizer = new ReentrantLock(true);
        this.cdcParams = RogLogCdcProcessor.Params.create(props);
        this.isPureMessageLogger = UtlProps.getValue((Properties)props, (String)PROP_IS_PURE_MESSAGE_LOGGER, (boolean)false);
        this.detachedMessageSerialization = UtlProps.getValue((Properties)props, (String)PROP_DETACHED_MESSAGE_SERIALIZATION, (boolean)false);
        this.flushUsingMappedMemory = UtlProps.getValue((Properties)props, (String)PROP_FLUSH_USING_MAPPED_MEMORY, (boolean)XRuntime.getValue((String)"nv.rog.log.flushusingmappedmem", (boolean)false));
        this.stats = new RogLogStats(this, name, "nv.rog.log." + name + ".stats.interval");
        super.setStats(this.stats);
    }

    private RogLog(String name, StorePersisterDescriptor descriptor) {
        this(name, descriptor, descriptor.getProperties());
    }

    public static final RogLog create(String name, Properties props) throws OdsException {
        return new RogLog(name, null, props == null ? new Properties() : (Properties)props.clone());
    }

    public static final RogLog create(String name) throws OdsException {
        return RogLog.create(name, (Properties)null);
    }

    public static final RogLog create(String name, StorePersisterDescriptor descriptor) throws OdsException {
        return new RogLog(name, descriptor);
    }

    public static final void failOpen(boolean val) {
        failOpen = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String backupLog(String logName, Properties props, boolean shrinkToSize) throws Exception {
        try (RogLog log = RogLog.create(logName, props);){
            String string = log.backupLog(shrinkToSize);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeFactories() {
        HashSet<String> factories = new HashSet<String>();
        StoreObjectFactoryRegistry.getInstance().getStoreObjectFactoryNames(factories);
        File file = new File(this.root.getAbsolutePath() + File.separator + this.factoriesFilename());
        if (!file.exists()) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "Writing factories...", Tracer.Level.DEBUG);
            }
            try (PrintWriter writer = new PrintWriter(file);){
                for (String factory : factories) {
                    writer.println(factory);
                }
            }
            catch (IOException e) {
                this.tracer.log(this.tracePrefix() + "Failed to create the factories file [" + e.toString() + "]", Tracer.Level.INFO);
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Not writing factories (Factories file already exists).", Tracer.Level.DEBUG);
        }
    }

    private final void initCheckpointState() throws Exception {
        try (RogLogReader reader = this.createReader();){
            reader.setLazyDeserialization(true);
            Entry entry = reader.next();
            CheckpointState checkpointState = entry != null ? (entry.getCheckpointVersion() > 0L ? CheckpointState.AllEntriesCheckpointed : CheckpointState.NoEntriesCheckpointed) : (this.checkpointState = CheckpointState.Pending);
            if (this.checkpointState == CheckpointState.NoEntriesCheckpointed && this.compactorParams.compactionThreshold > 0L) {
                throw new IllegalStateException("cannot enable compaction on a non-checkpointed log");
            }
        }
    }

    private final void renameTo(String newName) throws IOException {
        boolean factoriesRenamed;
        boolean metadataRenamed;
        boolean logRenamed;
        block9: {
            File logFile = new File(this.root, this.logFilename());
            File newLogFile = new File(this.root, this.logFilename(newName));
            if (newLogFile.exists()) {
                throw new IOException("Can't rename " + this.getName() + " to " + newName + ", file already exists");
            }
            File newMetadataFile = new File(this.root, this.metadataFilename(newName));
            if (newMetadataFile.exists()) {
                throw new IOException("Can't rename " + this.getName() + " to " + newName + ", metadata file already exists");
            }
            File factoriesFile = new File(this.root, this.factoriesFilename());
            File newFactoriesFile = new File(this.root, this.factoriesFilename(newName));
            if (newFactoriesFile.exists()) {
                throw new IOException("Can't rename " + this.getName() + " to " + newName + ", factories file already exists");
            }
            logRenamed = false;
            metadataRenamed = false;
            factoriesRenamed = false;
            try {
                logRenamed = logFile.renameTo(newLogFile);
                if (!logRenamed) {
                    throw new IOException("Couldn't rename " + logFile + " to " + newLogFile);
                }
                this.metadata.renameTo(newName);
                metadataRenamed = true;
                factoriesRenamed = factoriesFile.exists() ? factoriesFile.renameTo(newFactoriesFile) : true;
            }
            catch (IOException ioe) {
                if (logRenamed) {
                    newLogFile.renameTo(logFile);
                }
                if (metadataRenamed) {
                    this.metadata.renameTo(this.name);
                }
                if (!factoriesRenamed || !newFactoriesFile.exists()) break block9;
                newFactoriesFile.renameTo(factoriesFile);
            }
        }
        if (!(factoriesRenamed && logRenamed && metadataRenamed)) {
            throw new IOException("Failed to rename log " + this.name + " to" + newName);
        }
        this.name = newName;
    }

    private final String indexFilename(String name, int number) {
        return name + (number == 0 ? "" : String.valueOf(number)) + ".index";
    }

    private final String indexFilename(String name) {
        return this.indexFilename(name, this.getLiveLogNumber());
    }

    private final String indexFilename(int number) {
        return this.indexFilename(this.getName(), number);
    }

    private final String indexFilename() {
        return this.indexFilename(this.getLiveLogNumber());
    }

    private final String indexPFilename(String name, int number) {
        return name + (number == 0 ? "" : String.valueOf(number)) + ".index.p";
    }

    private final String indexPFilename(String name) {
        return this.indexPFilename(name, this.getLiveLogNumber());
    }

    private final String indexPFilename(int number) {
        return this.indexPFilename(this.getName(), number);
    }

    private final String indexPFilename() {
        return this.indexPFilename(this.getLiveLogNumber());
    }

    private final String metadataFilename(String name) {
        return name + ".metadata";
    }

    private final String metadataFilename() {
        return this.metadataFilename(this.getName());
    }

    private final String factoriesFilename(String name) {
        return name + ".factories";
    }

    private final String factoriesFilename() {
        return this.factoriesFilename(this.getName());
    }

    final String logFilename(String name, int number) {
        return name + (number == 0 ? "" : "." + String.valueOf(number)) + ".log";
    }

    final String logFilename(String name) {
        return this.logFilename(name, this.getLiveLogNumber());
    }

    final String logFilename(int number) {
        return this.logFilename(this.getName(), number);
    }

    final String logFilename() {
        return this.logFilename(this.getLiveLogNumber());
    }

    static final void checkAndCreateStoreRoot(File root) throws Exception {
        if (root.exists() && !root.isDirectory()) {
            throw new Exception("root directory ('" + root.getAbsolutePath() + "') is a file");
        }
        if (!root.exists()) {
            root.mkdirs();
            if (!root.exists()) {
                throw new Exception("Failed to create store root directory");
            }
        }
    }

    final Entry createEntry(PktPacket packet) throws OdsException {
        PktSubheaderODS subheader = packet.getHeader().getODSSubheader();
        if (subheader == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Detected log packet without an ODS header:!\n  ");
            PktBuffer headerBuffer = packet.getHeader().getBuffer();
            PktBuffer bodyBuffer = packet.getBody().getBuffer();
            sb.append(headerBuffer != null ? headerBuffer.dump("Header Buffer: ", 0, headerBuffer.getLength()) : " no header buffer!").append("\n  ");
            sb.append(headerBuffer != null ? bodyBuffer.dump("Body Buffer: ", 0, bodyBuffer.getLength()) : " no body buffer!");
            sb.append("[ body type: ").append(packet.getBody().getClass().getSimpleName()).append("]\n  ");
            sb.append("Packet: " + packet.toString());
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        }
        short ofid = subheader.getObjectFactoryId();
        short otype = subheader.getObjectType();
        UUID id = subheader.getObjectId() == null ? null : new UUID(subheader.getObjectId());
        short contentEncodingType = subheader.getContentEncodingType();
        PktBuffer metadata = subheader.getObjectMetadata();
        boolean commitStart = subheader.getFlagCommitStart();
        boolean commitEnd = subheader.getFlagCommitEnd();
        long timestamp = subheader.getTimestamp();
        long transactionId = subheader.getTransactionId();
        long stableTransactionId = subheader.getStableTransactionId();
        long checkpointVersion = subheader.getCheckpointVersion();
        PktRecoveryLog.FilePosition filePosition = (PktRecoveryLog.FilePosition)packet.getTag(4);
        long filePointer = filePosition.getPosition();
        int serializedSize = filePosition.getSize();
        switch (subheader.getCommitEntryType()) {
            case 1: {
                return this.createEntry(filePointer, serializedSize, Entry.Type.Put, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
            }
            case 2: {
                return this.createEntry(filePointer, serializedSize, Entry.Type.Update, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
            }
            case 3: {
                return this.createEntry(filePointer, serializedSize, Entry.Type.Remove, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
            }
            case 4: {
                return this.createEntry(filePointer, serializedSize, Entry.Type.Send, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
            }
            case 5: {
                return this.createEntry(filePointer, serializedSize, Entry.Type.Message, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
            }
        }
        throw new OdsException("entry in transaction log is corrupt (unsupported  commit entry type '" + subheader.getCommitEntryType() + "'). See nv.rog logs for more details");
    }

    final Entry createEntry(long fpos, int fsize, Entry.Type type, UUID id, short ofid, short otype, long transactionId, long stableTransactionId, long checkpointVersion, PktPacket packet, short contentEncodingType, PktBuffer serializedMetadata, long timestamp, boolean commitStart, boolean commitEnd) {
        return ((Entry)this.entryPool.get(null)).init(this, fpos, fsize, type, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, serializedMetadata, timestamp, commitStart, commitEnd);
    }

    final void setPacketLog(PktRecoveryLog log) {
        if (this.log != null && this.log != log) {
            this.log.close();
        }
        this.log = log;
    }

    final PktRecoveryLog getPacketLog() {
        return this.log;
    }

    final ReentrantLock getCompactionSynchronizer() {
        return this.compactionSynchronizer;
    }

    final IStoreBinding.Role getRole() {
        return this.role;
    }

    final int skipCdcOverMissing() throws Exception {
        if (!this.isOpen()) {
            throw new IllegalStateException("log needs to be open to set next CDC log number");
        }
        this.tracer.log(this.tracePrefix() + "Setting next CDC log number....", Tracer.Level.INFO);
        int cdcLogNumber = this.metadata.getCdcLogNumber();
        if (cdcLogNumber >= 0) {
            int liveLogNumber = this.metadata.getLiveLogNumber();
            for (int i = cdcLogNumber; i <= liveLogNumber; ++i) {
                File file = new File(this.root, this.logFilename(i));
                if (file.exists()) {
                    this.tracer.log(this.tracePrefix() + "... #" + i + " exists. setting as next CDC log number", Tracer.Level.INFO);
                    if (i != cdcLogNumber) {
                        this.metadata.setCdcLogNumber(i);
                        this.metadata.setCdcCursor(0L);
                    }
                    break;
                }
                this.tracer.log(this.tracePrefix() + "... #" + i + " does not exist. skipping....", Tracer.Level.INFO);
            }
        } else {
            this.tracer.log(this.tracePrefix() + "... <CDC is not enabled>", Tracer.Level.INFO);
        }
        this.scavenge();
        return this.metadata.getCdcLogNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void scavenge() throws Exception {
        if (!this.isOpen()) {
            throw new IllegalStateException("log needs to be open for scavenging");
        }
        int cdcLogNumber = this.metadata.getCdcLogNumber();
        int liveLogNumber = this.metadata.getLiveLogNumber();
        this.tracer.log(this.tracePrefix() + "Scavenging old log files....", Tracer.Level.INFO);
        int successCount = 0;
        int failCount = 0;
        block9: for (int i = 0; i < (cdcLogNumber >= 0 ? cdcLogNumber : liveLogNumber); ++i) {
            File file = new File(this.root, this.logFilename(i));
            if (!file.exists()) continue;
            switch (this.logScavengePolicy) {
                case Delete: {
                    this.tracer.log(this.tracePrefix() + "...truncating and deleting '" + file.getName() + "'...", Tracer.Level.INFO);
                    try {
                        try (RandomAccessFile truncate = new RandomAccessFile(file, "rw");){
                            truncate.setLength(0L);
                        }
                        if (file.delete()) {
                            ++successCount;
                            continue block9;
                        }
                        ++failCount;
                        this.tracer.log(this.tracePrefix() + "......unable to delete '" + file.getName() + "'", Tracer.Level.WARNING);
                    }
                    catch (IOException ioe) {
                        String message = this.tracePrefix() + "......unable to delete '" + file.getName() + "' [" + ioe.getMessage() + "]";
                        this.tracer.log(message, Tracer.Level.WARNING);
                        OdsException e = new OdsException(message);
                        e.initCause(ioe);
                        this.dispatchEvent((Event)StorePersisterCompactionErrorEvent.create(null, this, e));
                    }
                    continue block9;
                }
                case Disabled: {
                    this.tracer.log(this.tracePrefix() + "...skipping delete of '" + file.getName() + "' because log scavenge is Disabled...", Tracer.Level.INFO);
                    continue block9;
                }
                default: {
                    throw new InternalError("unknown scavenge policy '" + (Object)((Object)this.logScavengePolicy) + "'");
                }
            }
        }
        this.tracer.log(this.tracePrefix() + "....scavenged " + successCount + " files (" + failCount + " failed).", Tracer.Level.INFO);
    }

    final long getNextWritePointer() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Log is not open");
        }
        return this.log.getNextWritePointer();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int getLiveLogNumber() {
        int n;
        if (this.metadata.isOpen()) return this.metadata.getLiveLogNumber();
        if (!new File(this.root, this.metadataFilename(this.name)).exists()) return 0;
        this.metadata.open();
        try {
            n = this.metadata.getLiveLogNumber();
        }
        catch (Throwable throwable) {
            try {
                this.metadata.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.metadata.close();
        return n;
    }

    final void dispatchEvent(Event event) {
        IEventHandler handler = this.eventHandler;
        if (handler != null) {
            handler.onEvent(event);
        } else {
            event.dispose();
        }
    }

    final String backupLog(int logNumber, boolean shrinkToSize) throws Exception {
        this.tracer.log(this.tracePrefix() + "Backing up transaction log (#" + logNumber + " ,shrinkToSize=" + shrinkToSize + ")...", Tracer.Level.INFO);
        String backupFilename = PktRecoveryLog.backup((String)this.root.getAbsolutePath(), (String)this.logFilename(logNumber), (boolean)true, (boolean)shrinkToSize, (boolean)false, (int)this.logBackupRetentionCount);
        if (backupFilename == null) {
            this.tracer.log(this.tracePrefix() + "...no log to back up.", Tracer.Level.INFO);
        } else {
            this.tracer.log(this.tracePrefix() + "...backed up log to '" + backupFilename + "'.", Tracer.Level.INFO);
        }
        return backupFilename;
    }

    @Override
    protected final void doChangeRole(IStoreBinding.Role role) {
        super.doChangeRole(role);
        if (this.isOpen()) {
            this.metadata.setIsBackup(role == IStoreBinding.Role.Backup);
        }
    }

    @Override
    protected final void doWritePersisterMetadata(PktBuffer buffer) throws Exception {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Received metadata to write...", Tracer.Level.DEBUG);
        }
        if (this.metadata.getLiveLogNumber() == RogLogMetadata.getLiveLogNumber((IOElasticBuffer)buffer)) {
            int previousCdcLogNumber = this.metadata.getCdcLogNumber();
            this.metadata.deserialize((IOElasticBuffer)buffer, this.role);
            if (this.metadata.getCdcLogNumber() != previousCdcLogNumber) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix() + "...CDC log number has changed (previous=" + previousCdcLogNumber + ", current=" + this.metadata.getCdcLogNumber() + ").", Tracer.Level.DEBUG);
                }
                this.scavenge();
            } else if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "...no change to CDC log number (#" + previousCdcLogNumber + ").", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "...live logs are different (this=" + this.metadata.getLiveLogNumber() + ", that=" + RogLogMetadata.getLiveLogNumber((IOElasticBuffer)buffer) + ").", Tracer.Level.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doWrite(PktPacket packet) {
        if (!this.isPureMessageLogger) {
            long checkpointVersion = packet.getHeader().getODSSubheader().getCheckpointVersion();
            if (this.checkpointState == CheckpointState.Pending) {
                CheckpointState checkpointState = this.checkpointState = checkpointVersion > 0L ? CheckpointState.AllEntriesCheckpointed : CheckpointState.NoEntriesCheckpointed;
                if (this.checkpointState == CheckpointState.NoEntriesCheckpointed && this.compactorParams.compactionThreshold > 0L) {
                    throw new IllegalArgumentException("cannot log a non-checkpointed entry to log on which compaction is enabled");
                }
            }
            if (this.checkpointState == CheckpointState.AllEntriesCheckpointed && checkpointVersion <= 0L) {
                throw new IllegalArgumentException("cannot log a non-checkpointed entry to a checkpointed log");
            }
            if (this.checkpointState == CheckpointState.NoEntriesCheckpointed && checkpointVersion > 0L) {
                throw new IllegalArgumentException("cannot log a checkpointed entry to a non-checkpointed log");
            }
        }
        boolean compactInProgress = false;
        if (this.compactorParams.compactionThreshold > 0L && !(compactInProgress = this.compactor.isCompactionInProgress()) && (this.compactOnNextWrite || this.getSize() >= this.compactorParams.compactionThreshold)) {
            this.compactor.compact();
            compactInProgress = true;
        }
        this.compactOnNextWrite = false;
        if (compactInProgress) {
            this.compactionSynchronizer.lock();
            try {
                this.log.write(packet, 0);
            }
            finally {
                this.compactionSynchronizer.unlock();
            }
        } else {
            this.log.write(packet, 0);
        }
    }

    @Override
    protected final void doFlush(boolean sync) {
        block6: {
            try {
                if (this.compactor.isCompactionInProgress()) {
                    this.compactionSynchronizer.lock();
                    try {
                        this.log.flush(sync ? 1 : 0);
                        break block6;
                    }
                    finally {
                        this.compactionSynchronizer.unlock();
                    }
                }
                this.log.flush(sync ? 1 : 0);
            }
            catch (Throwable e) {
                this.fail(new OdsException(e));
            }
        }
    }

    @Override
    protected final void doFail(Exception cause) {
        this.failure = cause;
        this.onFailure(this.failure);
        IStorePersister.ErrorHandler errorHandler = this.errorHandler;
        if (errorHandler != null) {
            errorHandler.onError(this.failure);
        }
    }

    @Override
    protected final String tracePrefix() {
        return "[RogLog->'" + this.getName() + "'] ";
    }

    public final File getLogFile() {
        if (!this.isOpen()) {
            return new File(this.root, this.logFilename(this.getLiveLogNumber()));
        }
        return new File(this.root, this.logFilename());
    }

    public final File getMetadataFile() {
        return new File(this.root, this.metadataFilename());
    }

    public final RogLogMetadata getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getCompactionThreshold() {
        RogLog rogLog = this;
        synchronized (rogLog) {
            return this.compactorParams.compactionThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCompactionThreshold(int val) {
        RogLog rogLog = this;
        synchronized (rogLog) {
            this.compactorParams.compactionThreshold = (long)val * 1024L * 1024L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scheduleCompactionOnNextWrite() {
        RogLog rogLog = this;
        synchronized (rogLog) {
            this.compactOnNextWrite = true;
        }
    }

    public final void delete() throws IOException {
        if (this.isOpen()) {
            throw new IOException("Cannot delete open log");
        }
        try {
            this.metadata.open();
        }
        catch (Exception e) {
            throw new IOException("Error opening metadata: " + e.getLocalizedMessage(), e);
        }
        File metadataFile = new File(this.root, this.metadataFilename());
        try {
            new File(this.root, this.logFilename()).delete();
            new File(this.root, this.indexFilename()).delete();
            new File(this.root, this.factoriesFilename()).delete();
            new File(this.root, this.metadataFilename()).delete();
        }
        finally {
            this.metadata.close();
            metadataFile.delete();
        }
    }

    public final String backupLog(boolean shrinkToSize) throws Exception {
        if (this.isOpen()) {
            throw new IllegalStateException("the log file cannot be backed up after the persister has been opened");
        }
        return this.backupLog(this.getLiveLogNumber(), shrinkToSize);
    }

    @Override
    public final void setStartupExpectation(IStorePersister.StartupExpectation expectation, Enum<?> value) {
        if (expectation == null) {
            throw new IllegalArgumentException("expectation cannot be null");
        }
        if (this.isOpen()) {
            throw new IllegalStateException("startup expectation can only be set before open");
        }
        switch (expectation) {
            case LogPresence: {
                if (value != null) {
                    if (value instanceof IStorePersister.LogPresenceExpectation) {
                        this.logPresenceStartupExpectation = (IStorePersister.LogPresenceExpectation)value;
                        break;
                    }
                    throw new IllegalArgumentException("log presence expectation must of type IStorePersister.LogPresenceExpectation");
                }
                this.logPresenceStartupExpectation = null;
                break;
            }
            case LogEmptiness: {
                if (value != null) {
                    if (value instanceof IStorePersister.LogEmptinessExpectation) {
                        this.logEmptinessStartupExpectation = (IStorePersister.LogEmptinessExpectation)value;
                        break;
                    }
                    throw new IllegalArgumentException("log emptiness expectation must of type IStorePersister.LogEmptinessExpectation");
                }
                this.logEmptinessStartupExpectation = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown expectation '" + (Object)((Object)expectation) + "'");
            }
        }
    }

    public final void setIsPureMessageLogger(boolean isPureMessageLogger) {
        this.isPureMessageLogger = isPureMessageLogger;
        if (this.isOpen()) {
            this.metadata.setIsPureMessageLogger(isPureMessageLogger);
        }
    }

    @Override
    public final void open(PktBuffer serializedMetadata, boolean truncateLive, boolean concurrentReadWrite) throws Exception {
        block37: {
            PktRecoveryLog.FileOpenMode openMode;
            if (this.isOpen()) {
                throw new IllegalStateException("log is already open");
            }
            if (this.closed) {
                throw new IllegalStateException("log is closed");
            }
            if (failOpen) {
                throw new OdsException("force failed by user");
            }
            String openModeStr = UtlProps.getValue((Properties)this.props, (String)PROP_LOG_MODE, (String)UtlProps.getValue((Properties)this.props, (String)"logOpenMode", (String)PktRecoveryLog.FileOpenMode.rw.toString()));
            try {
                openMode = PktRecoveryLog.FileOpenMode.valueOf((String)openModeStr);
            }
            catch (Exception e) {
                throw new OdsException("Invalid log open mode '" + openModeStr + "'.");
            }
            boolean cdcEnabled = UtlProps.getValue((Properties)this.props, (String)PROP_CDC_ENABLED, (boolean)false);
            long initialLength = (long)UtlUnit.parseBytes((String)UtlProps.getValue((Properties)this.props, (String)PROP_INITIAL_LOG_LENGTH, (String)String.valueOf(1.0f)), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Gigabytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
            boolean zeroOutInitial = UtlProps.getValue((Properties)this.props, (String)PROP_ZERO_OUT_INITIAL, (boolean)false);
            int autoFlushSize = (int)UtlUnit.parseBytes((String)UtlProps.getValue((Properties)this.props, (String)PROP_AUTO_FLUSH_SIZE, (String)"8k"), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
            int pageSize = (int)UtlUnit.parseBytes((String)UtlProps.getValue((Properties)this.props, (String)PROP_PAGE_SIZE, (String)"8k"), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
            if (this.tracer.isEnabled(Tracer.Level.CONFIG)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Transaction Log '" + this.getName() + "' Configuration {").append("\n");
                sb.append("...autoFlushSize=" + autoFlushSize).append(" (").append(UtlUnit.readableBytesSize((long)autoFlushSize)).append(")").append("\n");
                sb.append("...autoRepair=" + this.autoRepair).append("\n");
                sb.append("...cdcEnabled=" + cdcEnabled).append("\n");
                sb.append("...flushUsingMappedMemory=" + this.flushUsingMappedMemory).append("\n");
                sb.append("...initialLogLength=" + initialLength).append(" (").append(UtlUnit.readableBytesSize((long)initialLength)).append(")").append("\n");
                sb.append("...logOpenMode=" + openMode).append("\n");
                sb.append("...pageSize=" + pageSize).append(" (").append(UtlUnit.readableBytesSize((long)pageSize)).append(")").append("\n");
                sb.append("...storeRoot=" + this.root).append("\n");
                sb.append("...zeroOutInitial=" + zeroOutInitial).append("\n");
                this.compactorParams.dump("...", sb);
                this.cdcParams.dump("...", sb);
                sb.append("}");
                this.tracer.log("\n" + sb.toString(), Tracer.Level.CONFIG);
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "Opening log (root=" + this.root.getAbsolutePath() + ")...", Tracer.Level.DEBUG);
            }
            RogLog.checkAndCreateStoreRoot(this.root);
            this.metadata.open((IOElasticBuffer)serializedMetadata, this.role);
            if (serializedMetadata == null) {
                if (this.props.containsKey(PROP_CDC_ENABLED)) {
                    this.metadata.setCdcEnabled(cdcEnabled);
                }
                if (this.isPureMessageLogger) {
                    this.metadata.setIsPureMessageLogger(this.isPureMessageLogger);
                }
            }
            if (truncateLive) {
                for (int i = 0; i <= this.getLiveLogNumber(); ++i) {
                    this.backupLog(i, true);
                }
            }
            int flags = 0;
            if (this.autoRepair) {
                flags |= 2;
            }
            if (cdcEnabled || concurrentReadWrite) {
                flags |= 0x80;
            }
            if (this.logEmptinessStartupExpectation != null) {
                switch (this.logEmptinessStartupExpectation) {
                    case None: {
                        break;
                    }
                    case Empty: {
                        flags |= 4;
                        break;
                    }
                    case NotEmpty: {
                        flags |= 0x20;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported log emptiness expectation '" + (Object)((Object)this.logEmptinessStartupExpectation) + "'");
                    }
                }
            }
            if (this.logPresenceStartupExpectation != null) {
                switch (this.logPresenceStartupExpectation) {
                    case None: {
                        break;
                    }
                    case Present: {
                        flags |= 8;
                        break;
                    }
                    case Absent: {
                        flags |= 0x10;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported log presence expectation '" + (Object)((Object)this.logPresenceStartupExpectation) + "'");
                    }
                }
            }
            try {
                this.tracer.log(this.tracePrefix() + "Live transaction log file is '" + this.logFilename() + "' [" + this.root.getCanonicalPath() + "]...", Tracer.Level.INFO);
                this.log = PktRecoveryLog.create((String)this.root.getAbsolutePath(), (String)this.logFilename(), (PktRecoveryLog.FileOpenMode)openMode, (long)initialLength, (boolean)zeroOutInitial, (boolean)this.flushUsingMappedMemory, (int)autoFlushSize, (int)pageSize);
                this.log.open(flags, this.metadata.getLastValidatedPosition(), (PktRecoveryLog.ILogIntegrityChecker)(UtlProps.getValue((Properties)this.props, (String)PROP_TRANSACTIONAL_INTEGRITY_CHECK, (boolean)true) ? new LogIntegrityChecker() : null));
                this.metadata.setLastValidatedPosition(this.log.getNextWritePointer());
            }
            catch (EPktLogExpectationNotMetException e) {
                Throwable oe;
                switch (e.getUnmetExpectation()) {
                    case 4: {
                        oe = new OdsExpectationNotMetException(IStorePersister.StartupExpectation.LogEmptiness, this.logEmptinessStartupExpectation, e.getUnmetExpectationData(), e.getMessage());
                        break;
                    }
                    case 32: {
                        oe = new OdsExpectationNotMetException(IStorePersister.StartupExpectation.LogEmptiness, this.logEmptinessStartupExpectation, e.getUnmetExpectationData(), e.getMessage());
                        break;
                    }
                    case 8: 
                    case 16: {
                        oe = new OdsExpectationNotMetException(IStorePersister.StartupExpectation.LogPresence, this.logPresenceStartupExpectation, e.getUnmetExpectationData(), e.getMessage());
                        break;
                    }
                    default: {
                        oe = null;
                    }
                }
                if (oe == null) break block37;
                oe.initCause(e);
                throw oe;
            }
        }
        try {
            this.initCheckpointState();
            this.scavenge();
            this.writeFactories();
            if (this.compactorParams.compactionThreshold > 0L) {
                this.compactor.start();
                if (this.compactorParams.compactOnStart) {
                    this.compactor.compact().waitForCompactionToComplete();
                }
            }
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    @Override
    public final void open(PktBuffer serializedMetadata, boolean truncateLive) throws Exception {
        this.open(serializedMetadata, truncateLive, false);
    }

    @Override
    public final void open(boolean concurrentReadWrite) throws Exception {
        this.open(null, false, concurrentReadWrite);
    }

    @Override
    public final void open() throws Exception {
        this.open(false);
    }

    public final UUID getLogUUID() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        return this.metadata.getLogUUID();
    }

    public final CheckpointState getCheckpointState() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        return this.checkpointState;
    }

    @Override
    public final boolean isOpen() {
        return this.log != null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final StorePersisterDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final void setErrorHandler(IStorePersister.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public final IStorePersister.ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public final void setEventHandler(IEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public IEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public final IStorePersisterStats getStats() {
        return this.stats;
    }

    @Override
    public final boolean wasRepaired() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        return this.log.wasRepaired();
    }

    @Override
    public final void readMetadata(PktBuffer buffer) {
        if (this.compactorParams.compactionThreshold > 0L || this.metadata.isCdcEnabled()) {
            this.metadata.serialize((IOElasticBuffer)buffer);
        }
    }

    @Override
    public final IStoreReader.IterativeReader iterativeReader(int flags) throws Exception {
        return this.storeReader.open(flags, System.currentTimeMillis());
    }

    @Override
    public final boolean read(IStoreReader.ReadCallback cb) throws Exception {
        return this.read(cb, 0);
    }

    @Override
    public final boolean read(IStoreReader.ReadCallback cb, int flags) throws Exception {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        long ts = System.currentTimeMillis();
        try {
            StoreCommitEntry commitEntry;
            if (!this.storeReader.open()) {
                this.tracer.log(this.tracePrefix() + "Transaction log read started.", Tracer.Level.INFO);
                this.storeReader.open(flags, ts);
                cb.metadata(this.storeReader.metadata());
            } else {
                this.tracer.log(this.tracePrefix() + "Transaction log read resumed.", Tracer.Level.INFO);
            }
            boolean suspend = false;
            while ((commitEntry = this.storeReader.next()) != null && !(suspend = !cb.entry(commitEntry))) {
            }
            long readTime = System.currentTimeMillis() - ts;
            this.storeReader.stats().recordReadLegTime(readTime);
            long elapsedTime = this.storeReader.stats().elapsedTime();
            if (!suspend) {
                cb.done(-1L);
                this.tracer.log(this.tracePrefix() + "Transaction log read complete (entries=" + this.storeReader.stats().numEntriesRead() + ", transactions=" + this.storeReader.stats().numTransactionsRead() + ", elapsedTime=" + UtlUnit.formatDuration((double)elapsedTime, (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ", readTime=" + UtlUnit.formatDuration((double)this.storeReader.stats().readTime(), (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ").", Tracer.Level.INFO);
                this.storeReader.close();
            } else {
                this.tracer.log(this.tracePrefix() + "Transaction log read suspended (entries=" + this.storeReader.stats().numEntriesRead() + ", transactions=" + this.storeReader.stats().numTransactionsRead() + ", elapsedTime=" + UtlUnit.formatDuration((double)elapsedTime, (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ", sectionReadTime=" + UtlUnit.formatDuration((double)readTime, (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ", totalReadTime=" + UtlUnit.formatDuration((double)this.storeReader.stats().readTime(), (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ").", Tracer.Level.INFO);
            }
            return !suspend;
        }
        catch (Throwable e) {
            this.storeReader.close();
            throw new OdsException(e);
        }
    }

    @Override
    public final void log(IRogMessage message) {
        this.log(message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void log(IRogMessage message, boolean commitEnd) {
        StoreCommitEntry commitEntry;
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Logging message " + message + " (commitEnd=" + commitEnd + ")...", Tracer.Level.DEBUG);
        }
        if ((commitEntry = this.threadLocalCommitEntry.get()) == null) {
            commitEntry = StoreCommitEntry.create();
            this.threadLocalCommitEntry.set(commitEntry);
        }
        commitEntry.init(IStoreBinding.Operation.Send, message.getId(), message.getOfid(), message.getType(), message.getTransactionId(), message.getStableTransactionId(), message.getCheckpointVersion(), message, (PktPacket)(this.detachedMessageSerialization && this.isDetached() ? null : message.serializeToPacket()), message.getContentEncodingType(), false, commitEnd);
        try {
            this.writeCommitEntry(commitEntry, false, false);
        }
        finally {
            if (commitEntry.serializedObject != null) {
                commitEntry.serializedObject.dispose();
            }
            commitEntry.fin();
        }
    }

    @Override
    public final void flush(boolean sync) {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Flushing the message log (sync=" + sync + ")...", Tracer.Level.DEBUG);
        }
        this.scheduleFlush(sync);
    }

    public final RogLogReader createReader() throws Exception {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        return new RogLogReader(this, this.log.createReader(), this.tracer, this.tracePrefix());
    }

    public final RogLogReader createReader(int logNumber) throws Exception {
        return new RogLogReader(this, this.createPacketReader(logNumber, 256), this.tracer, this.tracePrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PktRecoveryLog.Reader createPacketReader(int logNumber, int flags) throws IOException {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        PktRecoveryLog numberedLog = PktRecoveryLog.create((String)this.log.getDirname(), (String)this.logFilename(logNumber), (PktRecoveryLog.FileOpenMode)PktRecoveryLog.FileOpenMode.r, (long)0L, (boolean)false, (int)this.log.getAutoFlushSize(), (int)this.log.getPageSize());
        if (this.log.supportsTailing()) {
            flags |= 0x80;
        }
        if (logNumber == this.getLiveLogNumber()) {
            flags |= 0x100;
        }
        numberedLog.open(flags, -1L);
        try {
            PktRecoveryLog.Reader reader = numberedLog.createReader();
            if ((flags & 0x40) > 0) {
                reader.setPacketBodyDesyncDisabled(true);
            }
            reader.reset();
            PktRecoveryLog.Reader reader2 = reader;
            return reader2;
        }
        finally {
            numberedLog.close();
        }
    }

    public final RogLogCdcProcessor createCdcProcessor(IRogChangeDataCaptureHandler handler) throws Exception {
        return new RogLogCdcProcessor(this, handler, this.cdcParams);
    }

    public final long getSize() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (this.compactor.isCompactionInProgress()) {
            this.compactionSynchronizer.lock();
            try {
                long l = this.log.getSize();
                return l;
            }
            finally {
                this.compactionSynchronizer.unlock();
            }
        }
        return this.log.getSize();
    }

    public final long getAllocatedSize() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (this.compactor.isCompactionInProgress()) {
            this.compactionSynchronizer.lock();
            try {
                long l = this.log.getAllocatedSize();
                return l;
            }
            finally {
                this.compactionSynchronizer.unlock();
            }
        }
        return this.log.getAllocatedSize();
    }

    @Override
    public final void fail(Exception cause) {
        this.doFail(cause);
    }

    @Override
    public final void fail() {
        this.fail(new OdsException("force failed by user"));
    }

    public final RogLogRepository asRepository() {
        return new RogLogRepositoryImpl(this);
    }

    public final RogLogCompactor getCompactor() {
        return this.compactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File archive(File archiveFolder, String archiveId) throws IOException {
        if (this.isOpen()) {
            throw new IllegalStateException("Can't archive an open log file");
        }
        if (!this.metadata.exists()) {
            throw new IllegalStateException("Can't archive a transaction log with missing .metadata: " + this.metadataFilename() + " does not exist");
        }
        try {
            this.metadata.open();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error opening transaction log metadata: " + e.getLocalizedMessage(), e);
        }
        try {
            String backupFilename = PktRecoveryLog.backup((String)this.root.getAbsolutePath(), (String)this.logFilename(), (boolean)false, (boolean)true, (boolean)false);
            File backupFile = new File(this.root, backupFilename).getCanonicalFile();
            String backupName = this.getName() + "-" + archiveId;
            if (!archiveFolder.exists() && !archiveFolder.mkdirs()) {
                throw new IOException("Failed to create archive folder " + archiveFolder);
            }
            File archiveLogFile = new File(archiveFolder, this.logFilename(backupName));
            if (!backupFile.renameTo(archiveLogFile)) {
                throw new IOException("Failed to move transaction log backup '" + backupFile + "' to '" + archiveLogFile + "'");
            }
            File metadataFile = new File(this.root, this.metadataFilename());
            File archivedMetadataFile = new File(archiveFolder, this.metadataFilename(backupName));
            UtlFile.copyFile((File)metadataFile, (File)archivedMetadataFile);
            File factoriesFile = new File(this.root, this.factoriesFilename());
            File archivedFactoriesFile = new File(archiveFolder, this.factoriesFilename(backupName));
            UtlFile.copyFile((File)factoriesFile, (File)archivedFactoriesFile);
            File indexFile = new File(this.root, this.indexFilename());
            if (indexFile.exists()) {
                File archivedIndexFile = new File(archiveFolder, this.indexFilename(backupName));
                UtlFile.copyFile((File)indexFile, (File)archivedIndexFile);
                File indexPFile = new File(this.root, this.indexPFilename());
                if (indexPFile.exists()) {
                    File archivedIndexPFile = new File(archiveFolder, this.indexPFilename(backupName));
                    UtlFile.copyFile((File)indexPFile, (File)archivedIndexPFile);
                }
            }
            for (int i = Math.max(0, this.metadata.getCdcLogNumber()); i < Math.max(0, this.metadata.getLiveLogNumber()); ++i) {
                File cdcFile = new File(this.root, this.logFilename(i));
                if (!cdcFile.exists()) continue;
                File archivedCheckpointFile = new File(archiveFolder, backupFilename + "." + i + ".log");
                UtlFile.copyFile((File)cdcFile, (File)archivedCheckpointFile);
            }
            File file = archiveLogFile;
            return file;
        }
        finally {
            this.metadata.close();
        }
    }

    @Override
    public final void close() {
        super.stop();
        try {
            this.compactor.stop();
            if (this.log != null) {
                this.log.close();
            }
            if (this.metadata != null) {
                this.metadata.close();
            }
            this.entryPool.close();
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix() + "Failed to close the transaction log [" + e.toString() + "]", Tracer.Level.WARNING);
        }
        finally {
            this.log = null;
            this.closed = true;
        }
    }

    public String toString() {
        return "RogLog: " + this.name;
    }

    public static final class Stats
    implements IStoreWriter.LogCounters {
        private static final String header = String.format("%8s | %8s | %8s | %8s | %8s |%8s | %8s | %8s | %8s | %8s", "NumTxns", "Orphans", "TxnGaps", "TxnDups", "TxnParts", "Puts", "Updates", "Removes", "Sends", "Messages");
        long lastTxnId = -1L;
        int numTransactions = 0;
        int numOrphans = 0;
        int numPuts = 0;
        int numUpdates = 0;
        int numRemoves = 0;
        int numSends = 0;
        int numMessages = 0;
        int numTxnDups = 0;
        int numTxnGaps = 0;
        int numTxnParts = 0;
        HashSet<Long> partialTxns;

        final void update(Entry.Type type) {
            switch (type) {
                case Message: {
                    ++this.numMessages;
                    break;
                }
                case Put: {
                    ++this.numPuts;
                    break;
                }
                case Remove: {
                    ++this.numRemoves;
                    break;
                }
                case Send: {
                    ++this.numSends;
                    break;
                }
                case Update: {
                    ++this.numUpdates;
                }
            }
        }

        final Entry update(Entry entry) {
            if (entry == null) {
                return entry;
            }
            this.update(entry.getEntryType());
            long txnId = entry.getTransactionId();
            if (txnId == -1L) {
                ++this.numOrphans;
            } else if (entry.isCommitEnd()) {
                if (this.partialTxns != null && this.partialTxns.remove(txnId)) {
                    --this.numTxnParts;
                }
                boolean dup = false;
                if (txnId <= this.lastTxnId) {
                    ++this.numTxnDups;
                    dup = true;
                } else if (txnId != this.lastTxnId + 1L && this.lastTxnId != -1L) {
                    ++this.numTxnGaps;
                }
                ++this.numTransactions;
                if (!dup) {
                    this.lastTxnId = txnId;
                }
            } else {
                if (this.partialTxns == null) {
                    this.partialTxns = new HashSet();
                }
                if (!this.partialTxns.contains(txnId)) {
                    this.partialTxns.add(txnId);
                    ++this.numTxnParts;
                }
            }
            return entry;
        }

        final void copy(Stats counters) {
            this.lastTxnId = counters.lastTxnId;
            this.numMessages = counters.numMessages;
            this.numOrphans = counters.numOrphans;
            this.numSends = counters.numSends;
            this.numPuts = counters.numPuts;
            this.numRemoves = counters.numRemoves;
            this.numTransactions = counters.numTransactions;
            this.numUpdates = counters.numUpdates;
            this.numTxnDups = counters.numTxnDups;
            this.numTxnGaps = counters.numTxnGaps;
            this.numTxnParts = counters.numTxnParts;
        }

        final void reset() {
            this.lastTxnId = -1L;
            this.numMessages = 0;
            this.numOrphans = 0;
            this.numSends = 0;
            this.numPuts = 0;
            this.numRemoves = 0;
            this.numTransactions = 0;
            this.numUpdates = 0;
            this.numTxnDups = 0;
            this.numTxnGaps = 0;
            this.numTxnParts = 0;
            this.partialTxns = null;
        }

        public static final String getHeaderRow() {
            return header;
        }

        public final Stats delta(Stats compare) {
            Stats rc = new Stats();
            rc.numMessages = compare.numMessages - this.numMessages;
            rc.numSends = compare.numSends - this.numSends;
            rc.numUpdates = compare.numUpdates - this.numUpdates;
            rc.numRemoves = compare.numRemoves - this.numRemoves;
            rc.numPuts = compare.numPuts - this.numPuts;
            rc.numTxnGaps = compare.numTxnGaps - this.numTxnGaps;
            rc.numTxnDups = compare.numTxnDups - this.numTxnDups;
            rc.numTxnParts = compare.numTxnParts - this.numTxnParts;
            rc.numOrphans = compare.numOrphans - this.numOrphans;
            rc.numTransactions = compare.numTransactions - this.numTransactions;
            return rc;
        }

        @Override
        public final int getNumOrphans() {
            return this.numOrphans;
        }

        @Override
        public final int getNumPuts() {
            return this.numPuts;
        }

        @Override
        public final int getNumUpdates() {
            return this.numUpdates;
        }

        @Override
        public final int getNumRemoves() {
            return this.numRemoves;
        }

        @Override
        public final int getNumSends() {
            return this.numSends;
        }

        @Override
        public final int getNumMessages() {
            return this.numMessages;
        }

        @Override
        public final int getNumTransactions() {
            return this.numTransactions;
        }

        @Override
        public final int getNumDupTransactions() {
            return this.numTxnDups;
        }

        @Override
        public final int getNumGapTransactions() {
            return this.numTxnGaps;
        }

        @Override
        public final int getNumPartialTransactions() {
            return this.numTxnParts;
        }

        public int getNumEntries() {
            return this.numPuts + this.numUpdates + this.numRemoves + this.numMessages + this.numSends;
        }

        public final String toString() {
            return String.format("%8d | %8d | %8s | %8s | %8d | %8d |%8d | %8d | %8d | %8d", this.numTransactions, this.numOrphans, this.numTxnGaps, this.numTxnDups, this.numTxnParts, this.numPuts, this.numUpdates, this.numRemoves, this.numSends, this.numMessages);
        }
    }

    @JsonPropertyOrder(value={"entryType", "checkpointVersion", "className", "commitStart", "commitEnd", "contentEncodingType", "entrySize", "filePosition", "id", "logName", "payloadSize", "simpleClassName", "stableTransactionId", "timestamp", "transactionId", "ofid", "otype", "metadata", "object"})
    public static final class Entry
    implements UtlPool.Item<Entry> {
        private static final IdxField<Entry, Class<?>> PAYLOAD_TYPE;
        private static final UtlPool<Entry> FACTORY;
        private RogLog log;
        private long fpos;
        private int serializedSize = -1;
        private Type type;
        private UUID id;
        private short ofid;
        private short otype;
        private long transactionId;
        private long stableTransactionId;
        private long checkpointVersion;
        private PktPacket packet;
        private short contentEncodingType;
        private PktBuffer serializedMetadata;
        private long timestamp;
        private boolean commitStart;
        private boolean commitEnd;
        private IStoreObject object;
        private int payloadSize = -1;
        private IRogMetadata metadata;
        private UtlPool<Entry> pool;
        private static final String headerRow;
        private static final String headerRowCsv = "Type,Class,ObjectId,ParentId,TxnId,StblTxId,InSeq#,OutSeq#,MsgSeq#,ChkPnt#,HasInMsg?,HasOutMsg?,PossibleDup,CommitStart,CommitEnd";

        Entry() {
        }

        private final String toCsv() {
            StringBuilder sb = new StringBuilder();
            IRogNode node = (IRogNode)this.getObject();
            sb.append(String.format("%s,%s,%s,%s,%d,%d,%d,%d,%d,%d,%s,%s,%s,%s,%s", this.getEntryType().toString(), node == null ? "" : node.getClass().getSimpleName(), this.getId() != null ? this.getId().toString() : "null", this.getMetadata().getParentId(), this.getTransactionId(), this.getStableTransactionId(), this.getMetadata().getTransactionInSequenceNumber(), this.getMetadata().getTransactionOutSequenceNumber(), this.getMetadata().getMessageSequenceNumber(), this.getCheckpointVersion(), this.getMetadata().getInMsgsInTransaction() ? "true" : "false", this.getMetadata().getOutMsgsInTransaction() ? "true" : "false", this.getMetadata().isPossibleDuplicate() ? "true" : "false", this.isCommitStart() ? "true" : "false", this.isCommitEnd() ? "true" : "false"));
            return sb.toString();
        }

        private final String toTabular() {
            StringBuilder sb = new StringBuilder();
            char type = '?';
            switch (this.getEntryType()) {
                case Put: {
                    type = 'P';
                    break;
                }
                case Remove: {
                    type = 'R';
                    break;
                }
                case Send: {
                    type = 'S';
                    break;
                }
                case Update: {
                    type = 'U';
                    break;
                }
                case Message: {
                    type = 'M';
                }
            }
            IRogNode node = (IRogNode)this.getObject();
            sb.append(String.format("%4s | %30s | %36s | %36s | %07d | %07d | %07d | %07d | %07d | %07d | %s | %s | %s | %s | %s", Character.valueOf(type), node == null ? "" : node.getClass().getSimpleName(), this.getId() != null ? this.getId().toString() : "null", this.getMetadata().getParentId(), this.getTransactionId(), this.getStableTransactionId(), this.getMetadata().getTransactionInSequenceNumber(), this.getMetadata().getTransactionOutSequenceNumber(), this.getMetadata().getMessageSequenceNumber(), this.getCheckpointVersion(), this.getMetadata().getInMsgsInTransaction() ? "T" : "F", this.getMetadata().getOutMsgsInTransaction() ? "T" : "F", this.getMetadata().isPossibleDuplicate() ? "T" : "F", this.isCommitStart() ? "T" : "F", this.isCommitEnd() ? "T" : "F"));
            return sb.toString();
        }

        final Entry init(RogLog log, long fpos, int fsize, Type type, UUID id, short ofid, short otype, long transactionId, long stableTransactionId, long checkpointVersion, PktPacket packet, short contentEncodingType, PktBuffer serializedMetadata, long timestamp, boolean commitStart, boolean commitEnd) {
            this.log = log;
            this.fpos = fpos;
            this.serializedSize = fsize;
            this.type = type;
            this.id = id;
            this.ofid = ofid;
            this.otype = otype;
            this.transactionId = transactionId;
            this.stableTransactionId = stableTransactionId;
            this.checkpointVersion = checkpointVersion;
            this.packet = packet;
            this.contentEncodingType = contentEncodingType;
            this.serializedMetadata = serializedMetadata;
            this.timestamp = timestamp;
            this.commitStart = commitStart;
            this.commitEnd = commitEnd;
            return this;
        }

        public static final Entry create(PktPacket packet) throws OdsException {
            PktSubheaderODS subheader = packet.getHeader().getODSSubheader();
            if (subheader == null) {
                throw new OdsException("Packet does not have a valid ODS subheader");
            }
            short ofid = subheader.getObjectFactoryId();
            short otype = subheader.getObjectType();
            UUID id = subheader.getObjectId() == null ? null : new UUID(subheader.getObjectId());
            short contentEncodingType = subheader.getContentEncodingType();
            PktBuffer metadata = subheader.getObjectMetadata();
            boolean commitStart = subheader.getFlagCommitStart();
            boolean commitEnd = subheader.getFlagCommitEnd();
            long timestamp = subheader.getTimestamp();
            long transactionId = subheader.getTransactionId();
            long stableTransactionId = subheader.getStableTransactionId();
            long checkpointVersion = subheader.getCheckpointVersion();
            PktRecoveryLog.FilePosition fp = (PktRecoveryLog.FilePosition)packet.getTag(4);
            long filePointer = -1L;
            int serializedSize = packet.getSerializedLength();
            if (fp != null) {
                filePointer = ((PktRecoveryLog.FilePosition)packet.getTag(4)).getPosition();
                serializedSize = ((PktRecoveryLog.FilePosition)packet.getTag(4)).getSize();
            }
            Entry entry = (Entry)FACTORY.get(null);
            switch (subheader.getCommitEntryType()) {
                case 1: {
                    entry.init(null, filePointer, serializedSize, Type.Put, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
                    packet.acquire();
                    break;
                }
                case 2: {
                    entry.init(null, filePointer, serializedSize, Type.Update, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
                    packet.acquire();
                    break;
                }
                case 3: {
                    entry.init(null, filePointer, serializedSize, Type.Remove, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
                    break;
                }
                case 4: {
                    entry.init(null, filePointer, serializedSize, Type.Send, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
                    packet.acquire();
                    break;
                }
                case 5: {
                    entry.init(null, filePointer, serializedSize, Type.Message, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
                    packet.acquire();
                    break;
                }
                default: {
                    throw new OdsException("PktPacket has unsupported  commit entry type (type='" + subheader.getCommitEntryType() + "')");
                }
            }
            return entry;
        }

        @JsonProperty
        public final long getFilePosition() {
            return this.fpos;
        }

        @JsonProperty
        public final String getLogName() {
            return this.log == null ? null : this.log.getName();
        }

        @JsonProperty
        @JsonSerialize(converter=RogUtil.TimestampToDateConverter.class)
        public final long getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty
        public final Type getEntryType() {
            return this.type;
        }

        @JsonProperty
        public final int getEntrySize() {
            return this.serializedSize;
        }

        @JsonProperty
        public final int getPayloadSize() {
            if (this.payloadSize == -1) {
                if (this.getEntryType() == Type.Remove) {
                    this.payloadSize = 0;
                }
                this.payloadSize = this.packet == null ? this.payloadSize : this.packet.getBody().getSerializedLength();
            }
            return this.payloadSize;
        }

        @JsonProperty
        public final String getClassName() {
            Class type = (Class)PAYLOAD_TYPE.apply(this);
            return type == null ? null : type.getCanonicalName();
        }

        @JsonProperty
        public final String getSimpleClassName() {
            Class type = (Class)PAYLOAD_TYPE.apply(this);
            return type == null ? null : type.getSimpleName();
        }

        @JsonProperty
        @JsonSerialize(converter=RogUtil.UUIDToStringConverter.class)
        public final UUID getId() {
            return this.id;
        }

        @JsonProperty
        public final long getTransactionId() {
            return this.transactionId;
        }

        @JsonProperty
        public final long getStableTransactionId() {
            return this.stableTransactionId;
        }

        @JsonProperty
        public final long getCheckpointVersion() {
            return this.checkpointVersion;
        }

        @JsonIgnore
        public final PktPacket getPacket() {
            return this.packet;
        }

        @JsonProperty
        public final IStoreObject getObject() {
            if (this.type == Type.Remove && this.otype == 0 && this.ofid == 0) {
                return null;
            }
            if (this.object == null && this.packet != null) {
                IStoreObjectFactory factory = StoreObjectFactoryRegistry.getInstance().getObjectFactory(this.ofid);
                if (factory == null) {
                    throw new RuntimeException("Factory for object with ofid=" + this.ofid + " not found");
                }
                try {
                    this.payloadSize = this.packet.getBody().getSerializedLength();
                    this.object = factory.create(this.otype, this.id, IStoreObject.EncodingType.fromMessageViewEncoding(this.contentEncodingType), this.packet.acquire());
                    if (this.object instanceof IRogNode) {
                        ((IRogNode)this.object).deserializeMetadata(this.serializedMetadata);
                        this.object.setCheckpointVersion(this.getCheckpointVersion());
                        this.object.setStableTransactionId(this.getStableTransactionId());
                        this.object.setTransactionId(this.getTransactionId());
                        this.metadata = null;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error deserializing transaction log entry", e);
                }
            }
            if (this.object == null && this.type != Type.Remove) {
                throw new RuntimeException("Missing object on deserialization of packet for id=" + this.id);
            }
            return this.object;
        }

        @JsonIgnore
        public final boolean isPayloadDeserialized() {
            return this.object != null;
        }

        @JsonProperty(value="commitStart")
        public final boolean isCommitStart() {
            return this.commitStart;
        }

        @JsonProperty(value="commitEnd")
        public final boolean isCommitEnd() {
            return this.commitEnd;
        }

        public static final String getHeaderRow(boolean csv) {
            return csv ? headerRowCsv : headerRow;
        }

        public final String toString() {
            return this.toTabular();
        }

        public final String toString(boolean csv) {
            return csv ? this.toCsv() : this.toTabular();
        }

        @JsonProperty
        public short getOfid() {
            return this.ofid;
        }

        @JsonProperty
        public short getOtype() {
            return this.otype;
        }

        @JsonIgnore
        final PktPacket getSerializedObject() {
            return this.packet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JsonIgnore
        public final ByteBuffer getRawBody() {
            if (this.packet != null) {
                PktBuffer packetBuffer = this.packet.getBody().getBuffer();
                IOBuffer ioBuffer = packetBuffer.getIOBuffer();
                ByteBuffer byteBuffer = ioBuffer.takeBuffer();
                try {
                    ByteBuffer bb;
                    byteBuffer.position(packetBuffer.getOffset());
                    byteBuffer.limit(packetBuffer.getLength());
                    ByteBuffer byteBuffer2 = bb = byteBuffer.duplicate();
                    return byteBuffer2;
                }
                finally {
                    ioBuffer.releaseBuffer();
                }
            }
            return null;
        }

        @JsonProperty
        public IStoreObject.EncodingType getContentEncodingType() {
            return IStoreObject.EncodingType.fromMessageViewEncoding(this.contentEncodingType);
        }

        @JsonIgnore
        public PktBuffer getSerializedMetadata() {
            return this.serializedMetadata;
        }

        @JsonProperty
        public IRogMetadata getMetadata() {
            if (this.object != null && this.object instanceof IRogNode) {
                return ((IRogNode)this.object).getMetadata();
            }
            if (this.metadata != null) {
                return this.metadata;
            }
            if (this.serializedMetadata != null) {
                this.metadata = RogDirectMetadata.createFrom((IOElasticBuffer)this.serializedMetadata);
            }
            return this.metadata;
        }

        @JsonIgnore
        public RogLog getLog() {
            return this.log;
        }

        public final void dispose() {
            if (this.packet != null) {
                this.packet.dispose();
            }
            if (this.object != null) {
                this.object.dispose();
            }
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }

        public final Entry init() {
            this.object = null;
            this.packet = null;
            this.payloadSize = -1;
            this.metadata = null;
            this.serializedMetadata = null;
            this.id = null;
            this.log = null;
            return this;
        }

        public final Entry setPool(UtlPool<Entry> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<Entry> getPool() {
            return this.pool;
        }

        static {
            FACTORY = UtlPool.create((String)"rog.log.entry", (String)"global", (UtlPool.Factory)new Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
            IdxFieldResolver fieldResolver = RogLogFactory.createFieldResolver();
            PAYLOAD_TYPE = fieldResolver.getField(Entry.class, "object.class");
            headerRow = "I=InboundMsgsInTxn?\nO=OutboundMsgsInTxn?\nD=PossibleDup?\nS=CommitStart?\nE=CommitEnd?\n" + String.format("%4s | %30s | %36s | %36s | %7s | %8s| %7s | %7s | %7s | %7s | %s | %s | %s | %s | %s", "Type", "Class", "ObjectId", "ParentId", "TxnId", "StblTxId", "InSeq#", "OutSeq#", "MsgSeq#", "ChkPnt#", "I", "O", "D", "S", "E");
        }

        public static enum Type {
            Put,
            Update,
            Remove,
            Send,
            Message;

        }

        static final class Factory
        implements UtlPool.Factory<Entry> {
            Factory() {
            }

            public final Entry createItem(Object object) {
                return new Entry();
            }

            public final Entry[] createItemArray(int size) {
                return new Entry[size];
            }
        }
    }

    public static enum CheckpointState {
        Pending,
        AllEntriesCheckpointed,
        NoEntriesCheckpointed;

    }

    private final class StoreReader
    implements IStoreReader.IterativeReader {
        private final StoreCommitEntry commitEntry = StoreCommitEntry.create();
        private final Stats stats = new Stats();
        private boolean open;
        private PktRecoveryLog.Reader logReader;

        private StoreReader() {
        }

        final IStoreReader.IterativeReader open(int flags, long ts) throws Exception {
            if (this.open) {
                this.close();
            }
            RogLog.this.compactionSynchronizer.lock();
            this.logReader = RogLog.this.log.createReader();
            if ((flags & 0x40) == 64) {
                this.logReader.setPacketBodyDesyncDisabled(true);
            }
            this.logReader.reset();
            this.stats.init(ts);
            RogLog.this.metadata.serialize((IOElasticBuffer)this.commitEntry.serializedPersisterMetadata);
            this.open = true;
            return this;
        }

        @Override
        public final boolean open() {
            return this.open;
        }

        @Override
        public final PktBuffer metadata() {
            if (!this.open) {
                throw new IllegalStateException("reader not open");
            }
            return this.commitEntry.serializedPersisterMetadata;
        }

        @Override
        public final void seek(long pos) throws IOException {
            if (!this.open) {
                throw new IllegalStateException("reader not open");
            }
            if (pos < 0L) {
                throw new IllegalArgumentException("pos must be >= 0");
            }
            if (pos == 0L) {
                this.logReader.reset();
            } else {
                this.logReader.seek(pos);
            }
        }

        @Override
        public final StoreCommitEntry next() throws Exception {
            if (!this.open) {
                throw new IllegalStateException("reader not open");
            }
            PktPacket packet = this.logReader.next();
            if (packet != null && RogLog.this.depacketize(packet, this.commitEntry)) {
                this.stats.eCount++;
                if (this.commitEntry.commitEnd) {
                    this.stats.tCount++;
                }
                return this.commitEntry;
            }
            return null;
        }

        @Override
        public final Stats stats() {
            if (!this.open) {
                throw new IllegalStateException("reader not open");
            }
            return this.stats;
        }

        @Override
        public final void close() {
            if (this.open) {
                try {
                    this.logReader.close();
                    RogLog.this.compactionSynchronizer.unlock();
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n").append("Failure encountered while closing log read context").append("\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    RogLog.this.tracer.log(RogLog.this.tracePrefix() + sb.toString(), Tracer.Level.WARNING);
                }
                finally {
                    this.open = false;
                }
            }
        }

        private final class Stats
        implements IStoreReader.IterativeReader.Stats {
            private long startTs;
            private int eCount;
            private int tCount;
            private long readTime;

            private Stats() {
            }

            final void init(long ts) {
                this.startTs = ts;
                this.eCount = 0;
                this.tCount = 0;
                this.readTime = 0L;
            }

            @Override
            public final long startTime() {
                return this.startTs;
            }

            @Override
            public final void recordReadLegTime(long timeInMillis) {
                if (!StoreReader.this.open) {
                    throw new IllegalStateException("reader not open");
                }
                this.readTime += timeInMillis;
            }

            @Override
            public final long readTime() {
                return this.readTime;
            }

            @Override
            public final long elapsedTime() {
                return System.currentTimeMillis() - this.startTs;
            }

            @Override
            public final int numEntriesRead() {
                return this.eCount;
            }

            @Override
            public final int numTransactionsRead() {
                return this.tCount;
            }
        }
    }

    private final class LogIntegrityChecker
    implements PktRecoveryLog.ILogIntegrityChecker {
        private boolean inTransaction;
        private int lastTransactionSize;
        private int numValidEntries;
        private long validatedFileLength;

        private LogIntegrityChecker() {
        }

        private final boolean endOfCommit(QuarkBuffer buffer, int bufferPosition) {
            long addr = buffer.getNativeAddress();
            try {
                int odsSubheaderOffset = PktHeader.getSubheaderOffset((long)addr, (int)bufferPosition, (int)7);
                return odsSubheaderOffset >= 0 ? (PktSubheaderODS.getFlags((long)addr, (int)odsSubheaderOffset) & 1) == 1 : false;
            }
            catch (Throwable e) {
                throw new EPktLogCorruptException(e);
            }
        }

        public final void init(long logPreambleLength) {
            this.inTransaction = false;
            this.lastTransactionSize = 0;
            this.numValidEntries = 0;
            this.validatedFileLength = logPreambleLength;
        }

        public final void onPacket(QuarkBuffer buffer, int bufferPosition, int packetLength, long filePosition) {
            if (!this.inTransaction) {
                this.inTransaction = true;
            }
            ++this.lastTransactionSize;
            if (this.endOfCommit(buffer, bufferPosition)) {
                this.inTransaction = false;
                this.numValidEntries += this.lastTransactionSize;
                this.validatedFileLength = filePosition + (long)packetLength;
                this.lastTransactionSize = 0;
            }
        }

        public final void done() {
            if (this.corruptionDetected()) {
                throw new EPktLogCorruptException("incomplete last transaction (" + this.lastTransactionSize + " entries)");
            }
        }

        public final boolean corruptionDetected() {
            return this.inTransaction;
        }

        public final int numValidEntries() {
            return this.numValidEntries;
        }

        public final long validatedFileLength() {
            return this.validatedFileLength;
        }
    }

    private static enum LogScavengePolicy {
        Delete,
        Disabled;

    }
}

