/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.ci.XRuntime;
import com.neeve.lang.XFloatIterator;
import com.neeve.lang.XFloatLinkedHashMap;
import com.neeve.lang.XFloatMap;
import com.neeve.lang.XFloatSet;
import com.neeve.lang.XIterator;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogFloatMap;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogCollectionNode;
import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogNode;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RogXFloatMap<V extends IRogCollectionNodeElement>
extends RogCollectionNode<V>
implements IRogFloatMap<V> {
    private final int initialCapacity = XRuntime.getValue((String)("nv.rog.map." + this.getClass().getName() + ".initialCapacity"), (int)0);
    private final XFloatLinkedHashMap<V> map = this.initialCapacity > 0 ? new XFloatLinkedHashMap(this.initialCapacity) : new XFloatLinkedHashMap();
    private Set<Map.Entry<Float, V>> boxedEntrySet;
    private Set<Float> boxedKeySet;

    protected RogXFloatMap(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
        this.map.setSupportsIteratorModifications(false);
    }

    protected abstract float getMapElementKey(V var1);

    protected abstract void setMapElementKey(V var1, float var2);

    @Override
    protected final void onChildAddRollback(RogNode element) {
        this.map.remove(this.getMapElementKey((IRogCollectionNodeElement)((Object)element)));
    }

    @Override
    protected final void onChildRemoveRollback(RogNode element) {
        this.add((IRogCollectionNodeElement)((Object)element));
    }

    private final V add(V element) {
        return (V)((IRogCollectionNodeElement)this.map.put(this.getMapElementKey(element), element));
    }

    @Override
    protected final void visitFields(RogGraphVisitor visitor) {
        int i = 0;
        XIterator iterator = this.map.reuseableEntryIterator();
        while (iterator.hasNext()) {
            XFloatMap.Entry entry = (XFloatMap.Entry)iterator.next();
            this.visitField(visitor, "Key " + i, Float.valueOf(entry.getKey()));
            this.visitField(visitor, "Value " + i, (RogNode)entry.getValue());
            ++i;
        }
    }

    @Override
    protected final PktPacket getStoreCommitPacket() {
        return PktFactory.getInstance().createPacket(257);
    }

    @Override
    public final void clear() {
        XFloatIterator iterator = this.map.reuseableKeyIterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
            this.map.reuseableKeyIterator();
        }
        this.map.clear();
    }

    @Override
    public final boolean containsKey(float key) {
        return this.map.containsKey(key);
    }

    public final boolean containsKey(Float key) {
        if (key == null) {
            return false;
        }
        return this.containsKey(key.floatValue());
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.containsKey((Float)key);
    }

    @Override
    public final boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    @Override
    public final Set<Map.Entry<Float, V>> entrySet() {
        if (this.boxedEntrySet == null) {
            this.boxedEntrySet = new EntrySet();
        }
        return this.boxedEntrySet;
    }

    @Override
    public final Set<Float> keySet() {
        if (this.boxedKeySet == null) {
            this.boxedKeySet = new KeySet();
        }
        return this.boxedKeySet;
    }

    public final XFloatSet keyFloatSet() {
        return this.map.keySet();
    }

    @Override
    public final Collection<V> values() {
        return this.map.values();
    }

    @Override
    public final boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public final V get(float key) {
        return (V)((IRogCollectionNodeElement)this.map.get(key));
    }

    public final V get(Float key) {
        if (key == null) {
            return null;
        }
        return this.get(key.floatValue());
    }

    @Override
    public final V get(Object key) {
        if (key instanceof Float) {
            return this.get((Float)key);
        }
        return null;
    }

    @Override
    public final int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final XFloatIterator reuseableKeyIterator() {
        return this.map.reuseableKeyIterator();
    }

    @Override
    public final XIterator<V> reuseableValueIterator() {
        return this.map.reuseableValueIterator();
    }

    @Override
    public XIterator<XFloatMap.Entry<V>> reuseableEntryIterator() {
        return this.map.reuseableEntryIterator();
    }

    @Override
    public final V put(float key, V value) {
        V rc;
        if (value.getParent() == this && key == this.getMapElementKey(value)) {
            return value;
        }
        if (this.getMapElementKey(value) != key) {
            this.setMapElementKey(value, key);
        }
        if ((rc = this.add(value)) != null && rc != value) {
            try {
                this.removeChild(rc);
            }
            catch (RuntimeException thrown) {
                this.map.remove(key);
                this.map.put(key, rc);
                throw thrown;
            }
        }
        this.addChild(value);
        return rc;
    }

    @Override
    public final V put(Float key, V value) {
        if (key == null) {
            throw new NullPointerException("Null values not supported");
        }
        return this.put(key.floatValue(), value);
    }

    public final void putAll(XFloatMap<? extends V> from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends Float, ? extends V> from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(float key) {
        IRogCollectionNodeElement element = (IRogCollectionNodeElement)this.map.remove(key);
        if (element != null) {
            this.setMapElementKey(element, key + 1.0f);
            this.removeChild(element);
        }
        return (V)element;
    }

    public final V remove(Float key) {
        if (key == null) {
            return null;
        }
        return this.remove(key.floatValue());
    }

    @Override
    public final V remove(Object key) {
        if (key instanceof Float) {
            return this.remove((Float)key);
        }
        return null;
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final void addChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.put(this.getMapElementKey(mapElement), (V)mapElement);
    }

    @Override
    public final void removeChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.remove(this.getMapElementKey(mapElement));
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count == 0) {
            this.map.clear();
        }
        return count;
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + this.size();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Float, V>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return RogXFloatMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXFloatMap.this.isEmpty();
        }

        @Override
        public final Iterator<Map.Entry<Float, V>> iterator() {
            final Iterator it = RogXFloatMap.this.map.entrySet().iterator();
            return new Iterator<Map.Entry<Float, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<Float, V> next() {
                    final XFloatMap.Entry e = (XFloatMap.Entry)it.next();
                    return new Map.Entry<Float, V>(){

                        @Override
                        public Float getKey() {
                            return Float.valueOf(e.getKey());
                        }

                        @Override
                        public V getValue() {
                            return (IRogCollectionNodeElement)e.getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(Map.Entry<Float, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Float, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<Float> {
        KeySet() {
        }

        @Override
        public int size() {
            return RogXFloatMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXFloatMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return RogXFloatMap.this.containsKey(o);
        }

        @Override
        public Iterator<Float> iterator() {
            final XFloatIterator it = RogXFloatMap.this.map.keySet().iterator();
            return new Iterator<Float>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Float next() {
                    return Float.valueOf(it.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported");
                }
            };
        }

        @Override
        public boolean add(Float e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Float> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

