/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import cern.colt.function.IntObjectProcedure;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectAddedEvent;
import com.neeve.ods.IStoreObjectRemovedEvent;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsReferentialIntegrityException;
import com.neeve.ods.StoreBinding;
import com.neeve.ods.StoreBindingFactory;
import com.neeve.ods.StoreDescriptor;
import com.neeve.rog.IRogContainerNode;
import com.neeve.rog.IRogGraphCollection;
import com.neeve.rog.IRogNode;
import com.neeve.rog.IRogRootNode;
import com.neeve.rog.RogObject;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.impl.RogRootNode;
import com.neeve.rog.impl.ToStringVisitor;
import com.neeve.trace.Tracer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;

public final class RogGraphCollection
extends RogObject
implements IRogGraphCollection,
IStoreEventHandler {
    private final OpenIntObjectHashMap roots;
    private IStoreBinding initialStore;
    private IStoreBinding store;
    private IStoreBinding expectedNodeStore;
    private final IStoreEventHandler storeEventHandler;

    private RogGraphCollection(IStoreEventHandler storeEventHandler, int estimatedCount) {
        this.roots = estimatedCount == 0 ? new OpenIntObjectHashMap() : new OpenIntObjectHashMap(2 * estimatedCount, 0.1, 0.5);
        this.storeEventHandler = storeEventHandler;
    }

    public static IRogGraphCollection createUnbackedCollection(int estimatedGraphCount) {
        try {
            return RogGraphCollection.create(null, null, null, 0, estimatedGraphCount);
        }
        catch (OdsException e) {
            throw new IllegalStateException();
        }
    }

    public static IRogGraphCollection create(String storeMemberName, StoreDescriptor descriptor, IStoreEventHandler storeEventHandler) throws OdsException {
        return RogGraphCollection.create(storeMemberName, descriptor, storeEventHandler, 0, 0);
    }

    public static IRogGraphCollection create(String storeMemberName, StoreDescriptor descriptor, IStoreEventHandler storeEventHandler, int storeFlags, int estimatedGraphCount) throws OdsException {
        RogGraphCollection collection = new RogGraphCollection(storeEventHandler, estimatedGraphCount);
        if (descriptor != null) {
            collection.store = StoreBindingFactory.getInstance().createBinding(storeMemberName, descriptor, (IStoreEventHandler)collection, storeFlags);
            collection.expectedNodeStore = collection.store instanceof StoreBinding ? ((StoreBinding)collection.store).getUnderlyingBinding() : collection.store;
            collection.initialStore = collection.store;
        }
        return collection;
    }

    @Override
    public final IStoreBinding getInitialStore() {
        return this.initialStore;
    }

    @Override
    public final IStoreBinding getStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void add(IRogNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        IStoreBinding nodeStore = node.getBinding();
        if (node instanceof RogRootNode) {
            if (this.roots.size() == 0 && this.initialStore == null) {
                this.expectedNodeStore = this.store = nodeStore;
            }
            try {
                RogRootNode root = (RogRootNode)node;
                if (root.getGraphCollection() != null) {
                    throw new OdsReferentialIntegrityException("node " + root + " is already in a graph collection (" + root.getGraphCollection() + ")");
                }
                if (this.checked && this.roots.get(root.getGraphId()) != null) {
                    throw new OdsReferentialIntegrityException("an object graph with the same id is already in the collection");
                }
                if (nodeStore != null && nodeStore != this.expectedNodeStore) {
                    throw new OdsReferentialIntegrityException("node is in a store different from the store bound to the collection");
                }
                root.setGraphCollection(this);
                this.roots.put(root.getGraphId(), (Object)root);
                if (this.store == null || nodeStore != null) return;
                this.store.put(node);
                return;
            }
            finally {
                if (this.roots.size() == 0 && this.initialStore == null) {
                    this.store = null;
                    this.expectedNodeStore = null;
                }
            }
        } else {
            if (nodeStore == null) {
                throw new OdsReferentialIntegrityException("node is not in an ODS store");
            }
            if (nodeStore != this.expectedNodeStore) {
                throw new OdsReferentialIntegrityException("node is in a different store than the one bound to the graph collection");
            }
            IStoreObject parent = nodeStore.get(node.getParentId());
            if (parent != null && parent instanceof IRogContainerNode) {
                ((IRogContainerNode)parent).addChild(node);
                return;
            } else {
                if (parent == null) throw new OdsReferentialIntegrityException("parent of added node is not in the node's ODS store", false);
                throw new OdsReferentialIntegrityException("parent of added node is not a node container!");
            }
        }
    }

    @Override
    public final IRogRootNode get(int grid) {
        return (IRogRootNode)this.roots.get(grid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void remove(IRogNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        if (node instanceof IRogRootNode) {
            RogRootNode root = (RogRootNode)node;
            if (root.getGraphCollection() != this) throw new OdsReferentialIntegrityException("node is not in this graph collection", false);
            try {
                root.setGraphCollection(null);
                this.roots.removeKey(root.getGraphId());
                if (this.store == null || node.getBinding() == null) return;
                this.store.remove(root);
                return;
            }
            finally {
                if (this.roots.size() == 0 && this.initialStore == null) {
                    this.store = null;
                    this.expectedNodeStore = null;
                }
            }
        } else {
            if (node.getParent() == null) {
                throw new OdsReferentialIntegrityException("node's parent is null but is not a graph root");
            }
            node.getParent().removeChild(node);
        }
    }

    public void dump(final BufferedWriter bw) {
        this.roots.forEachPair(new IntObjectProcedure(){

            public boolean apply(int graphId, Object root) {
                try {
                    bw.newLine();
                    bw.newLine();
                    bw.write("Object Graph ");
                    bw.write(Integer.toString(graphId));
                    bw.write(": ");
                    bw.newLine();
                    StringBuilder sb = new StringBuilder();
                    ToStringVisitor visitor = new ToStringVisitor(sb, false, "", "--");
                    ((RogNode)root).accept(visitor);
                    bw.write(sb.toString());
                    bw.newLine();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                return false;
            }
        });
    }

    @Override
    public void onEvent(IStoreEvent event) {
        try {
            if (this.store.getRole() == IStoreBinding.Role.Backup || this.store.getState() == IStoreBinding.State.Opening) {
                IStoreObject object;
                if (event instanceof IStoreObjectAddedEvent) {
                    IStoreObject object2 = ((IStoreObjectAddedEvent)event).getObject();
                    if (object2 instanceof RogNode) {
                        RogNode node = (RogNode)object2;
                        this.add(node);
                    }
                } else if (event instanceof IStoreObjectRemovedEvent && (object = ((IStoreObjectRemovedEvent)event).getObject()) instanceof IRogNode) {
                    this.remove((IRogNode)object);
                }
            }
        }
        catch (Exception e) {
            this.tracer.log("Error processing node event: " + event.getClass().getSimpleName() + ": " + e.getMessage(), Tracer.Level.SEVERE);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.storeEventHandler != null) {
            this.storeEventHandler.onEvent(event);
        }
    }

    public Collection<Integer> roots() {
        return this.roots.keys().toList();
    }
}

