/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.predicates;

import com.google.common.base.Objects;
import com.neeve.query.impl.predicates.PredicateBase;
import com.neeve.query.impl.util.UtlQueryReflection;
import com.neeve.query.predicates.Predicate;
import java.util.Comparator;

public final class FieldTypePredicate<T>
extends PredicateBase<T> {
    private final String fieldPath;
    private final Class<?> type;

    public FieldTypePredicate(String fieldPath, Class<?> type) {
        this.fieldPath = fieldPath;
        this.type = type;
    }

    public final boolean apply(T record) {
        if (record == null) {
            return false;
        }
        try {
            if (this.fieldPath == null || this.fieldPath.length() == 0) {
                return this.type.isAssignableFrom(record.getClass());
            }
            Object fieldValue = UtlQueryReflection.getProperty(record, (String)this.fieldPath);
            if (fieldValue == null) {
                return false;
            }
            return this.type.isAssignableFrom(fieldValue.getClass());
        }
        catch (Exception e) {
            return false;
        }
    }

    public final String toString() {
        return (this.fieldPath == null ? "" : this.fieldPath + " ") + "instanceof " + this.type.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldTypePredicate)) {
            return false;
        }
        FieldTypePredicate other = (FieldTypePredicate)obj;
        return Objects.equal((Object)this.fieldPath, (Object)other.fieldPath) && Objects.equal(this.type, other.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldPath, this.type});
    }

    @Override
    public double getCost() {
        return 1.0;
    }

    @Override
    public void regularize() {
    }

    @Override
    public void prioritizeBy(Comparator<Predicate<?>> comparator) {
    }
}

