/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jni;

import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.solxf.ISolFlowReceiver;
import com.neeve.solxf.ISolMessageConsumer;
import com.neeve.solxf.ISolMessageListener;
import com.neeve.solxf.ISolMessageProducer;
import com.neeve.solxf.ISolPublishEventHandler;
import com.neeve.solxf.ISolQueue;
import com.neeve.solxf.ISolSession;
import com.neeve.solxf.ISolTopic;
import com.neeve.solxf.impl.jni.SolJniFlowReceiver;
import com.neeve.solxf.impl.jni.SolJniMessageConsumer;
import com.neeve.solxf.impl.jni.SolJniMessageProducer;
import com.neeve.solxf.impl.jni.SolJniUtils;
import com.neeve.util.UtlProps;
import java.util.Enumeration;
import java.util.Properties;

public final class SolJniSession
implements ISolSession {
    private final long _nthis;
    private final Properties _props;
    private final boolean _writePayloadInXmlContent;
    private final boolean _readPayloadFromXmlContent;

    SolJniSession(String host, String user, Properties props, Properties solxfProperties) throws SmaException {
        this._writePayloadInXmlContent = UtlProps.getValue((Properties)solxfProperties, (String)"write_payload_in_xml_content", (boolean)false);
        this._readPayloadFromXmlContent = UtlProps.getValue((Properties)solxfProperties, (String)"read_payload_from_xml_content", (boolean)false);
        if (this._writePayloadInXmlContent) {
            throw new SmaPermanentException("write_payload_in_xml_content is not supported in JNI binding");
        }
        this._nthis = SolJniSession.nativeCreate(SolJniUtils.props2Array(props));
        this._props = props;
    }

    private static final native long nativeCreate(String[] var0) throws SmaException;

    private static final native void nativeConnect(long var0) throws SmaException;

    private static final native boolean nativeIsCapable(long var0, String var2);

    private static final native String nativeGetRouterName(long var0);

    private static final native void nativeProvision(long var0, String var2, int var3, int var4, int var5, boolean var6) throws SmaException;

    private static final native void nativeAddSubscription(long var0, String var2) throws SmaException;

    private static final native void nativeAddSubscription(long var0, String var2, String var3) throws SmaException;

    private static final native void nativeRemoveSubscription(long var0, String var2) throws SmaException;

    private static final native void nativeRemoveSubscription(long var0, String var2, String var3) throws SmaException;

    private static final native String nativeGetStats(long var0);

    private static final native String nativeGetVersion(long var0);

    private static final native void nativeDestroy(long var0);

    private final String[] props2Array(Properties props) {
        String[] ret = new String[props.size() * 2];
        Enumeration<?> enumeration = props.propertyNames();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String val = props.getProperty(key);
            ret[i++] = key;
            ret[i++] = val;
        }
        return ret;
    }

    @Override
    public final void connect() throws SmaException {
        SolJniSession.nativeConnect(this._nthis);
    }

    @Override
    public final boolean isCapable(ISolSession.CapabilityType capability) {
        switch (capability) {
            case ENDPOINT_MANAGEMENT: {
                return SolJniSession.nativeIsCapable(this._nthis, "SESSION_CAPABILITY_ENDPOINT_MANAGEMENT");
            }
            case QUEUE_SUBSCRIPTIONS: {
                return SolJniSession.nativeIsCapable(this._nthis, "SESSION_CAPABILITY_QUEUE_SUBSCRIPTIONS");
            }
        }
        throw new IllegalArgumentException("unknown capability '" + (Object)((Object)capability) + "'");
    }

    @Override
    public final String getRouterName() {
        return SolJniSession.nativeGetRouterName(this._nthis);
    }

    @Override
    public final void provision(ISolQueue queue, ISolSession.EndpointProperties properties) throws SmaException {
        SolJniSession.nativeProvision(this._nthis, queue.getName(), properties.getPermission(), properties.getAccessType(), properties.getQuota(), properties.getRespectsMsgTTL());
    }

    @Override
    public final ISolFlowReceiver createFlow(ISolQueue queue, ISolMessageListener listener, Properties props) throws SmaException {
        return new SolJniFlowReceiver(this._nthis, queue, listener, props);
    }

    @Override
    public final ISolMessageProducer createMessageProducer(ISolPublishEventHandler handler) throws SmaException {
        return new SolJniMessageProducer(this._nthis, handler);
    }

    @Override
    public final ISolMessageConsumer createMessageConsumer(ISolMessageListener listener) throws SmaException {
        return new SolJniMessageConsumer(this._nthis, listener);
    }

    @Override
    public final void addSubscription(ISolTopic topic) throws SmaException {
        SolJniSession.nativeAddSubscription(this._nthis, topic.getName().getValue());
    }

    @Override
    public final void addSubscription(ISolQueue queue, ISolTopic topic) throws SmaException {
        SolJniSession.nativeAddSubscription(this._nthis, queue.getName(), topic.getName().getValue());
    }

    @Override
    public final void removeSubscription(ISolTopic topic) throws SmaException {
        SolJniSession.nativeRemoveSubscription(this._nthis, topic.getName().getValue());
    }

    @Override
    public final void removeSubscription(ISolQueue queue, ISolTopic topic) throws SmaException {
        SolJniSession.nativeRemoveSubscription(this._nthis, queue.getName(), topic.getName().getValue());
    }

    @Override
    public final void close() {
        SolJniSession.nativeDestroy(this._nthis);
    }

    @Override
    public final void getStats(String userName, boolean isProducer, StringBuilder builder) {
        SolJniSession.parseStats(userName, isProducer, SolJniSession.nativeGetStats(this._nthis), builder);
    }

    private static final void parseStats(String userName, boolean isProducer, String stats, StringBuilder builder) {
        if (stats == null) {
            return;
        }
        int pos = 0;
        while (pos < stats.length()) {
            int delim = stats.indexOf(59, pos);
            if (delim == -1) {
                delim = stats.length();
            }
            if (delim == pos) {
                pos = delim + 1;
                continue;
            }
            builder.append(userName);
            builder.append("[");
            builder.append(isProducer ? "P" : "C");
            builder.append("]");
            builder.append(stats, pos, delim);
            builder.append(",");
            pos = delim + 1;
        }
    }

    @Override
    public final String getVersion() {
        return SolJniSession.nativeGetVersion(this._nthis);
    }
}

