/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang.WordUtils;

public class UtlText {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    public static double uniformMetric(String text) {
        String alpha = text.replaceAll("[^a-zA-Z]", "").toLowerCase();
        byte[] bytes = alpha.getBytes();
        int numBytes = Math.min(bytes.length, 8);
        double value = 0.0;
        for (int i = 0; i < numBytes; ++i) {
            double charValue = (double)bytes[i] - 97.0;
            value += charValue / Math.pow(26.0, i + 1);
        }
        return value;
    }

    public static String toFirstLetterUppercase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String toFirstLetterLowercase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        return text != null && prefix != null && text.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static String removeLineBreaks(String text) {
        if (UtlText.isNullOrEmpty(text)) {
            return text;
        }
        String[] lines = text.split("[\\r\\n]+");
        if (lines.length == 1) {
            return lines[0];
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(lines[i].trim());
        }
        return builder.toString();
    }

    public static String toCamelCase(String text, boolean includeFirstLetter) {
        if (!includeFirstLetter) {
            if (text.length() > 1) {
                text = text.substring(0, 1) + WordUtils.capitalize((String)text).substring(1);
            }
        } else {
            text = WordUtils.capitalize((String)text);
        }
        return text.replaceAll(" ", "");
    }

    public static final String deCamelCase(String camelCase) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : UtlText.splitCamelCaseString(camelCase)) {
            if (!first) {
                sb.append(" ");
            } else {
                first = false;
            }
            sb.append(UtlText.upperCaseFirstLetters(str));
        }
        return sb.toString();
    }

    public static String upperCaseFirstLetters(String str) {
        char lastChar = ' ';
        StringBuilder sb = new StringBuilder();
        boolean replaced = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (UtlText.isWhitespace("" + lastChar) && Character.isLetter(c) && !Character.isUpperCase(c)) {
                sb.append(Character.toUpperCase(c));
                replaced = true;
            } else {
                sb.append(c);
            }
            lastChar = c;
        }
        if (!replaced) {
            return str;
        }
        return sb.toString();
    }

    private static boolean isWhitespace(String c) {
        return c.trim().length() == 0;
    }

    public static LinkedList<String> splitCamelCaseString(String s) {
        char[] cArray = s.toCharArray();
        LinkedList<Integer> al = new LinkedList<Integer>();
        al.add(0);
        for (int i = 1; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < 'A' || c > 'Z') continue;
            al.add(i);
        }
        LinkedList<String> strl = new LinkedList<String>();
        if (al.size() == 1) {
            strl.add(s);
            return strl;
        }
        int prev = 0;
        int curr = 0;
        int begin = 0;
        for (int k = 1; k < al.size(); ++k) {
            curr = (Integer)al.get(k);
            if (curr == s.length() - 1) {
                // empty if block
            }
            if (curr == prev + 1 && curr != s.length() - 1) {
                prev = curr;
                continue;
            }
            if (curr == prev + 1 && curr == s.length() - 1) {
                strl.add(s.substring(begin, curr + 1));
                continue;
            }
            strl.add(s.substring(prev, curr));
            prev = curr;
            begin = curr;
            if (k != al.size() - 1) continue;
            strl.add(s.substring(curr, s.length()));
        }
        return strl;
    }

    public static final byte[] hexToBytes(String hexString) {
        hexString = hexString.replaceAll(" ", "");
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    public static final String bytesToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_DIGITS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_DIGITS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static final String[] retokenizeWithQuotes(StringTokenizer tokenizer, boolean preserveInnerEscapes) {
        if (!tokenizer.hasMoreTokens()) {
            return new String[0];
        }
        String toProcess = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            toProcess = toProcess + " " + tokenizer.nextToken();
        }
        return UtlText.parseAsArgs(toProcess, preserveInnerEscapes);
    }

    public static final String[] parseAsArgs(String argString, boolean preserveInnerEscapes) {
        return UtlText.parseAsArgs(argString, preserveInnerEscapes, false);
    }

    public static final String[] parseAsArgs(String argString, boolean preserveInnerEscapes, boolean preserveQuotes) {
        if (argString == null) {
            return EMPTY_STRING_ARRAY;
        }
        StringTokenizer tok = new StringTokenizer(argString.trim(), "\"' \\", true);
        if (!tok.hasMoreTokens()) {
            return EMPTY_STRING_ARRAY;
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        boolean inEscape = false;
        int state = 0;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            if (inEscape) {
                inEscape = false;
                if (!nextTok.startsWith("\"") || nextTok.startsWith("'")) {
                    current.append("\\");
                }
                current.append(nextTok);
                continue;
            }
            if ("\\".equals(nextTok)) {
                if (preserveInnerEscapes && (state == 1 || state == 2)) {
                    current.append(nextTok);
                }
                inEscape = true;
                continue;
            }
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        if (preserveQuotes) {
                            current.append("'");
                        }
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        if (preserveQuotes) {
                            current.append("\"");
                        }
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
                if (preserveQuotes) {
                    current.append("'");
                }
            } else if ("\"".equals(nextTok)) {
                state = 2;
                if (preserveQuotes) {
                    current.append("\"");
                }
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    list.add(current.toString());
                    current = new StringBuilder();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + argString);
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    public static final String quoteAndEscape(String string) {
        boolean escape = false;
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': 
                case '\"': 
                case '\'': {
                    escape = true;
                    continue block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (!escape) {
            return string;
        }
        String escaped = string.replace("\"", "\\\"");
        return "\"" + escaped + "\"";
    }

    public static final String stripQuotesAndUnescape(String string) {
        if (string == null || !string.startsWith("\"")) {
            return string;
        }
        String unescaped = string.replaceAll("^\"|\"$", "");
        unescaped = unescaped.replace("\\\"", "\"");
        return unescaped.replace("\\'", "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readFully(InputStream input, String charset) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(input.available());){
            IOUtils.copy((InputStream)input, (OutputStream)baos, (int)8192);
            String string = new String(baos.toByteArray(), charset);
            return string;
        }
    }
}

