/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.link;

import com.neeve.stats.Stats;
import java.text.NumberFormat;

final class SrvLinkClientStats
extends Stats {
    private NumberFormat format = NumberFormat.getInstance();
    private long startTime;
    private long deltaStartTime;
    private long numPktsRcvdLast;
    private long numPktsSentLast;
    volatile long numPktsRcvd;
    volatile long numPktsSent;

    SrvLinkClientStats(String name, String startProp) {
        super("nv.server.link.client", name, "nv.server.link.client.stats", startProp);
        this.format.setMaximumFractionDigits(2);
        this.startPeriodicOutputIfConfigured();
    }

    private void stamp() {
        this.deltaStartTime = System.currentTimeMillis();
        this.numPktsRcvdLast = this.numPktsRcvd;
        this.numPktsSentLast = this.numPktsSent;
    }

    protected final void init() {
        this.startTime = System.currentTimeMillis();
        this.stamp();
    }

    public final synchronized void get(StringBuilder sb) {
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        long numPktsRcvdCurrent = this.numPktsRcvd;
        long numPktsSentCurrent = this.numPktsSent;
        String numPktsRcvdStr = this.format.format(numPktsRcvdCurrent);
        String deltaNumPktsRcvdStr = this.format.format(numPktsRcvdCurrent - this.numPktsRcvdLast);
        String pktRecvRateStr = this.format.format(numPktsRcvdCurrent * 1000L / deltaTotalTime);
        String deltaPktRecvRateStr = this.format.format((numPktsRcvdCurrent - this.numPktsRcvdLast) * 1000L / deltaTime);
        String numPktsSentStr = this.format.format(numPktsSentCurrent);
        String deltaNumPktsSentStr = this.format.format(numPktsSentCurrent - this.numPktsSentLast);
        String pktSendRateStr = this.format.format(numPktsSentCurrent * 1000L / deltaTotalTime);
        String deltaPktSendRateStr = this.format.format((numPktsSentCurrent - this.numPktsSentLast) * 1000L / deltaTime);
        sb.append("In{");
        sb.append(numPktsRcvdStr + "(" + deltaNumPktsRcvdStr + ") ");
        sb.append(pktRecvRateStr + "(" + deltaPktRecvRateStr + ") ");
        sb.append("} ");
        sb.append("Out{");
        sb.append(numPktsSentStr + "(" + deltaNumPktsSentStr + ") ");
        sb.append(pktSendRateStr + "(" + deltaPktSendRateStr + ")");
        sb.append("}");
        this.stamp();
    }
}

