/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.controller;

import com.neeve.adm.AdmFactory;
import com.neeve.aep.AepEngine;
import com.neeve.ci.XRuntime;
import com.neeve.emx.EmxActionExecutor;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.pkt.EPktException;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyServerAdminReply;
import com.neeve.pkt.types.PktBodyServerAdminRequest;
import com.neeve.pkt.types.PktBodyServerTraceRecord;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogRawMessage;
import com.neeve.rog.impl.RogRawMessageFactory;
import com.neeve.server.admin.EAdminException;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvController;
import com.neeve.server.controller.SrvControllerAdminApp;
import com.neeve.server.controller.SrvControllerObject;
import com.neeve.server.mon.SrvMonAppBusBindingCreateMessage;
import com.neeve.server.mon.SrvMonAppBusBindingDestroyMessage;
import com.neeve.server.mon.SrvMonAppBusChannelClosedMessage;
import com.neeve.server.mon.SrvMonAppBusChannelOpenedMessage;
import com.neeve.server.mon.SrvMonAppClientConnectMessage;
import com.neeve.server.mon.SrvMonAppLoadedMessage;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.cnc.ISrvMonXvmRequest;
import com.neeve.server.mon.cnc.ISrvMonXvmResponse;
import com.neeve.server.mon.cnc.SrvMonCncFactory;
import com.neeve.server.mon.cnc.SrvMonGetLoadedAppsRequest;
import com.neeve.server.mon.cnc.SrvMonGetTraceHistoryRequest;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandRequest;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandResponse;
import com.neeve.server.mon.cnc.SrvMonListCommandsRequest;
import com.neeve.server.mon.cnc.SrvMonReturnType;
import com.neeve.server.mon.cnc.SrvMonStartAppWatchCommand;
import com.neeve.server.mon.cnc.SrvMonStartTraceWatchRequest;
import com.neeve.server.mon.cnc.SrvMonStopAppWatchCommand;
import com.neeve.server.mon.cnc.SrvMonStopTraceWatchRequest;
import com.neeve.server.mon.cnc.SrvMonTraceLevel;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.mon.cnc.SrvMonXvmInfoRequest;
import com.neeve.server.mon.common.ISrvMonEvent;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingCreatedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingDestroyedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingStateChangeMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelUpMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppClientDisconnectMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppFlowCreateMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStateChangeMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppUnloadedMessage;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.sma.SmaException;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlText;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class SrvControllerAdminClient
extends SrvControllerObject
implements SrvControllerAdminApp.AdminClientContext {
    private final SrvController controller;
    private final AepEngine engine;
    private final MessageChannel channel;
    private final Flusher flusher;
    private final EmxActionExecutor<Object, Object> actionExecutor;
    private final FlushAction flushAction;
    private final boolean flushBindingOnFlush;
    private final OutboundQueue oq;
    private final AdminClientStats stats = new AdminClientStats();
    final String tracePrefix;
    private volatile boolean flushScheduled;
    private volatile State state;
    private volatile int adminCompatLevel = 1;
    private volatile boolean useAdmTraceRecords = true;
    private static final SrvMonCncFactory cncFactory = new SrvMonCncFactory();

    SrvControllerAdminClient(SrvController controller, AepEngine engine, MessageChannel channel) {
        this.engine = engine;
        this.channel = channel;
        this.controller = controller;
        this.tracePrefix = "[AdminClient-" + channel.getName() + "] ";
        this.flusher = new Flusher(channel.getName());
        this.flushBindingOnFlush = !XRuntime.getValue((String)"nv.server.adminappmultiplexsends", (boolean)true);
        this.actionExecutor = new EmxActionExecutor();
        this.flushAction = new FlushAction();
        this.oq = new OutboundQueue((SrvConfigDescriptor)controller.getConfigDescriptor());
        this.state = State.Open;
        this.flusher.start();
        this.flusher.waitForStart();
    }

    private final PktPacket clone(PktPacket packet) {
        PktPacket cloned = PktFactory.getInstance().createPacket(packet.getBody().getType());
        cloned.getBody().deserialize((IOElasticBuffer)packet.getBody().getBuffer(), 0, packet.getBody().getBuffer().getLength());
        return cloned;
    }

    private final void flushUnprotected() {
        if (!this.flushScheduled) {
            try {
                this.actionExecutor.invoke(this.flusher.dispatcher(), (IEmxAction)this.flushAction, null, 0);
                this.flushScheduled = true;
                ++this.stats.flushesScheduled;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final PktPacket prepareLegacyTraceRecord(SrvMonTraceRecord record) {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(560);
            StringBuilder sb = new StringBuilder();
            SrvMonUtil.formatTraceRecordTo(record, sb);
            ((PktBodyServerTraceRecord)packet.getBody()).setRecord(sb.toString());
            return packet;
        }
        catch (EPktException e) {
            throw new InternalError("Failed to create a trace record packet [" + e.toString() + "]");
        }
    }

    private final MessageView convertToLegacyLifecycleEvent(MessageView message) {
        if (this.adminCompatLevel >= 5) {
            return message;
        }
        if (message.getVfid() == 34) {
            switch (message.getType()) {
                case 301: {
                    SrvMonAppLoadedMessage to = SrvMonAppLoadedMessage.create();
                    com.neeve.server.mon.lifecycle.SrvMonAppLoadedMessage from = (com.neeve.server.mon.lifecycle.SrvMonAppLoadedMessage)message;
                    to.lendAppInfo(from.getAppInfo());
                    from.dispose();
                    return to;
                }
                case 308: {
                    com.neeve.server.mon.SrvMonAppUnloadedMessage to = com.neeve.server.mon.SrvMonAppUnloadedMessage.create();
                    SrvMonAppUnloadedMessage from = (SrvMonAppUnloadedMessage)message;
                    to.setAppNameFrom(from.getEventSourceUnsafe());
                    from.dispose();
                    return to;
                }
                case 302: {
                    com.neeve.server.mon.SrvMonAppStateChangeMessage to = com.neeve.server.mon.SrvMonAppStateChangeMessage.create();
                    SrvMonAppStateChangeMessage from = (SrvMonAppStateChangeMessage)message;
                    to.setAppNameFrom(from.getEventSourceUnsafe());
                    to.setAppState(from.getAppState());
                    from.dispose();
                    return to;
                }
                case 1: {
                    SrvMonAppBusBindingCreateMessage to = SrvMonAppBusBindingCreateMessage.create();
                    SrvMonAppBusBindingCreatedMessage from = (SrvMonAppBusBindingCreatedMessage)message;
                    to.setAppNameFrom(from.getEventSourceUnsafe());
                    to.lendBusBindingInfo(from.getBusBindingInfo());
                    from.dispose();
                    return to;
                }
                case 304: {
                    com.neeve.server.mon.SrvMonAppBusBindingStateChangeMessage to = com.neeve.server.mon.SrvMonAppBusBindingStateChangeMessage.create();
                    SrvMonAppBusBindingStateChangeMessage from = (SrvMonAppBusBindingStateChangeMessage)message;
                    to.setAppNameFrom(from.getEventSourceUnsafe());
                    to.setBusBindingNameFrom(from.getBusBindingNameUnsafe());
                    to.setBusBindingState(from.getBusBindingState());
                    from.dispose();
                    return to;
                }
                case 22: {
                    SrvMonAppBusBindingDestroyMessage to = SrvMonAppBusBindingDestroyMessage.create();
                    SrvMonAppBusBindingDestroyedMessage from = (SrvMonAppBusBindingDestroyedMessage)message;
                    to.setAppNameFrom(from.getEventSourceUnsafe());
                    to.setBusBindingNameFrom(from.getBusBindingNameUnsafe());
                    from.dispose();
                    return to;
                }
                case 10: {
                    SrvMonAppBusChannelOpenedMessage to = SrvMonAppBusChannelOpenedMessage.create();
                    SrvMonAppChannelUpMessage from = (SrvMonAppChannelUpMessage)message;
                    to.setAppNameFrom(from.getEventSourceUnsafe());
                    to.setBusBindingNameFrom(from.getBusBindingNameUnsafe());
                    to.setBusChannelInfo(SrvMonUtil.createMonAppBusChannelInfo(from.getChannelName(), from.getIsJoined()));
                    from.dispose();
                    return to;
                }
                case 19: {
                    SrvMonAppBusChannelClosedMessage to = SrvMonAppBusChannelClosedMessage.create();
                    SrvMonAppChannelDownMessage from = (SrvMonAppChannelDownMessage)message;
                    to.setAppNameFrom(from.getEventSourceUnsafe());
                    to.setBusBindingNameFrom(from.getBusBindingNameUnsafe());
                    to.setBusChannelNameFrom(from.getChannelNameUnsafe());
                    from.dispose();
                    return to;
                }
                case 305: {
                    SrvMonAppClientConnectMessage to = SrvMonAppClientConnectMessage.create();
                    com.neeve.server.mon.lifecycle.SrvMonAppClientConnectMessage from = (com.neeve.server.mon.lifecycle.SrvMonAppClientConnectMessage)message;
                    to.setAppNameFrom(from.getEventSourceUnsafe());
                    to.lendClientInfo(from.getClientInfo());
                    from.dispose();
                    return to;
                }
                case 306: {
                    com.neeve.server.mon.SrvMonAppClientDisconnectMessage to = com.neeve.server.mon.SrvMonAppClientDisconnectMessage.create();
                    SrvMonAppClientDisconnectMessage from = (SrvMonAppClientDisconnectMessage)message;
                    to.setAppNameFrom(from.getEventSourceUnsafe());
                    to.setClientNameFrom(from.getClientNameUnsafe());
                    from.dispose();
                    return to;
                }
                case 307: {
                    com.neeve.server.mon.SrvMonAppFlowCreateMessage to = com.neeve.server.mon.SrvMonAppFlowCreateMessage.create();
                    SrvMonAppFlowCreateMessage from = (SrvMonAppFlowCreateMessage)message;
                    to.setAppNameFrom(from.getEventSourceUnsafe());
                    to.lendFlowInfo(from.getFlowInfo());
                    from.dispose();
                    return to;
                }
            }
            message.dispose();
            return null;
        }
        message.dispose();
        return null;
    }

    private final boolean isCncPacket(PktPacket packet) {
        return 36 == AdmFactory.decodeObjectFactoryIdFromPacketId((int)packet.getBody().getType());
    }

    private final MessageView wrapCncCommand(PktPacket packet) {
        int packetType = packet.getBody().getType();
        if (36 == AdmFactory.decodeObjectFactoryIdFromPacketId((int)packetType)) {
            packet.acquire();
            return cncFactory.wrap(AdmFactory.decodeObjectTypeFormPacketId((int)packetType), 3, packet);
        }
        return null;
    }

    private final void replyWithError(MessageChannel channel, PktPacket packet, Throwable e) {
        StringBuilder builder = new StringBuilder();
        builder.append("NOK ");
        if (e.getMessage() != null) {
            builder.append(e.getMessage());
        } else {
            builder.append("server command processor threw exception <").append(e.toString()).append(">");
        }
        this.replyWithPacket(channel, packet, builder.toString());
    }

    private final void replyWithPacket(MessageChannel channel, PktPacket request, String result) {
        try {
            PktPacket reply = PktFactory.getInstance().createPacket(559);
            ((PktBodyServerAdminReply)reply.getBody()).setResult(result);
            try {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Replying to request: " + request + " with response " + reply + " on channel " + channel, Tracer.Level.DEBUG);
                }
                this.engine.replyToClient(channel, request, reply, 1, 1);
                ++this.stats.responsesSent;
            }
            catch (Exception e) {
                this.tracer.log(this.tracePrefix + "Failed to send admin reply to client <" + e.toString() + ">.", Tracer.Level.WARNING);
                ++this.stats.responsesDropped;
            }
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix + "Failed to create admin reply <" + e.toString() + ">.", Tracer.Level.WARNING);
            ++this.stats.responsesDropped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void replyWithMessage(MessageChannel channel, PktPacket request, IRogMessage reply) {
        try {
            PktPacket replyPacket = reply.serializeToPacket();
            try {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Replying to request: " + request + " with message" + reply + " on channel " + channel, Tracer.Level.DEBUG);
                }
                this.engine.replyToClient(channel, request, replyPacket, 1, 1);
                ++this.stats.responsesSent;
            }
            catch (Exception e) {
                this.tracer.log(this.tracePrefix + "Failed to send admin reply to client <" + e.toString() + ">.", Tracer.Level.WARNING);
                ++this.stats.responsesDropped;
            }
            finally {
                replyPacket.dispose();
            }
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix + "Failed to create admin reply <" + e.toString() + ">.", Tracer.Level.WARNING);
            ++this.stats.responsesDropped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean enque(PktPacket packet, int priority, boolean immediateFlush, boolean dropIfCongested, boolean clone) {
        SrvControllerAdminClient srvControllerAdminClient = this;
        synchronized (srvControllerAdminClient) {
            boolean retval = false;
            if (this.state == State.Open) {
                PktPacket clonedPacket;
                PktPacket pktPacket = clonedPacket = clone ? this.clone(packet) : packet;
                if (this.oq.offer(clonedPacket, priority, dropIfCongested)) {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Enqueued packet in admin client outbound queue (qcount=" + this.oq.count() + ", qsize=" + this.oq.size() + ")", Tracer.Level.DEBUG);
                    }
                    retval = true;
                } else if (clone) {
                    clonedPacket.dispose();
                }
                if (immediateFlush) {
                    this.flushUnprotected();
                }
            }
            return retval;
        }
    }

    final void setUseAdmTraceRecords(boolean admTraceRecords) {
        this.useAdmTraceRecords = admTraceRecords;
    }

    final boolean getUseAdmTraceRecords() {
        return this.useAdmTraceRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void onAdminPacket(PktPacket packet) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received: " + packet, Tracer.Level.DEBUG);
        }
        try {
            ISrvMonXvmRequest request;
            if (packet.getBody().getType() == 558) {
                PktBodyServerAdminRequest request2 = (PktBodyServerAdminRequest)packet.getBody();
                String commandLine = request2.getCommand();
                StringTokenizer tokenizer = new StringTokenizer(commandLine, " ");
                SrvMonInvokeCommandRequest invokeRequest = SrvMonInvokeCommandRequest.create();
                if (tokenizer.countTokens() < 2) throw new Exception("invalid command format [format=\"<target> <command> <args>\"]");
                invokeRequest.setTarget(tokenizer.nextToken());
                invokeRequest.setCommandName(tokenizer.nextToken());
                if (tokenizer.countTokens() > 0) {
                    StringBuilder quotedArg = null;
                    while (tokenizer.hasMoreElements()) {
                        String token = tokenizer.nextToken();
                        if (quotedArg == null) {
                            if (token.startsWith("\"")) {
                                if (token.endsWith("\"")) {
                                    invokeRequest.addParameters(token);
                                    continue;
                                }
                                quotedArg = new StringBuilder();
                                quotedArg.append(token);
                                continue;
                            }
                            invokeRequest.addParameters(token);
                            continue;
                        }
                        quotedArg.append(" ");
                        if (token.endsWith("\"")) {
                            quotedArg.append(token);
                            invokeRequest.addParameters(UtlText.stripQuotesAndUnescape((String)quotedArg.toString()));
                            quotedArg = null;
                            continue;
                        }
                        quotedArg.append(token);
                    }
                    if (quotedArg != null) {
                        invokeRequest.addParameters(UtlText.stripQuotesAndUnescape((String)(quotedArg.toString() + "\"")));
                    }
                }
                if (this.tracer.verbose) {
                    this.tracer.log(this.tracePrefix + "Invoking legacy admin command '" + invokeRequest.getCommandName() + "' [target=" + invokeRequest.getTarget() + ", args= " + Arrays.asList(invokeRequest.getParametersEmptyIfNull()) + "]", Tracer.Level.VERBOSE);
                }
                invokeRequest.setAttachment(packet);
                this.controller.onSrvMonInvokeCommandRequest(this, invokeRequest);
                invokeRequest.dispose();
                return;
            }
            if (!this.isCncPacket(packet)) throw new Exception("packet type '" + packet.getBody().getType() + "' is not a valid server admin request packet");
            MessageView command = this.wrapCncCommand(packet);
            ((IRogMessage)command).setAttachment((Object)packet);
            if (command instanceof ISrvMonXvmRequest && this.adminCompatLevel == 1 && (request = (ISrvMonXvmRequest)command).hasAdminClientCompatLevel()) {
                try {
                    this.setAdminCompatVersion(request.getAdminClientCompatLevelUnsafe());
                    if (this.tracer.verbose) {
                        this.tracer.log(this.tracePrefix + " compatibility version set to " + this.adminCompatLevel, Tracer.Level.VERBOSE);
                    }
                }
                catch (EAdminException e) {
                    this.tracer.log(this.tracePrefix + "Invalid client compatibility level on received request " + request, Tracer.Level.WARNING);
                }
            }
            try {
                switch (command.getType()) {
                    case 12: {
                        this.controller.onSrvMonGetLoadedAppsRequest(this, (SrvMonGetLoadedAppsRequest)command);
                        return;
                    }
                    case 14: {
                        this.controller.onSrvMonGetTraceHistoryRequest(this, (SrvMonGetTraceHistoryRequest)command);
                        return;
                    }
                    case 10: {
                        this.controller.onSrvMonInvokeCommandRequest(this, (SrvMonInvokeCommandRequest)command);
                        return;
                    }
                    case 1: {
                        this.controller.onSrvMonListCommandsRequest(this, (SrvMonListCommandsRequest)command);
                        return;
                    }
                    case 16: {
                        this.controller.onSrvMonStartAppWatchCommand(this, (SrvMonStartAppWatchCommand)command);
                        return;
                    }
                    case 18: {
                        this.controller.onSrvMonStopAppWatchCommand(this, (SrvMonStopAppWatchCommand)command);
                        return;
                    }
                    case 3: {
                        this.controller.onSrvMonStartTraceWatchRequest(this, (SrvMonStartTraceWatchRequest)command);
                        return;
                    }
                    case 6: {
                        this.controller.onSrvMonStopTraceWatchRequest(this, (SrvMonStopTraceWatchRequest)command);
                        return;
                    }
                    case 8: {
                        this.controller.onSrvMonXvmInfoRequest(this, (SrvMonXvmInfoRequest)command);
                        return;
                    }
                    default: {
                        this.tracer.log(this.tracePrefix + " received unsupported admin command type " + command.getClass().getName(), Tracer.Level.WARNING);
                        return;
                    }
                }
            }
            finally {
                command.dispose();
            }
        }
        catch (Exception e) {
            this.replyWithError(this.channel, packet, e);
        }
    }

    protected void setAdminCompatVersion(XString clientCompatLevel) throws EAdminException {
        try {
            int dot = clientCompatLevel.indexOf('.');
            this.adminCompatLevel = dot == -1 ? (int)clientCompatLevel.getValueAsLong() : Integer.parseInt(clientCompatLevel.getValue().substring(0, dot));
        }
        catch (NumberFormatException nfe) {
            throw new EAdminException("Client sent invalid compatibility level: " + clientCompatLevel + " admin capability may be limited");
        }
    }

    @Override
    public SrvControllerAdminApp.AdminClientContext.Stats getStats() {
        return this.stats;
    }

    @Override
    public final String getName() {
        return this.channel.getName();
    }

    @Override
    public String getClientName(ISrvMonXvmRequest request) {
        if (!request.hasAdminClientId()) {
            return this.getName();
        }
        return request.getAdminClientId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean publishTraceRecord(SrvMonTraceRecord traceRecord) {
        try {
            PktPacket packet = this.getUseAdmTraceRecords() ? traceRecord.serializeToPacket() : this.prepareLegacyTraceRecord(traceRecord);
            if (this.enque(packet, 9, true, traceRecord.getLevel().val >= SrvMonTraceLevel.WARNING.val, false)) {
                ++this.stats.tracesSent;
                boolean bl = true;
                return bl;
            }
            ++this.stats.tracesDropped;
            boolean bl = false;
            return bl;
        }
        finally {
            traceRecord.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <RequestType extends IRogMessage & ISrvMonEvent> boolean publishEvent(RequestType event, boolean flush, boolean dropIfCongested) {
        MessageView toSend = this.convertToLegacyLifecycleEvent((MessageView)event);
        if (toSend == null) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Dropped lifecycle message '" + event.getClass().getSimpleName() + "' for legacy client (" + this.adminCompatLevel + ")", Tracer.Level.DEBUG);
            }
            return true;
        }
        if (event != toSend && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Converted lifecycle message '" + event.getClass().getSimpleName() + "' for legacy client (" + this.adminCompatLevel + ")", Tracer.Level.DEBUG);
        }
        PktPacket packet = toSend.serializeToPacket();
        try {
            if (this.enque(packet, 0, flush, dropIfCongested, false)) {
                ++this.stats.eventsSent;
                boolean bl = true;
                return bl;
            }
            ++this.stats.eventsDropped;
            boolean bl = false;
            return bl;
        }
        finally {
            toSend.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <RequestType extends IRogMessage & ISrvMonXvmRequest, ResponseType extends IRogMessage & ISrvMonXvmResponse> void sendResponse(RequestType request, ResponseType response) {
        PktPacket requestPacket = null;
        try {
            requestPacket = (PktPacket)request.getAttachment();
            if (requestPacket.getBody() instanceof PktBodyServerAdminRequest) {
                if (requestPacket.getHeader().getRRSubheader() != null) {
                    if (response != null) {
                        SrvMonInvokeCommandResponse invokeResponse = (SrvMonInvokeCommandResponse)response;
                        if (invokeResponse.getErrorMessage() != null) {
                            this.replyWithPacket(this.channel, requestPacket, "NOK " + invokeResponse.getErrorMessage() + ": " + invokeResponse.getStackTrace());
                        } else if (!invokeResponse.hasReturnType() || invokeResponse.getReturnType() == SrvMonReturnType.VOID) {
                            this.replyWithPacket(this.channel, requestPacket, "OK ");
                        } else if (invokeResponse.getReturnType() == SrvMonReturnType.STRING) {
                            String result = invokeResponse.getStringReturnValue();
                            StringBuilder builder = new StringBuilder();
                            this.replyWithPacket(this.channel, requestPacket, result.startsWith("OK") || result.startsWith("NOK") ? result : builder.append("OK ").append(result).toString());
                        } else {
                            this.replyWithPacket(this.channel, requestPacket, "OK " + SrvMonUtil.getResponseValue(invokeResponse));
                        }
                    } else {
                        this.replyWithPacket(this.channel, requestPacket, "OK ");
                    }
                } else if (this.tracer.isEnabled(Tracer.Level.VERBOSE)) {
                    this.tracer.log(this.tracePrefix + "Legacy admin command '" + request.getClass().getSimpleName() + "' returned '" + SrvMonUtil.getResponseValue((SrvMonInvokeCommandResponse)response) + "', but no reply requested.", Tracer.Level.VERBOSE);
                }
            } else if (requestPacket.getHeader().getRRSubheader() != null) {
                if (response != null) {
                    ((ISrvMonXvmResponse)response).lendXvmHeader(this.controller.getXvmMessageHeader());
                    this.replyWithMessage(this.channel, requestPacket, response);
                } else {
                    this.replyWithPacket(this.channel, requestPacket, "NOK no data returned");
                }
            } else if (response != null && this.tracer.isEnabled(Tracer.Level.VERBOSE)) {
                this.tracer.log(this.tracePrefix + "Admin command '" + request.getClass().getSimpleName() + "' returned '" + response.getClass().getSimpleName() + "', but no reply requested.", Tracer.Level.VERBOSE);
            }
        }
        finally {
            if (response != null) {
                response.dispose();
            }
        }
    }

    @Override
    public final <RequestType extends IRogMessage & ISrvMonXvmRequest> void sendErrorResponse(RequestType request, Exception e) {
        PktPacket requestPacket = (PktPacket)request.getAttachment();
        this.replyWithError(this.channel, requestPacket, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean publishHeartbeat(SrvMonHeartbeatMessage message) {
        PktPacket packet = message.serializeToPacket();
        try {
            if (this.enque(packet, 1, true, true, false)) {
                ++this.stats.heartbeatsSent;
                boolean bl = true;
                return bl;
            }
            ++this.stats.heartbeatsDropped;
            boolean bl = false;
            return bl;
        }
        finally {
            message.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush() {
        SrvControllerAdminClient srvControllerAdminClient = this;
        synchronized (srvControllerAdminClient) {
            if (this.state == State.Open) {
                this.flushUnprotected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        SrvControllerAdminClient srvControllerAdminClient = this;
        synchronized (srvControllerAdminClient) {
            if (this.state != State.Closed) {
                try {
                    this.flusher.shutdown();
                    try {
                        this.channel.close();
                    }
                    catch (SmaException smaException) {
                        // empty catch block
                    }
                }
                finally {
                    this.state = State.Closed;
                }
            }
        }
    }

    private final class Flusher
    extends Thread {
        private final String name;
        private final IEmxDispatcher dispatcher;
        private final CountDownLatch startLatch;
        private final ShutdownEventHandler shutdownEventHandler;
        private volatile boolean done;

        Flusher(String channelName) {
            try {
                this.name = "X-Server-AdminClient-Flusher-" + channelName;
                this.dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, this.name, IEmxDispatcher.Params.create((boolean)false, (boolean)true));
                this.startLatch = new CountDownLatch(1);
                this.shutdownEventHandler = new ShutdownEventHandler();
                this.setName(this.name);
                this.setDaemon(true);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        private final IEmxDispatcher dispatcher() {
            return this.dispatcher;
        }

        private final CountDownLatch startLatch() {
            return this.startLatch;
        }

        final void waitForStart() {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        final void shutdown() {
            this.done = true;
            this.dispatcher.schedUserEv(EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.shutdownEventHandler));
        }

        @Override
        public final void run() {
            try {
                this.dispatcher.setOwner(1);
                this.startLatch.countDown();
                while (!this.done) {
                    this.dispatcher.run(-1);
                }
                this.dispatcher.close(true);
            }
            catch (Throwable e) {
                SrvControllerAdminClient.this.tracer.log("Unhandled fault in thread [" + this.dispatcher.getName() + "] [" + e.toString() + "]", Tracer.Level.SEVERE);
                e.printStackTrace();
            }
        }

        private final class ShutdownEventHandler
        implements IEmxEventHandler {
            private ShutdownEventHandler() {
            }

            public boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
                return false;
            }
        }
    }

    private final class FlushAction
    implements IEmxAction<Object, Object> {
        private final MessageViewFactory rawMessageViewFactory = MessageViewFactoryRegistry.getInstance().getMessageViewFactory((short)1);

        FlushAction() {
            if (this.rawMessageViewFactory == null) {
                throw new RuntimeException("Fatal error: Unable to load the raw message view factory");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            SrvControllerAdminClient srvControllerAdminClient = SrvControllerAdminClient.this;
            synchronized (srvControllerAdminClient) {
                block17: {
                    if (((SrvControllerAdminClient)SrvControllerAdminClient.this).tracer.debug) {
                        SrvControllerAdminClient.this.tracer.log("Flushing outbound queue of admin client '" + SrvControllerAdminClient.this.channel.getName() + "' (qcount = " + SrvControllerAdminClient.this.oq.count() + ")", Tracer.Level.DEBUG);
                    }
                    if (SrvControllerAdminClient.this.state == State.Open) {
                        SrvControllerAdminClient.this.flushScheduled = false;
                        ++((SrvControllerAdminClient)SrvControllerAdminClient.this).stats.flushesExecuted;
                        try {
                            PktPacket packet;
                            int sent = 0;
                            while ((packet = SrvControllerAdminClient.this.oq.poll()) != null) {
                                if (((SrvControllerAdminClient)SrvControllerAdminClient.this).tracer.debug) {
                                    SrvControllerAdminClient.this.tracer.log("Writing queue element (qcount = " + SrvControllerAdminClient.this.oq.count() + ")", Tracer.Level.DEBUG);
                                }
                                try {
                                    IRogRawMessage rawMessage = RogRawMessageFactory.createRogRawMessage();
                                    byte[] ioBuffer = new byte[packet.getSerializedLength()];
                                    packet.serialize(ioBuffer, 0);
                                    rawMessage.setRawMessage(ioBuffer);
                                    SrvControllerAdminClient.this.engine.sendMessage(SrvControllerAdminClient.this.channel, (IRogMessage)rawMessage);
                                    ++sent;
                                }
                                finally {
                                    packet.dispose();
                                }
                            }
                            if (SrvControllerAdminClient.this.flushBindingOnFlush && sent > 0) {
                                SrvControllerAdminClient.this.channel.getMessageBusBinding().flush(null);
                            }
                        }
                        catch (Exception e) {
                            SrvControllerAdminClient.this.state = State.Failed;
                            if (e.getMessage() != null) {
                                if (SrvControllerAdminClient.this.engine.getState() == AepEngine.State.Started) {
                                    SrvControllerAdminClient.this.tracer.log("Failed to send enqueued data to admin client '" + SrvControllerAdminClient.this.channel.getName() + "' [" + e.getMessage() + "]", Tracer.Level.WARNING);
                                }
                                break block17;
                            }
                            e.printStackTrace();
                        }
                    } else if (((SrvControllerAdminClient)SrvControllerAdminClient.this).tracer.debug) {
                        SrvControllerAdminClient.this.tracer.log("...admin client is not open (state = " + (Object)((Object)SrvControllerAdminClient.this.state) + "). nothing to do", Tracer.Level.DEBUG);
                    }
                }
            }
            return null;
        }
    }

    final class OutboundQueue {
        private final UtlList[] lists = new UtlList[10];
        private final AtomicInteger[] listSizes;
        private final int capacityPerList;
        private AtomicInteger count;
        private AtomicInteger size;
        private AtomicLong flushCount;
        private AtomicLong flushSize;

        OutboundQueue(SrvConfigDescriptor serverConfig) {
            int i;
            for (i = 0; i < this.lists.length; ++i) {
                this.lists[i] = UtlList.create();
            }
            this.listSizes = new AtomicInteger[this.lists.length];
            for (i = 0; i < this.listSizes.length; ++i) {
                this.listSizes[i] = new AtomicInteger(0);
            }
            this.capacityPerList = serverConfig.getAdminClientOutputQueueCapacity();
            this.count = new AtomicInteger(0);
            this.size = new AtomicInteger(0);
            this.flushCount = new AtomicLong(0L);
            this.flushSize = new AtomicLong(0L);
        }

        private final boolean drop(int priority, int serializedLength) {
            return this.listSizes[priority].get() + serializedLength > this.capacityPerList;
        }

        final int capacity() {
            return this.capacityPerList * this.lists.length;
        }

        final int count() {
            return this.count.get();
        }

        final int size() {
            return this.size.get();
        }

        final long flushCount() {
            return this.flushCount.get();
        }

        final long flushSize() {
            return this.flushSize.get();
        }

        final boolean offer(PktPacket packet, int priority, boolean dropIfCongested) {
            if (priority < 0 || priority > this.lists.length - 1) {
                throw new IllegalArgumentException("invalid priority " + priority);
            }
            UtlList list = this.lists[priority];
            int packetSerializedLength = packet.getSerializedLength();
            if (!dropIfCongested || !this.drop(priority, packetSerializedLength)) {
                list.append((UtlListElement)packet);
                this.listSizes[priority].addAndGet(packetSerializedLength);
                this.size.addAndGet(packetSerializedLength);
                this.count.incrementAndGet();
                return true;
            }
            return false;
        }

        final PktPacket poll() {
            for (int i = 0; i < this.lists.length; ++i) {
                UtlList list = this.lists[i];
                if (list.count() <= 0) continue;
                PktPacket packet = (PktPacket)list.first();
                int packetSerializedLength = packet.getSerializedLength();
                this.listSizes[i].addAndGet(-1 * packetSerializedLength);
                this.size.addAndGet(-1 * packetSerializedLength);
                this.flushSize.addAndGet(packetSerializedLength);
                this.count.decrementAndGet();
                this.flushCount.incrementAndGet();
                packet.unlink();
                return packet;
            }
            return null;
        }
    }

    private final class AdminClientStats
    implements SrvControllerAdminApp.AdminClientContext.Stats {
        volatile long responsesSent;
        volatile long responsesDropped;
        volatile long eventsSent;
        volatile long eventsDropped;
        volatile long heartbeatsSent;
        volatile long heartbeatsDropped;
        volatile long tracesSent;
        volatile long tracesDropped;
        volatile long flushesScheduled;
        volatile long flushesExecuted;

        private AdminClientStats() {
        }

        @Override
        public final long getResponsesSent() {
            return this.responsesSent;
        }

        @Override
        public final long getResponsesDropped() {
            return this.responsesDropped;
        }

        @Override
        public final long getEventsSent() {
            return this.eventsSent;
        }

        @Override
        public final long getEventsDropped() {
            return this.eventsDropped;
        }

        @Override
        public final long getHeartbeatsSent() {
            return this.heartbeatsSent;
        }

        @Override
        public final long getHeartbeatsDropped() {
            return this.heartbeatsDropped;
        }

        @Override
        public final long getTracesSent() {
            return this.tracesSent;
        }

        @Override
        public final long getTracesDropped() {
            return this.tracesDropped;
        }

        @Override
        public final long getFlushesScheduled() {
            return this.flushesScheduled;
        }

        @Override
        public final long getFlushesExecuted() {
            return this.flushesExecuted;
        }

        @Override
        public final SrvControllerAdminApp.AdminClientContext getClient() {
            return SrvControllerAdminClient.this;
        }

        @Override
        public final int getOutboundQueueCapacity() {
            return SrvControllerAdminClient.this.oq.capacity();
        }

        @Override
        public final int getOutboundQueueSize() {
            return SrvControllerAdminClient.this.oq.size();
        }

        @Override
        public final int getOutboundQueueCount() {
            return SrvControllerAdminClient.this.oq.count();
        }

        @Override
        public final long getOutboundQueueFlushSize() {
            return SrvControllerAdminClient.this.oq.flushSize();
        }

        @Override
        public final long getOutboundQueueFlushCount() {
            return SrvControllerAdminClient.this.oq.flushCount();
        }
    }

    private static enum State {
        Open,
        Failed,
        Closed;

    }
}

