/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.util.UtlProps;
import com.neeve.util.UtlTailoring;
import java.util.Properties;

public final class UtlStr {
    private static final String parseToken(String str, String token, UtlTailoring.PropertySource resolver) {
        int defValueIndex = token.indexOf("::");
        if (defValueIndex < 0) {
            throw new IllegalArgumentException("format error : '" + str + " (token='" + token + "') [substitution token must be of the format '[var]<::<defval>>]' (a non-empty default value is mandatory)");
        }
        String defValue = token.substring(defValueIndex + 2, token.length());
        String variable = token.substring(0, defValueIndex);
        if ((defValue = defValue.trim()).length() == 0) {
            throw new IllegalArgumentException("format error : '" + str + " (token='" + token + "') [substitution token must be of the format '[var]<::<defval>>]' (a non-empty default value is mandatory)");
        }
        return variable.length() > 0 ? resolver.getValue(variable.trim(), defValue) : defValue;
    }

    public static final String subst(String str, UtlTailoring.PropertySource resolver) {
        str = str.trim();
        StringBuilder source = new StringBuilder(str);
        StringBuilder dest = new StringBuilder();
        StringBuilder token = new StringBuilder();
        boolean inToken = false;
        boolean inEscape = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = source.charAt(i);
            if (c == '\\') {
                boolean bl = inEscape = !inEscape;
                if (inEscape) continue;
                dest.append(c);
                continue;
            }
            if (c == '%' && !inEscape) {
                boolean bl = inToken = !inToken;
                if (!inToken) {
                    dest.append(UtlStr.parseToken(str, token.toString().trim(), resolver));
                    token.setLength(0);
                }
            } else if (inToken) {
                token.append(c);
            } else {
                dest.append(c);
            }
            inEscape = false;
        }
        return dest.toString();
    }

    public static final String substEnv(String str) {
        return UtlStr.subst(str, new SubstResolverFromEnv());
    }

    public static final class SubstResolverFromEnv
    implements ISubstResolver {
        @Override
        public final String getValue(String variable, String defValue) {
            String value = System.getenv(variable);
            value = value != null ? value : UtlProps.getValue((Properties)System.getProperties(), (String)variable, (String)defValue);
            return value != null ? value.trim() : value;
        }
    }

    public static interface ISubstResolver
    extends UtlTailoring.PropertySource {
    }
}

