/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ci;

import com.neeve.ci.DefaultProductInfo;
import com.neeve.ci.ProductInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestProductInfo
extends DefaultProductInfo {
    private static final Map<String, ManifestProductInfo> productManifests = new HashMap<String, ManifestProductInfo>();
    private final String version;
    private final String vendorId;
    private final String productName;

    private ManifestProductInfo(Manifest manifest) {
        this.version = manifest.getMainAttributes().getValue("Implementation-Version");
        this.vendorId = manifest.getMainAttributes().getValue("Implementation-Vendor");
        this.productName = manifest.getMainAttributes().getValue("Implementation-Title");
    }

    @Override
    public String getComponentVersionString() {
        return this.version == null ? super.getComponentVersionString() : this.version;
    }

    @Override
    public String getProductName() {
        return this.productName == null ? super.getProductName() : this.productName;
    }

    @Override
    public String getVendorName() {
        return this.vendorId == null ? super.getVendorName() : this.vendorId;
    }

    public static final ProductInfo loadProductInfo(String productName) {
        ProductInfo pi = productManifests.get(productName);
        if (pi == null) {
            pi = new DefaultProductInfo();
        }
        return pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Enumeration<URL> resources = DefaultProductInfo.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                InputStream in = resources.nextElement().openStream();
                try {
                    Manifest manifest = new Manifest(in);
                    Attributes attributes = manifest.getMainAttributes();
                    String vendorId = attributes.getValue("Implementation-Vendor");
                    if (vendorId == null || !vendorId.equals("Neeve Research & Consulting, LLC") && !vendorId.equals("Neeve Research, LLC")) continue;
                    String productName = attributes.getValue("Implementation-Title");
                    productManifests.put(productName, new ManifestProductInfo(manifest));
                }
                catch (IOException e) {}
                continue;
                finally {
                    in.close();
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("Error reading product manifests " + ioe.getMessage());
        }
    }
}

