/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.AepSFRTestAppBase;
import com.neeve.aep.test.unit.AepSFRTestBase;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.aep.test.unit.generated.xbuf.Child1;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.ods.IStoreField;
import com.neeve.ods.impl.StoreBindingRoleChangedEvent;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.sma.MessageView;
import com.neeve.util.UtlReflection;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AepEngineStateQueryTest
extends AepSFRTestBase {
    @Parameterized.Parameter(value=0)
    public boolean hasStore;
    @Parameterized.Parameter(value=1)
    public AepEngine.HAPolicy haPolicy;
    @Parameterized.Parameter(value=2)
    public boolean persistent;
    @Parameterized.Parameter(value=3)
    public boolean clustered;
    @Parameterized.Parameter(value=4)
    public boolean testRecovery;
    @Parameterized.Parameter(value=5)
    public AepEngineTestObject.EncodingType encoding;
    @Rule
    public ExpectedException eventSourcingNotSupported = ExpectedException.none();
    private AepSFRTestBase.Sender sender;
    private AepSFRTestBase.Forwarder forwarder;
    private AepSFRTestBase.Forwarder forwarderBackup;
    private AepSFRTestBase.Receiver receiver;

    @Parameterized.Parameters(name="{index}: hasStore={0}, haPolicy={1}, persistent={2}, clustered={3}, testRecovery={4}, encoding={5}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false, AepEngine.HAPolicy.EventSourcing, false, false, false, AepEngineTestObject.EncodingType.Proto}, {true, AepEngine.HAPolicy.EventSourcing, false, false, false, AepEngineTestObject.EncodingType.Proto}, {false, AepEngine.HAPolicy.StateReplication, false, false, false, AepEngineTestObject.EncodingType.Proto}, {true, AepEngine.HAPolicy.StateReplication, true, false, false, AepEngineTestObject.EncodingType.Proto}, {true, AepEngine.HAPolicy.StateReplication, true, true, false, AepEngineTestObject.EncodingType.Proto}, {true, AepEngine.HAPolicy.StateReplication, true, false, true, AepEngineTestObject.EncodingType.Proto}, {true, AepEngine.HAPolicy.StateReplication, true, true, true, AepEngineTestObject.EncodingType.Proto}, {false, AepEngine.HAPolicy.StateReplication, false, false, false, AepEngineTestObject.EncodingType.Xbuf}, {true, AepEngine.HAPolicy.StateReplication, true, false, false, AepEngineTestObject.EncodingType.Xbuf}, {true, AepEngine.HAPolicy.StateReplication, true, true, false, AepEngineTestObject.EncodingType.Xbuf}, {true, AepEngine.HAPolicy.StateReplication, true, false, true, AepEngineTestObject.EncodingType.Xbuf}, {true, AepEngine.HAPolicy.StateReplication, true, true, true, AepEngineTestObject.EncodingType.Xbuf}};
        return Arrays.asList(data);
    }

    @Override
    public String testCaseId() {
        String methodName = this.testcaseName.getMethodName();
        return methodName.substring(0, methodName.indexOf(":")).replace('[', '-');
    }

    @Before
    public void setupTestcase() {
        AepEngineStateQueryTest.setVerbose((boolean)false);
        this.sender = this.createSender("standalone");
        this.forwarder = (AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)this.createForwarder(this.clustered ? "primary" : "standalone").setStoreEnabled(this.hasStore)).setClustered(this.clustered)).setPersistent(this.persistent);
        if (this.hasStore) {
            this.forwarder.storeDescriptor.setQueryable(true);
        }
        if (this.clustered) {
            this.forwarderBackup = (AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)this.createForwarder("backup").setStoreEnabled(this.hasStore)).setClustered(this.clustered)).setPersistent(this.persistent);
            this.forwarderBackup.storeDescriptor.setQueryable(true);
        }
        this.receiver = this.createReceiver("standalone");
        this.receiver.engineDescriptor.setPerformDuplicateChecking(false);
        for (AepSFRTestAppBase app : this.apps) {
            app.engineDescriptor.setHAPolicy(this.haPolicy);
        }
        switch (this.encoding) {
            case Proto: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(Repository.class);
                    app.engineDescriptor.addStateFactory(com.neeve.aep.test.unit.generated.proto.Factory.class.getName());
                    this.sender.engineDescriptor.addMessageFactory(com.neeve.aep.test.unit.generated.proto.Factory.class.getName());
                }
                break;
            }
            case Xbuf: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(com.neeve.aep.test.unit.generated.xbuf.Repository.class);
                    app.engineDescriptor.addStateFactory(Factory.class.getName());
                    this.sender.engineDescriptor.addMessageFactory(Factory.class.getName());
                }
                break;
            }
            case Json: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(com.neeve.aep.test.unit.generated.json.Repository.class);
                    app.engineDescriptor.addStateFactory(com.neeve.aep.test.unit.generated.json.Factory.class.getName());
                    this.sender.engineDescriptor.addMessageFactory(com.neeve.aep.test.unit.generated.json.Factory.class.getName());
                }
                break;
            }
            case Raw: {
                throw new UnsupportedOperationException("Raw support not enabled");
            }
        }
    }

    @Test
    @Ignore
    public void testIndexing() throws Throwable {
        AddUpdateRemoveHandler handler = new AddUpdateRemoveHandler(this.forwarder);
        this.forwarder.addEventHandler(handler);
        AddUpdateRemoveHandler backupHandler = null;
        if (this.clustered) {
            backupHandler = new AddUpdateRemoveHandler(this.forwarderBackup);
            this.forwarderBackup.addEventHandler(backupHandler);
        }
        this.startApps();
        int sendCount = 10;
        for (int i = 0; i < sendCount; ++i) {
            this.sender.sendMessage(this.CHANNELS[0][1][0][1], AepEngineTestMessage.create(this.encoding, false).getMessage());
        }
        this.forwarder.waitForMessageReceipt(sendCount);
        if (this.testRecovery) {
            this.restartApp(this.forwarder);
        }
        this.forwarder.assertExpectedReceipt(5, sendCount);
        if (handler.handlerError != null) {
            throw handler.handlerError;
        }
    }

    private final Object getOrCreateEntityField(Object rootState) {
        switch (this.encoding) {
            case Proto: {
                Repository state = (Repository)rootState;
                if (!state.hasEntityField()) {
                    state.setEntityField(com.neeve.aep.test.unit.generated.proto.Child1.create());
                }
                return state.getEntityField();
            }
            case Xbuf: {
                com.neeve.aep.test.unit.generated.xbuf.Repository state = (com.neeve.aep.test.unit.generated.xbuf.Repository)rootState;
                if (!state.hasEntityField()) {
                    state.setEntityField(Child1.create());
                }
                return state.getEntityField();
            }
            case Json: {
                com.neeve.aep.test.unit.generated.json.Repository state = (com.neeve.aep.test.unit.generated.json.Repository)rootState;
                if (!state.hasEntityField()) {
                    state.setEntityField(com.neeve.aep.test.unit.generated.json.Child1.create());
                }
                return state.getEntityField();
            }
        }
        throw new UnsupportedOperationException("Unsupported encoding");
    }

    private class AddUpdateRemoveHandler
    extends MessageHandler {
        AepSFRTestBase.Forwarder forwarder;
        IdxIndex<Integer, UUID> intFieldIndex;

        AddUpdateRemoveHandler(AepSFRTestBase.Forwarder forwarder) {
            this.forwarder = forwarder;
        }

        @EventHandler
        public void onRoleChangeEvent(StoreBindingRoleChangedEvent event) {
            IStoreField intField = this.forwarder.engine.getStore().getQueryEngine().getField("Child1.intField");
            this.forwarder.engine.getStore().getQueryEngine().createIndex((IdxField)intField, false);
            this.intFieldIndex = this.forwarder.engine.getStore().asQueryRepository().getIndex((IdxField)intField);
        }

        @Override
        public void handle(MessageView message, Object state) throws Exception {
            Object child = AepEngineStateQueryTest.this.getOrCreateEntityField(state);
            UtlReflection.setNonNestedProperty((Object)child, (String)"intField", (Object)2);
        }
    }

    public abstract class MessageHandler {
        protected Object state;
        volatile Throwable handlerError;

        @EventHandler
        public void onProtoMessage(com.neeve.aep.test.unit.generated.proto.Message message) {
            this.handleInternal((MessageView)message);
        }

        @EventHandler
        public void onXbufMessage(com.neeve.aep.test.unit.generated.xbuf.Message message) {
            this.handleInternal((MessageView)message);
        }

        @EventHandler
        public void onJsonMessage(Message message) {
            this.handleInternal((MessageView)message);
        }

        private void handleInternal(MessageView message) {
            try {
                this.handle(message, this.getState(message));
            }
            catch (Throwable t) {
                this.handlerError = t;
            }
        }

        protected Object getState(MessageView message) {
            if (AepEngineStateQueryTest.this.haPolicy == AepEngine.HAPolicy.StateReplication) {
                this.state = ((AepEngineStateQueryTest)AepEngineStateQueryTest.this).forwarder.engine.getApplicationState(message);
            } else if (this.state == null) {
                switch (AepEngineStateQueryTest.this.encoding) {
                    case Json: {
                        this.state = com.neeve.aep.test.unit.generated.json.Repository.create();
                        break;
                    }
                    case Proto: {
                        this.state = Repository.create();
                        break;
                    }
                    case Xbuf: {
                        this.state = com.neeve.aep.test.unit.generated.xbuf.Repository.create();
                        break;
                    }
                }
            }
            return this.state;
        }

        public abstract void handle(MessageView var1, Object var2) throws Exception;
    }
}

