/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.mon;

import cern.colt.map.OpenIntObjectHashMap;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.pkt.PktBuffer;
import com.neeve.server.mon.ISrvMonSysMemoryStats;
import com.neeve.server.mon.SrvMonFactory;
import com.neeve.server.mon.SrvMonSysMemoryIOBufCounters;
import com.neeve.server.mon.SrvMonSysMemoryNativeCounters;
import com.neeve.server.mon.SrvMonSysMemoryOffHeapUsage;
import com.neeve.server.mon.SrvMonSysMemoryUsage;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReferenceTracker;
import com.neeve.xbuf.IXbufDesyncer;
import com.neeve.xbuf.XbufDesyncPolicy;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufHeuristics;
import com.neeve.xbuf.XbufListField;
import com.neeve.xbuf.XbufReferenceTypeField;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufVariableLengthField;
import com.neeve.xbuf.XbufVariableLongField;
import com.neeve.xbuf.XbufVariableShortField;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="Xbuf", compatLevel="4.1.0", admVersion="Unknown Version", date="12/4/24 2:51 AM", buildInfo="nvx-talon 3.16 (raven)")
@AdmFactoryInfo(factoryClass=SrvMonFactory.class, vfid=32, ofid=32, typeId=212)
@JsonPropertyOrder(value={"committedVirtualMemorySize", "freePhysicalMemorySize", "freeSwapSpaceSize", "totalPhysicalMemorySize", "totalSwapSpaceSize", "heapUsage", "nonHeapUsage", "offHeapUsage", "nativeCounters", "iobufCounters"})
public final class SrvMonSysMemoryStats
implements IXbufDesyncer,
UtlPool.Item<SrvMonSysMemoryStats>,
ISrvMonSysMemoryStats {
    private static final int initialBackingBufferSize = XbufHeuristics.getProperty(SrvMonSysMemoryStats.class, (String)"initialbackingbuffersize", (int)256);
    public static final SrvMonSysMemoryStats[] EMPTY_ARRAY = new SrvMonSysMemoryStats[0];
    private XbufFieldContainer _container;
    private int _lateSyncBoundary;
    private final XbufVariableShortField _fldXRogType;
    private final XbufVariableLongField _fldCommittedVirtualMemorySize;
    private final XbufVariableLongField _fldFreePhysicalMemorySize;
    private final XbufVariableLongField _fldFreeSwapSpaceSize;
    private final XbufVariableLongField _fldTotalPhysicalMemorySize;
    private final XbufVariableLongField _fldTotalSwapSpaceSize;
    private final SrvMonSysMemoryUsage.Field _fldHeapUsage;
    private final SrvMonSysMemoryUsage.Field _fldNonHeapUsage;
    private final SrvMonSysMemoryOffHeapUsage.Field _fldOffHeapUsage;
    private final SrvMonSysMemoryNativeCounters.Field _fldNativeCounters;
    private final SrvMonSysMemoryIOBufCounters.Field _fldIobufCounters;
    private final XbufSchema _schema = SrvMonSysMemoryStats.createSchema();
    @JsonProperty(value="_xFieldBitmask_")
    private final long[] _fieldBitmask;
    private static long[] _fieldInterestBitmask;
    private static volatile boolean _objectInstantiated;
    private boolean _isDirty;
    private static int _optimizationHints;
    private static XbufDesyncPolicy _desyncPolicy;
    private static final Factory _factory;
    private static final UtlPool<SrvMonSysMemoryStats> _entityPool;
    private final UtlReferenceTracker _refTracker;
    private final AtomicInteger _ownershipCount;
    private UtlPool<SrvMonSysMemoryStats> _pool;
    private boolean readOnly;
    private static final OpenIntObjectHashMap fieldMapById;
    private static final Map<String, Integer> fieldMapByName;
    private final XbufField.VarintDesyncLength varintDesyncLength;

    public SrvMonSysMemoryStats() {
        this(initialBackingBufferSize);
    }

    public SrvMonSysMemoryStats(int initialBackingBufferSize) {
        this._fldXRogType = (XbufVariableShortField)this._schema.field("XRogType");
        this._fldCommittedVirtualMemorySize = (XbufVariableLongField)this._schema.field("CommittedVirtualMemorySize");
        this._fldFreePhysicalMemorySize = (XbufVariableLongField)this._schema.field("FreePhysicalMemorySize");
        this._fldFreeSwapSpaceSize = (XbufVariableLongField)this._schema.field("FreeSwapSpaceSize");
        this._fldTotalPhysicalMemorySize = (XbufVariableLongField)this._schema.field("TotalPhysicalMemorySize");
        this._fldTotalSwapSpaceSize = (XbufVariableLongField)this._schema.field("TotalSwapSpaceSize");
        this._fldHeapUsage = (SrvMonSysMemoryUsage.Field)this._schema.field("HeapUsage");
        this._fldNonHeapUsage = (SrvMonSysMemoryUsage.Field)this._schema.field("NonHeapUsage");
        this._fldOffHeapUsage = (SrvMonSysMemoryOffHeapUsage.Field)this._schema.field("OffHeapUsage");
        this._fldNativeCounters = (SrvMonSysMemoryNativeCounters.Field)this._schema.field("NativeCounters");
        this._fldIobufCounters = (SrvMonSysMemoryIOBufCounters.Field)this._schema.field("IobufCounters");
        this._fieldBitmask = new long[1];
        _objectInstantiated = true;
        this.varintDesyncLength = new XbufField.VarintDesyncLength();
        this._refTracker = UtlReferenceTracker.enabled(this.getClass()) ? new UtlReferenceTracker((Object)this) : null;
        this._ownershipCount = new AtomicInteger(0);
        this._container = XbufFieldContainer.create((PktBuffer)PktBuffer.create((IOElasticBuffer.Sizer)null, (int)initialBackingBufferSize, (boolean)true)).setDesyncer((IXbufDesyncer)this).setSchema(this._schema.setFieldInterest(_fieldInterestBitmask));
        this._lateSyncBoundary = this._container.getLateSyncBoundaryFieldNumber();
    }

    public static SrvMonSysMemoryStats create() {
        return ((SrvMonSysMemoryStats)_entityPool.get(null)).undispose();
    }

    public static SrvMonSysMemoryStats createFromSerializedXbufContainer(byte[] serializedContainer, XbufDesyncPolicy desyncPolicy) {
        SrvMonSysMemoryStats entity = SrvMonSysMemoryStats.create();
        entity._container.getBackingBuffer().putFrom(0, serializedContainer, 0, serializedContainer.length);
        entity._container.desync(desyncPolicy);
        return entity;
    }

    public static SrvMonSysMemoryStats createFromSerializedXbufContainer(byte[] serializedContainer) {
        return SrvMonSysMemoryStats.createFromSerializedXbufContainer(serializedContainer, XbufDesyncPolicy.Copy);
    }

    public static SrvMonSysMemoryStats createFrom(byte[] serializedContainer, XbufDesyncPolicy desyncPolicy) {
        return SrvMonSysMemoryStats.createFromSerializedXbufContainer(serializedContainer, desyncPolicy);
    }

    public static SrvMonSysMemoryStats createFrom(byte[] serializedContainer) {
        return SrvMonSysMemoryStats.createFromSerializedXbufContainer(serializedContainer);
    }

    public static final void setDesyncPolicy(XbufDesyncPolicy val) {
        _desyncPolicy = val;
    }

    public static final XbufDesyncPolicy getDesyncPolicy() {
        return _desyncPolicy;
    }

    public static final void setFieldInterest(List<Integer> fieldIds) {
        if (_objectInstantiated) {
            throw new IllegalStateException("field interest must be set before the first object of this class has been instantiated");
        }
        _fieldInterestBitmask = new long[1];
        _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 1L;
        if (fieldIds.contains(18)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 2L;
        }
        if (fieldIds.contains(19)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 4L;
        }
        if (fieldIds.contains(20)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 8L;
        }
        if (fieldIds.contains(21)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 0x10L;
        }
        if (fieldIds.contains(22)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 0x20L;
        }
        if (fieldIds.contains(16)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 0x40L;
            SrvMonSysMemoryUsage.setFieldInterest(fieldIds);
        }
        if (fieldIds.contains(17)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 0x80L;
            SrvMonSysMemoryUsage.setFieldInterest(fieldIds);
        }
        if (fieldIds.contains(23)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 0x100L;
            SrvMonSysMemoryOffHeapUsage.setFieldInterest(fieldIds);
        }
        if (fieldIds.contains(24)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 0x200L;
            SrvMonSysMemoryNativeCounters.setFieldInterest(fieldIds);
        }
        if (fieldIds.contains(25)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 0x400L;
            SrvMonSysMemoryIOBufCounters.setFieldInterest(fieldIds);
        }
    }

    private final void clearFieldReferences() {
        if (this.getHeapUsage() != null) {
            this.getHeapUsage().dispose();
        }
        if (this.getNonHeapUsage() != null) {
            this.getNonHeapUsage().dispose();
        }
        if (this.getOffHeapUsage() != null) {
            this.getOffHeapUsage().dispose();
        }
        if (this.getNativeCounters() != null) {
            this.getNativeCounters().dispose();
        }
        if (this.getIobufCounters() != null) {
            this.getIobufCounters().dispose();
        }
    }

    public final void clearContent() {
        this.clearXRogType();
        this.clearCommittedVirtualMemorySize();
        this.clearFreePhysicalMemorySize();
        this.clearFreeSwapSpaceSize();
        this.clearTotalPhysicalMemorySize();
        this.clearTotalSwapSpaceSize();
        if (this.getHeapUsage() != null) {
            this.getHeapUsage().clearContent();
        }
        this.clearHeapUsage();
        if (this.getNonHeapUsage() != null) {
            this.getNonHeapUsage().clearContent();
        }
        this.clearNonHeapUsage();
        if (this.getOffHeapUsage() != null) {
            this.getOffHeapUsage().clearContent();
        }
        this.clearOffHeapUsage();
        if (this.getNativeCounters() != null) {
            this.getNativeCounters().clearContent();
        }
        this.clearNativeCounters();
        if (this.getIobufCounters() != null) {
            this.getIobufCounters().clearContent();
        }
        this.clearIobufCounters();
    }

    public final void syncFieldBitmask() {
        this._fieldBitmask[0] = this.hasXRogType() ? this._fieldBitmask[0] | 1L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
        this._fieldBitmask[0] = this.hasCommittedVirtualMemorySize() ? this._fieldBitmask[0] | 2L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
        this._fieldBitmask[0] = this.hasFreePhysicalMemorySize() ? this._fieldBitmask[0] | 4L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFBL;
        this._fieldBitmask[0] = this.hasFreeSwapSpaceSize() ? this._fieldBitmask[0] | 8L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFF7L;
        this._fieldBitmask[0] = this.hasTotalPhysicalMemorySize() ? this._fieldBitmask[0] | 0x10L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFEFL;
        this._fieldBitmask[0] = this.hasTotalSwapSpaceSize() ? this._fieldBitmask[0] | 0x20L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFDFL;
        if (this.getHeapUsage() != null) {
            this.getHeapUsage().syncFieldBitmask();
        }
        if (this.getNonHeapUsage() != null) {
            this.getNonHeapUsage().syncFieldBitmask();
        }
        if (this.getOffHeapUsage() != null) {
            this.getOffHeapUsage().syncFieldBitmask();
        }
        if (this.getNativeCounters() != null) {
            this.getNativeCounters().syncFieldBitmask();
        }
        if (this.getIobufCounters() != null) {
            this.getIobufCounters().syncFieldBitmask();
        }
    }

    public final void desyncFieldBitmask() {
        if ((this._fieldBitmask[0] & 1L) == 0L) {
            this.clearXRogType();
        }
        if ((this._fieldBitmask[0] & 2L) == 0L) {
            this.clearCommittedVirtualMemorySize();
        }
        if ((this._fieldBitmask[0] & 4L) == 0L) {
            this.clearFreePhysicalMemorySize();
        }
        if ((this._fieldBitmask[0] & 8L) == 0L) {
            this.clearFreeSwapSpaceSize();
        }
        if ((this._fieldBitmask[0] & 0x10L) == 0L) {
            this.clearTotalPhysicalMemorySize();
        }
        if ((this._fieldBitmask[0] & 0x20L) == 0L) {
            this.clearTotalSwapSpaceSize();
        }
        if (this.getHeapUsage() != null) {
            this.getHeapUsage().desyncFieldBitmask();
        }
        if (this.getNonHeapUsage() != null) {
            this.getNonHeapUsage().desyncFieldBitmask();
        }
        if (this.getOffHeapUsage() != null) {
            this.getOffHeapUsage().desyncFieldBitmask();
        }
        if (this.getNativeCounters() != null) {
            this.getNativeCounters().desyncFieldBitmask();
        }
        if (this.getIobufCounters() != null) {
            this.getIobufCounters().desyncFieldBitmask();
        }
    }

    @JsonIgnore
    public final PktBuffer getBackingBuffer() {
        return this._container.getBackingBuffer();
    }

    public static final void optimizeFor(int val) {
        if (_objectInstantiated) {
            throw new IllegalStateException("optimizations must be set before the first object of this class has been instantiated");
        }
        _optimizationHints = val;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this.getHeapUsage() != null) {
            this.getHeapUsage().setAsReadOnly();
        }
        if (this.getNonHeapUsage() != null) {
            this.getNonHeapUsage().setAsReadOnly();
        }
        if (this.getOffHeapUsage() != null) {
            this.getOffHeapUsage().setAsReadOnly();
        }
        if (this.getNativeCounters() != null) {
            this.getNativeCounters().setAsReadOnly();
        }
        if (this.getIobufCounters() != null) {
            this.getIobufCounters().setAsReadOnly();
        }
    }

    public final boolean getIsReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPreserializedFields(PktBuffer buffer) {
        block10: {
            int length = buffer.getLength();
            if (length > 0) {
                IOBuffer iobuf = buffer.getIOBuffer();
                ByteBuffer bytebuf = iobuf.takeBuffer();
                XbufDesyncPolicy desyncPolicy = this._container.getDesyncPolicy();
                try {
                    this._container.setDesyncPolicy(XbufDesyncPolicy.FrameContainer);
                    try {
                        bytebuf.limit(length);
                        this.deserializeFromByteBuffer(bytebuf);
                        break block10;
                    }
                    finally {
                        iobuf.releaseBuffer();
                    }
                }
                finally {
                    this._container.setDesyncPolicy(desyncPolicy);
                }
            }
            XbufDesyncPolicy desyncPolicy = this._container.getDesyncPolicy();
            try {
                this._container.setDesyncPolicy(XbufDesyncPolicy.FrameContainer);
                this.deserializeFromByteArray(AdmRuntime.EMPTY_BYTE_ARRAY);
            }
            finally {
                this._container.setDesyncPolicy(desyncPolicy);
            }
            return;
        }
    }

    public static final int getXRogTypeFieldId() {
        return 1;
    }

    @JsonProperty(value="xRogType")
    public final void setXRogType(short val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldXRogType.setValue(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final short getXRogType() {
        return this._fldXRogType.getValue();
    }

    @JsonProperty(value="xRogType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Short getXRogTypeAsObject() {
        if (!this.hasXRogType()) {
            return null;
        }
        return this.getXRogType();
    }

    @JsonIgnore
    public final void setXRogTypeFrom(XbufVariableShortField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldXRogType.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableShortField getXRogTypeField() {
        return this._fldXRogType;
    }

    public final boolean hasXRogType() {
        return this._fldXRogType.hasValue();
    }

    public final void clearXRogType() {
        this._fldXRogType.clearValue();
        this._isDirty = true;
    }

    public static final int getCommittedVirtualMemorySizeFieldId() {
        return 18;
    }

    @Override
    @JsonProperty(value="committedVirtualMemorySize")
    public final void setCommittedVirtualMemorySize(long val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldCommittedVirtualMemorySize.setValue(val);
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final long getCommittedVirtualMemorySize() {
        return this._fldCommittedVirtualMemorySize.getValue();
    }

    @Override
    @JsonProperty(value="committedVirtualMemorySize")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Long getCommittedVirtualMemorySizeAsObject() {
        if (!this.hasCommittedVirtualMemorySize()) {
            return null;
        }
        return this.getCommittedVirtualMemorySize();
    }

    @JsonIgnore
    public final void setCommittedVirtualMemorySizeFrom(XbufVariableLongField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldCommittedVirtualMemorySize.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableLongField getCommittedVirtualMemorySizeField() {
        return this._fldCommittedVirtualMemorySize;
    }

    @Override
    public final boolean hasCommittedVirtualMemorySize() {
        return this._fldCommittedVirtualMemorySize.hasValue();
    }

    @Override
    public final void clearCommittedVirtualMemorySize() {
        this._fldCommittedVirtualMemorySize.clearValue();
        this._isDirty = true;
    }

    public static final int getFreePhysicalMemorySizeFieldId() {
        return 19;
    }

    @Override
    @JsonProperty(value="freePhysicalMemorySize")
    public final void setFreePhysicalMemorySize(long val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldFreePhysicalMemorySize.setValue(val);
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final long getFreePhysicalMemorySize() {
        return this._fldFreePhysicalMemorySize.getValue();
    }

    @Override
    @JsonProperty(value="freePhysicalMemorySize")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Long getFreePhysicalMemorySizeAsObject() {
        if (!this.hasFreePhysicalMemorySize()) {
            return null;
        }
        return this.getFreePhysicalMemorySize();
    }

    @JsonIgnore
    public final void setFreePhysicalMemorySizeFrom(XbufVariableLongField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldFreePhysicalMemorySize.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableLongField getFreePhysicalMemorySizeField() {
        return this._fldFreePhysicalMemorySize;
    }

    @Override
    public final boolean hasFreePhysicalMemorySize() {
        return this._fldFreePhysicalMemorySize.hasValue();
    }

    @Override
    public final void clearFreePhysicalMemorySize() {
        this._fldFreePhysicalMemorySize.clearValue();
        this._isDirty = true;
    }

    public static final int getFreeSwapSpaceSizeFieldId() {
        return 20;
    }

    @Override
    @JsonProperty(value="freeSwapSpaceSize")
    public final void setFreeSwapSpaceSize(long val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldFreeSwapSpaceSize.setValue(val);
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final long getFreeSwapSpaceSize() {
        return this._fldFreeSwapSpaceSize.getValue();
    }

    @Override
    @JsonProperty(value="freeSwapSpaceSize")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Long getFreeSwapSpaceSizeAsObject() {
        if (!this.hasFreeSwapSpaceSize()) {
            return null;
        }
        return this.getFreeSwapSpaceSize();
    }

    @JsonIgnore
    public final void setFreeSwapSpaceSizeFrom(XbufVariableLongField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldFreeSwapSpaceSize.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableLongField getFreeSwapSpaceSizeField() {
        return this._fldFreeSwapSpaceSize;
    }

    @Override
    public final boolean hasFreeSwapSpaceSize() {
        return this._fldFreeSwapSpaceSize.hasValue();
    }

    @Override
    public final void clearFreeSwapSpaceSize() {
        this._fldFreeSwapSpaceSize.clearValue();
        this._isDirty = true;
    }

    public static final int getTotalPhysicalMemorySizeFieldId() {
        return 21;
    }

    @Override
    @JsonProperty(value="totalPhysicalMemorySize")
    public final void setTotalPhysicalMemorySize(long val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldTotalPhysicalMemorySize.setValue(val);
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final long getTotalPhysicalMemorySize() {
        return this._fldTotalPhysicalMemorySize.getValue();
    }

    @Override
    @JsonProperty(value="totalPhysicalMemorySize")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Long getTotalPhysicalMemorySizeAsObject() {
        if (!this.hasTotalPhysicalMemorySize()) {
            return null;
        }
        return this.getTotalPhysicalMemorySize();
    }

    @JsonIgnore
    public final void setTotalPhysicalMemorySizeFrom(XbufVariableLongField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldTotalPhysicalMemorySize.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableLongField getTotalPhysicalMemorySizeField() {
        return this._fldTotalPhysicalMemorySize;
    }

    @Override
    public final boolean hasTotalPhysicalMemorySize() {
        return this._fldTotalPhysicalMemorySize.hasValue();
    }

    @Override
    public final void clearTotalPhysicalMemorySize() {
        this._fldTotalPhysicalMemorySize.clearValue();
        this._isDirty = true;
    }

    public static final int getTotalSwapSpaceSizeFieldId() {
        return 22;
    }

    @Override
    @JsonProperty(value="totalSwapSpaceSize")
    public final void setTotalSwapSpaceSize(long val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldTotalSwapSpaceSize.setValue(val);
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final long getTotalSwapSpaceSize() {
        return this._fldTotalSwapSpaceSize.getValue();
    }

    @Override
    @JsonProperty(value="totalSwapSpaceSize")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Long getTotalSwapSpaceSizeAsObject() {
        if (!this.hasTotalSwapSpaceSize()) {
            return null;
        }
        return this.getTotalSwapSpaceSize();
    }

    @JsonIgnore
    public final void setTotalSwapSpaceSizeFrom(XbufVariableLongField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldTotalSwapSpaceSize.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableLongField getTotalSwapSpaceSizeField() {
        return this._fldTotalSwapSpaceSize;
    }

    @Override
    public final boolean hasTotalSwapSpaceSize() {
        return this._fldTotalSwapSpaceSize.hasValue();
    }

    @Override
    public final void clearTotalSwapSpaceSize() {
        this._fldTotalSwapSpaceSize.clearValue();
        this._isDirty = true;
    }

    public static final int getHeapUsageFieldId() {
        return 16;
    }

    @Override
    @JsonProperty(value="heapUsage")
    public final void setHeapUsage(SrvMonSysMemoryUsage val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        SrvMonSysMemoryUsage existing = this.getHeapUsage();
        if (existing != null && val != existing) {
            existing.dispose();
        }
        if (val != null) {
            this._fldHeapUsage.setValue(val);
        } else {
            this._fldHeapUsage.clearValue();
        }
        this._isDirty = true;
    }

    @Override
    public final void lendHeapUsage(SrvMonSysMemoryUsage val) {
        if (val != null) {
            val.acquire();
        }
        this.setHeapUsage(val);
    }

    @Override
    @JsonProperty(value="heapUsage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final SrvMonSysMemoryUsage getHeapUsage() {
        return (SrvMonSysMemoryUsage)this._fldHeapUsage.getValue();
    }

    @Override
    @JsonIgnore
    public final void getHeapUsageTo(SrvMonSysMemoryUsage to) {
        if (this.hasHeapUsage()) {
            this.getHeapUsage().copyInto(to);
        } else {
            to.clearContent();
        }
    }

    @Override
    public final SrvMonSysMemoryUsage takeHeapUsage() {
        SrvMonSysMemoryUsage val = this.getHeapUsage();
        if (val != null) {
            val.acquire();
        }
        return val;
    }

    @Override
    public final boolean hasHeapUsage() {
        return this._fldHeapUsage.hasValue();
    }

    @Override
    public final void clearHeapUsage() {
        SrvMonSysMemoryUsage existing = this.getHeapUsage();
        if (existing != null) {
            existing.dispose();
        }
        this._fldHeapUsage.clearValue();
        this._isDirty = true;
    }

    public static final int getNonHeapUsageFieldId() {
        return 17;
    }

    @Override
    @JsonProperty(value="nonHeapUsage")
    public final void setNonHeapUsage(SrvMonSysMemoryUsage val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        SrvMonSysMemoryUsage existing = this.getNonHeapUsage();
        if (existing != null && val != existing) {
            existing.dispose();
        }
        if (val != null) {
            this._fldNonHeapUsage.setValue(val);
        } else {
            this._fldNonHeapUsage.clearValue();
        }
        this._isDirty = true;
    }

    @Override
    public final void lendNonHeapUsage(SrvMonSysMemoryUsage val) {
        if (val != null) {
            val.acquire();
        }
        this.setNonHeapUsage(val);
    }

    @Override
    @JsonProperty(value="nonHeapUsage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final SrvMonSysMemoryUsage getNonHeapUsage() {
        return (SrvMonSysMemoryUsage)this._fldNonHeapUsage.getValue();
    }

    @Override
    @JsonIgnore
    public final void getNonHeapUsageTo(SrvMonSysMemoryUsage to) {
        if (this.hasNonHeapUsage()) {
            this.getNonHeapUsage().copyInto(to);
        } else {
            to.clearContent();
        }
    }

    @Override
    public final SrvMonSysMemoryUsage takeNonHeapUsage() {
        SrvMonSysMemoryUsage val = this.getNonHeapUsage();
        if (val != null) {
            val.acquire();
        }
        return val;
    }

    @Override
    public final boolean hasNonHeapUsage() {
        return this._fldNonHeapUsage.hasValue();
    }

    @Override
    public final void clearNonHeapUsage() {
        SrvMonSysMemoryUsage existing = this.getNonHeapUsage();
        if (existing != null) {
            existing.dispose();
        }
        this._fldNonHeapUsage.clearValue();
        this._isDirty = true;
    }

    public static final int getOffHeapUsageFieldId() {
        return 23;
    }

    @Override
    @JsonProperty(value="offHeapUsage")
    public final void setOffHeapUsage(SrvMonSysMemoryOffHeapUsage val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        SrvMonSysMemoryOffHeapUsage existing = this.getOffHeapUsage();
        if (existing != null && val != existing) {
            existing.dispose();
        }
        if (val != null) {
            this._fldOffHeapUsage.setValue(val);
        } else {
            this._fldOffHeapUsage.clearValue();
        }
        this._isDirty = true;
    }

    @Override
    public final void lendOffHeapUsage(SrvMonSysMemoryOffHeapUsage val) {
        if (val != null) {
            val.acquire();
        }
        this.setOffHeapUsage(val);
    }

    @Override
    @JsonProperty(value="offHeapUsage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final SrvMonSysMemoryOffHeapUsage getOffHeapUsage() {
        return (SrvMonSysMemoryOffHeapUsage)this._fldOffHeapUsage.getValue();
    }

    @Override
    @JsonIgnore
    public final void getOffHeapUsageTo(SrvMonSysMemoryOffHeapUsage to) {
        if (this.hasOffHeapUsage()) {
            this.getOffHeapUsage().copyInto(to);
        } else {
            to.clearContent();
        }
    }

    @Override
    public final SrvMonSysMemoryOffHeapUsage takeOffHeapUsage() {
        SrvMonSysMemoryOffHeapUsage val = this.getOffHeapUsage();
        if (val != null) {
            val.acquire();
        }
        return val;
    }

    @Override
    public final boolean hasOffHeapUsage() {
        return this._fldOffHeapUsage.hasValue();
    }

    @Override
    public final void clearOffHeapUsage() {
        SrvMonSysMemoryOffHeapUsage existing = this.getOffHeapUsage();
        if (existing != null) {
            existing.dispose();
        }
        this._fldOffHeapUsage.clearValue();
        this._isDirty = true;
    }

    public static final int getNativeCountersFieldId() {
        return 24;
    }

    @Override
    @JsonProperty(value="nativeCounters")
    public final void setNativeCounters(SrvMonSysMemoryNativeCounters val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        SrvMonSysMemoryNativeCounters existing = this.getNativeCounters();
        if (existing != null && val != existing) {
            existing.dispose();
        }
        if (val != null) {
            this._fldNativeCounters.setValue(val);
        } else {
            this._fldNativeCounters.clearValue();
        }
        this._isDirty = true;
    }

    @Override
    public final void lendNativeCounters(SrvMonSysMemoryNativeCounters val) {
        if (val != null) {
            val.acquire();
        }
        this.setNativeCounters(val);
    }

    @Override
    @JsonProperty(value="nativeCounters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final SrvMonSysMemoryNativeCounters getNativeCounters() {
        return (SrvMonSysMemoryNativeCounters)this._fldNativeCounters.getValue();
    }

    @Override
    @JsonIgnore
    public final void getNativeCountersTo(SrvMonSysMemoryNativeCounters to) {
        if (this.hasNativeCounters()) {
            this.getNativeCounters().copyInto(to);
        } else {
            to.clearContent();
        }
    }

    @Override
    public final SrvMonSysMemoryNativeCounters takeNativeCounters() {
        SrvMonSysMemoryNativeCounters val = this.getNativeCounters();
        if (val != null) {
            val.acquire();
        }
        return val;
    }

    @Override
    public final boolean hasNativeCounters() {
        return this._fldNativeCounters.hasValue();
    }

    @Override
    public final void clearNativeCounters() {
        SrvMonSysMemoryNativeCounters existing = this.getNativeCounters();
        if (existing != null) {
            existing.dispose();
        }
        this._fldNativeCounters.clearValue();
        this._isDirty = true;
    }

    public static final int getIobufCountersFieldId() {
        return 25;
    }

    @Override
    @JsonProperty(value="iobufCounters")
    public final void setIobufCounters(SrvMonSysMemoryIOBufCounters val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        SrvMonSysMemoryIOBufCounters existing = this.getIobufCounters();
        if (existing != null && val != existing) {
            existing.dispose();
        }
        if (val != null) {
            this._fldIobufCounters.setValue(val);
        } else {
            this._fldIobufCounters.clearValue();
        }
        this._isDirty = true;
    }

    @Override
    public final void lendIobufCounters(SrvMonSysMemoryIOBufCounters val) {
        if (val != null) {
            val.acquire();
        }
        this.setIobufCounters(val);
    }

    @Override
    @JsonProperty(value="iobufCounters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final SrvMonSysMemoryIOBufCounters getIobufCounters() {
        return (SrvMonSysMemoryIOBufCounters)this._fldIobufCounters.getValue();
    }

    @Override
    @JsonIgnore
    public final void getIobufCountersTo(SrvMonSysMemoryIOBufCounters to) {
        if (this.hasIobufCounters()) {
            this.getIobufCounters().copyInto(to);
        } else {
            to.clearContent();
        }
    }

    @Override
    public final SrvMonSysMemoryIOBufCounters takeIobufCounters() {
        SrvMonSysMemoryIOBufCounters val = this.getIobufCounters();
        if (val != null) {
            val.acquire();
        }
        return val;
    }

    @Override
    public final boolean hasIobufCounters() {
        return this._fldIobufCounters.hasValue();
    }

    @Override
    public final void clearIobufCounters() {
        SrvMonSysMemoryIOBufCounters existing = this.getIobufCounters();
        if (existing != null) {
            existing.dispose();
        }
        this._fldIobufCounters.clearValue();
        this._isDirty = true;
    }

    public final boolean isDirty() {
        return this._isDirty;
    }

    public static final XbufSchema createSchema() {
        XbufField[] fields = new XbufField[]{XbufVariableShortField.create((short)1, (String)"XRogType"), XbufVariableLongField.create((short)18, (String)"CommittedVirtualMemorySize"), XbufVariableLongField.create((short)19, (String)"FreePhysicalMemorySize"), XbufVariableLongField.create((short)20, (String)"FreeSwapSpaceSize"), XbufVariableLongField.create((short)21, (String)"TotalPhysicalMemorySize"), XbufVariableLongField.create((short)22, (String)"TotalSwapSpaceSize"), SrvMonSysMemoryUsage.Field.create((short)16, "HeapUsage"), SrvMonSysMemoryUsage.Field.create((short)17, "NonHeapUsage"), SrvMonSysMemoryOffHeapUsage.Field.create((short)23, "OffHeapUsage"), SrvMonSysMemoryNativeCounters.Field.create((short)24, "NativeCounters"), SrvMonSysMemoryIOBufCounters.Field.create((short)25, "IobufCounters")};
        return XbufSchema.create((XbufField[])fields, fieldMapByName, (OpenIntObjectHashMap)fieldMapById);
    }

    private final int serializeToPacketBuffer(PktBuffer buffer, int offset) {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        int length = containerBuffer.getLength();
        buffer.putFrom(offset, (IOElasticBuffer)containerBuffer, 0, length);
        return length;
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        byte[] array = new byte[containerBuffer.getLength()];
        containerBuffer.getTo(0, array, 0, array.length);
        return array;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        ByteBuffer buffer = ByteBuffer.allocate(containerBuffer.getLength());
        containerBuffer.getTo(0, buffer, buffer.capacity());
        return buffer;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        IOBuffer ioBuffer = IOBuffer.create((int)containerBuffer.getLength(), (boolean)useNative);
        containerBuffer.getTo(0, ioBuffer.getBufferUnsafe(), containerBuffer.getLength());
        return ioBuffer;
    }

    public final boolean isBufferBacked() {
        return true;
    }

    @JsonIgnore
    public final int getSerializeToNativeLength() {
        this.sync();
        return this._container.getBackingBuffer().getLength();
    }

    public final int serializeToNative(long address, int addressOffset) {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        int length = containerBuffer.getLength();
        containerBuffer.getToNative(0, address, addressOffset, length);
        return length;
    }

    private final SrvMonSysMemoryStats deserializeFromPacketBuffer(PktBuffer buffer, int offset, int length, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, (IOElasticBuffer)buffer, offset, length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    private final SrvMonSysMemoryStats deserializeFromPacketBuffer(PktBuffer buffer, int offset, int length) {
        return this.deserializeFromPacketBuffer(buffer, offset, length, XbufDesyncPolicy.Copy);
    }

    public final SrvMonSysMemoryStats deserializeFromIOElasticBuffer(IOElasticBuffer buffer, int offset, int length, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, buffer, offset, length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final SrvMonSysMemoryStats deserializeFromIOElasticBuffer(IOElasticBuffer buffer, int offset, int length) {
        return this.deserializeFromIOElasticBuffer(buffer, offset, length, XbufDesyncPolicy.Copy);
    }

    public final SrvMonSysMemoryStats deserializeFromByteArray(byte[] array, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, array, 0, array.length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final SrvMonSysMemoryStats deserializeFromByteArray(byte[] array) {
        return this.deserializeFromByteArray(array, XbufDesyncPolicy.Copy);
    }

    public final SrvMonSysMemoryStats deserializeFromByteBuffer(ByteBuffer buffer, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, buffer, buffer.remaining());
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final SrvMonSysMemoryStats deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFromByteBuffer(buffer, XbufDesyncPolicy.Copy);
    }

    public final SrvMonSysMemoryStats deserializeFromNative(long address, int offset, int length, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFromNative(0, address, offset, length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final SrvMonSysMemoryStats deserializeFromNative(long address, int offset, int length) {
        return this.deserializeFromNative(address, offset, length, XbufDesyncPolicy.Copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sync() {
        if ((_optimizationHints & 1) == 1) {
            this._container.sync();
            return;
        }
        if (!this._isDirty) {
            return;
        }
        PktBuffer buffer = this._container.getBackingBuffer();
        int pos = this._container.syncPrepare();
        try {
            if (this._lateSyncBoundary == Integer.MAX_VALUE) {
                return;
            }
            boolean[] hasValues = this._container.getHasValues();
            if (0 >= this._lateSyncBoundary && hasValues[this._fldXRogType.index]) {
                pos += this._fldXRogType.sync(buffer, pos);
            }
            if (1 >= this._lateSyncBoundary && hasValues[this._fldCommittedVirtualMemorySize.index]) {
                pos += this._fldCommittedVirtualMemorySize.sync(buffer, pos);
            }
            if (2 >= this._lateSyncBoundary && hasValues[this._fldFreePhysicalMemorySize.index]) {
                pos += this._fldFreePhysicalMemorySize.sync(buffer, pos);
            }
            if (3 >= this._lateSyncBoundary && hasValues[this._fldFreeSwapSpaceSize.index]) {
                pos += this._fldFreeSwapSpaceSize.sync(buffer, pos);
            }
            if (4 >= this._lateSyncBoundary && hasValues[this._fldTotalPhysicalMemorySize.index]) {
                pos += this._fldTotalPhysicalMemorySize.sync(buffer, pos);
            }
            if (5 >= this._lateSyncBoundary && hasValues[this._fldTotalSwapSpaceSize.index]) {
                pos += this._fldTotalSwapSpaceSize.sync(buffer, pos);
            }
            if (6 >= this._lateSyncBoundary && hasValues[this._fldHeapUsage.index]) {
                pos += this._fldHeapUsage.sync(buffer, pos);
            }
            if (7 >= this._lateSyncBoundary && hasValues[this._fldNonHeapUsage.index]) {
                pos += this._fldNonHeapUsage.sync(buffer, pos);
            }
            if (8 >= this._lateSyncBoundary && hasValues[this._fldOffHeapUsage.index]) {
                pos += this._fldOffHeapUsage.sync(buffer, pos);
            }
            if (9 >= this._lateSyncBoundary && hasValues[this._fldNativeCounters.index]) {
                pos += this._fldNativeCounters.sync(buffer, pos);
            }
            if (10 >= this._lateSyncBoundary && hasValues[this._fldIobufCounters.index]) {
                pos += this._fldIobufCounters.sync(buffer, pos);
            }
        }
        finally {
            this._container.syncDone();
            this._isDirty = false;
        }
    }

    public final int desync(PktBuffer buffer, int pos, boolean frameOnly) {
        if ((_optimizationHints & 1) == 1) {
            return 0;
        }
        if ((_optimizationHints & 2) == 2) {
            return 0;
        }
        int len = 0;
        int limit = buffer.getLength();
        if (pos + len >= limit) {
            return len;
        }
        short id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        if (id == 1) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 1L) != 0L ? this._fldXRogType.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 18) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 2L) != 0L ? this._fldCommittedVirtualMemorySize.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 19) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 4L) != 0L ? this._fldFreePhysicalMemorySize.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 20) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 8L) != 0L ? this._fldFreeSwapSpaceSize.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 21) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 0x10L) != 0L ? this._fldTotalPhysicalMemorySize.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 22) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 0x20L) != 0L ? this._fldTotalSwapSpaceSize.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 16) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 0x40L) != 0L ? this._fldHeapUsage.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 17) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 0x80L) != 0L ? this._fldNonHeapUsage.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 23) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 0x100L) != 0L ? this._fldOffHeapUsage.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 24) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 0x200L) != 0L ? this._fldNativeCounters.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 25) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 0x400L) != 0L ? this._fldIobufCounters.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        return len;
    }

    public final SrvMonSysMemoryStats init() {
        this.clearFieldReferences();
        this._container.reset();
        Arrays.fill(this._fieldBitmask, 0L);
        this.readOnly = false;
        this._isDirty = false;
        return this;
    }

    public final SrvMonSysMemoryStats setPool(UtlPool<SrvMonSysMemoryStats> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<SrvMonSysMemoryStats> getPool() {
        return this._pool;
    }

    public final boolean isReferenceCounted() {
        return true;
    }

    public final SrvMonSysMemoryStats acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this._refTracker != null) {
            this._refTracker.onAcquire(val);
        }
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnerCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this._refTracker != null) {
            this._refTracker.onDispose(val);
        }
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this._pool.put((UtlPool.Item)this);
        }
    }

    private final SrvMonSysMemoryStats undispose() {
        int val = this._ownershipCount.getAndSet(1);
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this._refTracker != null) {
            this._refTracker.onInit(1);
        }
        if (val != 0 && this._pool != null) {
            throw new IllegalStateException("attempt to undispose an entity that's not disposed");
        }
        return this;
    }

    public final Object clone() {
        SrvMonSysMemoryUsage cloner_heapUsage;
        SrvMonSysMemoryStats clonee = SrvMonSysMemoryStats.create();
        if (this.hasXRogType()) {
            clonee.setXRogType(this.getXRogType());
        }
        if (this.hasCommittedVirtualMemorySize()) {
            clonee.setCommittedVirtualMemorySize(this.getCommittedVirtualMemorySize());
        }
        if (this.hasFreePhysicalMemorySize()) {
            clonee.setFreePhysicalMemorySize(this.getFreePhysicalMemorySize());
        }
        if (this.hasFreeSwapSpaceSize()) {
            clonee.setFreeSwapSpaceSize(this.getFreeSwapSpaceSize());
        }
        if (this.hasTotalPhysicalMemorySize()) {
            clonee.setTotalPhysicalMemorySize(this.getTotalPhysicalMemorySize());
        }
        if (this.hasTotalSwapSpaceSize()) {
            clonee.setTotalSwapSpaceSize(this.getTotalSwapSpaceSize());
        }
        if ((cloner_heapUsage = this.getHeapUsage()) != null) {
            clonee.setHeapUsage((SrvMonSysMemoryUsage)cloner_heapUsage.clone());
        } else {
            clonee.setHeapUsage(null);
        }
        SrvMonSysMemoryUsage cloner_nonHeapUsage = this.getNonHeapUsage();
        if (cloner_nonHeapUsage != null) {
            clonee.setNonHeapUsage((SrvMonSysMemoryUsage)cloner_nonHeapUsage.clone());
        } else {
            clonee.setNonHeapUsage(null);
        }
        SrvMonSysMemoryOffHeapUsage cloner_offHeapUsage = this.getOffHeapUsage();
        if (cloner_offHeapUsage != null) {
            clonee.setOffHeapUsage((SrvMonSysMemoryOffHeapUsage)cloner_offHeapUsage.clone());
        } else {
            clonee.setOffHeapUsage(null);
        }
        SrvMonSysMemoryNativeCounters cloner_nativeCounters = this.getNativeCounters();
        if (cloner_nativeCounters != null) {
            clonee.setNativeCounters((SrvMonSysMemoryNativeCounters)cloner_nativeCounters.clone());
        } else {
            clonee.setNativeCounters(null);
        }
        SrvMonSysMemoryIOBufCounters cloner_iobufCounters = this.getIobufCounters();
        if (cloner_iobufCounters != null) {
            clonee.setIobufCounters((SrvMonSysMemoryIOBufCounters)cloner_iobufCounters.clone());
        } else {
            clonee.setIobufCounters(null);
        }
        return clonee;
    }

    public final SrvMonSysMemoryStats copy() {
        SrvMonSysMemoryStats copy = SrvMonSysMemoryStats.create();
        this.copyInto(copy);
        return copy;
    }

    public final void copyInto(SrvMonSysMemoryStats copy) {
        if (copy.readOnly) {
            throw new IllegalStateException("target is read only");
        }
        this.sync();
        copy.deserializeFromIOElasticBuffer((IOElasticBuffer)this.getBackingBuffer(), 0, this.getBackingBuffer().getLength());
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasXRogType()) {
            builder.append(0 == c++ ? "" : ",").append("XRogType=").append(this.getXRogType());
        }
        if (this.hasCommittedVirtualMemorySize()) {
            builder.append(0 == c++ ? "" : ",").append("CommittedVirtualMemorySize=").append(this.getCommittedVirtualMemorySize());
        }
        if (this.hasFreePhysicalMemorySize()) {
            builder.append(0 == c++ ? "" : ",").append("FreePhysicalMemorySize=").append(this.getFreePhysicalMemorySize());
        }
        if (this.hasFreeSwapSpaceSize()) {
            builder.append(0 == c++ ? "" : ",").append("FreeSwapSpaceSize=").append(this.getFreeSwapSpaceSize());
        }
        if (this.hasTotalPhysicalMemorySize()) {
            builder.append(0 == c++ ? "" : ",").append("TotalPhysicalMemorySize=").append(this.getTotalPhysicalMemorySize());
        }
        if (this.hasTotalSwapSpaceSize()) {
            builder.append(0 == c++ ? "" : ",").append("TotalSwapSpaceSize=").append(this.getTotalSwapSpaceSize());
        }
        if (this.hasHeapUsage()) {
            builder.append(0 == c++ ? "" : ",").append("HeapUsage=").append(this.getHeapUsage());
        }
        if (this.hasNonHeapUsage()) {
            builder.append(0 == c++ ? "" : ",").append("NonHeapUsage=").append(this.getNonHeapUsage());
        }
        if (this.hasOffHeapUsage()) {
            builder.append(0 == c++ ? "" : ",").append("OffHeapUsage=").append(this.getOffHeapUsage());
        }
        if (this.hasNativeCounters()) {
            builder.append(0 == c++ ? "" : ",").append("NativeCounters=").append(this.getNativeCounters());
        }
        if (this.hasIobufCounters()) {
            builder.append(0 == c++ ? "" : ",").append("IobufCounters=").append(this.getIobufCounters());
        }
        builder.append("}");
        return builder.toString();
    }

    static {
        _optimizationHints = XbufHeuristics.getDefaultOptimizationHints(SrvMonSysMemoryStats.class);
        _desyncPolicy = XbufHeuristics.getDefaultDesyncPolicy(SrvMonSysMemoryStats.class);
        _factory = new Factory();
        _entityPool = UtlPool.create((String)"xbuf.entity", (String)"SrvMonSysMemoryStatsXbufEntity.0.212", (UtlPool.Factory)_factory, (UtlPool.Params)XbufHeuristics.configurePoolParams(SrvMonSysMemoryStats.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true)));
        fieldMapById = new OpenIntObjectHashMap(11, 0.0, 0.5);
        fieldMapByName = new HashMap<String, Integer>(11);
        fieldMapById.put(1, (Object)0);
        fieldMapByName.put("XRogType", 0);
        fieldMapById.put(18, (Object)1);
        fieldMapByName.put("CommittedVirtualMemorySize", 1);
        fieldMapById.put(19, (Object)2);
        fieldMapByName.put("FreePhysicalMemorySize", 2);
        fieldMapById.put(20, (Object)3);
        fieldMapByName.put("FreeSwapSpaceSize", 3);
        fieldMapById.put(21, (Object)4);
        fieldMapByName.put("TotalPhysicalMemorySize", 4);
        fieldMapById.put(22, (Object)5);
        fieldMapByName.put("TotalSwapSpaceSize", 5);
        fieldMapById.put(16, (Object)6);
        fieldMapByName.put("HeapUsage", 6);
        fieldMapById.put(17, (Object)7);
        fieldMapByName.put("NonHeapUsage", 7);
        fieldMapById.put(23, (Object)8);
        fieldMapByName.put("OffHeapUsage", 8);
        fieldMapById.put(24, (Object)9);
        fieldMapByName.put("NativeCounters", 9);
        fieldMapById.put(25, (Object)10);
        fieldMapByName.put("IobufCounters", 10);
    }

    public static final class ListField
    extends XbufListField<SrvMonSysMemoryStats> {
        private ListField(short id, String name) {
            super(XbufField.Type.COMPOUND_LIST, id, name, (XbufReferenceTypeField)Field.create(id, name));
        }

        public static ListField create(short id, String name) {
            return new ListField(id, name);
        }

        protected final SrvMonSysMemoryStats[] createTypeArray(int size) {
            return new SrvMonSysMemoryStats[size];
        }
    }

    public static final class Field
    extends XbufVariableLengthField<SrvMonSysMemoryStats> {
        private Field(short id, String name) {
            super(XbufField.Type.COMPOUND, id, name);
        }

        public static Field create(short id, String name) {
            return new Field(id, name);
        }

        protected final int serializedLength(SrvMonSysMemoryStats val) {
            return val != null ? val._container.getSerializedLength() : 0;
        }

        protected final int serialize(PktBuffer buffer, int offset, SrvMonSysMemoryStats val) {
            return val != null ? val.serializeToPacketBuffer(buffer, offset) : 0;
        }

        protected final SrvMonSysMemoryStats deserialize(PktBuffer buffer, int offset, int length) {
            SrvMonSysMemoryStats val = SrvMonSysMemoryStats.create();
            val.deserializeFromPacketBuffer(buffer, offset, length);
            return val;
        }

        protected final String toString(SrvMonSysMemoryStats val) {
            return val.toString();
        }
    }

    private static final class Factory
    implements UtlPool.Factory<SrvMonSysMemoryStats> {
        private Factory() {
        }

        public final SrvMonSysMemoryStats createItem(Object object) {
            return new SrvMonSysMemoryStats(initialBackingBufferSize);
        }

        public final SrvMonSysMemoryStats[] createItemArray(int size) {
            return new SrvMonSysMemoryStats[size];
        }
    }
}

