/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.config;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.server.config.ESrvConfigException;
import com.neeve.server.config.SrvConfigObject;
import com.neeve.util.UtlAddressDescriptor;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class SrvConfigAppDescriptor
extends SrvConfigObject {
    private final String name;
    private final Properties props;
    private String mainClass;
    private boolean autoStart;

    private SrvConfigAppDescriptor(String name) {
        this.name = name;
        this.props = new Properties();
        this.mainClass = null;
        this.autoStart = true;
    }

    public final String getName() {
        return this.name;
    }

    public final SrvConfigAppDescriptor setMainClass(String mainClass) {
        if (mainClass == null) {
            throw new IllegalArgumentException("main class name cannot be null");
        }
        this.mainClass = mainClass;
        return this;
    }

    public final String getMainClass() {
        return this.mainClass;
    }

    public final SrvConfigAppDescriptor setAutoStart(boolean val) {
        this.autoStart = val;
        return this;
    }

    public final boolean getAutoStart() {
        return this.autoStart;
    }

    public final SrvConfigAppDescriptor setProperty(String name, String val) {
        if (val != null) {
            this.props.setProperty(name, val);
        } else {
            this.props.remove(name);
        }
        return this;
    }

    public final String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public final SrvConfigAppDescriptor setProperties(Properties props) {
        this.props.putAll((Map<?, ?>)props);
        return this;
    }

    public final Properties getProperties() {
        return this.props;
    }

    public final void save(IConfigRepository repo, String serverName) throws ESrvConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("app's server name cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            String serverAddr = "/servers/" + serverName;
            String appContainerAddr = serverAddr + "/apps";
            IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer(appContainerAddr);
            if (container == null && repo.getComplexEntity(serverAddr) != null) {
                container = repo.createSimpleEntityContainer(appContainerAddr);
            }
            if (container != null) {
                entity = (IConfigSimpleEntity)container.getEntity(this.name);
                if (entity == null) {
                    entity = (IConfigSimpleEntity)container.createEntity(this.name);
                }
            } else {
                throw new ESrvConfigException("Server '" + serverName + "' does not exist in repository");
            }
            entity.setProperties(null);
            entity.setProperties(this.props);
            entity.setProperty("MainClass", this.getMainClass());
            entity.setProperty("AutoStart", String.valueOf(this.getAutoStart()));
        }
        catch (EConfigException e) {
            throw new ESrvConfigException(e);
        }
    }

    public final void save(String serverName) throws ESrvConfigException {
        this.save(ConfigRepositoryFactory.getInstance().getDefaultRepository(), serverName);
    }

    public final void delete(IConfigRepository repo, String serverName) throws ESrvConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/servers/" + serverName + "/apps");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final String toString() {
        return "(name=" + this.name + ", mainClass=" + this.getMainClass() + ", properties=" + this.getProperties() + ")";
    }

    public static SrvConfigAppDescriptor create(String name) {
        if (name == null) {
            throw new IllegalArgumentException("app name cannot be null");
        }
        return new SrvConfigAppDescriptor(name);
    }

    public static SrvConfigAppDescriptor create(UtlAddressDescriptor descriptor) {
        SrvConfigAppDescriptor appDescriptor = SrvConfigAppDescriptor.create(descriptor.address);
        Object classname = descriptor.props.get("class");
        if (classname == null || !(classname instanceof String)) {
            throw new IllegalArgumentException("app's main class must be specified. include &class=<classname>& in the supplied app descriptor string");
        }
        appDescriptor.setMainClass((String)classname);
        appDescriptor.props.putAll((Map<?, ?>)descriptor.props);
        return appDescriptor;
    }

    public static boolean exists(IConfigRepository repo, String serverName, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("app's server name cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("app name cannot be null");
        }
        return repo.getSimpleEntity("/servers/" + serverName + "/apps/" + name) != null;
    }

    public static boolean exists(String serverName, String name) {
        return SrvConfigAppDescriptor.exists(ConfigRepositoryFactory.getInstance().getDefaultRepository(), serverName, name);
    }

    public static SrvConfigAppDescriptor load(IConfigRepository repo, String serverName, String name) throws ESrvConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("app's server name cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("app name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/servers/" + serverName + "/apps/" + name);
        if (entity != null) {
            SrvConfigAppDescriptor appDescriptor = SrvConfigAppDescriptor.create(name);
            appDescriptor.setProperties(entity.getProperties());
            appDescriptor.getProperties().remove("MainClass");
            appDescriptor.getProperties().remove("AutoStart");
            String mainClass = entity.getProperty("MainClass", null);
            if (mainClass != null) {
                appDescriptor.setMainClass(mainClass);
            }
            boolean autoStart = Boolean.parseBoolean(entity.getProperty("AutoStart", "true"));
            appDescriptor.setAutoStart(autoStart);
            return appDescriptor;
        }
        throw new ESrvConfigException("App '" + name + "@" + serverName + "' not found in repository");
    }

    public static SrvConfigAppDescriptor load(String serverName, String name) throws ESrvConfigException {
        return SrvConfigAppDescriptor.load(ConfigRepositoryFactory.getInstance().getDefaultRepository(), serverName, name);
    }

    public static Set<SrvConfigAppDescriptor> loadAll(IConfigRepository repo, String serverName) throws ESrvConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<SrvConfigAppDescriptor> apps = new LinkedHashSet<SrvConfigAppDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/servers/" + serverName + "/apps");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    apps.add(SrvConfigAppDescriptor.load(repo, serverName, entity.getName()));
                }
                catch (ESrvConfigException e) {
                    throw new ESrvConfigException("Failure in loading descriptor for app '" + entity.getName() + "' for server '" + serverName + "' [" + e.toString() + "]");
                }
            }
        }
        return apps;
    }

    public static Set<SrvConfigAppDescriptor> loadAll(String serverName) throws ESrvConfigException {
        return SrvConfigAppDescriptor.loadAll(ConfigRepositoryFactory.getInstance().getDefaultRepository(), serverName);
    }
}

