/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import java.nio.ByteBuffer;

public final class StoLongField
extends StoField {
    private long val;

    private StoLongField(String name) {
        super(StoField.Type.LONG, name);
    }

    private StoLongField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int bufferOffset) {
        StoLongField.put(buffer, bufferOffset, this.val);
    }

    @Override
    protected final void onBackingBufferAttach() {
        StoLongField.put(this.buffer, this.bodyOffset, this.val);
    }

    @Override
    protected final void onBackingBufferDetach() {
        if (this.val == 0L) {
            this.val = StoLongField.get(this.buffer, this.bodyOffset);
        }
    }

    @Override
    protected final void onBackingBufferChange() {
        this.val = 0L;
    }

    @Override
    protected final int getSerializedLength() {
        return 8;
    }

    @Override
    protected final String getValueString() {
        return String.valueOf(this.getValue());
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        return this.getValue() == ((StoLongField)other).getValue();
    }

    @Override
    protected final void cloneBody(StoField clonee) {
        ((StoLongField)clonee).setValue(this.getValue());
    }

    public static StoLongField create(String name) {
        return new StoLongField(name);
    }

    public static StoLongField create(ByteBuffer buffer, int bufferOffset) {
        return new StoLongField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        return 8;
    }

    public static void put(ByteBuffer buffer, int offset, long val) {
        buffer.putLong(offset, val);
    }

    public static long get(ByteBuffer buffer, int offset) {
        return buffer.getLong(offset);
    }

    @Override
    public final boolean isVariableLength() {
        return false;
    }

    @Override
    public final void reset() {
        this.setValue(0L);
    }

    public final void setValue(long val) {
        this.val = val;
        if (this.buffer != null) {
            StoLongField.put(this.buffer, this.bodyOffset, val);
        }
    }

    public final long getValue() {
        if (this.val == 0L && this.buffer != null) {
            this.val = StoLongField.get(this.buffer, this.bodyOffset);
        }
        return this.val;
    }
}

