/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoVariableLengthField;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StoLongArrayField
extends StoVariableLengthField<long[]> {
    private StoLongArrayField(String name) {
        super(StoField.Type.LONG_ARRAY, name);
    }

    private StoLongArrayField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoLongArrayField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(long[] val) {
        return StoLongArrayField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, long[] val) {
        StoLongArrayField.put(buffer, offset, val);
    }

    @Override
    protected final long[] deserialize(ByteBuffer buffer, int offset) {
        return StoLongArrayField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(long[] val1, long[] val2) {
        return Arrays.equals(val1, val2);
    }

    @Override
    protected final long[] clone(long[] val) {
        return Arrays.copyOf(val, val.length);
    }

    @Override
    protected final String toString(long[] val) {
        return Arrays.toString(val);
    }

    public static StoLongArrayField create(String name) {
        return new StoLongArrayField(name);
    }

    public static StoLongArrayField create(ByteBuffer buffer, int bufferOffset) {
        return new StoLongArrayField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        return 2 + (len < 0 ? (short)0 : len) * 64 / 8;
    }

    public static int getSerializedLength(long[] val) {
        return 2 + (val != null ? val.length * 64 / 8 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ByteBuffer buffer, int offset, long[] val) {
        StoShortField.put(buffer, offset, (short)(val == null ? 0 : (val.length == 0 ? -1 : val.length)));
        if (val != null) {
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).asLongBuffer().put(val);
            }
            finally {
                buffer.position(pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] get(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len > 0) {
            long[] val = new long[len];
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).asLongBuffer().get(val);
                long[] lArray = val;
                return lArray;
            }
            finally {
                buffer.position(pos);
            }
        }
        if (len < 0) {
            return new long[0];
        }
        return null;
    }
}

