/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoVariableLengthField;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StoIntArrayField
extends StoVariableLengthField<int[]> {
    private StoIntArrayField(String name) {
        super(StoField.Type.INTEGER_ARRAY, name);
    }

    private StoIntArrayField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoIntArrayField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(int[] val) {
        return StoIntArrayField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, int[] val) {
        StoIntArrayField.put(buffer, offset, val);
    }

    @Override
    protected final int[] deserialize(ByteBuffer buffer, int offset) {
        return StoIntArrayField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(int[] val1, int[] val2) {
        return Arrays.equals(val1, val2);
    }

    @Override
    protected final int[] clone(int[] val) {
        return Arrays.copyOf(val, val.length);
    }

    @Override
    protected final String toString(int[] val) {
        return Arrays.toString(val);
    }

    public static StoIntArrayField create(String name) {
        return new StoIntArrayField(name);
    }

    public static StoIntArrayField create(ByteBuffer buffer, int bufferOffset) {
        return new StoIntArrayField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        return 2 + (len < 0 ? (short)0 : len) * 32 / 8;
    }

    public static int getSerializedLength(int[] val) {
        return 2 + (val != null ? val.length * 32 / 8 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ByteBuffer buffer, int offset, int[] val) {
        StoShortField.put(buffer, offset, (short)(val == null ? 0 : (val.length == 0 ? -1 : val.length)));
        if (val != null) {
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).asIntBuffer().put(val);
            }
            finally {
                buffer.position(pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] get(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len > 0) {
            int[] val = new int[len];
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).asIntBuffer().get(val);
                int[] nArray = val;
                return nArray;
            }
            finally {
                buffer.position(pos);
            }
        }
        if (len < 0) {
            return new int[0];
        }
        return null;
    }
}

