/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StoBufferField
extends StoField {
    private final int len;
    private ByteBuffer view;
    private ChangeNotifier notifier;

    private StoBufferField(String name, int len) {
        super(StoField.Type.BUFFER, name);
        if (len < 0) {
            throw new IllegalArgumentException("buffer length must be > 0");
        }
        this.len = len;
    }

    private StoBufferField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
        this.len = StoShortField.get(buffer, this.bodyOffset);
    }

    public static StoBufferField create(String name, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("buffer length must be >= 0");
        }
        return new StoBufferField(name, len);
    }

    public static StoBufferField create(ByteBuffer buffer, int bufferOffset) {
        return new StoBufferField(buffer, bufferOffset);
    }

    private final ByteBuffer view() {
        if (this.view == null) {
            this.view = this.buffer == null ? ByteBuffer.wrap(new byte[this.len]) : this.wrapViewOnBackingBuffer();
        }
        return this.view;
    }

    private final ByteBuffer wrapViewOnBackingBuffer() {
        int capacity = this.buffer.capacity();
        int pos = this.buffer.position();
        int limit = this.buffer.limit();
        this.buffer.limit(capacity);
        this.buffer.position(this.bodyOffset + 2);
        this.buffer.limit(this.bodyOffset + 2 + this.len);
        ByteBuffer view = this.buffer.slice();
        this.buffer.limit(capacity);
        this.buffer.position(pos);
        this.buffer.limit(limit);
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyView(ByteBuffer view, ByteBuffer buffer, int offset) {
        int viewPos = view.position();
        int viewLimit = view.limit();
        view.limit(view.capacity());
        view.position(0);
        try {
            int pos = buffer.position();
            ((ByteBuffer)buffer.position(offset)).put(view).position(pos);
        }
        finally {
            view.limit(view.capacity());
            view.position(viewPos);
            view.limit(viewLimit);
        }
    }

    private final void dispatchViewChangeNotification() {
        if (this.notifier != null) {
            this.notifier.onChange(this.view);
        }
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int offset) {
        this.view();
        StoShortField.put(buffer, offset, (short)this.len);
        this.copyView(this.view, buffer, offset + 2);
    }

    @Override
    protected final void onBackingBufferAttach() {
        StoShortField.put(this.buffer, this.bodyOffset, (short)this.len);
        if (this.view != null) {
            ByteBuffer newView = this.wrapViewOnBackingBuffer();
            this.copyView(this.view, newView, 0);
            this.view = newView;
            this.dispatchViewChangeNotification();
        }
    }

    @Override
    protected final void onBackingBufferDetach() {
        ByteBuffer newView = ByteBuffer.wrap(new byte[this.len]);
        this.copyView(this.view(), newView, 0);
        this.view = newView;
        this.dispatchViewChangeNotification();
    }

    @Override
    protected final void onBackingBufferChange() {
        StoShortField.put(this.buffer, this.bodyOffset, (short)this.len);
        if (this.view != null) {
            this.view = this.wrapViewOnBackingBuffer();
            this.dispatchViewChangeNotification();
        }
    }

    @Override
    protected final int getSerializedLength() {
        return 2 + this.len;
    }

    @Override
    protected final String getValueString() {
        return this.view().toString();
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        ByteBuffer thisVal = this.getValue();
        ByteBuffer otherVal = ((StoBufferField)other).getValue();
        return thisVal.equals(otherVal);
    }

    @Override
    protected final void cloneBody(StoField object) {
        throw new UnsupportedOperationException("buffer fields offer transparent views into the backing buffers and so cannot be cloned");
    }

    @Override
    public final boolean isVariableLength() {
        return false;
    }

    @Override
    public final void reset() {
        block6: {
            if (this.view == null) break block6;
            if (this.view.isDirect()) {
                for (int i = 0; i < this.len; ++i) {
                    this.view.put(i, (byte)0);
                }
            } else if (this.buffer == null || this.buffer.capacity() == this.buffer.array().length) {
                Arrays.fill(this.view.array(), 0, this.len, (byte)0);
            } else {
                for (int i = 0; i < this.len; ++i) {
                    this.view.put(i, (byte)0);
                }
            }
        }
    }

    public static int shiftForPreamble(int val) {
        return 2 + val;
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        return 2 + StoShortField.get(buffer, offset);
    }

    public final ByteBuffer getValue() {
        return this.view();
    }

    public final ByteBuffer getValue(ChangeNotifier notifier) {
        this.notifier = notifier;
        return this.view();
    }

    public static interface ChangeNotifier {
        public void onChange(ByteBuffer var1);
    }
}

