/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxObject;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwReadReadyEvent;
import com.neeve.emx.IEmxNwWriteReadyEvent;
import com.neeve.io.IOBuffer;
import java.nio.ByteBuffer;

public final class EmxNwLnk
extends EmxObject {
    private final IEmxNwLnkPeerEndpoint writePep;
    private final IEmxNwWriteReadyEvent writeReadyEvent;
    private final IEmxNwLnkPeerEndpoint readPep;
    private final IEmxNwReadReadyEvent readReadyEvent;
    private IOBuffer readBuffer;

    EmxNwLnk(IEmxNwLnkPeerEndpoint writePep, IEmxNwLnkPeerEndpoint readPep) {
        if (writePep == null) {
            throw new IllegalArgumentException("write link cannot be null");
        }
        if (readPep == null) {
            throw new IllegalArgumentException("read link cannot be null");
        }
        this.writePep = writePep;
        this.writeReadyEvent = writePep.getWriteReadyEvent();
        this.writeReadyEvent.setAttachment((Object)this);
        this.readPep = readPep;
        this.readReadyEvent = readPep.getReadReadyEvent();
        this.readReadyEvent.setAttachment((Object)this);
    }

    public final void setReadBuffer(IOBuffer buffer) {
        if (this.readBuffer != null) {
            this.readBuffer.dispose();
        }
        this.readBuffer = buffer;
    }

    public final IOBuffer getReadBuffer() {
        return this.readBuffer;
    }

    public final void configureBlockingRead(boolean val) throws EEmxException {
        this.readPep.configureBlocking(val);
    }

    public final int read() throws EEmxException {
        return this.readPep.read(this.readBuffer.getBufferUnsafe());
    }

    public final IEmxNwReadReadyEvent getReadReadyEvent() {
        return this.readReadyEvent;
    }

    public final void configureBlockingWrite(boolean val) throws EEmxException {
        this.writePep.configureBlocking(val);
    }

    public final long write(ByteBuffer[] buffers, int count) throws EEmxException {
        return this.writePep.write(buffers, count);
    }

    public final IEmxNwWriteReadyEvent getWriteReadyEvent() {
        return this.writeReadyEvent;
    }

    public final void close() throws EEmxException {
        this.setReadBuffer(null);
        if (this.readPep != null) {
            this.readPep.close();
        }
        if (this.writePep != null) {
            this.writePep.close();
        }
    }
}

