/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.ConstraintDefinitionNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.TableName;

public class FKConstraintDefinitionNode
extends ConstraintDefinitionNode {
    TableName refTableName;
    ResultColumnList refRcl;
    int refActionDeleteRule;
    int refActionUpdateRule;
    boolean grouping;

    @Override
    public void init(Object constraintName, Object refTableName, Object fkRcl, Object refRcl, Object refActions, Object grouping) {
        super.init(constraintName, (Object)ConstraintDefinitionNode.ConstraintType.FOREIGN_KEY, fkRcl, null, null, null);
        this.refRcl = (ResultColumnList)refRcl;
        this.refTableName = (TableName)refTableName;
        this.refActionDeleteRule = ((int[])refActions)[0];
        this.refActionUpdateRule = ((int[])refActions)[1];
        this.grouping = (Boolean)grouping;
    }

    @Override
    public void init(Object constraintName, Object constraintType, Object behavior, Object grouping) {
        super.init(constraintName, constraintType, null, null, null, null, behavior, (Object)ConstraintDefinitionNode.ConstraintType.FOREIGN_KEY);
        this.grouping = (Boolean)grouping;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        FKConstraintDefinitionNode other = (FKConstraintDefinitionNode)node;
        this.refTableName = (TableName)this.getNodeFactory().copyNode(other.refTableName, this.getParserContext());
        this.refRcl = (ResultColumnList)this.getNodeFactory().copyNode(other.refRcl, this.getParserContext());
        this.refActionDeleteRule = other.refActionDeleteRule;
        this.refActionUpdateRule = other.refActionUpdateRule;
    }

    public TableName getRefTableName() {
        return this.refTableName;
    }

    public ResultColumnList getRefResultColumnList() {
        return this.refRcl;
    }

    public boolean isGrouping() {
        return this.grouping;
    }

    @Override
    public String toString() {
        return "refTable name : " + this.refTableName + "\n" + "grouping: " + this.grouping + "\n" + super.toString();
    }
}

