/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.test.unit;

import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.test.unit.json.ChildEntity;
import com.neeve.adm.test.unit.json.ChildEntityL2;
import com.neeve.adm.test.unit.proto.Factory;
import com.neeve.adm.test.unit.xbuf.Parent2;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.rog.test.unit.RogReplicatedStoreTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RogReferenceCountingTests
extends RogReplicatedStoreTestBase {
    protected static final int MEMBER_COUNT = 2;
    private static List<Object> openMemberParameters;
    protected List<Object> currentTestParameters;
    protected FailureType failureType;
    protected boolean compactionEnabled;
    private AdmEncodingType lastInitializedEncoding = null;
    private AdmEncodingType encoding = AdmEncodingType.Xbuf;

    @Parameterized.Parameters(name="{index}_persistent_{0}_failure_{1}_compaction_{2}_cdc_{3}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{false, FailureType.NO_FAILURES, false, false});
        data.add(new Object[]{true, FailureType.NO_FAILURES, false, false});
        data.add(new Object[]{true, FailureType.RESTART_ON_COMMIT, false, false});
        data.add(new Object[]{true, FailureType.COMPACT_NO_FAILURE, true, false});
        data.add(new Object[]{true, FailureType.COMPACT_AND_RESTART, true, false});
        return data;
    }

    public RogReferenceCountingTests(boolean persistent, FailureType failureType, boolean compactionEnabled, boolean cdcEnabled) {
        this.persistent = persistent;
        this.failureType = failureType;
        this.compactionEnabled = compactionEnabled;
        this.cdcEnabled = cdcEnabled;
        this.currentTestParameters = Arrays.asList(new Object[]{persistent, failureType});
    }

    @Before
    public synchronized void setup() throws Exception {
        if (openMembers.isEmpty() || openMemberParameters == null || !openMemberParameters.equals(this.currentTestParameters) || this.lastInitializedEncoding != this.encoding) {
            RogReferenceCountingTests.closeOpenMembers();
        }
        super.setupBase();
        openMemberParameters = this.currentTestParameters;
    }

    @Override
    protected void configureStoreDescriptor(StoreDescriptor descriptor) {
        if (this.compactionEnabled && this.cdcEnabled) {
            descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
            descriptor.setCheckpointThreshold(1);
        } else if (this.compactionEnabled) {
            descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Conflation);
            descriptor.setCheckpointThreshold(5);
        } else if (this.cdcEnabled) {
            descriptor.setCheckpointingType(IStoreCheckpointingController.Type.CDC);
            descriptor.setCheckpointThreshold(1);
        }
    }

    @Override
    protected void configurePersisterDescriptor(StorePersisterDescriptor persisterDescriptor) {
        if (this.compactionEnabled) {
            persisterDescriptor.setProperty("compaction.compactionThreshold", "1");
            persisterDescriptor.setProperty("logScavengePolicy", "Delete");
        }
        persisterDescriptor.setProperty("initialLogLength", "0");
        persisterDescriptor.setProperty("cdcEnabled", String.valueOf(this.cdcEnabled));
    }

    @Override
    protected synchronized void induceCommitFailure() throws Exception {
        switch (this.failureType) {
            case NO_FAILURES: {
                break;
            }
            case RESTART_ON_COMMIT: {
                System.out.println("Restarting Members on Commit");
                RogReferenceCountingTests.closeOpenMembers();
                this.checkInitialized();
                break;
            }
            case COMPACT_NO_FAILURE: {
                System.out.println("Compacting Logs and Restarting Members on Commit");
                this.primaryMember().getCompactor().compact();
                this.primaryMember().getCompactor().waitForCompactionToComplete();
                break;
            }
            case COMPACT_AND_RESTART: {
                System.out.println("Compacting Logs and Restarting Members on Commit");
                this.primaryMember().getCompactor().compact();
                this.primaryMember().getCompactor().waitForCompactionToComplete();
                RogReferenceCountingTests.closeOpenMembers();
                this.checkInitialized();
                break;
            }
        }
    }

    @Override
    protected Collection<IStoreObjectFactory> getObjectFactories() {
        this.lastInitializedEncoding = this.encoding;
        switch (this.encoding) {
            case Protobuf: {
                return Arrays.asList(new Factory());
            }
            case Xbuf: {
                return Arrays.asList(new com.neeve.adm.test.unit.xbuf.Factory());
            }
            case Json: {
                return Arrays.asList(new com.neeve.adm.test.unit.json.Factory());
            }
        }
        throw new IllegalStateException("No encoding type specified");
    }

    @Test
    public void testOwnershipCountsProtobuf() throws Exception {
        this.encoding = AdmEncodingType.Protobuf;
        Assert.assertEquals((String)"Expected to be optimized for latency", (Object)true, (Object)XRuntime.optimizeForLatency());
        com.neeve.adm.test.unit.proto.Parent2 parent = this.primaryMember().addRootObject(com.neeve.adm.test.unit.proto.Parent2.create(this.nextGraphId()));
        this.primaryMember().commit(true);
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        long timeout = System.currentTimeMillis() + 5000L;
        while (parent.getOwnershipCount() > 1 && System.currentTimeMillis() < timeout) {
            Thread.sleep(10L);
        }
        com.neeve.adm.test.unit.proto.Parent2 backupParent = (com.neeve.adm.test.unit.proto.Parent2)this.backupMember().getRootObject(parent.getGraphId());
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after create", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after create", (long)1L, (long)backupParent.getOwnershipCount());
        com.neeve.adm.test.unit.proto.ChildEntity child = com.neeve.adm.test.unit.proto.ChildEntity.create();
        parent.setEntityField(child);
        this.primaryMember().commitAndFail(true);
        parent = (com.neeve.adm.test.unit.proto.Parent2)this.primaryMember().getRootObject(parent.getGraphId());
        child = parent.getEntityField();
        backupParent = (com.neeve.adm.test.unit.proto.Parent2)this.backupMember().getRootObject(parent.getGraphId());
        com.neeve.adm.test.unit.proto.ChildEntity backupChild = backupParent.getEntityField();
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after child add", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after child add", (long)1L, (long)backupParent.getOwnershipCount());
        Assert.assertEquals((String)"Primary child has unexpected ownership count after child add", (long)2L, (long)child.getOwnershipCount());
        Assert.assertEquals((String)"Backup child has unexpected ownership count after child add", (long)2L, (long)child.getOwnershipCount());
        com.neeve.adm.test.unit.proto.ChildEntityL2 grandChild = com.neeve.adm.test.unit.proto.ChildEntityL2.create();
        child.setChildEntityField(grandChild);
        this.primaryMember().commitAndFail(true);
        parent = (com.neeve.adm.test.unit.proto.Parent2)this.primaryMember().getRootObject(parent.getGraphId());
        child = parent.getEntityField();
        grandChild = child.getChildEntityField();
        backupParent = (com.neeve.adm.test.unit.proto.Parent2)this.backupMember().getRootObject(parent.getGraphId());
        backupChild = backupParent.getEntityField();
        com.neeve.adm.test.unit.proto.ChildEntityL2 backupGrandChild = backupChild.getChildEntityField();
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after grandchild add", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after grandchild add", (long)1L, (long)backupParent.getOwnershipCount());
        Assert.assertEquals((String)"Primary child has unexpected ownership count after grandchild add", (long)2L, (long)child.getOwnershipCount());
        Assert.assertEquals((String)"Backup child has unexpected ownership count after grandchild add", (long)2L, (long)backupChild.getOwnershipCount());
        Assert.assertEquals((String)"Backup grand child has unexpected ownership count after grandchild add", (long)2L, (long)backupGrandChild.getOwnershipCount());
        Assert.assertEquals((String)"Primary grand child has unexpected ownership count after grandchild add", (long)2L, (long)grandChild.getOwnershipCount());
        parent.clearEntityField();
        this.primaryMember().commitAndFail(true);
        parent = (com.neeve.adm.test.unit.proto.Parent2)this.primaryMember().getRootObject(parent.getGraphId());
        backupParent = (com.neeve.adm.test.unit.proto.Parent2)this.backupMember().getRootObject(parent.getGraphId());
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after grandchild add", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after grandchild add", (long)1L, (long)backupParent.getOwnershipCount());
        Assert.assertEquals((String)"Primary child has unexpected ownership count after grandchild add", (long)0L, (long)child.getOwnershipCount());
        Assert.assertEquals((String)"Backup child has unexpected ownership count after grandchild add", (long)0L, (long)backupChild.getOwnershipCount());
        Assert.assertEquals((String)"Primary grand child has unexpected ownership count after grandchild add", (long)0L, (long)grandChild.getOwnershipCount());
        Assert.assertEquals((String)"Backup grand child has unexpected ownership count after grandchild add", (long)0L, (long)backupGrandChild.getOwnershipCount());
        Assert.assertNull((String)"Primary child should be null", (Object)parent.getEntityField());
        Assert.assertNull((String)"Backup child should be null", (Object)backupParent.getEntityField());
    }

    @Test
    public void testOwnershipCountsXbuf() throws Exception {
        this.encoding = AdmEncodingType.Xbuf;
        Assert.assertEquals((String)"Expected to be optimized for latency", (Object)true, (Object)XRuntime.optimizeForLatency());
        Parent2 parent = this.primaryMember().addRootObject(Parent2.create(this.nextGraphId()));
        this.primaryMember().commit(true);
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        long timeout = System.currentTimeMillis() + 5000L;
        while (parent.getOwnershipCount() > 1 && System.currentTimeMillis() < timeout) {
            Thread.sleep(10L);
        }
        Parent2 backupParent = (Parent2)this.backupMember().getRootObject(parent.getGraphId());
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after create", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after create", (long)1L, (long)backupParent.getOwnershipCount());
        com.neeve.adm.test.unit.xbuf.ChildEntity child = com.neeve.adm.test.unit.xbuf.ChildEntity.create();
        parent.setEntityField(child);
        this.primaryMember().commitAndFail(true);
        parent = (Parent2)this.primaryMember().getRootObject(parent.getGraphId());
        child = parent.getEntityField();
        backupParent = (Parent2)this.backupMember().getRootObject(parent.getGraphId());
        com.neeve.adm.test.unit.xbuf.ChildEntity backupChild = backupParent.getEntityField();
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after child add", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after child add", (long)1L, (long)backupParent.getOwnershipCount());
        Assert.assertEquals((String)"Primary child has unexpected ownership count after child add", (long)2L, (long)child.getOwnershipCount());
        Assert.assertEquals((String)"Backup child has unexpected ownership count after child add", (long)2L, (long)child.getOwnershipCount());
        com.neeve.adm.test.unit.xbuf.ChildEntityL2 grandChild = com.neeve.adm.test.unit.xbuf.ChildEntityL2.create();
        child.setChildEntityField(grandChild);
        this.primaryMember().commitAndFail(true);
        parent = (Parent2)this.primaryMember().getRootObject(parent.getGraphId());
        child = parent.getEntityField();
        grandChild = child.getChildEntityField();
        backupParent = (Parent2)this.backupMember().getRootObject(parent.getGraphId());
        backupChild = backupParent.getEntityField();
        com.neeve.adm.test.unit.xbuf.ChildEntityL2 backupGrandChild = backupChild.getChildEntityField();
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after grandchild add", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after grandchild add", (long)1L, (long)backupParent.getOwnershipCount());
        Assert.assertEquals((String)"Primary child has unexpected ownership count after grandchild add", (long)2L, (long)child.getOwnershipCount());
        Assert.assertEquals((String)"Backup child has unexpected ownership count after grandchild add", (long)2L, (long)backupChild.getOwnershipCount());
        Assert.assertEquals((String)"Backup grand child has unexpected ownership count after grandchild add", (long)2L, (long)backupGrandChild.getOwnershipCount());
        Assert.assertEquals((String)"Primary grand child has unexpected ownership count after grandchild add", (long)2L, (long)grandChild.getOwnershipCount());
        parent.clearEntityField();
        this.primaryMember().commitAndFail(true);
        parent = (Parent2)this.primaryMember().getRootObject(parent.getGraphId());
        backupParent = (Parent2)this.backupMember().getRootObject(parent.getGraphId());
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after grandchild add", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after grandchild add", (long)1L, (long)backupParent.getOwnershipCount());
        Assert.assertEquals((String)"Primary child has unexpected ownership count after grandchild add", (long)0L, (long)child.getOwnershipCount());
        Assert.assertEquals((String)"Backup child has unexpected ownership count after grandchild add", (long)0L, (long)backupChild.getOwnershipCount());
        Assert.assertEquals((String)"Primary grand child has unexpected ownership count after grandchild add", (long)0L, (long)grandChild.getOwnershipCount());
        Assert.assertEquals((String)"Backup grand child has unexpected ownership count after grandchild add", (long)0L, (long)backupGrandChild.getOwnershipCount());
        Assert.assertNull((String)"Primary child should be null", (Object)parent.getEntityField());
        Assert.assertNull((String)"Backup child should be null", (Object)backupParent.getEntityField());
    }

    @Test
    public void testOwnershipCountsJson() throws Exception {
        this.encoding = AdmEncodingType.Json;
        Assert.assertEquals((String)"Expected to be optimized for latency", (Object)true, (Object)XRuntime.optimizeForLatency());
        com.neeve.adm.test.unit.json.Parent2 parent = this.primaryMember().addRootObject(com.neeve.adm.test.unit.json.Parent2.create(this.nextGraphId()));
        this.primaryMember().commit(true);
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        long timeout = System.currentTimeMillis() + 5000L;
        while (parent.getOwnershipCount() > 1 && System.currentTimeMillis() < timeout) {
            Thread.sleep(10L);
        }
        com.neeve.adm.test.unit.json.Parent2 backupParent = (com.neeve.adm.test.unit.json.Parent2)this.backupMember().getRootObject(parent.getGraphId());
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after create", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after create", (long)1L, (long)backupParent.getOwnershipCount());
        ChildEntity child = ChildEntity.create();
        parent.setEntityField(child);
        this.primaryMember().commitAndFail(true);
        parent = (com.neeve.adm.test.unit.json.Parent2)this.primaryMember().getRootObject(parent.getGraphId());
        child = parent.getEntityField();
        backupParent = (com.neeve.adm.test.unit.json.Parent2)this.backupMember().getRootObject(parent.getGraphId());
        ChildEntity backupChild = backupParent.getEntityField();
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after child add", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after child add", (long)1L, (long)backupParent.getOwnershipCount());
        Assert.assertEquals((String)"Primary child has unexpected ownership count after child add", (long)2L, (long)child.getOwnershipCount());
        Assert.assertEquals((String)"Backup child has unexpected ownership count after child add", (long)2L, (long)child.getOwnershipCount());
        ChildEntityL2 grandChild = ChildEntityL2.create();
        child.setChildEntityField(grandChild);
        this.primaryMember().commitAndFail(true);
        parent = (com.neeve.adm.test.unit.json.Parent2)this.primaryMember().getRootObject(parent.getGraphId());
        child = parent.getEntityField();
        grandChild = child.getChildEntityField();
        backupParent = (com.neeve.adm.test.unit.json.Parent2)this.backupMember().getRootObject(parent.getGraphId());
        backupChild = backupParent.getEntityField();
        ChildEntityL2 backupGrandChild = backupChild.getChildEntityField();
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after grandchild add", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after grandchild add", (long)1L, (long)backupParent.getOwnershipCount());
        Assert.assertEquals((String)"Primary child has unexpected ownership count after grandchild add", (long)2L, (long)child.getOwnershipCount());
        Assert.assertEquals((String)"Backup child has unexpected ownership count after grandchild add", (long)2L, (long)backupChild.getOwnershipCount());
        Assert.assertEquals((String)"Backup grand child has unexpected ownership count after grandchild add", (long)2L, (long)backupGrandChild.getOwnershipCount());
        Assert.assertEquals((String)"Primary grand child has unexpected ownership count after grandchild add", (long)2L, (long)grandChild.getOwnershipCount());
        parent.clearEntityField();
        this.primaryMember().commitAndFail(true);
        parent = (com.neeve.adm.test.unit.json.Parent2)this.primaryMember().getRootObject(parent.getGraphId());
        backupParent = (com.neeve.adm.test.unit.json.Parent2)this.backupMember().getRootObject(parent.getGraphId());
        this.primaryMember().flushPersister();
        this.backupMember().flushPersister();
        Assert.assertEquals((String)"Primary Parent has unexpected ownership count after grandchild add", (long)1L, (long)parent.getOwnershipCount());
        Assert.assertEquals((String)"Backup Parent has unexpected ownership count after grandchild add", (long)1L, (long)backupParent.getOwnershipCount());
        Assert.assertEquals((String)"Primary child has unexpected ownership count after grandchild add", (long)0L, (long)child.getOwnershipCount());
        Assert.assertEquals((String)"Backup child has unexpected ownership count after grandchild add", (long)0L, (long)backupChild.getOwnershipCount());
        Assert.assertEquals((String)"Primary grand child has unexpected ownership count after grandchild add", (long)0L, (long)grandChild.getOwnershipCount());
        Assert.assertEquals((String)"Backup grand child has unexpected ownership count after grandchild add", (long)0L, (long)backupGrandChild.getOwnershipCount());
        Assert.assertNull((String)"Primary child should be null", (Object)parent.getEntityField());
        Assert.assertNull((String)"Backup child should be null", (Object)backupParent.getEntityField());
    }

    static {
        System.setProperty("nv.optimizefor", "latency");
        System.setProperty("nv.conservecpu", "true");
        System.setProperty("nv.reftracking.enabled", "true");
    }

    public static enum FailureType {
        NO_FAILURES,
        RESTART_ON_COMMIT,
        COMPACT_NO_FAILURE,
        COMPACT_AND_RESTART;

    }
}

