/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.util.test.unit;

import com.neeve.query.impl.mock.domain.Address;
import com.neeve.query.impl.mock.domain.Customer;
import com.neeve.query.impl.mock.domain.SalesOrder;
import com.neeve.query.impl.mock.domain.UsAddress;
import com.neeve.query.impl.util.UtlQueryReflection;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class UtlQueryReflectionTest {
    @Test
    public void testGetter() {
        Class<Customer> c = Customer.class;
        Method getter = UtlQueryReflection.getGetter(c, (String)"address");
        Class<?> a = getter.getReturnType();
        getter = UtlQueryReflection.getGetter(a, (String)"zipcode");
        Assert.assertEquals((String)"zipcode is String", String.class, getter.getReturnType());
    }

    @Test
    public void testReturnType() {
        Class<Customer> custType = Customer.class;
        Class<?> returnType = UtlQueryReflection.getReturnType(custType, "address.zipcode");
        Assert.assertEquals((String)"zipcode is String", String.class, returnType);
        returnType = UtlQueryReflection.getReturnType(custType, "address.zipcode2");
        Assert.assertNull((String)"address.zipcode2 does not exist", returnType);
        returnType = UtlQueryReflection.getReturnType(custType, "address2.zipcode");
        Assert.assertNull((String)"address2.zipcode does not exist", returnType);
    }

    @Test
    public void testProperty() {
        Customer cust = new Customer(100L, "Bob");
        cust.setAddress(new Address("12345"));
        SalesOrder order = new SalesOrder(1L, cust, "an apple");
        Assert.assertEquals(Customer.class, (Object)UtlQueryReflection.getProperty((Object)cust, (String)"class"));
        Assert.assertEquals((Object)"12345", (Object)UtlQueryReflection.getProperty((Object)cust, (String)"address.zipcode"));
        Assert.assertEquals(Address.class, (Object)UtlQueryReflection.getProperty((Object)cust, (String)"address.class"));
        Assert.assertEquals((Object)"Bob", (Object)UtlQueryReflection.getProperty((Object)order, (String)"customer.name"));
        Assert.assertEquals((Object)"12345", (Object)UtlQueryReflection.getProperty((Object)order, (String)"customer.address.zipcode"));
        Assert.assertEquals(String.class, (Object)UtlQueryReflection.getProperty((Object)order, (String)"customer.address.zipcode.class"));
        order.setCustomer(null);
        Assert.assertEquals(null, (Object[])((Object[])UtlQueryReflection.getProperty((Object)order, (String)"customer.name")));
        Assert.assertEquals(null, (Object[])((Object[])UtlQueryReflection.getProperty((Object)order, (String)"customer.address.zipcode.class")));
        Assert.assertEquals(null, (Object[])((Object[])UtlQueryReflection.getProperty(null, (String)"customer.name")));
        Assert.assertEquals(null, (Object[])((Object[])UtlQueryReflection.getProperty(null, (String)"customer.address.zipcode.class")));
    }

    @Test
    public void testHasPath() {
        Assert.assertTrue((String)"Object has class", (boolean)UtlQueryReflection.hasPath(Object.class, (String)"class"));
        Assert.assertTrue((String)"Object instance has class", (boolean)UtlQueryReflection.hasPath((Object)new Object(), (String)"class"));
        Assert.assertTrue((String)"Address has zipcode", (boolean)UtlQueryReflection.hasPath(Address.class, (String)"zipcode"));
        Assert.assertTrue((String)"Address has zipcode", (boolean)UtlQueryReflection.hasPath((Object)new Address("12345"), (String)"zipcode"));
        Assert.assertFalse((String)"Address does not have state", (boolean)UtlQueryReflection.hasPath((Object)new Address("12345"), (String)"state"));
        Assert.assertTrue((String)"US address has state", (boolean)UtlQueryReflection.hasPath((Object)new UsAddress("12345"), (String)"state"));
        Assert.assertTrue((String)"Customer has address.zipcode", (boolean)UtlQueryReflection.hasPath(Customer.class, (String)"address.zipcode"));
        Assert.assertTrue((String)"Nested unpopulated address has zipcode", (boolean)UtlQueryReflection.hasPath((Object)new Customer(1L, "Bob"), (String)"address.zipcode"));
        Assert.assertFalse((String)"Nested unpopulated address does not have state", (boolean)UtlQueryReflection.hasPath((Object)new Customer(1L, "Bob"), (String)"address.state"));
        Customer customer = new Customer(1L, "Bob");
        customer.setAddress(new UsAddress("22222"));
        Assert.assertTrue((String)"Nested US address has state", (boolean)UtlQueryReflection.hasPath((Object)customer, (String)"address.state"));
    }
}

