/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.google.common.collect.Lists;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryAggregateField;
import com.neeve.query.impl.QueryDefaultFieldResolver;
import com.neeve.query.impl.QueryResultImpl;
import com.neeve.query.impl.QueryResultSetImpl;
import com.neeve.query.impl.index.IdxIndexerImpl;
import com.neeve.query.impl.mock.domain.Customer;
import com.neeve.query.index.IdxField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;

public class ResultSetImplTest {
    private static IdxIndexerImpl.IdMapper<Long, Customer> customerIdMapper = new IdxIndexerImpl.IdMapper<Long, Customer>(){

        @Override
        public Long getRecordId(Customer record) {
            return record.getId();
        }

        @Override
        public long getCommitSequence(Customer record) {
            return 0L;
        }
    };
    private static final QueryDefaultFieldResolver<Customer> resolver = new QueryDefaultFieldResolver<Customer>(Customer.class);
    private static final IdxField<Customer, Long> customerId = resolver.getField(Customer.class, "id");
    private static final IdxField<Customer, String> customerName = resolver.getField(Customer.class, "name");
    private static final QueryAggregateField.Count<Customer, String> customerNameCount = (QueryAggregateField.Count)customerName.count();
    private static final Comparator<QueryResultSet.Row<Customer>> byId = new Comparator<QueryResultSet.Row<Customer>>(){

        @Override
        public int compare(QueryResultSet.Row<Customer> row1, QueryResultSet.Row<Customer> row2) {
            Customer cust1 = row1.getRecord();
            Customer cust2 = row2.getRecord();
            long c = cust1.getId() - cust2.getId();
            if (c == 0L) {
                return 0;
            }
            if (c > 0L) {
                return 1;
            }
            return -1;
        }
    };
    private static final Comparator<QueryResultSet.Row<Customer>> byCustomerName = new Comparator<QueryResultSet.Row<Customer>>(){

        @Override
        public int compare(QueryResultSet.Row<Customer> row1, QueryResultSet.Row<Customer> row2) {
            String name1 = (String)row1.getValue(customerName);
            String name2 = (String)row2.getValue(customerName);
            return name1.compareTo(name2);
        }
    };

    @Test
    public void testColumnIndex() {
        QueryResultSetImpl<Long, Customer> rs = new QueryResultSetImpl<Long, Customer>(null);
        QueryResultImpl queryResult = new QueryResultImpl(null, rs.forRecords(customerIdMapper, new Customer(1L, "bob"), new Customer(2L, "alice")), 2);
        rs.addQueryResult(queryResult);
        rs.addColumn(customerId);
        rs.addColumn(customerName);
        Assert.assertEquals((String)"2 rows in queryResult", (long)2L, (long)queryResult.size());
        Assert.assertEquals((String)"2 rows in result set", (long)2L, (long)rs.getCount());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getLong(1));
        Assert.assertEquals((Object)"bob", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getLong(1));
        Assert.assertEquals((Object)"alice", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testColumnNames() {
        QueryResultSetImpl<Long, Customer> rs = new QueryResultSetImpl<Long, Customer>(null);
        QueryResultImpl queryResult = new QueryResultImpl(null, rs.forRecords(customerIdMapper, new Customer(1L, "bob"), new Customer(2L, "alice")), 2);
        rs.addQueryResult(queryResult);
        rs.addColumn(customerId);
        rs.addColumn(customerName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getLong(customerId.getName()));
        Assert.assertEquals((Object)"bob", (Object)rs.getString(customerName.getName()));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getLong(customerId.getName()));
        Assert.assertEquals((Object)"alice", (Object)rs.getString(customerName.getName()));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testGetObject() {
        QueryResultSetImpl<Long, Customer> rs = new QueryResultSetImpl<Long, Customer>(null);
        QueryResultImpl queryResult = new QueryResultImpl(null, rs.forRecords(customerIdMapper, new Customer(1L, "bob"), new Customer(2L, "alice")), 2);
        rs.addQueryResult(queryResult);
        rs.addColumn(customerId);
        rs.addColumn(customerName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)1L, rs.getObject(1));
        Assert.assertEquals((Object)"bob", rs.getObject(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)2L, rs.getObject(1));
        Assert.assertEquals((Object)"alice", rs.getObject(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testConcatenation() {
        QueryResultSetImpl<Long, Customer> rs = new QueryResultSetImpl<Long, Customer>(null);
        QueryResultImpl queryResult = new QueryResultImpl(null, rs.forRecords(customerIdMapper, new Customer(1L, "bob"), new Customer(2L, "alice")), 2);
        rs.addQueryResult(queryResult);
        rs.addQueryResult(queryResult);
        rs.addQueryResult(queryResult);
        rs.addColumn(customerId);
        rs.addColumn(customerName);
        Assert.assertEquals((String)"6 rows from 3 query results", (long)6L, (long)rs.getCount());
        Assert.assertEquals((String)"6 rows from 3 query results", (long)6L, (long)rs.getEstimatedCount());
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertEquals((Object)"bob", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertEquals((Object)"alice", (Object)rs.getString(2));
        }
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testInterleave() {
        QueryResultSetImpl<Long, Customer> rs = new QueryResultSetImpl<Long, Customer>(null);
        QueryResultImpl oddQueryResult = new QueryResultImpl(null, rs.forRecords(customerIdMapper, new Customer(1L, "alice"), new Customer(3L, "carl"), new Customer(5L, "ellen")), 3);
        QueryResultImpl evenQueryResult = new QueryResultImpl(null, rs.forRecords(customerIdMapper, new Customer(2L, "bob"), new Customer(4L, "donna")), 2);
        rs.addQueryResult(oddQueryResult);
        rs.addQueryResult(evenQueryResult);
        rs.setCollation(QueryResultSet.Collation.INTERLEAVE);
        rs.setInterleaveComparator(byId);
        rs.addColumn(customerId);
        rs.addColumn(customerName);
        Assert.assertEquals((String)"should be 5 rows", (long)5L, (long)rs.getCount());
        Assert.assertEquals((String)"should be 5 rows", (long)5L, (long)rs.getEstimatedCount());
        block7: for (int i = 1; i <= 5; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)i, (long)rs.getLong(1));
            String name = rs.getString(2);
            switch (i) {
                case 1: {
                    Assert.assertEquals((Object)"alice", (Object)name);
                    continue block7;
                }
                case 2: {
                    Assert.assertEquals((Object)"bob", (Object)name);
                    continue block7;
                }
                case 3: {
                    Assert.assertEquals((Object)"carl", (Object)name);
                    continue block7;
                }
                case 4: {
                    Assert.assertEquals((Object)"donna", (Object)name);
                    continue block7;
                }
                case 5: {
                    Assert.assertEquals((Object)"ellen", (Object)name);
                    continue block7;
                }
                default: {
                    Assert.fail((String)"should only be 5 id values");
                }
            }
        }
        Assert.assertFalse((boolean)rs.next());
    }

    private QueryAggregateField.Aggregate<Customer> createCustNameCount(String name, int count) {
        IdxField[] keyFields = new IdxField[]{customerName};
        Serializable[] keyValues = new Serializable[]{name};
        QueryAggregateField.Key key = QueryAggregateField.createKey(keyFields, keyValues);
        QueryAggregateField.Aggregate<Customer> agg = QueryAggregateField.createAggregate(key);
        agg.registerField(customerNameCount);
        for (int i = 1; i <= count; ++i) {
            agg.addRecord(new Customer(i, name));
        }
        Assert.assertEquals((String)"Two Alice records", (long)count, (long)((Integer)agg.yield(customerNameCount)).intValue());
        return agg;
    }

    @Test
    public void testOrderedAggregation() {
        QueryResultSetImpl rs = new QueryResultSetImpl(null);
        ArrayList qr1Rows = Lists.newArrayList();
        qr1Rows.add(rs.forAggregate(this.createCustNameCount("Alice", 2)));
        qr1Rows.add(rs.forAggregate(this.createCustNameCount("Bob", 2)));
        qr1Rows.add(rs.forAggregate(this.createCustNameCount("Carol", 2)));
        QueryResultImpl queryResult1 = new QueryResultImpl(null, qr1Rows, 3);
        ArrayList qr2Rows = Lists.newArrayList();
        qr2Rows.add(rs.forAggregate(this.createCustNameCount("Bob", 3)));
        qr2Rows.add(rs.forAggregate(this.createCustNameCount("Carol", 3)));
        qr2Rows.add(rs.forAggregate(this.createCustNameCount("Doug", 3)));
        qr2Rows.add(rs.forAggregate(this.createCustNameCount("Emily", 3)));
        QueryResultImpl queryResult2 = new QueryResultImpl(null, qr2Rows, 4);
        rs.addQueryResult(queryResult1);
        rs.addQueryResult(queryResult2);
        rs.setCollation(QueryResultSet.Collation.ORDERED_AGGREGATE);
        rs.setInterleaveComparator(byCustomerName);
        rs.addColumn(customerName);
        rs.addColumn(customerNameCount);
        Assert.assertTrue((String)"has first row", (boolean)rs.next());
        Assert.assertEquals((String)"Alice first", (Object)"Alice", (Object)rs.getString(1));
        Assert.assertEquals((String)"Alice/count 2", (long)2L, (long)rs.getInteger(2));
        Assert.assertTrue((String)"has second row", (boolean)rs.next());
        Assert.assertEquals((String)"Bob second", (Object)"Bob", (Object)rs.getString(1));
        Assert.assertEquals((String)"Bob/count 2+3", (long)5L, (long)rs.getInteger(2));
        Assert.assertTrue((String)"has third row", (boolean)rs.next());
        Assert.assertEquals((String)"Carol third", (Object)"Carol", (Object)rs.getString(1));
        Assert.assertEquals((String)"Carol/count 2+3", (long)5L, (long)rs.getInteger(2));
        Assert.assertTrue((String)"has fourth row", (boolean)rs.next());
        Assert.assertEquals((String)"Doug fouth", (Object)"Doug", (Object)rs.getString(1));
        Assert.assertEquals((String)"Doug/count 3", (long)3L, (long)rs.getInteger(2));
        Assert.assertTrue((String)"has fifth row", (boolean)rs.next());
        Assert.assertEquals((String)"Emily fifth", (Object)"Emily", (Object)rs.getString(1));
        Assert.assertEquals((String)"Emily/count 3", (long)3L, (long)rs.getInteger(2));
        Assert.assertFalse((String)"only five rows", (boolean)rs.next());
    }
}

