/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.mock;

import com.neeve.query.impl.QueryStaticField;
import com.neeve.query.impl.mem.MemQuerySetRepository;
import com.neeve.query.impl.mock.MockQueryEngine;
import com.neeve.query.impl.mock.domain.Address;
import com.neeve.query.impl.mock.domain.Customer;
import com.neeve.query.impl.mock.domain.SalesOrder;
import com.neeve.query.index.IdxField;
import java.util.Currency;

public class MockRecord {
    public static final MemQuerySetRepository.RecordMapper<Integer, MockRecord> keyMapper = new MockRecordMapper();
    public static final IdxField<MockRecord, Integer> recordId = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "id", Integer.class, new Class[0]);
    public static final IdxField<MockRecord, Object> payload = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object", Object.class, new Class[0]);
    public static final IdxField<MockRecord, Customer> customer = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object", Customer.class, Customer.class);
    public static final IdxField<MockRecord, Long> customerId = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.id", Long.class, Customer.class);
    public static final IdxField<MockRecord, String> customerName = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.name", String.class, Customer.class);
    public static final IdxField<MockRecord, String> customerZipcode = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.address.zipcode", String.class, Customer.class, Address.class);
    public static final IdxField<MockRecord, SalesOrder> order = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object", SalesOrder.class, SalesOrder.class);
    public static final IdxField<MockRecord, Long> orderId = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.id", Long.class, SalesOrder.class);
    public static final IdxField<MockRecord, Currency> orderCurrency = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.currency", Currency.class, SalesOrder.class);
    public static final IdxField<MockRecord, Customer> orderCustomer = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.customer", Customer.class, SalesOrder.class);
    public static final IdxField<MockRecord, Long> orderCustomerId = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.customer.id", Long.class, SalesOrder.class, Customer.class);
    public static final IdxField<MockRecord, Object> selectAll = new QueryStaticField<MockRecord, Object>(MockRecord.class, "", Object.class){
        private static final long serialVersionUID = 1L;

        @Override
        public Object applyUnchecked(MockRecord rec) {
            return rec.getObject();
        }
    };
    public static final IdxField<MockRecord, Integer> staticRecordId = new QueryStaticField<MockRecord, Integer>(MockRecord.class, "id", Integer.class){
        private static final long serialVersionUID = 1L;

        @Override
        public Integer applyUnchecked(MockRecord rec) {
            return rec.getId();
        }
    };
    public static final IdxField<MockRecord, Long> staticCustomerId = new QueryStaticField<MockRecord, Long>(MockRecord.class, "object.id", Long.class){
        private static final long serialVersionUID = 1L;

        @Override
        public Long applyUnchecked(MockRecord rec) {
            Customer cust = (Customer)rec.getObject();
            return cust.getId();
        }
    };
    public static final IdxField<MockRecord, String> staticCustomerName = new QueryStaticField<MockRecord, String>(MockRecord.class, "object.name", String.class){
        private static final long serialVersionUID = 1L;

        @Override
        public String applyUnchecked(MockRecord rec) {
            Customer cust = (Customer)rec.getObject();
            return cust.getName();
        }
    };
    public static final IdxField<MockRecord, String> staticCustomerZipcode = new QueryStaticField<MockRecord, String>(MockRecord.class, "object.address.zipcode", String.class){
        private static final long serialVersionUID = 1L;

        @Override
        public String applyUnchecked(MockRecord rec) {
            Customer cust = (Customer)rec.getObject();
            return cust.getAddress().getZipcode();
        }
    };
    public static final IdxField<MockRecord, Long> staticOrderId = new QueryStaticField<MockRecord, Long>(MockRecord.class, "object.id", Long.class){
        private static final long serialVersionUID = 1L;

        @Override
        public Long applyUnchecked(MockRecord rec) {
            SalesOrder ord = (SalesOrder)rec.getObject();
            return ord.getId();
        }
    };
    public static final IdxField<MockRecord, Long> staticOrderCustomerId = new QueryStaticField<MockRecord, Long>(MockRecord.class, "object.id", Long.class){
        private static final long serialVersionUID = 1L;

        @Override
        public Long applyUnchecked(MockRecord rec) {
            SalesOrder ord = (SalesOrder)rec.getObject();
            return ord.getCustomer().getId();
        }
    };
    private int id;
    private Object object;

    public MockRecord(int id, Object payload) {
        this.setId(id);
        this.object = payload;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String toString() {
        return "[" + this.id + "," + this.object + "]";
    }

    private static final class MockRecordMapper
    implements MemQuerySetRepository.RecordMapper<Integer, MockRecord> {
        private MockRecordMapper() {
        }

        @Override
        public Integer getKey(MockRecord record) {
            return record.id;
        }

        @Override
        public long getCommitSequenceNumber(MockRecord value) {
            return value.getId();
        }
    }
}

