/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryAggregateField;
import com.neeve.query.impl.index.IdxComparatorRegistry;
import com.neeve.query.impl.predicates.FieldTypePredicate;
import com.neeve.query.impl.predicates.PredicateOperators;
import com.neeve.query.impl.predicates.Predicates;
import com.neeve.query.impl.predicates.PredicatesImpl;
import com.neeve.query.index.IdxField;
import com.neeve.query.predicates.Predicate;
import com.neeve.util.UtlDataTypes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class QueryAbstractField<REC, T>
implements IdxField<REC, T> {
    private static final long serialVersionUID = 1L;
    private static Predicates predicates = PredicatesImpl.get();
    protected Class<? extends REC> recordType;
    protected Class<?>[] pathSelector;
    protected String fieldPath;
    protected Class<T> fieldType;
    private IdxField.KeyMapping<T> keyMapping;
    private transient int hashCode = 0;
    private transient List<Predicate<REC>> typePredicates;
    private transient String canonicalName;

    protected QueryAbstractField() {
    }

    public QueryAbstractField(Class<? extends REC> recordType, String fieldPath, Class<T> fieldType, Class<?> ... pathSelector) {
        if (pathSelector != null && pathSelector.length > 0) {
            int lastMeandingfulSelectorIdx;
            for (lastMeandingfulSelectorIdx = pathSelector.length - 1; lastMeandingfulSelectorIdx >= 0 && pathSelector[lastMeandingfulSelectorIdx] == Object.class; --lastMeandingfulSelectorIdx) {
            }
            if (lastMeandingfulSelectorIdx < 0) {
                pathSelector = null;
            } else if (lastMeandingfulSelectorIdx < pathSelector.length - 1) {
                Class[] strippedPathSelector = new Class[lastMeandingfulSelectorIdx + 1];
                System.arraycopy(pathSelector, 0, strippedPathSelector, 0, strippedPathSelector.length);
                pathSelector = strippedPathSelector;
            }
        }
        this.pathSelector = pathSelector == null || pathSelector.length == 0 ? null : pathSelector;
        this.recordType = recordType;
        this.fieldType = fieldType;
        this.fieldPath = fieldPath == null ? "" : fieldPath;
    }

    @Override
    public Class<? extends REC> getRecordType() {
        return this.recordType;
    }

    @Override
    public Class<T> getFieldType() {
        return this.fieldType;
    }

    public Class<?>[] getPathSelector() {
        return this.pathSelector;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QueryAbstractField)) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        QueryAbstractField other = (QueryAbstractField)obj;
        return this.fieldType.equals(other.fieldType) && this.recordType.equals(other.recordType) && this.fieldPath.equals(other.fieldPath) && Arrays.equals(this.pathSelector, other.pathSelector);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int calc = Objects.hashCode((Object[])this.pathSelector);
            calc = calc * 31 + Objects.hashCode((Object[])new Object[]{this.fieldPath});
            calc = calc * 31 + Objects.hashCode((Object[])new Object[]{this.fieldType});
            this.hashCode = calc = calc * 31 + Objects.hashCode((Object[])new Object[]{this.recordType});
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public final Predicate<REC> equal(T value) {
        if (value == null) {
            return this.isNull();
        }
        return predicates.createBinary(this, PredicateOperators.EQUALS, value);
    }

    @Override
    public final Predicate<REC> is(T value) {
        return this.equal(value);
    }

    @Override
    public final Predicate<REC> like(T likeMask) {
        if (!(likeMask instanceof String)) {
            throw new QueryException("The LIKE operator can only be used on String fields and only with a String mask");
        }
        return predicates.createBinary(this, PredicateOperators.LIKE, likeMask);
    }

    @Override
    public final Predicate<REC> regexLike(T pattern) {
        if (!(pattern instanceof String)) {
            throw new QueryException("The LIKE operator can only be used on String fields and only with a String mask");
        }
        return predicates.createBinary(this, PredicateOperators.REGEX_LIKE, pattern);
    }

    @Override
    public final Predicate<REC> greaterThan(T value) {
        return predicates.createBinary(this, PredicateOperators.GREATER_THAN, value);
    }

    @Override
    public final Predicate<REC> greaterThanOrEqual(T value) {
        return predicates.createBinary(this, PredicateOperators.GREATER_THAN_OR_EQUAL, value);
    }

    @Override
    public final Predicate<REC> lessThan(T value) {
        return predicates.createBinary(this, PredicateOperators.LESS_THAN, value);
    }

    @Override
    public final Predicate<REC> lessThanOrEqual(T value) {
        return predicates.createBinary(this, PredicateOperators.LESS_THAN_OR_EQUAL, value);
    }

    @Override
    public final Predicate<REC> between(T lowValue, T highValue) {
        return predicates.createTernary(this, PredicateOperators.BETWEEN, lowValue, highValue);
    }

    @Override
    public final Predicate<REC> in(Collection<T> values) {
        return predicates.createNary(this, PredicateOperators.IN, values);
    }

    @Override
    public final Predicate<REC> in(T ... values) {
        return predicates.createNary(this, PredicateOperators.IN, Arrays.asList(values));
    }

    @Override
    public final Predicate<REC> isNull() {
        return predicates.createUnary(this, PredicateOperators.IS_NULL);
    }

    @Override
    public final Predicate<REC> isNotNull() {
        return predicates.createUnary(this, PredicateOperators.IS_NOT_NULL);
    }

    @Override
    public T convertToFieldType(Object value) throws IllegalArgumentException {
        return (T)UtlDataTypes.convert(this.fieldType, (Object)value);
    }

    @Override
    public String getName() {
        if (Strings.isNullOrEmpty((String)this.fieldPath)) {
            return this.recordType.getSimpleName();
        }
        return this.recordType.getSimpleName() + "." + this.fieldPath;
    }

    @Override
    public String getFieldPath() {
        return this.fieldPath;
    }

    protected String getCanonicalName(Class<?> type) {
        return type.getCanonicalName().replace(".", "/");
    }

    @Override
    public String getCanonicalName() {
        if (this.canonicalName == null) {
            this.canonicalName = Strings.isNullOrEmpty((String)this.fieldPath) ? this.getCanonicalName(this.recordType) : (this.fieldPath.startsWith("object.") && this.isQualified() ? this.getCanonicalName(this.recordType) + this.fieldPath.substring(6) : this.fieldPath);
        }
        return this.canonicalName;
    }

    protected boolean isRecordTypeStatic() {
        return false;
    }

    protected boolean supportsPayloadTypeInference() {
        return false;
    }

    protected String getPayloadPath() {
        return "";
    }

    protected Predicate<REC> getPayloadTypePredicate() {
        return predicates.alwaysTrue();
    }

    protected List<Predicate<REC>> getPathTypePredicates() {
        if (this.typePredicates == null) {
            ArrayList types = Lists.newArrayList();
            if (!this.isRecordTypeStatic()) {
                types.add(new FieldTypePredicate(null, this.recordType));
            }
            if (this.pathSelector != null && this.pathSelector.length > 0) {
                int pathPos = 0;
                for (int i = 0; i < this.pathSelector.length; ++i) {
                    if (pathPos >= this.fieldPath.length()) {
                        throw new QueryException("Invalid path selector, path selector length is longer than fieldPath: " + this.pathSelector.length + " vs. " + this.fieldPath);
                    }
                    int pathEnd = this.fieldPath.indexOf(46, pathPos);
                    String subPath = null;
                    if (pathEnd == -1) {
                        subPath = this.fieldPath;
                        pathPos = this.fieldPath.length();
                    } else {
                        subPath = this.fieldPath.substring(0, pathEnd);
                        pathPos = pathEnd + 1;
                    }
                    if (this.supportsPayloadTypeInference() && subPath.equals(this.getPayloadPath()) || this.pathSelector[i] == Object.class) continue;
                    types.add(new FieldTypePredicate(subPath, this.pathSelector[i]));
                }
            }
            this.typePredicates = types;
        }
        return this.typePredicates;
    }

    @Override
    public Predicate<REC> getTypePredicate() {
        ArrayList childPredicates = Lists.newArrayList();
        Predicate<REC> payloadPredicate = this.getPayloadTypePredicate();
        if (payloadPredicate != PredicatesImpl.ALWAYS_TRUE) {
            childPredicates.add(payloadPredicate);
        }
        childPredicates.addAll(this.getPathTypePredicates());
        Predicate typePredicate = null;
        typePredicate = childPredicates.isEmpty() ? predicates.alwaysTrue() : predicates.and(childPredicates);
        return typePredicate;
    }

    @Override
    public IdxField<REC, Integer> count() {
        return new QueryAggregateField.Count(this);
    }

    @Override
    public IdxField<REC, T> min() {
        return new QueryAggregateField.Min(this);
    }

    @Override
    public IdxField<REC, T> max() {
        return new QueryAggregateField.Max(this);
    }

    @Override
    public IdxField<REC, Long> sumLong() {
        return new QueryAggregateField.LongSum(this);
    }

    @Override
    public IdxField<REC, Double> sumDouble() {
        return new QueryAggregateField.DoubleSum(this);
    }

    @Override
    public IdxField<REC, Double> average() {
        return new QueryAggregateField.Average(this);
    }

    @Override
    public boolean isQualified() {
        return this.recordType != null && this.recordType != Object.class;
    }

    @Override
    public void setKeyMapping(IdxField.KeyMapping<T> keyMapping) {
        this.keyMapping = keyMapping;
    }

    @Override
    public IdxField.KeyMapping<T> getKeyMapping() {
        return this.keyMapping;
    }

    @Override
    public Class<?> getIndexKeyType() {
        return this.keyMapping == null ? this.fieldType : this.keyMapping.getIndexKeyType();
    }

    @Override
    public void validateIndexable() throws Exception {
        Class<T> fieldType = this.getFieldType();
        if (fieldType.isArray()) {
            throw new QueryException("array indexes are not currently supported");
        }
        if (!fieldType.isPrimitive() && !Serializable.class.isAssignableFrom(fieldType)) {
            throw new QueryException("type, " + fieldType.getName() + ", is not Serializable");
        }
        if (!(fieldType.isPrimitive() || Comparable.class.isAssignableFrom(fieldType) || IdxComparatorRegistry.hasKeyComparator(fieldType))) {
            throw new QueryException("type, " + fieldType.getName() + ", is not Comparable");
        }
    }

    @Override
    public double getCost() {
        return 1.0;
    }
}

