/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit.xbuf;

import cern.colt.map.OpenIntObjectHashMap;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.adm.test.unit.xbuf.Enumeration;
import com.neeve.adm.test.unit.xbuf.IInliningEntity;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIntAdapter;
import com.neeve.lang.XString;
import com.neeve.pkt.PktBuffer;
import com.neeve.rog.ERogFieldNotSetException;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReferenceTracker;
import com.neeve.xbuf.IXbufDesyncer;
import com.neeve.xbuf.XbufCurrencyField;
import com.neeve.xbuf.XbufDesyncPolicy;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufHeuristics;
import com.neeve.xbuf.XbufListField;
import com.neeve.xbuf.XbufReferenceTypeField;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufStringField;
import com.neeve.xbuf.XbufVariableBooleanField;
import com.neeve.xbuf.XbufVariableEnumField;
import com.neeve.xbuf.XbufVariableLengthField;
import com.neeve.xbuf.XbufVariableShortField;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="Xbuf", compatLevel="4.1.0", admVersion="Unknown Version", date="11/26/24 7:56 AM", buildInfo="${build.version.string}")
@AdmFactoryInfo(factoryClass=com.neeve.adm.test.unit.xbuf.Factory.class, vfid=-1, ofid=-1, typeId=402)
@JsonPropertyOrder(value={"enumField", "booleanField", "currencyField", "pooledStringField", "stringField"})
public final class InliningEntity
implements IXbufDesyncer,
UtlPool.Item<InliningEntity>,
IInliningEntity {
    private static final int initialBackingBufferSize = XbufHeuristics.getProperty(InliningEntity.class, (String)"initialbackingbuffersize", (int)256);
    public static final InliningEntity[] EMPTY_ARRAY = new InliningEntity[0];
    static final XIntAdapter<Enumeration> _adpEnumField = new XIntAdapter<Enumeration>(){

        public final boolean canAdaptFrom(int from) {
            return from == 0 ? true : Enumeration.hasValue(from);
        }

        public final Enumeration adaptFrom(int from) {
            return from == 0 ? null : (Enumeration.hasValue(from) ? Enumeration.fromValue(from) : null);
        }

        public final int adaptTo(Enumeration to) {
            return to == null ? 0 : to.val;
        }

        public final Enumeration[] newArray(int size) {
            if (size == 0) {
                return Enumeration.EMPTY_ARRAY;
            }
            return new Enumeration[size];
        }
    };
    private XbufFieldContainer _container;
    private int _lateSyncBoundary;
    private final XbufVariableShortField _fldXRogType;
    private final XbufVariableEnumField<Enumeration> _fldEnumField;
    private final XbufVariableBooleanField _fldBooleanField;
    private final XbufCurrencyField _fldCurrencyField;
    private final XbufStringField _fldPooledStringField;
    private final XbufStringField _fldStringField;
    private final XbufSchema _schema = InliningEntity.createSchema();
    @JsonProperty(value="_xFieldBitmask_")
    private final long[] _fieldBitmask;
    private static long[] _fieldInterestBitmask;
    private static volatile boolean _objectInstantiated;
    private boolean _isDirty;
    private static int _optimizationHints;
    private static XbufDesyncPolicy _desyncPolicy;
    private static final Factory _factory;
    private static final UtlPool<InliningEntity> _entityPool;
    private final UtlReferenceTracker _refTracker;
    private final AtomicInteger _ownershipCount;
    private UtlPool<InliningEntity> _pool;
    private boolean readOnly;
    private static final OpenIntObjectHashMap fieldMapById;
    private static final Map<String, Integer> fieldMapByName;
    private final XbufField.VarintDesyncLength varintDesyncLength;

    public InliningEntity() {
        this(initialBackingBufferSize);
    }

    public InliningEntity(int initialBackingBufferSize) {
        this._fldXRogType = (XbufVariableShortField)this._schema.field("XRogType");
        this._fldEnumField = this._schema.variableLengthEnumField("EnumField", Enumeration.class);
        this._fldBooleanField = (XbufVariableBooleanField)this._schema.field("BooleanField");
        this._fldCurrencyField = (XbufCurrencyField)this._schema.field("CurrencyField");
        this._fldPooledStringField = (XbufStringField)this._schema.field("PooledStringField");
        this._fldStringField = (XbufStringField)this._schema.field("StringField");
        this._fieldBitmask = new long[1];
        _objectInstantiated = true;
        this.varintDesyncLength = new XbufField.VarintDesyncLength();
        this._refTracker = UtlReferenceTracker.enabled(this.getClass()) ? new UtlReferenceTracker((Object)this) : null;
        this._ownershipCount = new AtomicInteger(0);
        this._container = XbufFieldContainer.create((PktBuffer)PktBuffer.create((IOElasticBuffer.Sizer)null, (int)initialBackingBufferSize, (boolean)true)).setDesyncer((IXbufDesyncer)this).setSchema(this._schema.setFieldInterest(_fieldInterestBitmask));
        this._lateSyncBoundary = this._container.getLateSyncBoundaryFieldNumber();
    }

    public static InliningEntity create() {
        return ((InliningEntity)_entityPool.get(null)).undispose();
    }

    public static InliningEntity createFromSerializedXbufContainer(byte[] serializedContainer, XbufDesyncPolicy desyncPolicy) {
        InliningEntity entity = InliningEntity.create();
        entity._container.getBackingBuffer().putFrom(0, serializedContainer, 0, serializedContainer.length);
        entity._container.desync(desyncPolicy);
        return entity;
    }

    public static InliningEntity createFromSerializedXbufContainer(byte[] serializedContainer) {
        return InliningEntity.createFromSerializedXbufContainer(serializedContainer, XbufDesyncPolicy.Copy);
    }

    public static InliningEntity createFrom(byte[] serializedContainer, XbufDesyncPolicy desyncPolicy) {
        return InliningEntity.createFromSerializedXbufContainer(serializedContainer, desyncPolicy);
    }

    public static InliningEntity createFrom(byte[] serializedContainer) {
        return InliningEntity.createFromSerializedXbufContainer(serializedContainer);
    }

    public static final void setDesyncPolicy(XbufDesyncPolicy val) {
        _desyncPolicy = val;
    }

    public static final XbufDesyncPolicy getDesyncPolicy() {
        return _desyncPolicy;
    }

    public static final void setFieldInterest(List<Integer> fieldIds) {
        if (_objectInstantiated) {
            throw new IllegalStateException("field interest must be set before the first object of this class has been instantiated");
        }
        _fieldInterestBitmask = new long[1];
        _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 1L;
        if (fieldIds.contains(32752)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 2L;
        }
        if (fieldIds.contains(32751)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 4L;
        }
        if (fieldIds.contains(32748)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 8L;
        }
        if (fieldIds.contains(32750)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 0x10L;
        }
        if (fieldIds.contains(32749)) {
            _fieldInterestBitmask[0] = _fieldInterestBitmask[0] | 0x20L;
        }
    }

    private final void clearFieldReferences() {
    }

    public final void clearContent() {
        this.clearXRogType();
        this.clearEnumField();
        this.clearBooleanField();
        this.clearCurrencyField();
        this.clearPooledStringField();
        this.clearStringField();
    }

    public final void syncFieldBitmask() {
        this._fieldBitmask[0] = this.hasXRogType() ? this._fieldBitmask[0] | 1L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
        this._fieldBitmask[0] = this.hasBooleanField() ? this._fieldBitmask[0] | 4L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFBL;
        this._fieldBitmask[0] = this.hasCurrencyField() ? this._fieldBitmask[0] | 8L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFF7L;
        this._fieldBitmask[0] = this.hasPooledStringField() ? this._fieldBitmask[0] | 0x10L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFEFL;
        this._fieldBitmask[0] = this.hasStringField() ? this._fieldBitmask[0] | 0x20L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFDFL;
    }

    public final void desyncFieldBitmask() {
        if ((this._fieldBitmask[0] & 1L) == 0L) {
            this.clearXRogType();
        }
        if ((this._fieldBitmask[0] & 4L) == 0L) {
            this.clearBooleanField();
        }
        if ((this._fieldBitmask[0] & 8L) == 0L) {
            this.clearCurrencyField();
        }
        if ((this._fieldBitmask[0] & 0x10L) == 0L) {
            this.clearPooledStringField();
        }
        if ((this._fieldBitmask[0] & 0x20L) == 0L) {
            this.clearStringField();
        }
    }

    @JsonIgnore
    public final PktBuffer getBackingBuffer() {
        return this._container.getBackingBuffer();
    }

    public static final void optimizeFor(int val) {
        if (_objectInstantiated) {
            throw new IllegalStateException("optimizations must be set before the first object of this class has been instantiated");
        }
        _optimizationHints = val;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
    }

    public final boolean getIsReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPreserializedFields(PktBuffer buffer) {
        block10: {
            int length = buffer.getLength();
            if (length > 0) {
                IOBuffer iobuf = buffer.getIOBuffer();
                ByteBuffer bytebuf = iobuf.takeBuffer();
                XbufDesyncPolicy desyncPolicy = this._container.getDesyncPolicy();
                try {
                    this._container.setDesyncPolicy(XbufDesyncPolicy.FrameContainer);
                    try {
                        bytebuf.limit(length);
                        this.deserializeFromByteBuffer(bytebuf);
                        break block10;
                    }
                    finally {
                        iobuf.releaseBuffer();
                    }
                }
                finally {
                    this._container.setDesyncPolicy(desyncPolicy);
                }
            }
            XbufDesyncPolicy desyncPolicy = this._container.getDesyncPolicy();
            try {
                this._container.setDesyncPolicy(XbufDesyncPolicy.FrameContainer);
                this.deserializeFromByteArray(AdmRuntime.EMPTY_BYTE_ARRAY);
            }
            finally {
                this._container.setDesyncPolicy(desyncPolicy);
            }
            return;
        }
    }

    public static final int getXRogTypeFieldId() {
        return 1;
    }

    @JsonProperty(value="xRogType")
    public final void setXRogType(short val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldXRogType.setValue(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final short getXRogType() {
        return this._fldXRogType.getValue();
    }

    @JsonProperty(value="xRogType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Short getXRogTypeAsObject() {
        if (!this.hasXRogType()) {
            return null;
        }
        return this.getXRogType();
    }

    @JsonIgnore
    public final void setXRogTypeFrom(XbufVariableShortField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldXRogType.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableShortField getXRogTypeField() {
        return this._fldXRogType;
    }

    public final boolean hasXRogType() {
        return this._fldXRogType.hasValue();
    }

    public final void clearXRogType() {
        this._fldXRogType.clearValue();
        this._isDirty = true;
    }

    public static final int getEnumFieldFieldId() {
        return 32752;
    }

    @Override
    @JsonProperty(value="enumField")
    public final void setEnumField(Enumeration val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val != null) {
            this._fldEnumField.setValue((Object)val);
        } else {
            this._fldEnumField.clearValue();
        }
        this._isDirty = true;
    }

    @JsonIgnore
    public final void setEnumFieldFrom(XbufVariableEnumField<Enumeration> val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldEnumField.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableEnumField<Enumeration> getEnumFieldField() {
        return this._fldEnumField;
    }

    @JsonIgnore
    public final InliningEntity enumField(Enumeration val) {
        this.setEnumField(val);
        return this;
    }

    @Override
    @JsonProperty(value="enumField")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Enumeration getEnumField() {
        return this._fldEnumField.hasValue() ? (Enumeration)((Object)this._fldEnumField.getValue()) : null;
    }

    @Override
    @JsonIgnore
    public final Enumeration getEnumFieldOrThrow() {
        if (!this.hasEnumField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        return this.getEnumField();
    }

    @Override
    @JsonIgnore
    public final Enumeration getEnumField(Enumeration defaultIfNotSet) {
        return this.hasEnumField() ? this.getEnumField() : defaultIfNotSet;
    }

    @Override
    public final boolean hasEnumField() {
        return this._fldEnumField.hasValue();
    }

    @Override
    public final void clearEnumField() {
        this._fldEnumField.clearValue();
        this._isDirty = true;
    }

    public static final int getBooleanFieldFieldId() {
        return 32751;
    }

    @Override
    @JsonProperty(value="booleanField")
    public final void setBooleanField(boolean val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldBooleanField.setValue(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final InliningEntity booleanField(boolean val) {
        this.setBooleanField(val);
        return this;
    }

    @Override
    @JsonIgnore
    public final boolean getBooleanField() {
        return this._fldBooleanField.getValue();
    }

    @Override
    @JsonProperty(value="booleanField")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Boolean getBooleanFieldAsObject() {
        if (!this.hasBooleanField()) {
            return null;
        }
        return this.getBooleanField();
    }

    @JsonIgnore
    public final void setBooleanFieldFrom(XbufVariableBooleanField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldBooleanField.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufVariableBooleanField getBooleanFieldField() {
        return this._fldBooleanField;
    }

    @Override
    @JsonIgnore
    public final boolean getBooleanFieldOrThrow() {
        if (!this.hasBooleanField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        return this.getBooleanField();
    }

    @Override
    @JsonIgnore
    public final boolean getBooleanField(boolean defaultIfNotSet) {
        return this.hasBooleanField() ? this.getBooleanField() : defaultIfNotSet;
    }

    @Override
    public final boolean hasBooleanField() {
        return this._fldBooleanField.hasValue();
    }

    @Override
    public final void clearBooleanField() {
        this._fldBooleanField.clearValue();
        this._isDirty = true;
    }

    public static final int getCurrencyFieldFieldId() {
        return 32748;
    }

    @Override
    @JsonProperty(value="currencyField")
    public final void setCurrencyField(Currency val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val != null) {
            this._fldCurrencyField.setValue(val);
        } else {
            this._fldCurrencyField.clearValue();
        }
        this._isDirty = true;
    }

    @JsonIgnore
    public final InliningEntity currencyField(Currency val) {
        this.setCurrencyField(val);
        return this;
    }

    @Override
    @JsonProperty(value="currencyField")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Currency getCurrencyField() {
        return this._fldCurrencyField.getValue();
    }

    @JsonIgnore
    public final void setCurrencyFieldFrom(XbufCurrencyField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldCurrencyField.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufCurrencyField getCurrencyFieldField() {
        return this._fldCurrencyField;
    }

    @Override
    @JsonIgnore
    public final Currency getCurrencyFieldOrThrow() {
        if (!this.hasCurrencyField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        return this.getCurrencyField();
    }

    @Override
    @JsonIgnore
    public final Currency getCurrencyField(Currency defaultIfNotSet) {
        return this.hasCurrencyField() ? this.getCurrencyField() : defaultIfNotSet;
    }

    @Override
    public final boolean hasCurrencyField() {
        return this._fldCurrencyField.hasValue();
    }

    @Override
    public final void clearCurrencyField() {
        this._fldCurrencyField.clearValue();
        this._isDirty = true;
    }

    public static final int getPooledStringFieldFieldId() {
        return 32750;
    }

    @Override
    @JsonProperty(value="pooledStringField")
    public final void setPooledStringField(String val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val != null) {
            this._fldPooledStringField.setValue(val);
        } else {
            this._fldPooledStringField.clearValue();
        }
        this._isDirty = true;
    }

    @JsonIgnore
    public final InliningEntity pooledStringField(String val) {
        this.setPooledStringField(val);
        return this;
    }

    @JsonIgnore
    public final InliningEntity pooledStringField(XString val) {
        this.setPooledStringFieldFrom(val);
        return this;
    }

    @Override
    @JsonProperty(value="pooledStringField")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getPooledStringField() {
        return this._fldPooledStringField.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendPooledStringField(XString val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setPooledStringField(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this._fldPooledStringField.setValue(val);
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final void setPooledStringFieldFrom(long val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldPooledStringField.setValueFrom(val);
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getPooledStringFieldTo(XString.Factory<T> factory) {
        if (this._fldPooledStringField.hasValue()) {
            XString to = factory.create(false);
            this._fldPooledStringField.getValueTo(to);
            return (T)to;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public final void setPooledStringFieldFrom(XString val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val != null && !val.isNull()) {
            this._fldPooledStringField.setValueFrom(val);
        } else {
            this._fldPooledStringField.clearValue();
        }
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final void getPooledStringFieldTo(XString val) {
        this._fldPooledStringField.getValueTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getPooledStringFieldUnsafe() {
        return this._fldPooledStringField.getRawValue();
    }

    @JsonIgnore
    public final void setPooledStringFieldFrom(XbufStringField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldPooledStringField.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufStringField getPooledStringFieldField() {
        return this._fldPooledStringField;
    }

    @Override
    @JsonIgnore
    public final String getPooledStringFieldOrThrow() {
        if (!this.hasPooledStringField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        return this.getPooledStringField();
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getPooledStringFieldToOrThrow(XString.Factory<T> factory) {
        if (!this.hasPooledStringField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        return this.getPooledStringFieldTo(factory);
    }

    @Override
    @JsonIgnore
    public final void getPooledStringFieldToOrThrow(XString val) {
        if (!this.hasPooledStringField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        this.getPooledStringFieldTo(val);
    }

    @Override
    @JsonIgnore
    public XString getPooledStringFieldUnsafeOrThrow() {
        if (!this.hasPooledStringField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        return this.getPooledStringFieldUnsafe();
    }

    @Override
    @JsonIgnore
    public final String getPooledStringField(String defaultIfNotSet) {
        return this.hasPooledStringField() ? this.getPooledStringField() : defaultIfNotSet;
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getPooledStringFieldTo(XString.Factory<T> factory, T defaultIfNotSet) {
        if (!this.hasPooledStringField()) {
            return defaultIfNotSet;
        }
        return this.getPooledStringFieldTo(factory);
    }

    @Override
    @JsonIgnore
    public final void getPooledStringFieldTo(XString val, XString defaultIfNotSet) {
        if (this.hasPooledStringField()) {
            this.getPooledStringFieldTo(val);
        } else {
            val.setValue(defaultIfNotSet);
        }
    }

    @Override
    @JsonIgnore
    public final XString getPooledStringFieldUnsafe(XString defaultIfNotSet) {
        return this.hasPooledStringField() ? this.getPooledStringFieldUnsafe() : defaultIfNotSet;
    }

    @Override
    public final boolean hasPooledStringField() {
        return this._fldPooledStringField.hasValue();
    }

    @Override
    public final void clearPooledStringField() {
        this._fldPooledStringField.clearValue();
        this._isDirty = true;
    }

    public static final int getStringFieldFieldId() {
        return 32749;
    }

    @Override
    @JsonProperty(value="stringField")
    public final void setStringField(String val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val != null) {
            this._fldStringField.setValue(val);
        } else {
            this._fldStringField.clearValue();
        }
        this._isDirty = true;
    }

    @JsonIgnore
    public final InliningEntity stringField(String val) {
        this.setStringField(val);
        return this;
    }

    @JsonIgnore
    public final InliningEntity stringField(XString val) {
        this.setStringFieldFrom(val);
        return this;
    }

    @Override
    @JsonProperty(value="stringField")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getStringField() {
        return this._fldStringField.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendStringField(XString val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setStringField(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this._fldStringField.setValue(val);
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final void setStringFieldFrom(long val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._fldStringField.setValueFrom(val);
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getStringFieldTo(XString.Factory<T> factory) {
        if (this._fldStringField.hasValue()) {
            XString to = factory.create(false);
            this._fldStringField.getValueTo(to);
            return (T)to;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public final void setStringFieldFrom(XString val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val != null && !val.isNull()) {
            this._fldStringField.setValueFrom(val);
        } else {
            this._fldStringField.clearValue();
        }
        this._isDirty = true;
    }

    @Override
    @JsonIgnore
    public final void getStringFieldTo(XString val) {
        this._fldStringField.getValueTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getStringFieldUnsafe() {
        return this._fldStringField.getRawValue();
    }

    @JsonIgnore
    public final void setStringFieldFrom(XbufStringField val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this._fldStringField.setValueFrom(val);
        this._isDirty = true;
    }

    @JsonIgnore
    public final XbufStringField getStringFieldField() {
        return this._fldStringField;
    }

    @Override
    @JsonIgnore
    public final String getStringFieldOrThrow() {
        if (!this.hasStringField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        return this.getStringField();
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getStringFieldToOrThrow(XString.Factory<T> factory) {
        if (!this.hasStringField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        return this.getStringFieldTo(factory);
    }

    @Override
    @JsonIgnore
    public final void getStringFieldToOrThrow(XString val) {
        if (!this.hasStringField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        this.getStringFieldTo(val);
    }

    @Override
    @JsonIgnore
    public XString getStringFieldUnsafeOrThrow() {
        if (!this.hasStringField()) {
            throw new ERogFieldNotSetException("Field has not been set");
        }
        return this.getStringFieldUnsafe();
    }

    @Override
    @JsonIgnore
    public final String getStringField(String defaultIfNotSet) {
        return this.hasStringField() ? this.getStringField() : defaultIfNotSet;
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getStringFieldTo(XString.Factory<T> factory, T defaultIfNotSet) {
        if (!this.hasStringField()) {
            return defaultIfNotSet;
        }
        return this.getStringFieldTo(factory);
    }

    @Override
    @JsonIgnore
    public final void getStringFieldTo(XString val, XString defaultIfNotSet) {
        if (this.hasStringField()) {
            this.getStringFieldTo(val);
        } else {
            val.setValue(defaultIfNotSet);
        }
    }

    @Override
    @JsonIgnore
    public final XString getStringFieldUnsafe(XString defaultIfNotSet) {
        return this.hasStringField() ? this.getStringFieldUnsafe() : defaultIfNotSet;
    }

    @Override
    public final boolean hasStringField() {
        return this._fldStringField.hasValue();
    }

    @Override
    public final void clearStringField() {
        this._fldStringField.clearValue();
        this._isDirty = true;
    }

    public final boolean isDirty() {
        return this._isDirty;
    }

    public static final XbufSchema createSchema() {
        XbufField[] fields = new XbufField[]{XbufVariableShortField.create((short)1, (String)"XRogType"), XbufVariableEnumField.create((short)32752, (String)"EnumField", _adpEnumField), XbufVariableBooleanField.create((short)32751, (String)"BooleanField"), XbufCurrencyField.create((short)32748, (String)"CurrencyField", (boolean)false), XbufStringField.create((short)32750, (String)"PooledStringField"), XbufStringField.create((short)32749, (String)"StringField")};
        return XbufSchema.create((XbufField[])fields, fieldMapByName, (OpenIntObjectHashMap)fieldMapById);
    }

    private final int serializeToPacketBuffer(PktBuffer buffer, int offset) {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        int length = containerBuffer.getLength();
        buffer.putFrom(offset, (IOElasticBuffer)containerBuffer, 0, length);
        return length;
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        byte[] array = new byte[containerBuffer.getLength()];
        containerBuffer.getTo(0, array, 0, array.length);
        return array;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        ByteBuffer buffer = ByteBuffer.allocate(containerBuffer.getLength());
        containerBuffer.getTo(0, buffer, buffer.capacity());
        return buffer;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        IOBuffer ioBuffer = IOBuffer.create((int)containerBuffer.getLength(), (boolean)useNative);
        containerBuffer.getTo(0, ioBuffer.getBufferUnsafe(), containerBuffer.getLength());
        return ioBuffer;
    }

    public final boolean isBufferBacked() {
        return true;
    }

    @JsonIgnore
    public final int getSerializeToNativeLength() {
        this.sync();
        return this._container.getBackingBuffer().getLength();
    }

    public final int serializeToNative(long address, int addressOffset) {
        this.sync();
        PktBuffer containerBuffer = this._container.getBackingBuffer();
        int length = containerBuffer.getLength();
        containerBuffer.getToNative(0, address, addressOffset, length);
        return length;
    }

    private final InliningEntity deserializeFromPacketBuffer(PktBuffer buffer, int offset, int length, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, (IOElasticBuffer)buffer, offset, length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    private final InliningEntity deserializeFromPacketBuffer(PktBuffer buffer, int offset, int length) {
        return this.deserializeFromPacketBuffer(buffer, offset, length, XbufDesyncPolicy.Copy);
    }

    public final InliningEntity deserializeFromIOElasticBuffer(IOElasticBuffer buffer, int offset, int length, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, buffer, offset, length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final InliningEntity deserializeFromIOElasticBuffer(IOElasticBuffer buffer, int offset, int length) {
        return this.deserializeFromIOElasticBuffer(buffer, offset, length, XbufDesyncPolicy.Copy);
    }

    public final InliningEntity deserializeFromByteArray(byte[] array, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, array, 0, array.length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final InliningEntity deserializeFromByteArray(byte[] array) {
        return this.deserializeFromByteArray(array, XbufDesyncPolicy.Copy);
    }

    public final InliningEntity deserializeFromByteBuffer(ByteBuffer buffer, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFrom(0, buffer, buffer.remaining());
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final InliningEntity deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFromByteBuffer(buffer, XbufDesyncPolicy.Copy);
    }

    public final InliningEntity deserializeFromNative(long address, int offset, int length, XbufDesyncPolicy desyncPolicy) {
        this.clearFieldReferences();
        this._container.reset();
        this._container.getBackingBuffer().putFromNative(0, address, offset, length);
        this._container.desync(desyncPolicy);
        this._isDirty = false;
        return this;
    }

    public final InliningEntity deserializeFromNative(long address, int offset, int length) {
        return this.deserializeFromNative(address, offset, length, XbufDesyncPolicy.Copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sync() {
        if ((_optimizationHints & 1) == 1) {
            this._container.sync();
            return;
        }
        if (!this._isDirty) {
            return;
        }
        PktBuffer buffer = this._container.getBackingBuffer();
        int pos = this._container.syncPrepare();
        try {
            if (this._lateSyncBoundary == Integer.MAX_VALUE) {
                return;
            }
            boolean[] hasValues = this._container.getHasValues();
            if (0 >= this._lateSyncBoundary && hasValues[this._fldXRogType.index]) {
                pos += this._fldXRogType.sync(buffer, pos);
            }
            if (1 >= this._lateSyncBoundary && hasValues[this._fldEnumField.index]) {
                pos += this._fldEnumField.sync(buffer, pos);
            }
            if (2 >= this._lateSyncBoundary && hasValues[this._fldBooleanField.index]) {
                pos += this._fldBooleanField.sync(buffer, pos);
            }
            if (3 >= this._lateSyncBoundary && hasValues[this._fldCurrencyField.index]) {
                pos += this._fldCurrencyField.sync(buffer, pos);
            }
            if (4 >= this._lateSyncBoundary && hasValues[this._fldPooledStringField.index]) {
                pos += this._fldPooledStringField.sync(buffer, pos);
            }
            if (5 >= this._lateSyncBoundary && hasValues[this._fldStringField.index]) {
                pos += this._fldStringField.sync(buffer, pos);
            }
        }
        finally {
            this._container.syncDone();
            this._isDirty = false;
        }
    }

    public final int desync(PktBuffer buffer, int pos, boolean frameOnly) {
        if ((_optimizationHints & 1) == 1) {
            return 0;
        }
        if ((_optimizationHints & 2) == 2) {
            return 0;
        }
        int len = 0;
        int limit = buffer.getLength();
        if (pos + len >= limit) {
            return len;
        }
        short id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        if (id == 1) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 1L) != 0L ? this._fldXRogType.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 32752) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 2L) != 0L ? this._fldEnumField.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 32751) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 4L) != 0L ? this._fldBooleanField.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 32748) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 8L) != 0L ? this._fldCurrencyField.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 32750) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 0x10L) != 0L ? this._fldPooledStringField.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        if (id == 32749) {
            if (pos + (len += _fieldInterestBitmask == null || (_fieldInterestBitmask[0] & 0x20L) != 0L ? this._fldStringField.desync(buffer, pos + len, frameOnly) : XbufField.skip((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength)) >= limit) {
                return len;
            }
            id = XbufField.fieldId((PktBuffer)buffer, (int)(pos + len), (XbufField.VarintDesyncLength)this.varintDesyncLength);
        }
        return len;
    }

    public final InliningEntity init() {
        this.clearFieldReferences();
        this._container.reset();
        Arrays.fill(this._fieldBitmask, 0L);
        this.readOnly = false;
        this._isDirty = false;
        return this;
    }

    public final InliningEntity setPool(UtlPool<InliningEntity> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<InliningEntity> getPool() {
        return this._pool;
    }

    public final boolean isReferenceCounted() {
        return true;
    }

    public final InliningEntity acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this._refTracker != null) {
            this._refTracker.onAcquire(val);
        }
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnerCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this._refTracker != null) {
            this._refTracker.onDispose(val);
        }
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this._pool.put((UtlPool.Item)this);
        }
    }

    private final InliningEntity undispose() {
        int val = this._ownershipCount.getAndSet(1);
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this._refTracker != null) {
            this._refTracker.onInit(1);
        }
        if (val != 0 && this._pool != null) {
            throw new IllegalStateException("attempt to undispose an entity that's not disposed");
        }
        return this;
    }

    public final Object clone() {
        InliningEntity clonee = InliningEntity.create();
        if (this.hasXRogType()) {
            clonee.setXRogType(this.getXRogType());
        }
        if (this.hasEnumField()) {
            clonee.setEnumField(this.getEnumField());
        }
        if (this.hasBooleanField()) {
            clonee.setBooleanField(this.getBooleanField());
        }
        if (this.hasCurrencyField()) {
            clonee.setCurrencyField(this.getCurrencyField());
        }
        if (this.hasPooledStringField()) {
            clonee.setPooledStringField(this.getPooledStringField());
        }
        if (this.hasStringField()) {
            clonee.setStringField(this.getStringField());
        }
        return clonee;
    }

    public final InliningEntity copy() {
        InliningEntity copy = InliningEntity.create();
        this.copyInto(copy);
        return copy;
    }

    public final void copyInto(InliningEntity copy) {
        if (copy.readOnly) {
            throw new IllegalStateException("target is read only");
        }
        this.sync();
        copy.deserializeFromIOElasticBuffer((IOElasticBuffer)this.getBackingBuffer(), 0, this.getBackingBuffer().getLength());
    }

    @Override
    public final boolean isValid() {
        return this.hasPooledStringField();
    }

    @Override
    public final void getValidationErrors(List<XString> results, String errorPrefix) {
        if (results == null) {
            throw new IllegalStateException("Results list cannot be null.");
        }
        if (!this.hasPooledStringField()) {
            XString error = XString.create((int)(28 + (errorPrefix == null ? 0 : errorPrefix.length())), (boolean)true);
            if (errorPrefix != null) {
                error.append((CharSequence)errorPrefix);
            }
            error.append((CharSequence)"pooledStringField is not set");
            results.add(error);
        }
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasXRogType()) {
            builder.append(0 == c++ ? "" : ",").append("XRogType=").append(this.getXRogType());
        }
        if (this.hasEnumField()) {
            builder.append(0 == c++ ? "" : ",").append("EnumField=").append((Object)this.getEnumField());
        }
        if (this.hasBooleanField()) {
            builder.append(0 == c++ ? "" : ",").append("BooleanField=").append(this.getBooleanField());
        }
        if (this.hasCurrencyField()) {
            builder.append(0 == c++ ? "" : ",").append("CurrencyField=").append(this.getCurrencyField());
        }
        if (this.hasPooledStringField()) {
            builder.append(0 == c++ ? "" : ",").append("PooledStringField=").append(this.getPooledStringField());
        }
        if (this.hasStringField()) {
            builder.append(0 == c++ ? "" : ",").append("StringField=").append(this.getStringField());
        }
        builder.append("}");
        return builder.toString();
    }

    static {
        _optimizationHints = XbufHeuristics.getDefaultOptimizationHints(InliningEntity.class);
        _desyncPolicy = XbufHeuristics.getDefaultDesyncPolicy(InliningEntity.class);
        _factory = new Factory();
        _entityPool = UtlPool.create((String)"xbuf.entity", (String)"InliningEntityXbufEntity.1.402", (UtlPool.Factory)_factory, (UtlPool.Params)XbufHeuristics.configurePoolParams(InliningEntity.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true)));
        fieldMapById = new OpenIntObjectHashMap(6, 0.0, 0.5);
        fieldMapByName = new HashMap<String, Integer>(6);
        fieldMapById.put(1, (Object)0);
        fieldMapByName.put("XRogType", 0);
        fieldMapById.put(32752, (Object)1);
        fieldMapByName.put("EnumField", 1);
        fieldMapById.put(32751, (Object)2);
        fieldMapByName.put("BooleanField", 2);
        fieldMapById.put(32748, (Object)3);
        fieldMapByName.put("CurrencyField", 3);
        fieldMapById.put(32750, (Object)4);
        fieldMapByName.put("PooledStringField", 4);
        fieldMapById.put(32749, (Object)5);
        fieldMapByName.put("StringField", 5);
    }

    public static final class ListField
    extends XbufListField<InliningEntity> {
        private ListField(short id, String name) {
            super(XbufField.Type.COMPOUND_LIST, id, name, (XbufReferenceTypeField)Field.create(id, name));
        }

        public static ListField create(short id, String name) {
            return new ListField(id, name);
        }

        protected final InliningEntity[] createTypeArray(int size) {
            return new InliningEntity[size];
        }
    }

    public static final class Field
    extends XbufVariableLengthField<InliningEntity> {
        private Field(short id, String name) {
            super(XbufField.Type.COMPOUND, id, name);
        }

        public static Field create(short id, String name) {
            return new Field(id, name);
        }

        protected final int serializedLength(InliningEntity val) {
            return val != null ? val._container.getSerializedLength() : 0;
        }

        protected final int serialize(PktBuffer buffer, int offset, InliningEntity val) {
            return val != null ? val.serializeToPacketBuffer(buffer, offset) : 0;
        }

        protected final InliningEntity deserialize(PktBuffer buffer, int offset, int length) {
            InliningEntity val = InliningEntity.create();
            val.deserializeFromPacketBuffer(buffer, offset, length);
            return val;
        }

        protected final String toString(InliningEntity val) {
            return val.toString();
        }
    }

    private static final class Factory
    implements UtlPool.Factory<InliningEntity> {
        private Factory() {
        }

        public final InliningEntity createItem(Object object) {
            return new InliningEntity(initialBackingBufferSize);
        }

        public final InliningEntity[] createItemArray(int size) {
            return new InliningEntity[size];
        }
    }
}

