/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.test.unit;

import com.neeve.lang.XString;
import com.neeve.pkt.PktBuffer;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.SmaException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class MessageMetadataTest {
    private Random random = new Random(System.currentTimeMillis());
    private byte version;
    private byte encodingType;
    private short vfid;
    private short type;
    private int sender;
    private int flow;
    private long sno;
    private short channelId;
    private XString channelName;

    final XString randomString() {
        StringBuilder sb = new StringBuilder();
        int len = this.random.nextInt(20);
        for (int i = 0; i < len; ++i) {
            sb.append(this.random.nextInt(10));
        }
        return XString.create((String)sb.toString());
    }

    private final void validate(MessageMetadata metadata) {
        Assert.assertEquals((long)this.version, (long)metadata.getVersion());
        Assert.assertEquals((long)this.encodingType, (long)metadata.getMessageEncodingType());
        Assert.assertEquals((long)this.vfid, (long)metadata.getMessageViewFactory());
        Assert.assertEquals((long)this.type, (long)metadata.getMessageViewType());
        Assert.assertEquals((long)this.sender, (long)metadata.getMessageSender());
        Assert.assertEquals((long)this.flow, (long)metadata.getMessageFlow());
        Assert.assertEquals((long)this.sno, (long)metadata.getMessageSno());
        Assert.assertEquals((long)this.channelId, (long)metadata.getMessageChannelId());
        Assert.assertEquals((Object)(this.channelName == null ? null : this.channelName.getValue()), (Object)metadata.getMessageChannelName());
        Assert.assertEquals((long)((this.version == 1 ? 24 : 26) + (this.channelName == null ? 0 : this.channelName.length())), (long)metadata.getSerializedLength());
        Assert.assertEquals((long)metadata.getSerializedLength(), (long)metadata.getBuffer().getLength());
    }

    @Test
    public void testGetVersionOnFresh() {
        Assert.assertEquals((long)0L, (long)MessageMetadataFactory.getInstance().createMessageMetadata().getVersion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getEncodingTypeWithInvalidVersion() {
        MessageMetadataFactory.getInstance().createMessageMetadata().getMessageEncodingType();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getViewFactoryWithInvalidVersion() {
        MessageMetadataFactory.getInstance().createMessageMetadata().getMessageViewFactory();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getViewWithInvalidVersion() {
        MessageMetadataFactory.getInstance().createMessageMetadata().getMessageViewType();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSenderWithInvalidVersion() {
        MessageMetadataFactory.getInstance().createMessageMetadata().getMessageSender();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFlowWithInvalidVersion() {
        MessageMetadataFactory.getInstance().createMessageMetadata().getMessageFlow();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSnoWithInvalidVersion() {
        MessageMetadataFactory.getInstance().createMessageMetadata().getMessageSno();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getChannelIdWithInvalidVersion() {
        MessageMetadataFactory.getInstance().createMessageMetadata().getMessageChannelId();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getChannelNameWithInvalidVersion() {
        MessageMetadataFactory.getInstance().createMessageMetadata().getMessageChannelName();
    }

    @Test
    public void testSerializeV1() {
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        this.version = 1;
        this.type = 0;
        this.encodingType = (byte)this.random.nextInt(256);
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.flow = this.random.nextInt();
        this.channelName = this.randomString();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.vfid = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
    }

    @Test
    public void testSerializeV2() {
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        this.version = (byte)2;
        this.encodingType = (byte)this.random.nextInt(256);
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.flow = this.random.nextInt();
        this.channelName = this.randomString();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        this.validate(metadata);
    }

    @Test
    public void testSerializeWrapV1() throws Exception {
        MessageMetadata metadata1 = MessageMetadataFactory.getInstance().createMessageMetadata();
        this.version = 1;
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata1.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        PktBuffer buffer = PktBuffer.create(null, (int)metadata1.getSerializedLength(), (boolean)false);
        buffer.putFrom(0, metadata1.getBuffer().getIOBuffer().getBufferUnsafe(), metadata1.getSerializedLength());
        MessageMetadata metadata2 = MessageMetadataFactory.getInstance().createMessageMetadata();
        metadata2.wrap(buffer.getIOBuffer());
        Assert.assertEquals((long)2L, (long)metadata2.getBuffer().getIOBuffer().getOwnerCount());
        this.validate(metadata2);
    }

    @Test
    public void testSerializeDeserializeV1() throws Exception {
        MessageMetadata metadata1 = MessageMetadataFactory.getInstance().createMessageMetadata();
        this.version = 1;
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata1.serializeV1(this.encodingType, this.vfid, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        PktBuffer buffer = PktBuffer.create(null, (int)metadata1.getSerializedLength(), (boolean)false);
        buffer.putFrom(0, metadata1.getBuffer().getIOBuffer().getBufferUnsafe(), metadata1.getSerializedLength());
        MessageMetadata metadata2 = MessageMetadataFactory.getInstance().createMessageMetadata();
        ByteBuffer byteBuffer = buffer.getIOBuffer().takeBuffer();
        byteBuffer.limit(metadata1.getSerializedLength());
        metadata2.deserialize(byteBuffer);
        buffer.getIOBuffer().releaseBuffer();
        this.validate(metadata2);
    }

    @Test
    public void testSerializeWrapV2() throws Exception {
        MessageMetadata metadata1 = MessageMetadataFactory.getInstance().createMessageMetadata();
        this.version = (byte)2;
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata1.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        PktBuffer buffer = PktBuffer.create(null, (int)metadata1.getSerializedLength(), (boolean)false);
        buffer.putFrom(0, metadata1.getBuffer().getIOBuffer().getBufferUnsafe(), metadata1.getSerializedLength());
        MessageMetadata metadata2 = MessageMetadataFactory.getInstance().createMessageMetadata();
        metadata2.wrap(buffer.getIOBuffer());
        Assert.assertEquals((long)2L, (long)metadata2.getBuffer().getIOBuffer().getOwnerCount());
        this.validate(metadata2);
    }

    @Test
    public void testSerializeDeserializeV2() throws Exception {
        MessageMetadata metadata1 = MessageMetadataFactory.getInstance().createMessageMetadata();
        this.version = (byte)2;
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata1.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        PktBuffer buffer = PktBuffer.create(null, (int)metadata1.getSerializedLength(), (boolean)false);
        buffer.putFrom(0, metadata1.getBuffer().getIOBuffer().getBufferUnsafe(), metadata1.getSerializedLength());
        MessageMetadata metadata2 = MessageMetadataFactory.getInstance().createMessageMetadata();
        ByteBuffer byteBuffer = buffer.getIOBuffer().takeBuffer();
        byteBuffer.limit(metadata1.getSerializedLength());
        metadata2.deserialize(byteBuffer);
        buffer.getIOBuffer().releaseBuffer();
        this.validate(metadata2);
    }

    @Test
    public void testCreateDispose() throws Exception {
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        metadata.getVersion();
        Assert.assertNotNull((Object)metadata.getBuffer().getIOBuffer());
        metadata.dispose();
        Assert.assertNotNull(metadata.getPool());
        Assert.assertNull((Object)metadata.getBuffer().getIOBuffer());
    }

    @Test
    public void testWrapDispose() throws Exception {
        MessageMetadata metadata1 = MessageMetadataFactory.getInstance().createMessageMetadata();
        this.version = (byte)2;
        this.encodingType = (byte)this.random.nextInt(256);
        this.vfid = (short)this.random.nextInt(32768);
        this.type = (short)this.random.nextInt(32768);
        this.sender = this.random.nextInt();
        this.flow = this.random.nextInt();
        this.sno = this.random.nextLong();
        this.channelId = (short)this.random.nextInt(32768);
        this.channelName = this.randomString();
        metadata1.serializeV2(this.encodingType, this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, this.channelName);
        PktBuffer buffer = PktBuffer.create(null, (int)metadata1.getSerializedLength(), (boolean)false);
        buffer.putFrom(0, metadata1.getBuffer().getIOBuffer().getBufferUnsafe(), metadata1.getSerializedLength());
        MessageMetadata metadata2 = MessageMetadataFactory.getInstance().createMessageMetadata();
        metadata2.wrap(buffer.getIOBuffer());
        Assert.assertEquals((long)2L, (long)metadata2.getBuffer().getIOBuffer().getOwnerCount());
        metadata2.dispose();
        Assert.assertNull((Object)metadata2.getBuffer().getIOBuffer());
        Assert.assertEquals((long)1L, (long)metadata1.getBuffer().getIOBuffer().getOwnerCount());
    }

    @Test
    public void testNullChannelName() throws SmaException {
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        XString nullChannel = XString.create(null);
        metadata.serializeV1((byte)this.random.nextInt(256), this.vfid, this.sender, this.flow, this.sno, this.channelId, nullChannel);
        MessageMetadata deserialized = MessageMetadataFactory.getInstance().createMessageMetadata();
        deserialized.deserialize(metadata.getBuffer().getIOBuffer().getBufferUnsafe());
        Assert.assertEquals((String)"Wrong channel name from V1 metadata.", null, (Object)deserialized.getMessageChannelName());
        this.vfid = (short)this.random.nextInt(32768);
        metadata.serializeV2((byte)this.random.nextInt(256), this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, nullChannel);
        Assert.assertEquals((String)"Wrong channel name from V2 metadata.", null, (Object)deserialized.getMessageChannelName());
    }

    @Test
    public void testEmptyChannelName() throws SmaException {
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        XString emptyChannel = XString.create((String)"");
        metadata.serializeV1((byte)this.random.nextInt(256), this.vfid, this.sender, this.flow, this.sno, this.channelId, emptyChannel);
        MessageMetadata deserialized = MessageMetadataFactory.getInstance().createMessageMetadata();
        deserialized.deserialize(metadata.getBuffer().getIOBuffer().getBufferUnsafe());
        Assert.assertEquals((String)"Wrong channel name from V1 metadata.", (Object)"", (Object)deserialized.getMessageChannelName());
        this.vfid = (short)this.random.nextInt(32768);
        metadata.serializeV2((byte)this.random.nextInt(256), this.vfid, this.type, this.sender, this.flow, this.sno, this.channelId, emptyChannel);
        Assert.assertEquals((String)"Wrong channel name from V2 metadata.", (Object)"", (Object)deserialized.getMessageChannelName());
    }
}

