/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufVariableBooleanField;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufVariableBooleanFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    static final boolean randomBoolean() {
        return random.nextBoolean();
    }

    private final XbufVariableBooleanField testSetClearSyncDesync(XbufVariableBooleanField field1) {
        boolean value = false;
        field1.setValue(false);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(value))), (long)field1.length());
        value = XbufVariableBooleanFieldTest.randomBoolean();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(value))), (long)field1.length());
        value = XbufVariableBooleanFieldTest.randomBoolean();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertFalse((boolean)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(false))), (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        value = false;
        field1.setValue(false);
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(value))), (long)field1.sync(buffer1, 23));
        XbufVariableBooleanField field2 = XbufVariableBooleanField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(value))), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((Object)value, (Object)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(value))), (long)field2.length());
        value = XbufVariableBooleanFieldTest.randomBoolean();
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(value))), (long)field1.sync(buffer1, 23));
        field2 = XbufVariableBooleanField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(value))), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((Object)value, (Object)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(value))), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufVariableBooleanField field1 = XbufVariableBooleanField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARBOOLEAN), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertFalse((boolean)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(false))), (long)field1.length());
        field1 = XbufVariableBooleanField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARBOOLEAN), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertFalse((boolean)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + CodedOutputStream.computeRawVarint32Size((int)XbufVariableBooleanField.toInt(false))), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap() {
        XbufVariableBooleanField field1 = XbufVariableBooleanField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Native() {
        XbufVariableBooleanField field1 = XbufVariableBooleanField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }
}

