/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.neeve.pkt.PktBuffer;
import com.neeve.raw.RawUUID;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufUUIDField;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Random;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public final class XbufUUIDFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    static final String randomString() {
        return String.format("%04d", random.nextInt(9999));
    }

    static final UUID randomUUID() {
        return UUID.randomUUID();
    }

    private final XbufUUIDField testSetClearSyncDesync(XbufUUIDField field1) {
        UUID value = null;
        value = XbufUUIDFieldTest.randomUUID();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 16), (long)field1.length());
        value = null;
        field1.setValue(null);
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertEquals((Object)value, (Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 16), (long)field1.length());
        value = XbufUUIDFieldTest.randomUUID();
        field1.setValue(value);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull((Object)field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)field1.headerLength(), (long)field1.sync(buffer1, 10));
        XbufUUIDField field2 = XbufUUIDField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)field1.headerLength(), (long)field2.desync(buffer1, 10));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertNull((Object)field2.getRawValue());
        Assert.assertNull((Object)field2.getValue());
        Assert.assertEquals((long)field2.headerLength(), (long)field2.length());
        value = XbufUUIDFieldTest.randomUUID();
        field1.setValue(value);
        Assert.assertEquals((long)(field1.headerLength() + 16), (long)field1.sync(buffer1, 23));
        field2 = XbufUUIDField.create(field1.id(), field1.name(), field1.pinned());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(field1.headerLength() + 16), (long)field2.desync(buffer1, 23));
        Assert.assertTrue((boolean)field2.hasValue());
        Assert.assertEquals((Object)value, (Object)XbufUUIDField.fromRaw((RawUUID)field2.getRawValue()));
        Assert.assertEquals((Object)value, (Object)field2.getValue());
        Assert.assertEquals((long)(field2.headerLength() + 16), (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufUUIDField field1 = XbufUUIDField.create(id, name, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.UUID), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertFalse((boolean)field1.hasValue());
        Assert.assertNull((Object)field1.getValue());
        Assert.assertEquals((long)field1.headerLength(), (long)field1.length());
        field1 = XbufUUIDField.create(id, null, true);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.UUID), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertTrue((boolean)field1.pinned());
        Assert.assertFalse((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertTrue((boolean)field1.hasValue());
        Assert.assertNull((Object)field1.getValue());
        Assert.assertEquals((long)(field1.headerLength() + 16), (long)field1.length());
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Heap() {
        XbufUUIDField field1 = XbufUUIDField.create((short)random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Unpinned_Native() {
        XbufUUIDField field1 = XbufUUIDField.create((short)random.nextInt(Short.MAX_VALUE), null, false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }
}

