/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public final class XbufIntField
extends XbufField {
    private final int DEFAULT;
    private final Value value = new Value();

    private XbufIntField(short id, String name, int defval, boolean pinned) {
        super(XbufField.Type.INTEGER, id, name, pinned);
        this.value.val = this.DEFAULT = defval;
    }

    private final void serialize(PktBuffer buffer, int offset, int val) {
        buffer.putInt(offset, val);
    }

    private final int deserialize(PktBuffer buffer, int offset) {
        return buffer.getInt(offset);
    }

    public static final XbufIntField create(short id, String name, int defval, boolean pinned) {
        return new XbufIntField(id, name, defval, pinned);
    }

    public static final XbufIntField create(short id, String name, boolean pinned) {
        return XbufIntField.create(id, name, 0, pinned);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        this.serialize(buffer, offset, this.getValue());
        return 4;
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        if (length != 4) {
            throw new InternalError("request to deserialize int with length != 4 (length=" + length + ")");
        }
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return 4;
    }

    @Override
    protected final int contentLength() {
        return 4;
    }

    @Override
    protected final String contentAsString() {
        return String.valueOf(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, this.DEFAULT);
            return true;
        }
        this.value.val = this.DEFAULT;
        return this.container.clearValue(this);
    }

    public final int getDefault() {
        return this.DEFAULT;
    }

    public final void setValue(int val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, val);
        } else {
            this.value.val = val;
            this.container.setValue(this, this.value);
        }
    }

    public final void setValueFrom(XbufIntField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final int getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.pinned || this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : this.DEFAULT;
    }

    private final class Value {
        int val;

        private Value() {
        }
    }
}

