/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TransactionStatementNode;

public class TransactionControlNode
extends TransactionStatementNode {
    private Operation operation;

    @Override
    public void init(Object operation) throws StandardException {
        this.operation = (Operation)((Object)operation);
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        TransactionControlNode other = (TransactionControlNode)node;
        this.operation = other.operation;
    }

    @Override
    public String toString() {
        return super.toString() + "operation: " + (Object)((Object)this.operation) + "\n";
    }

    @Override
    public String statementToString() {
        switch (this.operation) {
            case BEGIN: {
                return "BEGIN";
            }
            case COMMIT: {
                return "COMMIT";
            }
            case ROLLBACK: {
                return "ROLLBACK";
            }
        }
        assert (false) : "Unknown transaction statement type";
        return "UNKNOWN";
    }

    public static enum Operation {
        BEGIN,
        COMMIT,
        ROLLBACK;

    }
}

