/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.ValueNode;

public class ColumnReference
extends ValueNode {
    private String columnName;
    private TableName tableName;

    @Override
    public void init(Object columnName, Object tableName, Object tokBeginOffset, Object tokEndOffset) {
        this.columnName = (String)columnName;
        this.tableName = (TableName)tableName;
        this.setBeginOffset((Integer)tokBeginOffset);
        this.setEndOffset((Integer)tokEndOffset);
    }

    @Override
    public void init(Object columnName, Object tableName) {
        this.columnName = (String)columnName;
        this.tableName = (TableName)tableName;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        ColumnReference other = (ColumnReference)node;
        this.columnName = other.columnName;
        this.tableName = (TableName)this.getNodeFactory().copyNode(other.tableName, this.getParserContext());
    }

    @Override
    public String toString() {
        return "columnName: " + this.columnName + "\n" + "tableName: " + (this.tableName != null ? this.tableName.toString() : "null") + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
    }

    public String getSQLColumnName() {
        if (this.tableName == null) {
            return this.columnName;
        }
        return this.tableName.toString() + "." + this.columnName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getTableName() {
        return this.tableName != null ? this.tableName.getTableName() : null;
    }

    public TableName getTableNameNode() {
        return this.tableName;
    }

    public void setTableNameNode(TableName tableName) {
        this.tableName = tableName;
    }

    @Override
    public String getSchemaName() {
        return this.tableName != null ? this.tableName.getSchemaName() : null;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        ColumnReference other = (ColumnReference)o;
        if (!this.columnName.equals(other.getColumnName())) {
            return false;
        }
        if (this.tableName == null) {
            return other.tableName == null;
        }
        return this.tableName.equals(other.tableName);
    }
}

