/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.ValueNodeList;
import com.akiban.sql.parser.Visitor;

public class CoalesceFunctionNode
extends ValueNode {
    private String functionName;
    private ValueNodeList argumentsList;

    @Override
    public void init(Object functionName, Object argumentsList) {
        this.functionName = (String)functionName;
        this.argumentsList = (ValueNodeList)argumentsList;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        CoalesceFunctionNode other = (CoalesceFunctionNode)node;
        this.functionName = other.functionName;
        this.argumentsList = (ValueNodeList)this.getNodeFactory().copyNode(other.argumentsList, this.getParserContext());
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public ValueNodeList getArgumentsList() {
        return this.argumentsList;
    }

    @Override
    public String toString() {
        return "functionName: " + this.functionName + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "argumentsList: ");
        this.argumentsList.treePrint(depth + 1);
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        CoalesceFunctionNode other = (CoalesceFunctionNode)o;
        return this.argumentsList.isEquivalent(other.argumentsList);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        this.argumentsList = (ValueNodeList)this.argumentsList.accept(v);
    }
}

