/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepMessagingStartedEvent;
import com.neeve.aep.test.unit.generated.proto.Message;
import com.neeve.ods.impl.StoreMemberDownEvent;
import com.neeve.ods.impl.StoreMemberUpEvent;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.event.MessageStabilityEvent;

public final class AepEngineSplitBrainTestApp {
    String name;
    AepEngineSplitBrainTestApp sender;
    Object sendFlowControlObject = new Object();
    MessageChannel channel;
    boolean receivedMessagingStartFailEvent;
    boolean receivedEngineStoppedEvent;
    boolean sendDone;
    int numSent;
    int numSentReceived;
    int messageCount;
    int stabilityCount;
    int memberUpEventCount;
    int memberDownEventCount;

    AepEngineSplitBrainTestApp(String name, AepEngineSplitBrainTestApp sender) {
        this.name = name;
        this.sender = sender;
    }

    AepEngineSplitBrainTestApp(String name) {
        this(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onSend() {
        Object object = this.sendFlowControlObject;
        synchronized (object) {
            ++this.numSent;
            while (!this.sendDone && this.numSent - this.numSentReceived > 1000) {
                try {
                    this.sendFlowControlObject.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendDone() {
        Object object = this.sendFlowControlObject;
        synchronized (object) {
            this.sendDone = true;
            this.sendFlowControlObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onReceive() {
        Object object = this.sendFlowControlObject;
        synchronized (object) {
            ++this.numSentReceived;
            this.sendFlowControlObject.notifyAll();
        }
    }

    final boolean waitForExpectedMessageReceipt(int expectedMessageCount) {
        for (int i = 0; i < 10; ++i) {
            System.out.println("received " + this.messageCount + "... (expected=" + expectedMessageCount + ")");
            if (this.messageCount < expectedMessageCount) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    final boolean waitForExpectedMessageStability(int expectedStabilityCount) {
        for (int i = 0; i < 20; ++i) {
            System.out.println("'" + this.stabilityCount + "' messages are stable (expect '" + expectedStabilityCount + "')...");
            if (this.stabilityCount < expectedStabilityCount) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    final boolean waitForMessagingStartFailEvent() {
        for (int i = 0; i < 20; ++i) {
            System.out.println("messaging start fail event still not received...nook");
            if (!this.receivedMessagingStartFailEvent) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            System.out.println("received messaging start fail event...ok");
            return true;
        }
        return false;
    }

    final boolean waitForEngineStoppedEvent() {
        for (int i = 0; i < 20; ++i) {
            System.out.println("engine stopped event still not received...nook");
            if (!this.receivedEngineStoppedEvent) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            System.out.println("received engine stopped event...ok");
            return true;
        }
        return false;
    }

    @EventHandler(source="channel4@aeptest1")
    public void onChannel4UpEventHandler(AepChannelUpEvent event) {
        this.channel = event.getMessageChannel();
    }

    @EventHandler
    public void onProtoMessageHandler(Message message) {
        ++this.messageCount;
        if (this.sender != null) {
            this.sender.onReceive();
        }
    }

    @EventHandler
    public void onStability(MessageStabilityEvent event) {
        ++this.stabilityCount;
    }

    @EventHandler
    public void onMemberUpEvent(StoreMemberUpEvent event) {
        ++this.memberUpEventCount;
    }

    @EventHandler
    public void onMemberDownEvent(StoreMemberDownEvent event) {
        ++this.memberDownEventCount;
    }

    @EventHandler
    public void onMessagingStartedEvent(AepMessagingStartedEvent event) {
        this.receivedMessagingStartFailEvent = event.getStatus() != null;
    }

    @EventHandler
    public void onEngineStoppedEvent(AepEngineStoppedEvent event) {
        this.receivedEngineStoppedEvent = event.getCause() != null;
    }
}

