/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.AepSFRTestAppBase;
import com.neeve.aep.test.unit.AepSFRTestBase;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.aep.test.unit.generated.xbuf.Child1;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageView;
import com.neeve.util.UtlReflection;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AepEngineRollbackTest
extends AepSFRTestBase {
    @Parameterized.Parameter(value=0)
    public boolean hasStore;
    @Parameterized.Parameter(value=1)
    public AepEngine.HAPolicy haPolicy;
    @Parameterized.Parameter(value=2)
    public boolean persistent;
    @Parameterized.Parameter(value=3)
    public boolean clustered;
    @Parameterized.Parameter(value=4)
    public AepEngineTestObject.EncodingType encoding;
    @Rule
    public ExpectedException storeRequiredForRollback = ExpectedException.none();
    public ExpectedException eventSourcingNoSupported = ExpectedException.none();
    private AepSFRTestBase.Sender sender;
    private AepSFRTestBase.Forwarder forwarder;
    private AepSFRTestBase.Forwarder forwarderBackup;
    private AepSFRTestBase.Receiver receiver;

    @Parameterized.Parameters(name="{index}: hasStore={0}, haPolicy={1}, persistent={2}, clustered={3}, encoding={4}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false, AepEngine.HAPolicy.EventSourcing, false, false, AepEngineTestObject.EncodingType.Proto}, {false, AepEngine.HAPolicy.StateReplication, false, false, AepEngineTestObject.EncodingType.Proto}, {true, AepEngine.HAPolicy.EventSourcing, true, false, AepEngineTestObject.EncodingType.Proto}, {true, AepEngine.HAPolicy.StateReplication, true, false, AepEngineTestObject.EncodingType.Proto}, {true, AepEngine.HAPolicy.EventSourcing, true, true, AepEngineTestObject.EncodingType.Proto}, {true, AepEngine.HAPolicy.StateReplication, true, true, AepEngineTestObject.EncodingType.Proto}, {false, AepEngine.HAPolicy.EventSourcing, false, false, AepEngineTestObject.EncodingType.Xbuf}, {false, AepEngine.HAPolicy.StateReplication, false, false, AepEngineTestObject.EncodingType.Xbuf}, {true, AepEngine.HAPolicy.EventSourcing, true, false, AepEngineTestObject.EncodingType.Xbuf}, {true, AepEngine.HAPolicy.StateReplication, true, false, AepEngineTestObject.EncodingType.Xbuf}, {true, AepEngine.HAPolicy.EventSourcing, true, true, AepEngineTestObject.EncodingType.Xbuf}, {true, AepEngine.HAPolicy.StateReplication, true, true, AepEngineTestObject.EncodingType.Xbuf}};
        return Arrays.asList(data);
    }

    @Override
    public String testCaseId() {
        String methodName = this.testcaseName.getMethodName();
        return methodName.substring(0, methodName.indexOf(":")).replace('[', '-');
    }

    @Before
    public void setupTestcase() {
        AepEngineRollbackTest.setVerbose((boolean)false);
        this.sender = this.createSender("standalone");
        this.sender.engineDescriptor.setEnableTransactionSavepoints(true);
        this.forwarder = (AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)this.createForwarder(this.clustered ? "primary" : "standalone").setStoreEnabled(this.hasStore)).setClustered(this.clustered)).setPersistent(this.persistent);
        this.forwarder.engineDescriptor.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.UseDedicated);
        this.forwarder.engineDescriptor.setAdaptiveCommitBatchCeiling(10);
        this.forwarder.engineDescriptor.setEnableTransactionSavepoints(true);
        if (this.clustered) {
            this.forwarderBackup = (AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)((AepSFRTestBase.Forwarder)this.createForwarder("backup").setStoreEnabled(this.hasStore)).setClustered(this.clustered)).setPersistent(this.persistent);
            this.forwarderBackup.engineDescriptor.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.UseDedicated);
            this.forwarderBackup.engineDescriptor.setAdaptiveCommitBatchCeiling(10);
            this.forwarderBackup.engineDescriptor.setEnableTransactionSavepoints(true);
        }
        this.receiver = this.createReceiver("standalone");
        this.receiver.engineDescriptor.setEnableTransactionSavepoints(true);
        this.receiver.engineDescriptor.setPerformDuplicateChecking(false);
        for (AepSFRTestAppBase app : this.apps) {
            app.engineDescriptor.setHAPolicy(this.haPolicy);
        }
        switch (this.encoding) {
            case Proto: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(Repository.class);
                    app.engineDescriptor.addStateFactory(com.neeve.aep.test.unit.generated.proto.Factory.class.getName());
                    this.sender.engineDescriptor.addMessageFactory(com.neeve.aep.test.unit.generated.proto.Factory.class.getName());
                }
                break;
            }
            case Xbuf: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(com.neeve.aep.test.unit.generated.xbuf.Repository.class);
                    app.engineDescriptor.addStateFactory(Factory.class.getName());
                    this.sender.engineDescriptor.addMessageFactory(Factory.class.getName());
                }
                break;
            }
            case Json: {
                for (AepSFRTestAppBase app : this.apps) {
                    app.setStateType(com.neeve.aep.test.unit.generated.json.Repository.class);
                    app.engineDescriptor.addStateFactory(com.neeve.aep.test.unit.generated.json.Factory.class.getName());
                    this.sender.engineDescriptor.addMessageFactory(com.neeve.aep.test.unit.generated.json.Factory.class.getName());
                }
                break;
            }
            case Raw: {
                throw new UnsupportedOperationException("Raw support not enabled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStateAndMessagePartialRollback() throws Throwable {
        if (!this.hasStore) {
            this.storeRequiredForRollback.expect(IllegalStateException.class);
            this.storeRequiredForRollback.expectMessage("Transaction savepoints are only supported when storage is enabled.");
        }
        StateAndMessagePartialRollbackHandler handler = new StateAndMessagePartialRollbackHandler(this.forwarder);
        this.forwarder.addEventHandler(handler);
        StateAndMessagePartialRollbackHandler backupHandler = null;
        if (this.clustered) {
            backupHandler = new StateAndMessagePartialRollbackHandler(this.forwarderBackup);
            this.forwarderBackup.addEventHandler(backupHandler);
        }
        this.startApps();
        this.sender.sendMessage(this.CHANNELS[0][1][0][1], AepEngineTestMessage.create(this.encoding, false).getMessage());
        this.forwarder.assertExpectedReceipt(5, 1);
        this.receiver.waitForMessages(5, 1);
        if (handler.handlerError != null) {
            throw handler.handlerError;
        }
        AepSFRTestAppBase.ChannelMessageTracker tracker = this.forwarder.getChannelMessageTracker(this.CHANNELS[1][1][0][1]);
        tracker.sentMessages.remove(0);
        --tracker.sentMessageCount;
        this.forwarder.sent.remove(0);
        --this.forwarder.sentMessageCount;
        try {
            this.receiver.assertExpectedReceipt(5, 1);
        }
        finally {
            this.assertSentAndReceivedMessageEqual(this.forwarder, this.receiver);
        }
        this.forwarder.engine.getOutboundMessageLogger().flush(true);
        this.assertOutboundMessagesLogged(this.forwarder);
        if (backupHandler != null) {
            if (backupHandler.handlerError != null) {
                throw backupHandler.handlerError;
            }
            if (this.haPolicy == AepEngine.HAPolicy.EventSourcing) {
                tracker = this.forwarderBackup.getChannelMessageTracker(this.CHANNELS[1][1][0][1]);
                tracker.sentMessages.remove(0);
                --tracker.sentMessageCount;
                this.forwarderBackup.sent.remove(0);
                --this.forwarderBackup.sentMessageCount;
                this.forwarderBackup.engine.getOutboundMessageLogger().flush(true);
                this.assertOutboundMessagesLogged(this.forwarderBackup);
                this.assertPrimaryAndBackupMessageEqual(this.forwarder, this.forwarderBackup);
            }
            if (this.persistent) {
                this.assertPrimaryAndBackupTransactionLogsDoNotDiverge(this.forwarder, this.forwarderBackup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPriorityOutboundMessageRollback() throws Throwable {
        if (!this.hasStore) {
            this.storeRequiredForRollback.expect(IllegalStateException.class);
            this.storeRequiredForRollback.expectMessage("Transaction savepoints are only supported when storage is enabled.");
        }
        PriorityOutboundMessageRollbackHandler handler = new PriorityOutboundMessageRollbackHandler(this.forwarder);
        this.forwarder.addEventHandler(handler);
        PriorityOutboundMessageRollbackHandler backupHandler = null;
        if (this.clustered) {
            backupHandler = new PriorityOutboundMessageRollbackHandler(this.forwarderBackup);
            this.forwarderBackup.addEventHandler(backupHandler);
        }
        this.startApps();
        this.sender.sendMessage(this.CHANNELS[0][1][0][1], AepEngineTestMessage.create(this.encoding, false).getMessage());
        this.forwarder.assertExpectedReceipt(5, 1);
        this.receiver.waitForMessages(5, 4);
        if (handler.handlerError != null) {
            throw handler.handlerError;
        }
        AepSFRTestAppBase.ChannelMessageTracker tracker = this.forwarder.getChannelMessageTracker(this.CHANNELS[1][1][0][1]);
        tracker.sentMessages.remove(2);
        --tracker.sentMessageCount;
        this.forwarder.sent.remove(2);
        --this.forwarder.sentMessageCount;
        tracker.sentMessages.remove(2);
        --tracker.sentMessageCount;
        this.forwarder.sent.remove(2);
        --this.forwarder.sentMessageCount;
        this.forwarder.engine.getOutboundMessageLogger().flush(true);
        this.assertOutboundMessagesLogged(this.forwarder);
        tracker.sentMessages.add(0, tracker.sentMessages.remove(1));
        this.forwarder.sent.add(0, this.forwarder.sent.remove(1));
        tracker.sentMessages.add(1, tracker.sentMessages.remove(3));
        this.forwarder.sent.add(1, this.forwarder.sent.remove(3));
        try {
            this.receiver.assertExpectedReceipt(5, 4);
        }
        finally {
            this.assertSentAndReceivedMessageEqual(this.forwarder, this.receiver);
        }
        if (backupHandler != null) {
            if (backupHandler.handlerError != null) {
                throw backupHandler.handlerError;
            }
            if (this.persistent) {
                this.assertPrimaryAndBackupTransactionLogsDoNotDiverge(this.forwarder, this.forwarderBackup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionBatchingRollbackBoundaries() throws Throwable {
        if (!this.hasStore) {
            this.storeRequiredForRollback.expect(IllegalStateException.class);
            this.storeRequiredForRollback.expectMessage("Transaction savepoints are only supported when storage is enabled.");
        }
        TransactionBatchingRollbackBoundariesHandler handler = new TransactionBatchingRollbackBoundariesHandler(this.forwarder);
        this.forwarder.addEventHandler(handler);
        TransactionBatchingRollbackBoundariesHandler backupHandler = null;
        if (this.clustered) {
            backupHandler = new TransactionBatchingRollbackBoundariesHandler(this.forwarderBackup);
            this.forwarderBackup.addEventHandler(backupHandler);
        }
        this.startApps();
        for (int i = 1; i <= 10; ++i) {
            IRogMessage m = AepEngineTestMessage.create(this.encoding, false).getMessage();
            UtlReflection.setNonNestedProperty((Object)m, (String)"stringField", (Object)("SenderSend " + i));
            if (i == 5) {
                Thread.sleep(2000L);
            }
            this.sender.sendMessage(this.CHANNELS[0][1][0][1], m);
        }
        this.forwarder.assertExpectedReceipt(5, 10);
        this.receiver.waitForMessages(5, handler.sentBeforeBatch);
        if (handler.handlerError != null) {
            throw handler.handlerError;
        }
        AepSFRTestAppBase.ChannelMessageTracker tracker = this.forwarder.getChannelMessageTracker(this.CHANNELS[1][1][0][1]);
        while (tracker.sentMessageCount > handler.sentBeforeBatch) {
            tracker.sentMessages.remove(tracker.sentMessages.size() - 1);
            --tracker.sentMessageCount;
            this.forwarder.sent.remove(this.forwarder.sent.size() - 1);
            --this.forwarder.sentMessageCount;
        }
        try {
            this.receiver.assertExpectedReceipt(5, this.forwarder.sentMessageCount);
        }
        finally {
            this.assertSentAndReceivedMessageEqual(this.forwarder, this.receiver);
        }
        this.forwarder.engine.getOutboundMessageLogger().flush(true);
        this.assertOutboundMessagesLogged(this.forwarder);
        Assert.assertTrue((String)"Forwarder never hit a transaction batch", (boolean)handler.hitTxnBatch);
        if (backupHandler != null && backupHandler.handlerError != null) {
            throw backupHandler.handlerError;
        }
    }

    @Test
    @Ignore
    public void testMultiHandlerRollback() {
        Assert.fail((String)"Not yet implemented");
    }

    private final void setEntityFieldIntField(Object rootState, int value) {
        switch (this.encoding) {
            case Proto: {
                Repository state = (Repository)rootState;
                if (!state.hasEntityField()) {
                    state.setEntityField(com.neeve.aep.test.unit.generated.proto.Child1.create());
                }
                state.getEntityField().setIntField(value);
                break;
            }
            case Xbuf: {
                com.neeve.aep.test.unit.generated.xbuf.Repository state = (com.neeve.aep.test.unit.generated.xbuf.Repository)rootState;
                if (!state.hasEntityField()) {
                    state.setEntityField(Child1.create());
                }
                state.getEntityField().setIntField(value);
                break;
            }
            case Json: {
                com.neeve.aep.test.unit.generated.json.Repository state = (com.neeve.aep.test.unit.generated.json.Repository)rootState;
                if (!state.hasEntityField()) {
                    state.setEntityField(com.neeve.aep.test.unit.generated.json.Child1.create());
                }
                state.getEntityField().setIntField(value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported encoding");
            }
        }
    }

    private final int getEntityFieldIntField(Object rootState) {
        switch (this.encoding) {
            case Proto: {
                Repository state = (Repository)rootState;
                if (!state.hasEntityField()) {
                    return -1;
                }
                return state.getEntityField().getIntField();
            }
            case Xbuf: {
                com.neeve.aep.test.unit.generated.xbuf.Repository state = (com.neeve.aep.test.unit.generated.xbuf.Repository)rootState;
                if (!state.hasEntityField()) {
                    return -1;
                }
                return state.getEntityField().getIntField();
            }
            case Json: {
                com.neeve.aep.test.unit.generated.json.Repository state = (com.neeve.aep.test.unit.generated.json.Repository)rootState;
                if (!state.hasEntityField()) {
                    return -1;
                }
                return state.getEntityField().getIntField();
            }
        }
        throw new UnsupportedOperationException("Unsupported encoding");
    }

    private class TransactionBatchingRollbackBoundariesHandler
    extends MessageHandler {
        volatile int invocationCount;
        volatile int sentBeforeBatch;
        long lastTxn;
        volatile boolean hitTxnBatch;
        AepSFRTestBase.Forwarder forwarder;

        TransactionBatchingRollbackBoundariesHandler(AepSFRTestBase.Forwarder forwarder) {
            this.invocationCount = 0;
            this.sentBeforeBatch = 0;
            this.lastTxn = 0L;
            this.hitTxnBatch = false;
            this.forwarder = forwarder;
        }

        @Override
        public void handle(MessageView message, Object state) throws Exception {
            ++this.invocationCount;
            long txnId = ((IRogMessage)message).getTransactionId();
            int txnInSeqNo = ((IRogMessage)message).getTransactionInSequenceNumber();
            boolean inBatch = txnId == this.lastTxn;
            this.lastTxn = txnId;
            if (this.invocationCount == 1) {
                Thread.sleep(2000L);
                Assert.assertEquals((String)("Unexpected transactionInSequenceNum on invocation " + this.invocationCount), (long)1L, (long)txnInSeqNo);
            }
            System.out.println("Received Message txn=" + txnId + " inseqno=" + txnInSeqNo + " (in batch=" + inBatch + ")");
            Assert.assertEquals((String)("Unexpected initial savepoint on invocation " + this.invocationCount), (long)0L, (long)this.forwarder.engine.getTransactionSavepoint());
            AepEngineRollbackTest.this.setEntityFieldIntField(state, AepEngineRollbackTest.this.getEntityFieldIntField(state) + 1);
            IRogMessage m1 = AepEngineTestMessage.create(AepEngineRollbackTest.this.encoding, false).getMessage();
            UtlReflection.setNonNestedProperty((Object)m1, (String)"stringField", (Object)(txnInSeqNo + ":ForwarderSendFrom invocation " + this.invocationCount));
            this.forwarder.sendMessage(AepEngineRollbackTest.this.CHANNELS[1][1][0][1], m1);
            this.hitTxnBatch |= inBatch;
            if (this.hitTxnBatch) {
                this.forwarder.engine.rollbackToTransactionSavepoint(0);
            } else {
                ++this.sentBeforeBatch;
            }
        }
    }

    private class PriorityOutboundMessageRollbackHandler
    extends MessageHandler {
        AepSFRTestBase.Forwarder forwarder;

        PriorityOutboundMessageRollbackHandler(AepSFRTestBase.Forwarder forwarder) {
            this.forwarder = forwarder;
        }

        @Override
        public void handle(MessageView message, Object state) throws Exception {
            Assert.assertEquals((String)"Unexpected initial savepoint", (long)0L, (long)this.forwarder.engine.getTransactionSavepoint());
            AepEngineRollbackTest.this.setEntityFieldIntField(state, 1);
            IRogMessage m1 = AepEngineTestMessage.create(AepEngineRollbackTest.this.encoding, false).getMessage();
            UtlReflection.setNonNestedProperty((Object)m1, (String)"stringField", (Object)"1:ForwarderNormalSend");
            this.forwarder.sendMessage(AepEngineRollbackTest.this.CHANNELS[1][1][0][1], m1);
            IRogMessage m2 = AepEngineTestMessage.create(AepEngineRollbackTest.this.encoding, false).getMessage();
            UtlReflection.setNonNestedProperty((Object)m2, (String)"stringField", (Object)"2:ForwarderPrioritySend");
            m2.setAsPriority();
            this.forwarder.sendMessage(AepEngineRollbackTest.this.CHANNELS[1][1][0][1], m2);
            int savepoint = this.forwarder.engine.createTransactionSavepoint();
            AepEngineRollbackTest.this.setEntityFieldIntField(state, 2);
            IRogMessage m3 = AepEngineTestMessage.create(AepEngineRollbackTest.this.encoding, false).getMessage();
            UtlReflection.setNonNestedProperty((Object)m3, (String)"stringField", (Object)"3:Forwarder Normal Send Should Be Rolled Back");
            this.forwarder.sendMessage(AepEngineRollbackTest.this.CHANNELS[1][1][0][1], m3);
            IRogMessage m4 = AepEngineTestMessage.create(AepEngineRollbackTest.this.encoding, false).getMessage();
            UtlReflection.setNonNestedProperty((Object)m4, (String)"stringField", (Object)"4:Forwarder Priority Send Should Be Rolled Back");
            m4.setAsPriority();
            this.forwarder.sendMessage(AepEngineRollbackTest.this.CHANNELS[1][1][0][1], m4);
            this.forwarder.engine.rollbackToTransactionSavepoint(savepoint);
            Assert.assertEquals((String)"Int field was not rolled back", (long)(AepEngineRollbackTest.this.haPolicy == AepEngine.HAPolicy.StateReplication ? 1L : 2L), (long)AepEngineRollbackTest.this.getEntityFieldIntField(state));
            IRogMessage m5 = AepEngineTestMessage.create(AepEngineRollbackTest.this.encoding, false).getMessage();
            UtlReflection.setNonNestedProperty((Object)m5, (String)"stringField", (Object)"5:Forwarder Normal Send after Rollback");
            this.forwarder.sendMessage(AepEngineRollbackTest.this.CHANNELS[1][1][0][1], m5);
            IRogMessage m6 = AepEngineTestMessage.create(AepEngineRollbackTest.this.encoding, false).getMessage();
            m6.setAsPriority();
            UtlReflection.setNonNestedProperty((Object)m6, (String)"stringField", (Object)"6:Forwarder Priority Send after Rollback");
            this.forwarder.sendMessage(AepEngineRollbackTest.this.CHANNELS[1][1][0][1], m6);
        }
    }

    private class StateAndMessagePartialRollbackHandler
    extends MessageHandler {
        AepSFRTestBase.Forwarder forwarder;

        StateAndMessagePartialRollbackHandler(AepSFRTestBase.Forwarder forwarder) {
            this.forwarder = forwarder;
        }

        @Override
        public void handle(MessageView message, Object state) throws Exception {
            Assert.assertEquals((String)"Unexpected initial savepoint", (long)0L, (long)this.forwarder.engine.getTransactionSavepoint());
            AepEngineRollbackTest.this.setEntityFieldIntField(state, 1);
            int savepoint = this.forwarder.engine.createTransactionSavepoint();
            AepEngineRollbackTest.this.setEntityFieldIntField(state, 2);
            IRogMessage m1 = AepEngineTestMessage.create(AepEngineRollbackTest.this.encoding, false).getMessage();
            UtlReflection.setNonNestedProperty((Object)m1, (String)"stringField", (Object)"1:ForwarderShouldBeRolledBack");
            this.forwarder.sendMessage(AepEngineRollbackTest.this.CHANNELS[1][1][0][1], m1);
            this.forwarder.engine.rollbackToTransactionSavepoint(savepoint);
            Assert.assertEquals((String)"Int field was not rolled back", (long)(AepEngineRollbackTest.this.haPolicy == AepEngine.HAPolicy.StateReplication ? 1L : 2L), (long)AepEngineRollbackTest.this.getEntityFieldIntField(state));
            IRogMessage m2 = AepEngineTestMessage.create(AepEngineRollbackTest.this.encoding, false).getMessage();
            UtlReflection.setNonNestedProperty((Object)m2, (String)"stringField", (Object)"1:ForwarderShouldNotBeRolledBack");
            this.forwarder.sendMessage(AepEngineRollbackTest.this.CHANNELS[1][1][0][1], m2);
        }
    }

    public abstract class MessageHandler {
        protected Object state;
        volatile Throwable handlerError;

        @EventHandler
        public void onProtoMessage(com.neeve.aep.test.unit.generated.proto.Message message) {
            this.handleInternal((MessageView)message);
        }

        @EventHandler
        public void onXbufMessage(com.neeve.aep.test.unit.generated.xbuf.Message message) {
            this.handleInternal((MessageView)message);
        }

        @EventHandler
        public void onJsonMessage(Message message) {
            this.handleInternal((MessageView)message);
        }

        private void handleInternal(MessageView message) {
            try {
                this.handle(message, this.getState(message));
            }
            catch (Throwable t) {
                this.handlerError = t;
            }
        }

        protected Object getState(MessageView message) {
            if (AepEngineRollbackTest.this.haPolicy == AepEngine.HAPolicy.StateReplication) {
                this.state = ((AepEngineRollbackTest)AepEngineRollbackTest.this).forwarder.engine.getApplicationState(message);
            } else if (this.state == null) {
                switch (AepEngineRollbackTest.this.encoding) {
                    case Json: {
                        this.state = com.neeve.aep.test.unit.generated.json.Repository.create();
                        break;
                    }
                    case Proto: {
                        this.state = Repository.create();
                        break;
                    }
                    case Xbuf: {
                        this.state = com.neeve.aep.test.unit.generated.xbuf.Repository.create();
                        break;
                    }
                }
            }
            return this.state;
        }

        public abstract void handle(MessageView var1, Object var2) throws Exception;
    }
}

