/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.test.unit.AepEngineReplicationTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ci.XRuntime;
import com.neeve.ods.StoreDescriptor;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.sma.MessageChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AepEngineReplicationTest
extends AepEngineTest {
    private static final boolean USE_DEEP_COMPARISON = false;
    private static final HashSet<String> DIVERGENT_FIELD_EXCEPTIONS = new HashSet();
    private static final RogLogUtil.FieldFilter METADATA_ONLY_FILTER;
    private static final RogLogUtil.FieldFilter METADATA_AND_PAYLOAD_FILTER;
    private static final int LAST_BURST_MESSAGE_COUNT = 1000;
    private static final int LAST_BURST_MESSAGE_COUNT_ICR = 500;

    static final void compareMetadata(IRogMessage message1, IRogMessage message2) {
        Assert.assertNotSame((Object)message1, (Object)message2);
        Assert.assertEquals((Object)message1.getMessageBus(), (Object)message2.getMessageBus());
        Assert.assertEquals((Object)message1.getMessageChannel(), (Object)message2.getMessageChannel());
        Assert.assertEquals((Object)message1.getMessageKey(), (Object)message2.getMessageKey());
        Assert.assertEquals((long)message1.getMessageSender(), (long)message2.getMessageSender());
        Assert.assertEquals((long)message1.getMessageFlow(), (long)message2.getMessageFlow());
        Assert.assertEquals((long)message1.getMessageSequenceNumber(), (long)message2.getMessageSequenceNumber());
        Assert.assertEquals((long)message1.getGraphId(), (long)message2.getGraphId());
        Assert.assertEquals((Object)message1.getParentId(), (Object)message2.getParentId());
        Assert.assertEquals((long)message1.getTransactionId(), (long)message2.getTransactionId());
        Assert.assertEquals((long)message1.getStableTransactionId(), (long)message2.getStableTransactionId());
        Assert.assertEquals((long)message1.getPreProcessingTs(), (long)message2.getPreProcessingTs());
        Assert.assertEquals((Object)message1.isPossibleDuplicate(), (Object)message2.isPossibleDuplicate());
        Assert.assertEquals((Object)message1.getInMsgsInTransaction(), (Object)message2.getInMsgsInTransaction());
        Assert.assertEquals((Object)message1.getOutMsgsInTransaction(), (Object)message2.getOutMsgsInTransaction());
    }

    static final void compareMetadata(ArrayList<IRogMessage> list1, ArrayList<IRogMessage> list2) {
        Assert.assertEquals((long)list1.size(), (long)list2.size());
        int size = list1.size();
        for (int i = 0; i < size; ++i) {
            try {
                AepEngineReplicationTest.compareMetadata(list1.get(i), list2.get(i));
                continue;
            }
            catch (Error re) {
                StringBuffer buffer = new StringBuffer();
                try {
                    RogLogUtil.compareRogNodes((IRogNode)((IRogNode)list1.get(i)), (IRogNode)((IRogNode)list2.get(i)), null, (StringBuffer)buffer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.err.println("Divergent message #" + i + ": " + buffer.toString());
                throw re;
            }
        }
    }

    static final void compareData(List<AepEngineTestMessage> expected, List<IRogMessage> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        int size = expected.size();
        for (int i = 0; i < size; ++i) {
            expected.get(i).compareAgainst(actual.get(i));
        }
    }

    static final void compareData1(List<IRogMessage> expected, List<IRogMessage> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        int size = expected.size();
        for (int i = 0; i < size; ++i) {
            AepEngineTestMessage.compare(expected.get(i), actual.get(i));
        }
    }

    private final void send(MessageChannel channel, ArrayList<AepEngineTestMessage> messages, AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage message = new AepEngineTestMessage(encodingType);
        messages.add(message);
        if (((AepEngine)((Object)this.engines.get(0))).getDescriptor().getDisposeOnSend()) {
            message.getMessage().acquire();
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(channel, message.getMessage());
        }
    }

    private final void testReplicationEventSourcing(int adaptiveCommitBatchCeiling, boolean guaranteed, boolean persistent, boolean detachedPersister, boolean readMessages, boolean updateMessages, boolean holdMessagesOnPrimary, boolean holdMessagesOnBackup, AepEngineTestObject.EncodingType encodingType, boolean icrReceiver) throws Exception {
        int i;
        AepEngineReplicationTestApp sender = super.registerTestApp(new AepEngineReplicationTestApp());
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineReplicationTestApp receiver1 = super.registerTestApp(new AepEngineReplicationTestApp());
        receiver1.readMessages = readMessages;
        receiver1.updateMessages = updateMessages;
        receiver1.holdMessages = holdMessagesOnPrimary;
        AepEngineReplicationTestApp receiver2 = super.registerTestApp(new AepEngineReplicationTestApp());
        receiver2.readMessages = readMessages;
        receiver2.updateMessages = updateMessages;
        receiver2.holdMessages = holdMessagesOnBackup;
        AepEngineReplicationTestApp receiver3 = super.registerTestApp(new AepEngineReplicationTestApp());
        receiver3.readMessages = readMessages;
        receiver3.updateMessages = updateMessages;
        receiver3.holdMessages = holdMessagesOnBackup;
        int clusterHeartbeatInterval = 1000;
        if (icrReceiver) {
            this.startSenderStandaloneReceiverRedundantWithICRReceiver(sender, null, receiverName, receiver1, null, receiver2, null, receiver3, null, guaranteed ? 15 : 1, guaranteed ? 15 : 1, guaranteed ? 15 : 1, 0, AepEngine.HAPolicy.EventSourcing, persistent, detachedPersister, false, adaptiveCommitBatchCeiling, encodingType, clusterHeartbeatInterval);
        } else {
            this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, guaranteed ? 15 : 1, guaranteed ? 15 : 1, guaranteed ? 15 : 1, 0, AepEngine.HAPolicy.EventSourcing, persistent, detachedPersister, false, adaptiveCommitBatchCeiling, encodingType);
        }
        ArrayList<AepEngineTestMessage> messages = new ArrayList<AepEngineTestMessage>();
        for (i = 0; i < 10; ++i) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        Thread.sleep(1000L);
        for (i = 0; i < 10; ++i) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        Thread.sleep(1000L);
        for (i = 0; i < 100; ++i) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        Thread.sleep(1000L);
        for (i = 0; i < 1000; ++i) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        if (holdMessagesOnPrimary) {
            Assert.assertTrue((boolean)receiver1.waitForExpectedMessageReceipt(1120));
            Assert.assertEquals((long)1120L, (long)receiver1.messages.size());
        }
        if (holdMessagesOnBackup) {
            Assert.assertTrue((boolean)receiver2.waitForExpectedMessageReceipt(1120));
            Assert.assertEquals((long)1120L, (long)receiver2.messages.size());
        }
        if (holdMessagesOnPrimary && holdMessagesOnBackup) {
            AepEngineReplicationTest.compareMetadata(receiver1.messages, receiver2.messages);
        }
        if (!updateMessages) {
            if (holdMessagesOnPrimary) {
                AepEngineReplicationTest.compareData(messages, receiver1.messages);
            }
            if (holdMessagesOnBackup) {
                AepEngineReplicationTest.compareData(messages, receiver2.messages);
            }
        } else if (holdMessagesOnPrimary && holdMessagesOnBackup) {
            AepEngineReplicationTest.compareData1(receiver1.messages, receiver2.messages);
        }
        if (guaranteed && persistent && !detachedPersister) {
            AepEngine primaryEngine = (AepEngine)((Object)this.engines.get(1));
            AepEngine backupEngine = (AepEngine)((Object)this.engines.get(2));
            this.waitForTransactionPipelineToEmpty(primaryEngine);
            this.waitForTransactionPipelineToEmpty(backupEngine);
            Assert.assertEquals((long)((RogLog)primaryEngine.getStore().getPersister()).getSize(), (long)((RogLog)backupEngine.getStore().getPersister()).getSize());
        }
    }

    private final void testReplicationEventSourcingFailover(int adaptiveCommitBatchCeiling, boolean guaranteed, boolean persistent, boolean detachedPersister, boolean readMessages, boolean updateMessages, boolean holdMessagesOnPrimary, boolean holdMessagesOnBackup, AepEngineTestObject.EncodingType encodingType, boolean icrReceiver) throws Exception {
        int i;
        int i2;
        int LAST_BURST_MESSAGE_COUNT;
        AepEngineReplicationTestApp sender = super.registerTestApp(new AepEngineReplicationTestApp());
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineReplicationTestApp receiver1 = super.registerTestApp(new AepEngineReplicationTestApp());
        receiver1.readMessages = readMessages;
        receiver1.updateMessages = updateMessages;
        receiver1.holdMessages = holdMessagesOnPrimary;
        AepEngineReplicationTestApp receiver2 = super.registerTestApp(new AepEngineReplicationTestApp());
        receiver2.readMessages = readMessages;
        receiver2.updateMessages = updateMessages;
        receiver2.holdMessages = holdMessagesOnBackup;
        AepEngineReplicationTestApp receiver3 = super.registerTestApp(new AepEngineReplicationTestApp());
        receiver3.readMessages = readMessages;
        receiver3.updateMessages = updateMessages;
        receiver3.holdMessages = holdMessagesOnBackup;
        int clusterHearbeatInterval = 1000;
        if (icrReceiver) {
            LAST_BURST_MESSAGE_COUNT = 500;
            this.startSenderStandaloneReceiverRedundantWithICRReceiver(sender, null, receiverName, receiver1, null, receiver2, null, receiver3, null, guaranteed ? 15 : 1, guaranteed ? 15 : 1, guaranteed ? 15 : 1, 0, AepEngine.HAPolicy.EventSourcing, persistent, detachedPersister, false, adaptiveCommitBatchCeiling, encodingType, 1000);
        } else {
            LAST_BURST_MESSAGE_COUNT = 1000;
            this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, guaranteed ? 15 : 1, guaranteed ? 15 : 1, guaranteed ? 15 : 1, 0, AepEngine.HAPolicy.EventSourcing, persistent, detachedPersister, false, adaptiveCommitBatchCeiling, encodingType);
        }
        receiver1.engine = (AepEngine)((Object)this.engines.get(1));
        receiver2.engine = (AepEngine)((Object)this.engines.get(2));
        receiver3.engine = (AepEngine)((Object)this.engines.get(3));
        ArrayList<AepEngineTestMessage> messages = new ArrayList<AepEngineTestMessage>();
        for (i2 = 0; i2 < 100; ++i2) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("Killing primary engine...");
                ((AepEngine)((Object)AepEngineReplicationTest.this.engines.get(1))).getStore().fail(new Exception("Intentionally Failing"));
                System.out.println("Killed primary engine...");
            }
        }, "Primary Killer").start();
        for (i2 = 0; i2 < LAST_BURST_MESSAGE_COUNT - 100; ++i2) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        AepEngineTest.BaseEngineCusomizer icrSender1Customizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setInterClusterReplicationQuorum(2);
                descriptor.setInterClusterReplicator("icrSender2");
            }

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setClusterHeartbeatInterval(1000);
            }
        };
        receiver1.clear();
        receiver1 = new AepEngineReplicationTestApp();
        receiver1.readMessages = readMessages;
        receiver1.updateMessages = updateMessages;
        receiver1.holdMessages = holdMessagesOnPrimary;
        System.out.println("===>RESTARTING FORMER PRIMARY");
        AepEngine primaryEngineReincarnate = this.createEngine(((AepEngine)((Object)this.engines.get(1))).getDescriptor().getName(), AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, persistent, detachedPersister, false, XRuntime.getDataDirectory() + File.separator + "m1", guaranteed ? 15 : 1, guaranteed ? 15 : 1, receiver1, null, null, adaptiveCommitBatchCeiling, false, false, null, null, null, false, false, icrSender1Customizer);
        primaryEngineReincarnate.start();
        for (i = 0; i < 100; ++i) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("Killing backup engine...");
                ((AepEngine)((Object)AepEngineReplicationTest.this.engines.get(2))).getStore().fail(new Exception("Intentionally Failing"));
                System.out.println("Killed backup engine...");
            }
        }, "Backup Killer").start();
        for (i = 0; i < LAST_BURST_MESSAGE_COUNT - 100; ++i) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        receiver2.clear();
        receiver2 = new AepEngineReplicationTestApp();
        receiver2.readMessages = readMessages;
        receiver2.updateMessages = updateMessages;
        receiver2.holdMessages = holdMessagesOnPrimary;
        System.out.println("===>RESTARTING BACKUP");
        AepEngine backupEngineReincarnate = this.createEngine(((AepEngine)((Object)this.engines.get(1))).getDescriptor().getName(), AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, persistent, detachedPersister, false, XRuntime.getDataDirectory() + File.separator + "m1", guaranteed ? 15 : 1, guaranteed ? 15 : 1, receiver2, null, null, adaptiveCommitBatchCeiling, false, false, null, null, null, false, false, icrSender1Customizer);
        backupEngineReincarnate.start();
        if (holdMessagesOnPrimary) {
            Assert.assertTrue((String)"Primary receiver didn't receive all messages", (boolean)receiver1.waitForExpectedMessageReceipt(LAST_BURST_MESSAGE_COUNT * 2));
            Assert.assertEquals((String)"Primary receiver has incorrect message count", (long)(LAST_BURST_MESSAGE_COUNT * 2), (long)receiver1.messages.size());
        }
        if (holdMessagesOnBackup) {
            Assert.assertTrue((String)"Backup receiver didn't receive all messages", (boolean)receiver2.waitForExpectedMessageReceipt(LAST_BURST_MESSAGE_COUNT * 2));
            Assert.assertEquals((String)"Backup receiver has incorrect message count", (long)(LAST_BURST_MESSAGE_COUNT * 2), (long)receiver2.messages.size());
            if (icrReceiver) {
                Assert.assertTrue((String)"ICR receiver didn't receive all messages", (boolean)receiver3.waitForExpectedMessageReceipt(LAST_BURST_MESSAGE_COUNT * 2));
                Assert.assertEquals((String)"ICR receiver has incorrect message count", (long)(LAST_BURST_MESSAGE_COUNT * 2), (long)receiver3.messages.size());
            }
        }
        if (holdMessagesOnPrimary && holdMessagesOnBackup) {
            AepEngineReplicationTest.compareMetadata(receiver1.messages, receiver2.messages);
        }
        if (!updateMessages) {
            if (holdMessagesOnPrimary) {
                AepEngineReplicationTest.compareData(messages, receiver1.messages);
            }
            if (holdMessagesOnBackup) {
                AepEngineReplicationTest.compareData(messages, receiver2.messages);
            }
        } else if (holdMessagesOnPrimary && holdMessagesOnBackup) {
            AepEngineReplicationTest.compareData1(receiver1.messages, receiver2.messages);
        }
        backupEngineReincarnate.stop();
        primaryEngineReincarnate.stop();
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_NoReadNoUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_NoReadNoUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_NoReadNoUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, false, false, true, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadWithoutUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadWithoutUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadWithoutUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, true, false, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_UpdateWithoutRead_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_UpdateWithoutRead_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_UpdateWithoutRead_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_NonPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_AttachedPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Async_DetachedPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_NonPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(0, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_NonPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_AttachedPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Async_DetachedPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, false, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_NonPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, false, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, true, false, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Xbuf() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Xbuf, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Proto() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Proto, false);
    }

    @Test
    public void testReplication_EventSourcing_NonDefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Json() throws Exception {
        this.testReplicationEventSourcing(64, true, true, true, true, true, false, true, AepEngineTestObject.EncodingType.Json, false);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_AdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Xbuf_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(64, true, true, true, true, true, true, true, AepEngineTestObject.EncodingType.Xbuf, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_AdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Xbuf_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(64, true, true, false, true, true, true, true, AepEngineTestObject.EncodingType.Xbuf, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_AdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Proto_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(64, true, true, true, true, true, true, true, AepEngineTestObject.EncodingType.Proto, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_AdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Proto_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(64, true, true, false, true, true, true, true, AepEngineTestObject.EncodingType.Proto, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_AdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Json_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(64, true, true, true, true, true, true, true, AepEngineTestObject.EncodingType.Json, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_AdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Json_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(64, true, true, false, true, true, true, true, AepEngineTestObject.EncodingType.Json, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Xbuf_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(0, true, true, true, true, true, true, true, AepEngineTestObject.EncodingType.Xbuf, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Xbuf_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(0, true, true, false, true, true, true, true, AepEngineTestObject.EncodingType.Xbuf, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Proto_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(0, true, true, true, true, true, true, true, AepEngineTestObject.EncodingType.Proto, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Proto_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(0, true, true, false, true, true, true, true, AepEngineTestObject.EncodingType.Proto, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_DetachedPersistent_ReadAndUpdate_Json_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(0, true, true, true, true, true, true, true, AepEngineTestObject.EncodingType.Json, true);
    }

    @Test
    @Ignore
    public void testReplication_EventSourcing_DefaultAdaptiveCommit_Pipelined_AttachedPersistent_ReadAndUpdate_Json_Failover_ICR() throws Exception {
        this.testReplicationEventSourcingFailover(0, true, true, false, true, true, true, true, AepEngineTestObject.EncodingType.Json, true);
    }

    @Test
    @Ignore
    public void testMessageComparison() throws Exception {
        IRogMessage message1 = AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Xbuf).getMessage();
        IRogMessage message2 = AepEngineTestMessage.create(AepEngineTestObject.EncodingType.Xbuf).getMessage();
        message2.deserializeFromByteArray(message1.serializeToByteArray());
        StringBuffer diffs = new StringBuffer();
        long start = System.nanoTime();
        for (int i = 0; i < 100000000; ++i) {
            RogLogUtil.compareRogNodes((IRogNode)message1, (IRogNode)message2, (RogLogUtil.FieldFilter)METADATA_AND_PAYLOAD_FILTER, (StringBuffer)diffs);
        }
        long end = System.nanoTime();
        System.out.println("Compared in " + (end - start) / 1000000L + "ms");
    }

    static {
        DIVERGENT_FIELD_EXCEPTIONS.add("ownershipCount");
        System.setProperty("nv.optimizefor", "latency");
        System.setProperty("nv.conservecpu", "true");
        METADATA_ONLY_FILTER = new RogLogUtil.FieldFilter(){
            RogLogUtil.FieldFilter defaultFilter;

            public boolean filter(Class<?> type, String path) {
                if (this.defaultFilter == null) {
                    try {
                        this.defaultFilter = RogLogUtil.loadComparisonFilter();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading comparison filter", e);
                    }
                }
                if (this.defaultFilter.filter(type, path) || DIVERGENT_FIELD_EXCEPTIONS.contains(path)) {
                    return true;
                }
                if (IRogMetadata.class.isAssignableFrom(type)) {
                    return false;
                }
                if (IRogNode.class.isAssignableFrom(type)) {
                    return !path.equalsIgnoreCase("metadata");
                }
                return true;
            }
        };
        METADATA_AND_PAYLOAD_FILTER = new RogLogUtil.FieldFilter(){
            RogLogUtil.FieldFilter defaultFilter;

            public final boolean filter(Class<?> type, String path) {
                if (this.defaultFilter == null) {
                    try {
                        this.defaultFilter = RogLogUtil.loadComparisonFilter();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading comparison filter", e);
                    }
                }
                return this.defaultFilter.filter(type, path) || DIVERGENT_FIELD_EXCEPTIONS.contains(path);
            }
        };
    }
}

