/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.test.unit.AepEngineMessageBusBindingFailTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.ci.XRuntime;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineMessageBusBindingFailTest
extends AepEngineTest {
    private int engineCounter = 0;

    private final String createEnginesForClusteredTest(Object instance1, Object instance2, AepEngine.MessageBusBindingFailPolicy messageBusBindingFailPolicy, int channelMask) throws Exception {
        String engineName = "engine-" + System.currentTimeMillis() + "-" + this.engineCounter++;
        this.createEngine(engineName, null, null, messageBusBindingFailPolicy, null, null, true, false, false, false, XRuntime.getDataDirectory() + File.separator + "m1", channelMask, channelMask, instance1, null, null, 0, false, false, null, null, null, false, false);
        this.createEngine(engineName, null, null, messageBusBindingFailPolicy, null, null, true, false, false, false, XRuntime.getDataDirectory() + File.separator + "m2", channelMask, channelMask, instance2, null, null, 0, false, false, null, null, null, false, false);
        return engineName;
    }

    @Test
    public void testStandaloneFailIfAnyBindingFailsOneBindingFail() throws Exception {
        AepEngineMessageBusBindingFailTestApp app = new AepEngineMessageBusBindingFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, null, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        engine.start();
        engine.waitForMessagingToStart();
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        this.messagingController.failBinding("aeptest1", "engine1");
        Assert.assertTrue((boolean)app.waitForBindingToFail());
        Assert.assertTrue((boolean)app.waitForMessagingToFail());
        Assert.assertTrue((boolean)app.waitForEngineToStop());
        Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertEquals((long)1L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)1L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)1L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingFailedEventCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusteredFailIfAnyBindingFailsOneBindingFail() throws Exception {
        AepEngineMessageBusBindingFailTestApp app1 = new AepEngineMessageBusBindingFailTestApp();
        AepEngineMessageBusBindingFailTestApp app2 = new AepEngineMessageBusBindingFailTestApp();
        app2.waitInMemberDown = true;
        String engineName = this.createEnginesForClusteredTest(app1, app2, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, 1);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine1.getMessagingState()));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
        engine2.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
        this.messagingController.failBinding("aeptest1", engineName);
        try {
            Assert.assertTrue((boolean)app1.waitForBindingToFail());
            Assert.assertTrue((boolean)app1.waitForMessagingToFail());
            Assert.assertTrue((boolean)app1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertEquals((long)1L, (long)app1.channelUpEventCount);
            Assert.assertEquals((long)1L, (long)app1.bindingUpEventCount);
            Assert.assertEquals((long)1L, (long)app1.channelDownEventCount);
            Assert.assertEquals((long)1L, (long)app1.bindingDownEventCount);
            Assert.assertEquals((long)1L, (long)app1.messagingFailedEventCount);
        }
        finally {
            app2.releaseFromMemberDown();
        }
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
        Assert.assertEquals((long)1L, (long)app2.channelUpEventCount);
        Assert.assertEquals((long)1L, (long)app2.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app2.channelDownEventCount);
        Assert.assertEquals((long)0L, (long)app2.bindingDownEventCount);
        Assert.assertEquals((long)0L, (long)app2.messagingFailedEventCount);
    }

    @Test
    public void testStandaloneFailIfAnyBindingFailsTwoBindingsOneFail() throws Exception {
        AepEngineMessageBusBindingFailTestApp app = new AepEngineMessageBusBindingFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, null, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        engine.start();
        engine.waitForMessagingToStart();
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)3L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)2L, (long)app.bindingUpEventCount);
        this.messagingController.failBinding("aeptest1", "engine1");
        Assert.assertTrue((boolean)app.waitForBindingToFail());
        Assert.assertTrue((boolean)app.waitForMessagingToFail());
        Assert.assertTrue((boolean)app.waitForEngineToStop());
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
        Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)2L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingFailedEventCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusteredFailIfAnyBindingFailsTwoBindingsOneFail() throws Exception {
        AepEngineMessageBusBindingFailTestApp app1 = new AepEngineMessageBusBindingFailTestApp();
        AepEngineMessageBusBindingFailTestApp app2 = new AepEngineMessageBusBindingFailTestApp();
        app2.waitInMemberDown = true;
        String engineName = this.createEnginesForClusteredTest(app1, app2, AepEngine.MessageBusBindingFailPolicy.FailIfAnyBindingFails, 67);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine1.getMessagingState()));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
        engine2.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
        this.messagingController.failBinding("aeptest1", engineName);
        try {
            Assert.assertTrue((boolean)app1.waitForBindingToFail());
            Assert.assertTrue((boolean)app1.waitForMessagingToFail());
            Assert.assertTrue((boolean)app1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
            Assert.assertEquals((long)3L, (long)app1.channelUpEventCount);
            Assert.assertEquals((long)2L, (long)app1.bindingUpEventCount);
            Assert.assertEquals((long)2L, (long)app1.channelDownEventCount);
            Assert.assertEquals((long)1L, (long)app1.bindingDownEventCount);
            Assert.assertEquals((long)1L, (long)app1.messagingFailedEventCount);
        }
        finally {
            app2.releaseFromMemberDown();
        }
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
        Assert.assertEquals((long)3L, (long)app2.channelUpEventCount);
        Assert.assertEquals((long)2L, (long)app2.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app2.channelDownEventCount);
        Assert.assertEquals((long)0L, (long)app2.bindingDownEventCount);
        Assert.assertEquals((long)0L, (long)app2.messagingFailedEventCount);
    }

    @Test
    public void testStandaloneReconnectOneBindingFail() throws Exception {
        AepEngineMessageBusBindingFailTestApp app = new AepEngineMessageBusBindingFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, null, AepEngine.MessageBusBindingFailPolicy.Reconnect, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        engine.start();
        engine.waitForMessagingToStart();
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertEquals((long)1L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)1L, (long)app.bindingUpEventCount);
        this.messagingController.failBinding("aeptest1", "engine1");
        Assert.assertTrue((boolean)app.waitForBindingToFail());
        Assert.assertTrue((boolean)app.waitForBindingToEstablish(1));
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertEquals((long)1L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)2L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)2L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app.messagingFailedEventCount);
    }

    @Test
    public void testStandaloneReconnectTwoBindingsOneFail() throws Exception {
        AepEngineMessageBusBindingFailTestApp app = new AepEngineMessageBusBindingFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, null, AepEngine.MessageBusBindingFailPolicy.Reconnect, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        engine.start();
        engine.waitForMessagingToStart();
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)3L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)2L, (long)app.bindingUpEventCount);
        this.messagingController.failBinding("aeptest1", "engine1");
        Assert.assertTrue((boolean)app.waitForBindingToFail());
        Assert.assertTrue((boolean)app.waitForBindingToEstablish(2));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)5L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)3L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)2L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)0L, (long)app.messagingFailedEventCount);
    }
}

