/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.test.unit.AepEngineTestApp;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.proto.Child1;
import com.neeve.aep.test.unit.generated.proto.Child4;
import com.neeve.aep.test.unit.generated.proto.ChildLongMap;
import com.neeve.aep.test.unit.generated.proto.Message;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.sma.MessageView;

public final class AepEngineLogTestApp
extends AepEngineTestApp {
    AepEngine engine;
    volatile int inMessageCount;
    volatile int outMessageCount;
    volatile int primaryOutMessageCount;
    volatile int primaryInMessageCount;
    volatile int numPuts;
    volatile int numUpdates;
    volatile int numRemoves;
    volatile int txnCount;
    volatile int numGaps;
    private boolean lastMessageCounted = true;

    final boolean waitForExpectedMessageReceipt(int expectedMessageCount) {
        for (int i = 0; i < 10; ++i) {
            System.out.println("received " + this.inMessageCount + "...");
            if (this.inMessageCount < expectedMessageCount) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1UpEventHandler(AepChannelUpEvent event) {
        this.channel1 = event.getMessageChannel();
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1DownEventHandler(AepChannelDownEvent event) {
        this.channel1 = null;
    }

    @EventHandler(source="channel2@aeptest1")
    public void onChannel2UpEventHandler(AepChannelUpEvent event) {
        this.channel2 = event.getMessageChannel();
    }

    @EventHandler(source="channel2@aeptest1")
    public void onChannel2DownEventHandler(AepChannelDownEvent event) {
        this.channel2 = null;
    }

    @EventHandler
    public void onProtoMessageHandler(Message message) {
        boolean countAsTxn = false;
        int currentCount = this.inMessageCount;
        if (this.engine.getState() != AepEngine.State.Starting) {
            ++currentCount;
            if (this.engine.isPrimary()) {
                ++this.primaryInMessageCount;
            }
            countAsTxn |= this.engine.getHAPolicy() == AepEngine.HAPolicy.EventSourcing;
        }
        if (message.getStringField() != null) {
            if (message.getStringField().equals("DOLAST")) {
                if (this.engine.getState() != AepEngine.State.Starting) {
                    System.out.println("Setting as last transaction for message txid: " + message.getTransactionId());
                }
                this.engine.setAsLastTransaction(null, true);
            } else if (this.engine.isPrimary() && message.getStringField().equals("FORCEFAIL")) {
                this.engine.getStore().fail(new Exception("Intentional failure by test"));
            }
        }
        if (currentCount % 2 == 0) {
            Child4 lastChild;
            Repository state = (Repository)this.engine.getApplicationState((MessageView)message);
            Child1 child = Child1.create();
            state.setEntityField(child);
            ChildLongMap childMap = state.getLongMapField();
            if (this.numPuts == 0) {
                state.setFixlenField(1);
                this.numPuts += 3;
            } else {
                state.setFixlenField(state.getFixlenField() + 1);
                ++this.numPuts;
                ++this.numRemoves;
                ++this.numUpdates;
            }
            childMap.put(Long.valueOf(state.getFixlenField()), Child4.create());
            ++this.numPuts;
            ++this.numUpdates;
            if (state.getFixlenField() > 2) {
                lastChild = (Child4)childMap.get((long)state.getFixlenField() - 1L);
                lastChild.setLongField(state.getFixlenField());
                ++this.numUpdates;
            }
            if (state.getFixlenField() > 3) {
                lastChild = (Child4)childMap.get((long)state.getFixlenField() - 2L);
                if (lastChild != null) {
                    childMap.remove((long)state.getFixlenField() - 2L);
                }
                ++this.numRemoves;
            }
            countAsTxn |= this.engine.getHAPolicy() == AepEngine.HAPolicy.StateReplication;
        }
        if (currentCount % 3 == 0) {
            AepEngineTestMessage out = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
            out.getMessage().setMessageBus("aeptest1");
            out.getMessage().setMessageChannel("channel2");
            this.engine.sendMessage(this.channel2, out.getMessage());
            if (this.engine.getState() != AepEngine.State.Starting) {
                ++this.outMessageCount;
                if (this.engine.isPrimary()) {
                    ++this.primaryOutMessageCount;
                }
            }
            countAsTxn |= this.engine.getHAPolicy() == AepEngine.HAPolicy.StateReplication;
        }
        if (currentCount == 1 && this.engine.getHAPolicy() == AepEngine.HAPolicy.StateReplication) {
            countAsTxn = true;
        }
        if (countAsTxn) {
            ++this.txnCount;
            this.lastMessageCounted = true;
        } else if (this.engine.getHAPolicy() == AepEngine.HAPolicy.StateReplication) {
            if (this.lastMessageCounted) {
                ++this.numGaps;
            }
            this.lastMessageCounted = false;
        }
        this.inMessageCount = currentCount;
    }

    public void passCountsToBackup(AepEngineLogTestApp app) {
        if (this.engine.getHAPolicy() == AepEngine.HAPolicy.StateReplication) {
            app.inMessageCount += this.inMessageCount;
            app.outMessageCount += this.outMessageCount;
            app.txnCount += this.txnCount;
            app.numPuts += this.numPuts;
            app.numUpdates += this.numUpdates;
            app.numRemoves += this.numRemoves;
            app.numGaps += this.numGaps;
        }
    }
}

