/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.test.unit.AepEngineLastTransactionTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ci.XRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineLastTransactionTest
extends AepEngineTest {
    private final List<AepEngineLastTransactionTestApp> apps = new ArrayList<AepEngineLastTransactionTestApp>();

    public AepEngineLastTransactionTest() {
        this.storeDiscoveryParams = "&initWaitTime=5000&discoveryInitWaitTime=2";
    }

    private final List<AepEngineTestMessage> createMessagesToSend(AepEngineTestObject.EncodingType encodingType) {
        ArrayList<AepEngineTestMessage> list = new ArrayList<AepEngineTestMessage>();
        for (int i = 0; i < 20; ++i) {
            list.add(new AepEngineTestMessage(encodingType));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testLastTransaction(AepEngine.HAPolicy haPolicy, final PreserveChannelJoinBehavior behavior, final boolean suppressReplicationOfOutboundMessages) throws Exception {
        try {
            AepEngine engine2;
            AepEngine engine13;
            AepEngine engine12;
            AepEngine engine11;
            this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

                @Override
                public void customizeEngine(AepEngineDescriptor descriptor) {
                    if (behavior == PreserveChannelJoinBehavior.PreserveViaEngineDescriptor || behavior == PreserveChannelJoinBehavior.LeaveViaStoppingEventOverridesEngine) {
                        descriptor.setPreserveChannelJoinsOnStop(true);
                    } else {
                        descriptor.setPreserveChannelJoinsOnStop(false);
                    }
                    descriptor.setReplicateSolicitedSends(!suppressReplicationOfOutboundMessages);
                }
            };
            AepEngineLastTransactionTestApp app11 = new AepEngineLastTransactionTestApp();
            this.apps.add(app11);
            app11.name = "app11";
            behavior.applyToApp(app11);
            app11.stopCount1 = 10;
            app11.stopCount2 = -1;
            String app1Name = "engine-" + System.currentTimeMillis();
            app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 31, 16, app11, null, null, 0, false, false, null, null, null, false, false);
            engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            engine11.start();
            app11.releaseFromPrestart();
            engine11.waitForMessagingToStart();
            Assert.assertNotNull((Object)app11.setAsLastTransactionFromNonMessageHandlerStatus);
            Assert.assertTrue((boolean)(app11.setAsLastTransactionFromNonMessageHandlerStatus instanceof IllegalStateException));
            try {
                engine11.setAsLastTransaction(null, false);
                Assert.fail((String)"setAsLastTransaction() did not fail when invoked outside of a transaction");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            AepEngineLastTransactionTestApp app12 = new AepEngineLastTransactionTestApp();
            this.apps.add(app12);
            app12.name = "app12";
            behavior.applyToApp(app12);
            app12.stopCount1 = haPolicy == AepEngine.HAPolicy.EventSourcing ? 10 : -1;
            app12.stopCount2 = haPolicy == AepEngine.HAPolicy.EventSourcing ? 30 : 20;
            app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 31, 16, app12, null, null, 0, false, false, null, null, null, false, false);
            engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            engine12.start();
            AepEngineLastTransactionTestApp app13 = new AepEngineLastTransactionTestApp();
            this.apps.add(app13);
            app13.name = "app13";
            behavior.applyToApp(app13);
            app13.stopCount1 = haPolicy == AepEngine.HAPolicy.EventSourcing ? 10 : -1;
            app13.stopCount2 = haPolicy == AepEngine.HAPolicy.EventSourcing ? 30 : -1;
            app13.engine = engine13 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, false, false, false, null, 31, 16, app13, null, null, 0, false, false, null, null, null, false, false);
            engine13.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            AepEngineLastTransactionTestApp app2 = new AepEngineLastTransactionTestApp();
            this.apps.add(app2);
            app2.name = "app2";
            behavior.applyToApp(app2);
            String app2Name = "engine-" + System.currentTimeMillis() + "-100";
            app2.engine = engine2 = this.createEngine(app2Name, haPolicy, null, null, null, null, false, false, false, false, null, 15, 8, app2, null, null, 0, false, false, null, null, null, false, false);
            engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            engine2.start();
            app2.releaseFromPrestart();
            engine2.waitForMessagingToStart();
            List<AepEngineTestMessage> messages = this.createMessagesToSend(AepEngineTestObject.EncodingType.Proto);
            for (AepEngineTestMessage message : messages) {
                message.getMessage().setMessageBus("aeptest1");
                message.getMessage().setMessageChannel("channel1");
                engine11.sendMessage(app11.channel5, message.getMessage());
            }
            app11.onMessagesSent();
            app12.onMessagesSent();
            app13.onMessagesSent();
            Assert.assertTrue((boolean)app11.waitForEngineStopped());
            Assert.assertSame((Object)app11.lastTransactionCause, (Object)app11.engineStoppedCause);
            Assert.assertEquals((long)app11.stopCount1, (long)app11.inMessageCount);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int expectedMessageCount = haPolicy == AepEngine.HAPolicy.EventSourcing ? app11.stopCount1 : 0;
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine12.getState()));
            Assert.assertEquals((long)expectedMessageCount, (long)app12.inMessageCount);
            app12.releaseFromPrestart();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (behavior.preserveSubscriptions()) {
                Assert.assertEquals((String)"Expected to get messages not acked by former primary", (long)(expectedMessageCount + 10), (long)app12.inMessageCount);
            } else {
                Assert.assertEquals((String)"Didn't expect new message on new primary after subscriptions were dropped.", (long)expectedMessageCount, (long)app12.inMessageCount);
            }
            Assert.assertEquals((long)1L, (long)app2.inMessageCount);
            engine13.start();
            Assert.assertFalse((String)"Expected restarted engine to come up as primary", (boolean)engine13.isPrimary());
            app13.clusterShutdown = true;
            app12.clusterShutdown = true;
            messages = this.createMessagesToSend(AepEngineTestObject.EncodingType.Proto);
            for (AepEngineTestMessage message : messages) {
                message.getMessage().setMessageBus("aeptest1");
                message.getMessage().setMessageChannel("channel1");
                engine12.sendMessage(app12.channel5, message.getMessage());
            }
            app12.onMessagesSent();
            app13.onMessagesSent();
            Assert.assertTrue((boolean)app12.waitForEngineStopped());
            Assert.assertSame((Object)app12.lastTransactionCause, (Object)app12.engineStoppedCause);
            Assert.assertEquals((long)app12.stopCount2, (long)app12.inMessageCount);
            Assert.assertTrue((boolean)app13.waitForEngineStopped());
            if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
                if (app13.lastTransactionCause != null) {
                    Assert.assertEquals((Object)app13.lastTransactionCause.getMessage(), (Object)app13.engineStoppedCause.getMessage());
                } else {
                    Assert.assertNull((Object)app13.engineStoppedCause);
                }
                Assert.assertEquals((long)app13.stopCount2, (long)app13.inMessageCount);
            } else {
                if (behavior.stopsWithException()) {
                    Assert.assertEquals((Object)app12.lastTransactionCause.getMessage(), (Object)app13.engineStoppedCause.getMessage());
                }
                Assert.assertEquals((long)0L, (long)app13.inMessageCount);
            }
            Assert.assertEquals((long)2L, (long)app2.inMessageCount);
            app12 = new AepEngineLastTransactionTestApp();
            app12.name = "app12";
            app12.stopCount1 = -1;
            app12.stopCount2 = -1;
            this.apps.add(app12);
            app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 31, 16, app12, null, null, 0, false, false, null, null, null, false, false);
            engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            engine12.start();
            try {
                Assert.assertTrue((boolean)engine12.isPrimary());
            }
            finally {
                app12.releaseFromPrestart();
            }
            engine12.waitForMessagingToStart();
            Thread.sleep(1000L);
            if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
                if (behavior.preserveSubscriptions()) {
                    Assert.assertEquals((String)"Didn't get undelivered messsages after restart.", (long)40L, (long)app12.inMessageCount);
                } else {
                    Assert.assertEquals((String)"Didn't expect new message after subscriptions were dropped.", (long)30L, (long)app12.inMessageCount);
                }
            } else if (behavior.preserveSubscriptions()) {
                Assert.assertEquals((String)"Didn't get undelivered messsages after restart.", (long)10L, (long)app12.inMessageCount);
            } else {
                Assert.assertEquals((String)"Didn't expect new message after subscriptions were dropped.", (long)0L, (long)app12.inMessageCount);
            }
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine12.getState()));
            app13 = new AepEngineLastTransactionTestApp();
            this.apps.add(app13);
            app13.name = "app13";
            behavior.applyToApp(app13);
            app13.stopCount1 = -1;
            app13.stopCount2 = -1;
            app13.engine = engine13 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, false, false, false, null, 31, 16, app13, null, null, 0, false, false, null, null, null, false, false);
            engine13.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            engine13.start();
            Assert.assertFalse((String)"Expected restarted engine to be backup", (boolean)engine13.isPrimary());
            if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
                if (behavior.preserveSubscriptions()) {
                    Assert.assertEquals((String)"Didn't get undelivered messsages after restart.", (long)40L, (long)app13.inMessageCount);
                } else {
                    Assert.assertEquals((String)"Didn't expect new message after subscriptions were dropped.", (long)30L, (long)app13.inMessageCount);
                }
            } else {
                Assert.assertEquals((String)"Wrong number of messages received by restarted backup", (long)0L, (long)app13.inMessageCount);
            }
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Expected restarted engine to be started", (Object)((Object)AepEngine.State.Started), (Object)((Object)engine13.getState()));
        }
        catch (Throwable throwable) {
            for (AepEngineLastTransactionTestApp app : this.apps) {
                app.preserveChannelJoinBehavior = PreserveChannelJoinBehavior.NoPreservation;
                app.releaseFromPrestart();
            }
            this.engineCustomizer = null;
            throw throwable;
        }
        for (AepEngineLastTransactionTestApp app : this.apps) {
            app.preserveChannelJoinBehavior = PreserveChannelJoinBehavior.NoPreservation;
            app.releaseFromPrestart();
        }
        this.engineCustomizer = null;
    }

    private final void testLastTransaction(AepEngine.HAPolicy haPolicy, PreserveChannelJoinBehavior behavior) throws Exception {
        this.testLastTransaction(haPolicy, behavior, false);
    }

    @Test
    public void testLastTransactionEventSourcingSubsNotPreservedOnCleanShutdown() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.EventSourcing, PreserveChannelJoinBehavior.NoPreservation);
    }

    @Test
    public void testLastTransactionStateReplicationSubsNotPreservedOnCleanShutdown() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.StateReplication, PreserveChannelJoinBehavior.NoPreservation);
    }

    @Test
    public void testLastTransactionStateReplicationSubsNotPreservedOnCleanShutdownSuppressReplicationOfOutboundMessages() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.StateReplication, PreserveChannelJoinBehavior.NoPreservation, true);
    }

    @Test
    public void testLastTransactionEventSourcingPreserveViaException() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.EventSourcing, PreserveChannelJoinBehavior.PreserveViaException);
    }

    @Test
    public void testLastTransactionStateReplicationPreserveViaException() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.StateReplication, PreserveChannelJoinBehavior.PreserveViaException);
    }

    @Test
    public void testLastTransactionEventSourcingPreserveSubscriptionsViaStoppingEvent() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.EventSourcing, PreserveChannelJoinBehavior.PreserveViaStoppingEvent);
    }

    @Test
    public void testLastTransactionStateReplicationPreserveSubscriptionsViaStoppingEvent() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.StateReplication, PreserveChannelJoinBehavior.PreserveViaStoppingEvent);
    }

    @Test
    public void testLastTransactionEventSourcingLeaveViaStoppingEventOverridesEngine() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.EventSourcing, PreserveChannelJoinBehavior.LeaveViaStoppingEventOverridesEngine);
    }

    @Test
    public void testLastTransactionStateReplicationLeaveViaStoppingEventOverridesEngine() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.StateReplication, PreserveChannelJoinBehavior.LeaveViaStoppingEventOverridesEngine);
    }

    @Test
    public void testLastTransactionEventSourcingPreserveSubscriptionsViaEngineDescriptor() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.EventSourcing, PreserveChannelJoinBehavior.PreserveViaEngineDescriptor);
    }

    @Test
    public void testLastTransactionStateReplicationPreserveSubscriptionsViaEngineDescriptor() throws Exception {
        this.testLastTransaction(AepEngine.HAPolicy.StateReplication, PreserveChannelJoinBehavior.PreserveViaEngineDescriptor);
    }

    public static enum PreserveChannelJoinBehavior {
        PreserveViaException,
        PreserveViaStoppingEvent,
        PreserveViaEngineDescriptor,
        LeaveViaStoppingEventOverridesEngine,
        NoPreservation;


        public boolean preserveSubscriptions() {
            switch (this) {
                case LeaveViaStoppingEventOverridesEngine: 
                case NoPreservation: {
                    return false;
                }
            }
            return true;
        }

        public boolean stopsWithException() {
            switch (this) {
                case PreserveViaException: {
                    return true;
                }
            }
            return false;
        }

        public void applyToApp(AepEngineLastTransactionTestApp app) {
            app.lastTransactionCause = null;
            app.preserveChannelJoinBehavior = this;
            switch (this) {
                case PreserveViaException: {
                    app.lastTransactionCause = new Exception("intentional stop on last transaction");
                    break;
                }
                case NoPreservation: {
                    break;
                }
                case LeaveViaStoppingEventOverridesEngine: {
                    break;
                }
                case PreserveViaEngineDescriptor: {
                    break;
                }
                case PreserveViaStoppingEvent: {
                    break;
                }
            }
        }
    }
}

