/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl.loopback;

import cern.colt.list.ObjectArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.MultiThreadedClaimStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.neeve.ci.XRuntime;
import com.neeve.hstr.EHstrFormatException;
import com.neeve.hstr.Hstr;
import com.neeve.hstr.HstrTable;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XAbstractPooledString;
import com.neeve.lang.XLongLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.sma.SmaPermanentException;
import com.neeve.sma.impl.loopback.LoopbackMessageBusBinding;
import com.neeve.sma.impl.loopback.LoopbackMessageChannel;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPlist;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class LoopbackBus
extends SmaObject {
    private final String name;
    private final ReentrantReadWriteLock lock;
    private final Map<String, AgentParameters> agentParameterTable;
    private final Map<String, AgentTestController> agentTestControllerTable;
    private final Map<String, AgentQueue> agentQueueTable;
    private final Map<String, Agent> agentTable;
    private final SubscriptionTable subscriptionTable;
    private final ForwardingTable forwardingTable;
    private final AtomicInteger currentAddr;
    private final String tracePrefix;
    private final ActivityTracker activityTracker;
    private final Object pendingGuarNotify = new Object();
    private final Topic.Factory topicFactory;
    private volatile boolean busActive;
    private volatile boolean waitForQuiescenceEnabled;
    private volatile int waitingForPendingAcks;
    private int nonQuiescentActivity;
    private boolean discardMessages;
    private AtomicLong pendingGuarCount = new AtomicLong(0L);
    private static final Map<String, LoopbackBus> instances;
    private static final boolean ACTIVITY_TRACKING_ENABLED;
    private static final int ACTIVITY_TRACKING_HISTORY_SIZE;
    private static final int ACTIVITY_DUMP_WAIT_LIMIT;

    private LoopbackBus(String name) {
        super(null);
        this.name = name;
        this.lock = new ReentrantReadWriteLock();
        Hstr.setElementSeparator((String)"/");
        Hstr.setElementWildcard((char)'*');
        Hstr.setLevelWildcard((String)"...");
        this.topicFactory = new Topic.Factory();
        this.agentTable = new HashMap<String, Agent>();
        this.agentParameterTable = new HashMap<String, AgentParameters>();
        this.agentTestControllerTable = new HashMap<String, AgentTestController>();
        this.agentQueueTable = new HashMap<String, AgentQueue>();
        this.forwardingTable = new ForwardingTable();
        this.subscriptionTable = new SubscriptionTable();
        this.currentAddr = new AtomicInteger();
        this.busActive = false;
        this.waitForQuiescenceEnabled = false;
        this.nonQuiescentActivity = 0;
        this.tracePrefix = "[LoopbackBus <" + name + ">] ";
        if (ACTIVITY_TRACKING_ENABLED) {
            this.activityTracker = new ActivityTracker();
            this.tracer.log(this.tracePrefix + " QUIESCENCE TRACKING ENABLED", Tracer.Level.WARNING);
        } else {
            this.activityTracker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoopbackBus getInstance(String name) {
        Map<String, LoopbackBus> map = instances;
        synchronized (map) {
            LoopbackBus bus = instances.get(name);
            if (bus == null) {
                bus = new LoopbackBus(name);
                instances.put(name, bus);
            }
            return bus;
        }
    }

    public static LoopbackBus getInstance() {
        return LoopbackBus.getInstance(null);
    }

    public static void clearAllInstances() {
        instances.clear();
    }

    private final void acquireReadLock() {
        this.lock.readLock().lock();
    }

    private final void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    private final void acquireWriteLock() {
        this.lock.writeLock().lock();
    }

    private final void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void subscribeUnsubscribe(Agent agent, String topic, boolean flgSubscribe) {
        block12: {
            this.acquireWriteLock();
            try {
                if (topic != null) {
                    topic = Hstr.normalize((String)topic);
                    if (flgSubscribe) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Updating forwarding table for <" + agent + ", '" + topic + "', subscribe>", Tracer.Level.DEBUG);
                        }
                        this.forwardingTable.update(topic, true, agent.msgQueue);
                        this.subscriptionTable.update(agent.addr, topic, true);
                        this.tracer.log(this.tracePrefix + "Agent " + agent + " has subscribed to '" + topic + "'", Tracer.Level.VERBOSE);
                    } else {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Updating forwarding table for <" + agent + ", '" + topic + "', unsubscribe>", Tracer.Level.DEBUG);
                        }
                        this.subscriptionTable.update(agent.addr, topic, false);
                        this.forwardingTable.update(topic, false, agent.msgQueue);
                        this.tracer.log(this.tracePrefix + "Agent " + agent + " has unsubscribed from '" + topic + "'", Tracer.Level.VERBOSE);
                    }
                    break block12;
                }
                throw new Exception("topic is null");
            }
            catch (Exception e) {
                if (flgSubscribe) {
                    this.tracer.log(this.tracePrefix + "Error in agent " + agent + " joining '" + topic + "' [" + e.getMessage() + "]", Tracer.Level.WARNING);
                } else {
                    this.tracer.log(this.tracePrefix + "Error in agent " + agent + " leaving '" + topic + "' [" + e.getMessage() + "]", Tracer.Level.WARNING);
                }
                e.printStackTrace();
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void forward(Agent agent, LoopbackMessageChannel channel, XString topic, Object message, MessageMetadata metadata, long originTs, long preWireTs) throws Exception {
        if (!this.discardMessages) {
            this.acquireReadLock();
            try {
                HstrTable.Node node;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Resolving forwarding entry for topic '" + topic + "'...", Tracer.Level.DEBUG);
                }
                if ((node = this.forwardingTable.get(topic.getValue())) != null) {
                    ForwardingEntry entry = (ForwardingEntry)node.getObject();
                    if (entry == null) {
                        throw new InternalError("HSTR table returned a node with a null entry!");
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Forwarding entry found. Forwarding to agents in entry...", Tracer.Level.WARNING);
                    }
                    if (entry.set != null) {
                        Object[] elements = entry.set.elements();
                        int size = entry.set.size();
                        if (size > 0) {
                            MessageWaypointListenerRegistry.dispatch(MessageWaypointListener.Waypoint.w1, MessageWaypointListener.MessagingDirection.Outbound, message);
                            Object nextForwardCopy = message;
                            for (int i = 0; i < size; ++i) {
                                ForwardingElement element = (ForwardingElement)elements[i];
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "Forwarding to " + element.queue + "...", Tracer.Level.WARNING);
                                }
                                if (element.queue != null) {
                                    Object toForward = nextForwardCopy;
                                    if (i + 1 < size && nextForwardCopy instanceof IOBuffer) {
                                        nextForwardCopy = ((IOBuffer)nextForwardCopy).copy();
                                    }
                                    try {
                                        element.queue.offerMessage(channel, topic, toForward, metadata, originTs, preWireTs);
                                        continue;
                                    }
                                    finally {
                                        if (toForward != message && toForward instanceof IOBuffer) {
                                            ((IOBuffer)toForward).dispose();
                                        }
                                    }
                                }
                                if (!this.tracer.debug) continue;
                                this.tracer.log(this.tracePrefix + "Agent in forwarding element = null. Ignoring...", Tracer.Level.WARNING);
                            }
                            MessageWaypointListenerRegistry.dispatch(MessageWaypointListener.Waypoint.w2, MessageWaypointListener.MessagingDirection.Outbound, message);
                            return;
                        }
                        if (!this.tracer.debug) return;
                        this.tracer.log(this.tracePrefix + "No forwarding agents for entry (size=0).", Tracer.Level.WARNING);
                        return;
                    }
                    if (!this.tracer.debug) return;
                    this.tracer.log(this.tracePrefix + "No forwarding agents for entry (set=null).", Tracer.Level.WARNING);
                    return;
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "No forwarding entry found for '" + topic + "'. Creating entry...", Tracer.Level.WARNING);
                }
                try {
                    this.forwardingTable.update(topic.getValue(), true, null);
                    this.forward(agent, channel, topic, message, metadata, originTs, preWireTs);
                    return;
                }
                catch (EHstrFormatException e) {
                    this.tracer.log(this.tracePrefix + "Topic string '" + topic + "' is incorrecly formatted. Discarding...", Tracer.Level.WARNING);
                }
                return;
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            this.tracer.log(this.tracePrefix + "*** Discarding published message ***", Tracer.Level.WARNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void disconnect(Agent agent) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Disconnecting agent " + agent + "'...", Tracer.Level.DEBUG);
        }
        AgentQueue queueToClose = null;
        Map<String, Agent> map = this.agentTable;
        synchronized (map) {
            this.agentTable.remove(agent.binding.getUserName());
            int remainingSubCount = 0;
            Map<String, AgentQueue> map2 = this.agentQueueTable;
            synchronized (map2) {
                this.acquireReadLock();
                try {
                    Object subscriptionSet = this.subscriptionTable.get(agent.addr);
                    if (subscriptionSet != null) {
                        remainingSubCount = subscriptionSet.size();
                    }
                    if (remainingSubCount == 0) {
                        queueToClose = this.agentQueueTable.remove(agent.binding.getUserName());
                    }
                }
                finally {
                    this.releaseReadLock();
                }
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Agent '" + agent.binding.getUserName() + "'disconnected (with " + (remainingSubCount > 0 ? Integer.valueOf(remainingSubCount) : "no") + " subs still joined)", Tracer.Level.DEBUG);
            }
        }
        if (queueToClose != null) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Closing agent queue '" + agent.binding.getUserName() + "'", Tracer.Level.DEBUG);
            }
            queueToClose.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AgentQueue getAgentQueue(String name) {
        Map<String, AgentQueue> map = this.agentQueueTable;
        synchronized (map) {
            AgentQueue queue = this.agentQueueTable.get(name);
            if (queue == null) {
                queue = new AgentQueue(name, true);
                this.agentQueueTable.put(name, queue);
            }
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ActivityTracker.ActivityRecord onActivity() {
        if (this.waitForQuiescenceEnabled) {
            LoopbackBus loopbackBus = this;
            synchronized (loopbackBus) {
                ++this.nonQuiescentActivity;
            }
            if (this.activityTracker != null) {
                return this.activityTracker.onActivity(null);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onActivityQuieten(ActivityTracker.ActivityRecord activityRecord) {
        if (this.waitForQuiescenceEnabled) {
            LoopbackBus loopbackBus = this;
            synchronized (loopbackBus) {
                if (--this.nonQuiescentActivity == 0) {
                    ((Object)((Object)this)).notifyAll();
                }
                if (this.nonQuiescentActivity < 0) {
                    new Exception("nonQuiescentActivity dropped to below zero (val=" + this.nonQuiescentActivity + ")").printStackTrace();
                }
            }
            if (activityRecord != null) {
                this.activityTracker.onQuieten(activityRecord);
            }
        }
    }

    final Agent connect(LoopbackMessageBusBinding binding) throws SmaException {
        String name = binding.getUserName();
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Connecting agent " + name + "'...", Tracer.Level.DEBUG);
        }
        Map<String, Agent> map = this.agentTable;
        synchronized (map) {
            Agent agent = this.agentTable.get(name);
            if (agent == null) {
                AgentTestController testController;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...not found. creating a new one...", Tracer.Level.DEBUG);
                }
                if ((testController = this.getAgentTestController(name)).failNextConnectPermanent()) {
                    if (!testController.failAllConnectsPermanent()) {
                        testController.failNextConnectPermanent = false;
                    }
                    throw new SmaPermanentException("intentionally and permanently failed by test controller");
                }
                if (testController.failNextConnect()) {
                    if (!testController.failAllConnects()) {
                        testController.failNextConnect = false;
                    }
                    throw new SmaException("intentionally failed by test controller");
                }
                agent = new Agent(binding, this.getAgentParameters(name), this.getAgentQueue(name), testController);
                this.agentTable.put(name, agent);
                return agent;
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...already exists. throwing error...", Tracer.Level.DEBUG);
            }
            throw new SmaException(name + " already connected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AgentParameters getAgentParameters(String name) {
        Map<String, AgentParameters> map = this.agentParameterTable;
        synchronized (map) {
            AgentParameters parameters = this.agentParameterTable.get(name);
            if (parameters == null) {
                parameters = new AgentParameters();
                this.agentParameterTable.put(name, parameters);
            }
            return parameters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AgentTestController getAgentTestController(String name) {
        Map<String, AgentTestController> map = this.agentTestControllerTable;
        synchronized (map) {
            AgentTestController controller = this.agentTestControllerTable.get(name);
            if (controller == null) {
                controller = new AgentTestController(name);
                this.agentTestControllerTable.put(name, controller);
            }
            return controller;
        }
    }

    public TestController getTestController() {
        return new TestController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LoopbackBus reset() {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Resetting the bus...", Tracer.Level.DEBUG);
        }
        this.agentParameterTable.clear();
        this.agentTestControllerTable.clear();
        ArrayList<AgentQueue> queuesToClose = new ArrayList<AgentQueue>();
        Object object = this.agentQueueTable;
        synchronized (object) {
            queuesToClose.addAll(this.agentQueueTable.values());
        }
        for (AgentQueue queue : queuesToClose) {
            queue.close();
        }
        this.agentTable.clear();
        this.subscriptionTable.clear();
        this.forwardingTable.clear();
        this.currentAddr.set(0);
        if (this.waitForQuiescenceEnabled) {
            object = this;
            synchronized (object) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Resetting bus quiescence...", Tracer.Level.DEBUG);
                }
                this.waitForQuiescenceEnabled = false;
                this.nonQuiescentActivity = 0;
                ((Object)((Object)this)).notifyAll();
            }
        } else {
            this.waitForQuiescenceEnabled = false;
            this.nonQuiescentActivity = 0;
        }
        if (this.activityTracker != null) {
            this.activityTracker.onReset();
        }
        this.pendingGuarCount = new AtomicLong(0L);
        if (this.waitingForPendingAcks > 0) {
            object = this.pendingGuarNotify;
            synchronized (object) {
                this.pendingGuarNotify.notifyAll();
            }
        }
        this.discardMessages = false;
        this.busActive = false;
        return this;
    }

    public final boolean isAgentConnected(String name) {
        return this.getAgent(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean agentHasSubscriptions(String name) {
        Map<String, AgentQueue> map = this.agentQueueTable;
        synchronized (map) {
            boolean bl;
            AgentQueue queue = this.agentQueueTable.get(name);
            if (queue == null) return false;
            this.acquireReadLock();
            try {
                Object subscriptionSet = this.subscriptionTable.get(queue.addr);
                bl = subscriptionSet != null && subscriptionSet.size() > 0;
                this.releaseReadLock();
            }
            catch (Throwable throwable) {
                this.releaseReadLock();
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Agent getAgent(String name) {
        Map<String, Agent> map = this.agentTable;
        synchronized (map) {
            return this.agentTable.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableWaitForQuiescence(boolean val) {
        LoopbackBus loopbackBus = this;
        synchronized (loopbackBus) {
            if (this.busActive) {
                throw new IllegalStateException("bus is active (wait for quiescence cannot be enabled/disabled on an active bus)");
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Enabling wait for quiescence.", Tracer.Level.DEBUG);
            }
        }
        this.waitForQuiescenceEnabled = val;
    }

    public final boolean waitForPendingAcks(long timeout, TimeUnit timeUnit) {
        return this.waitForPendingAcks(timeUnit.toMillis(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean waitForPendingAcks(long timeout) {
        if (this.pendingGuarCount.get() <= 0L) return true;
        ++this.waitingForPendingAcks;
        long tte = timeout > 0L ? System.currentTimeMillis() + timeout : 0L;
        try {
            while (this.pendingGuarCount.get() > 0L) {
                try {
                    Object object;
                    if (tte > 0L) {
                        timeout = tte - System.currentTimeMillis();
                        if (timeout > 0L) {
                            object = this.pendingGuarNotify;
                            synchronized (object) {
                                this.pendingGuarNotify.wait(Math.min(100L, timeout));
                                continue;
                            }
                        }
                        break;
                    }
                    object = this.pendingGuarNotify;
                    synchronized (object) {
                        this.pendingGuarNotify.wait(Math.min(100L, timeout));
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        finally {
            --this.waitingForPendingAcks;
        }
        if (this.pendingGuarCount.get() > 0L) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpPendingAck(StringBuilder builder) {
        builder.append("Pending Ack for bus '").append(this.name).append("'\n");
        if (this.pendingGuarCount.get() <= 0L) {
            builder.append("No outstanding acknowldegements\n");
            return;
        }
        ArrayList<AgentQueue> queues = null;
        Map<String, AgentQueue> map = this.agentQueueTable;
        synchronized (map) {
            queues = new ArrayList<AgentQueue>(this.agentQueueTable.values());
        }
        for (AgentQueue queue : queues) {
            builder.append("\n");
            queue.dump(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForQuiescence() {
        if (this.waitForQuiescenceEnabled) {
            boolean interrupted = false;
            long dumpLimit = this.activityTracker != null ? System.currentTimeMillis() + (long)(ACTIVITY_DUMP_WAIT_LIMIT * 1000) : 0L;
            LoopbackBus loopbackBus = this;
            synchronized (loopbackBus) {
                while (this.nonQuiescentActivity > 0) {
                    if (this.activityTracker != null && System.currentTimeMillis() > dumpLimit) {
                        this.tracer.log("Possibly hung waiting for quiescence, activity dump to follow...", Tracer.Level.SEVERE);
                        this.dumpActivityTrackingInfo();
                        dumpLimit = System.currentTimeMillis() + (long)(ACTIVITY_DUMP_WAIT_LIMIT * 1000);
                    }
                    try {
                        ((Object)((Object)this)).wait(1000L);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        } else {
            throw new UnsupportedOperationException("wait for quiescence feature needs to be enabled before use. use enableWaitForQuiescence() to enable it.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForQuiescence(long timeout) {
        if (timeout < 0L) {
            this.waitForQuiescence();
            return true;
        }
        if (this.waitForQuiescenceEnabled) {
            LoopbackBus loopbackBus = this;
            synchronized (loopbackBus) {
                long start = System.currentTimeMillis();
                long remaining = timeout;
                while (remaining > 0L && this.nonQuiescentActivity > 0) {
                    try {
                        ((Object)((Object)this)).wait(remaining);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                    finally {
                        remaining = timeout - (System.currentTimeMillis() - start);
                    }
                }
                if (this.activityTracker != null && this.nonQuiescentActivity > 0) {
                    this.tracer.log(this.tracePrefix + "****waitForQuiescence Timeout ******", Tracer.Level.SEVERE);
                    this.dumpActivityTrackingInfo();
                }
                return this.nonQuiescentActivity == 0;
            }
        }
        throw new UnsupportedOperationException("wait for quiescence feature needs to be enabled before use. use enableWaitForQuiescence() to enable it.");
    }

    public final boolean waitForQuiescence(long timeout, TimeUnit timeUnit) {
        return this.waitForQuiescence(timeUnit.toMillis(timeout));
    }

    public final void dumpActivityTrackingInfo() {
        if (this.activityTracker == null) {
            this.tracer.log(this.tracePrefix + "**** Activity Tracking not enabled ******", Tracer.Level.WARNING);
        } else {
            this.activityTracker.dumpPendingActivity();
        }
    }

    public final void discardMessages() {
        this.tracer.log(this.tracePrefix + "**** Setting message discard = true ******", Tracer.Level.INFO);
        this.discardMessages = true;
    }

    public final void clearMessageDiscard() {
        this.tracer.log(this.tracePrefix + "**** Setting message discard = false ******", Tracer.Level.INFO);
        this.discardMessages = false;
    }

    static {
        ACTIVITY_TRACKING_ENABLED = UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.sma.loopback.activitytracker.enabled", (boolean)false);
        ACTIVITY_TRACKING_HISTORY_SIZE = UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.sma.loopback.activitytracker.historySize", (int)20);
        ACTIVITY_DUMP_WAIT_LIMIT = UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.sma.loopback.activitytracker.dumpWaitThreshold", (int)60);
        instances = new HashMap<String, LoopbackBus>();
    }

    final class ActivityTracker {
        private AtomicLong activityCount = new AtomicLong(0L);
        private UtlList pendingActivity = UtlList.create();
        private UtlList historicalActivity = UtlList.create();
        private long lastReset = System.currentTimeMillis();

        ActivityTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActivityRecord onActivity(String activityDescription) {
            ActivityRecord record = new ActivityRecord(this.activityCount.incrementAndGet());
            record.setDescription(activityDescription);
            ActivityTracker activityTracker = this;
            synchronized (activityTracker) {
                this.pendingActivity.append((UtlListElement)record);
                return record;
            }
        }

        public final synchronized void onQuieten(ActivityRecord record) {
            long count = this.activityCount.decrementAndGet();
            record.complete();
            if (count < 0L) {
                LoopbackBus.this.tracer.log("Negative activityCount onQuieten for " + (Object)((Object)record), Tracer.Level.SEVERE);
                this.dumpPendingActivity();
            }
            if (record.isLinked()) {
                record.unlink();
                this.historicalActivity.append((UtlListElement)record);
                while (this.historicalActivity.count > ACTIVITY_TRACKING_HISTORY_SIZE) {
                    this.historicalActivity.first().unlink();
                }
            } else {
                LoopbackBus.this.tracer.log("onQuieten for untracked record: " + (Object)((Object)record), Tracer.Level.SEVERE);
            }
        }

        public final synchronized void onReset() {
            this.lastReset = System.currentTimeMillis();
            this.activityCount.set(0L);
            this.pendingActivity = UtlList.create();
            this.historicalActivity.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dumpPendingActivity() {
            StringBuilder sb = new StringBuilder();
            ActivityTracker activityTracker = this;
            synchronized (activityTracker) {
                ActivityRecord record;
                sb.append("Activity Dump for ").append(LoopbackBus.this.tracePrefix).append("\n");
                sb.append("Last Activity Reset: ").append(UtlTime.format((Date)new Date(this.lastReset))).append("\n");
                sb.append("Activity Count: ").append(this.activityCount.get()).append("\n");
                sb.append("Pending Activity (size=").append(this.pendingActivity.count()).append("):").append("\n");
                for (record = (ActivityRecord)this.pendingActivity.first(); record != null; record = (ActivityRecord)record.next()) {
                    record.dump(sb);
                }
                sb.append("\nHistorical Activity (size=").append(this.historicalActivity.count()).append("):").append("\n");
                for (record = (ActivityRecord)this.historicalActivity.first(); record != null; record = (ActivityRecord)record.next()) {
                    record.dump(sb);
                }
            }
            LoopbackBus.this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        }

        public class ActivityRecord
        extends UtlListElement {
            long activityCount;
            long timestamp;
            String threadName;
            private boolean complete = false;
            StackTraceElement[] stack;
            String activityDescription;
            String completionThreadName;
            StackTraceElement[] completionStack;

            ActivityRecord(long activityCount) {
                this.activityCount = activityCount;
                this.timestamp = System.currentTimeMillis();
                this.threadName = Thread.currentThread().getName();
                this.stack = Thread.currentThread().getStackTrace();
            }

            public void dump(StringBuilder sb) {
                this.appendSummary(sb, true);
            }

            public void setDescription(String description) {
                this.activityDescription = description;
            }

            public void complete() {
                this.complete = true;
                this.completionThreadName = Thread.currentThread().getName();
                this.completionStack = Thread.currentThread().getStackTrace();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendSummary(sb, false);
                return sb.toString();
            }

            private final void appendSummary(StringBuilder sb, boolean includeStack) {
                int i;
                sb.append("ActivityRecord [timestamp='").append(UtlTime.format((Date)new Date(this.timestamp)));
                sb.append("', count=").append(this.activityCount).append("]\n");
                if (this.activityDescription != null) {
                    sb.append(this.activityDescription).append("\n");
                } else {
                    sb.append("No activity description available \n");
                }
                sb.append("Status: ").append(this.complete ? "COMPLETE" : "PENDING").append("\n");
                sb.append("Initiating thread: ").append(this.threadName).append(":").append("\n");
                if (includeStack) {
                    for (i = 4; i < this.stack.length; ++i) {
                        sb.append("  at ").append(this.stack[i].toString()).append("\n");
                    }
                }
                if (this.completionThreadName != null) {
                    sb.append("Completing thread: ").append(this.completionThreadName).append(":").append("\n");
                    if (includeStack) {
                        for (i = 4; i < this.completionStack.length; ++i) {
                            sb.append("  at ").append(this.completionStack[i].toString()).append("\n");
                        }
                    }
                }
            }
        }
    }

    public final class Agent {
        private final int addr;
        private final LoopbackMessageBusBinding binding;
        private final AgentTestController testController;
        private final AgentQueue msgQueue;
        private final AgentQueue ackQueue;
        private final List<OooAckContext> oooAckQueue;
        private final Random random;

        Agent(LoopbackMessageBusBinding binding, AgentParameters parameters, AgentQueue msgQueue, AgentTestController testController) {
            this.addr = msgQueue.addr;
            this.binding = binding;
            this.testController = testController;
            this.msgQueue = msgQueue;
            this.ackQueue = new AgentQueue(msgQueue.name, false);
            this.oooAckQueue = new ArrayList<OooAckContext>();
            this.random = new Random(System.currentTimeMillis());
        }

        final void start() throws Exception {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Agent " + this + " is starting...", Tracer.Level.DEBUG);
            }
            if (this.testController.failNextStart()) {
                this.testController.failNextStart = false;
                throw new SmaException("intentionally failed by test controller");
            }
            this.msgQueue.start(this);
            this.ackQueue.start(this);
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Agent " + this + " is started...", Tracer.Level.DEBUG);
            }
        }

        final void subscribe(String topic) {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Agent " + this + " is subscribing to '" + topic + "'...", Tracer.Level.DEBUG);
            }
            LoopbackBus.this.subscribeUnsubscribe(this, topic, true);
        }

        final void unsubscribe(String topic) {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Agent " + this + " is unsubscribing from '" + topic + "'...;", Tracer.Level.DEBUG);
            }
            LoopbackBus.this.subscribeUnsubscribe(this, topic, false);
        }

        final void publish(LoopbackMessageChannel channel, XString topic, MessageView view, Object message, MessageMetadata metadata) throws Exception {
            int sleepTime;
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Agent " + this + " is publishing a message to topic '" + topic + "' through channel '" + channel.getName() + "'...", Tracer.Level.DEBUG);
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "...Message is " + message, Tracer.Level.DEBUG);
                if (!LoopbackBus.this.busActive) {
                    LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "... bus is going active", Tracer.Level.DEBUG);
                }
            }
            if (this.msgQueue.state != AgentQueueState.Started) {
                throw new IllegalStateException(LoopbackBus.this.tracePrefix + "Invalid message queue state for publish: " + (Object)((Object)this.msgQueue.state));
            }
            if (this.ackQueue.state != AgentQueueState.Started) {
                throw new IllegalStateException(LoopbackBus.this.tracePrefix + "Invalid ack queue state for publish: " + (Object)((Object)this.ackQueue.state));
            }
            view.acquire();
            LoopbackBus.this.busActive = true;
            if (this.testController.isCongested() && (sleepTime = this.random.nextInt(30)) > 20) {
                Thread.sleep(sleepTime - 20);
            }
            Exception status = null;
            try {
                if (this.testController.failNextPublish() || this.testController.failNextPublishWithException()) {
                    throw new Exception("intentionally failed through test controller");
                }
                LoopbackBus.this.forward(this, channel, topic, message, metadata, view.getOriginTs(), view.getPreWireTs());
            }
            catch (Exception e) {
                if (this.testController.failNextPublish()) {
                    status = e;
                    this.testController.failNextPublish = false;
                    this.testController.failNextPublishWithException = false;
                }
                this.testController.failNextPublish = false;
                this.testController.failNextPublishWithException = false;
                throw e;
            }
            if (channel.getQos() == MessageChannel.Qos.Guaranteed) {
                if (this.testController.dropNextAck()) {
                    this.testController.dropNextAck(false);
                } else if (this.testController.oooAckGap() > 0) {
                    this.oooAckQueue.add(new OooAckContext(channel, view, metadata, status));
                    this.testController.oooAckGap(this.testController.oooAckGap() - 1);
                } else {
                    this.ackQueue.offerPublishCompletion(channel, view, metadata, status);
                    if (this.oooAckQueue.size() > 0) {
                        for (OooAckContext context : this.oooAckQueue) {
                            this.ackQueue.offerPublishCompletion(context.channel, context.view, context.metadata, context.status);
                        }
                        this.oooAckQueue.clear();
                    }
                    if (this.testController.dupNextAck()) {
                        this.ackQueue.offerPublishCompletion(channel, view, metadata, status);
                        this.testController.dupNextAck(false);
                    }
                }
            }
            view.dispose();
        }

        final void onPublishCompletionEvent(AgentQueue.Event event) {
            this.binding.onPublishComplete(event.getChannel(), event.getMessageView(), event.getMessageMetadata(), event.getPublishCompletionStatus());
        }

        final void onMessageEvent(XString topic, long sno, Object message, MessageMetadata metadata, boolean ackRequired, long originTs, long preWireTs) {
            MessageWaypointListenerRegistry.dispatch(MessageWaypointListener.Waypoint.r, MessageWaypointListener.MessagingDirection.Inbound, message);
            this.binding.onMessage(sno, topic, message, metadata, ackRequired, originTs, preWireTs);
        }

        final void onProcessingComplete(long sno) {
            this.msgQueue.onProcessingComplete(sno);
        }

        final void stop() {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Agent " + this + " is stopping...", Tracer.Level.DEBUG);
            }
            this.ackQueue.stop();
            this.msgQueue.stop();
        }

        final void fail() throws SmaException {
            this.binding.fail(new Exception("intentionally failed by test controller"), true);
        }

        final void close() {
            this.stop();
            LoopbackBus.this.acquireReadLock();
            try {
                this.msgQueue.dropOrphanedMessages();
            }
            finally {
                LoopbackBus.this.releaseReadLock();
            }
            LoopbackBus.this.disconnect(this);
        }

        public final AgentTestController getTestController() {
            return this.testController;
        }

        public final boolean equals(Object obj) {
            return ((Agent)obj).addr == this.addr;
        }

        public final int hashCode() {
            return this.addr;
        }

        public final String toString() {
            return this.binding.getUserName() + "(" + this.addr + ")";
        }

        private final class OooAckContext {
            final LoopbackMessageChannel channel;
            final MessageView view;
            final MessageMetadata metadata;
            final Exception status;

            OooAckContext(LoopbackMessageChannel channel, MessageView view, MessageMetadata metadata, Exception status) {
                this.channel = channel;
                this.view = view;
                this.metadata = metadata;
                this.status = status;
            }
        }
    }

    private final class AgentQueue {
        private final int addr;
        private final String name;
        private final AgentParameters parameters;
        private final WaitStrategy waitStrategy;
        private final Processor processor;
        private final GuaranteedQueue guarQueue;
        private final UtlPool<GuarMessage> messagePool;
        private RingBuffer<Event> ringBuffer;
        private SequenceBarrier sequenceBarrier;
        private BatchEventProcessor<Event> batchProcessor;
        private Agent agent;
        private Thread processorThread;
        private volatile AgentQueueState state;

        AgentQueue(String name, boolean addressable) {
            this.addr = addressable ? LoopbackBus.this.currentAddr.incrementAndGet() : 0;
            this.name = name;
            this.parameters = LoopbackBus.this.getAgentParameters(name);
            this.processor = new Processor();
            this.waitStrategy = XRuntime.createWaitStrategy((String)this.parameters.getQueueWaitStrategy().name(), (boolean)false);
            this.messagePool = addressable ? UtlPool.create((String)"sma.loopback.guarmessage", (String)name, (UtlPool.Factory)new UtlPool.Factory<GuarMessage>(){

                public GuarMessage createItem(Object object) {
                    return new GuarMessage();
                }

                public GuarMessage[] createItemArray(int size) {
                    return new GuarMessage[size];
                }
            }, (UtlPool.Params)UtlPool.Params.create().setThreaded(false)) : null;
            this.guarQueue = new GuaranteedQueue();
            this.state = AgentQueueState.Init;
        }

        private final boolean dispatch(long sno, LoopbackMessageChannel channel, Topic topic, Object message, MessageMetadata metadata, boolean canBlock, long originTs, long preWireTs) throws Exception {
            if (this.state == AgentQueueState.Started && (canBlock || this.ringBuffer.hasAvailableCapacity(1))) {
                long sequence = this.ringBuffer.next();
                Event event = (Event)this.ringBuffer.get(sequence);
                event.init().setSno(sno).setChannel(channel).setTopic(topic).setMessage(message).setMessageMetadata(metadata).setOriginTs(originTs).setPreWireTs(preWireTs);
                event.setActivityRecord(LoopbackBus.this.onActivity());
                this.ringBuffer.publish(sequence);
                return true;
            }
            topic.dispose();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void start(Agent agent) throws Exception {
            this.state = AgentQueueState.Starting;
            this.ringBuffer = new RingBuffer((EventFactory)new EventFactory<Event>(){

                public Event newInstance() {
                    return new Event();
                }
            }, (ClaimStrategy)new MultiThreadedClaimStrategy(1024), this.waitStrategy);
            this.sequenceBarrier = UtlThread.asIntrumentedSequenceBarrier((SequenceBarrier)this.ringBuffer.newBarrier(new Sequence[0]));
            this.batchProcessor = new BatchEventProcessor(this.ringBuffer, this.sequenceBarrier, (EventHandler)this.processor);
            this.ringBuffer.setGatingSequences(new Sequence[]{this.batchProcessor.getSequence()});
            this.agent = agent;
            GuaranteedQueue guaranteedQueue = this.guarQueue;
            synchronized (guaranteedQueue) {
                this.state = AgentQueueState.Started;
                this.guarQueue.reset().play();
            }
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "...starting agent queue (agent=" + agent + "')...", Tracer.Level.DEBUG);
            }
            this.processorThread = new Thread((Runnable)this.batchProcessor);
            this.processorThread.setName("X-Loopback-AgentQueue-" + this.name + "-" + this.addr);
            this.processorThread.setDaemon(true);
            this.processorThread.start();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "...agent queue successfully started.", Tracer.Level.DEBUG);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void offerMessage(LoopbackMessageChannel channel, XString topic, Object message, MessageMetadata metadata, long originTs, long preWireTs) throws Exception {
            if (channel.getQos() == MessageChannel.Qos.Guaranteed) {
                GuaranteedQueue guaranteedQueue = this.guarQueue;
                synchronized (guaranteedQueue) {
                    this.guarQueue.enque(channel, topic, message, metadata, originTs, preWireTs).play();
                }
            } else {
                this.dispatch(0L, channel, (Topic)LoopbackBus.this.topicFactory.create(topic, true), message, metadata, true, originTs, preWireTs);
            }
        }

        final void offerPublishCompletion(LoopbackMessageChannel channel, MessageView view, MessageMetadata metadata, Exception status) throws Exception {
            if (this.state == AgentQueueState.Started) {
                if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                    LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "enqueuing publish completion in queue (agent=" + this.agent + "') (status='" + status + "')...", Tracer.Level.DEBUG);
                }
                long sequence = this.ringBuffer.next();
                Event event = (Event)this.ringBuffer.get(sequence);
                event.init().setChannel(channel).setMessageView(view).setMessageMetadata(metadata).setPublishCompletionStatus(status);
                event.setActivityRecord(LoopbackBus.this.onActivity());
                this.ringBuffer.publish(sequence);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onProcessingComplete(long sno) {
            GuaranteedQueue guaranteedQueue = this.guarQueue;
            synchronized (guaranteedQueue) {
                this.guarQueue.onAck(sno);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void dropOrphanedMessages() {
            GuaranteedQueue guaranteedQueue = this.guarQueue;
            synchronized (guaranteedQueue) {
                this.guarQueue.dropUndeliveredOrphanMessages();
            }
        }

        final void stop() {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "...stopping agent queue (agent=" + this.agent + ")...", Tracer.Level.DEBUG);
            }
            if (this.state == AgentQueueState.Started) {
                this.state = AgentQueueState.Stopping;
                while (this.processorThread.isAlive()) {
                    try {
                        this.batchProcessor.halt();
                        this.processorThread.join(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.ringBuffer = null;
                this.sequenceBarrier = null;
                this.batchProcessor = null;
                this.agent = null;
                UtlThread.deregister((Thread)this.processorThread);
                this.processorThread = null;
                this.state = AgentQueueState.Stopped;
                if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                    LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "...agent queue successfully stopped.", Tracer.Level.DEBUG);
                }
            } else if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "...agent queue not started.", Tracer.Level.DEBUG);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void close() {
            if (this.messagePool != null) {
                GuaranteedQueue guaranteedQueue = this.guarQueue;
                synchronized (guaranteedQueue) {
                    this.messagePool.close();
                }
            }
        }

        public final boolean equals(Object obj) {
            return ((AgentQueue)obj).addr == this.addr;
        }

        public final int hashCode() {
            return this.addr;
        }

        public final String toString() {
            return this.name + "<online=" + (this.agent != null) + ">(" + this.addr + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump(StringBuilder sb) {
            sb.append("AgentQueue [").append(this.toString()).append("]\n");
            sb.append("State: ").append((Object)this.state).append("\n");
            GuaranteedQueue guaranteedQueue = this.guarQueue;
            synchronized (guaranteedQueue) {
                sb.append("Guaranteed Messages Pending Ack: ").append(this.guarQueue.ackPendingList.count()).append("\n");
                int i = 1;
                if (this.guarQueue.ackPendingList.count() > 0) {
                    try {
                        UtlPlist.Element elem = this.guarQueue.ackPendingList.first();
                        while (elem != null) {
                            sb.append("Message ").append(i).append(": \n");
                            ((GuarMessage)elem.getObject()).dump(sb);
                            sb.append("\n");
                            elem = (UtlPlist.Element)elem.next();
                            ++i;
                        }
                    }
                    catch (Throwable thrown) {
                        sb.append("ERROR dumping Message ").append(i).append(": \n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)thrown)).append("\n");
                    }
                }
            }
        }

        private final class GuaranteedQueue {
            private final XLongLinkedHashMap<UtlPlist.Element<GuarMessage>> ackPendingMap = new XLongLinkedHashMap(1024);
            private final UtlPlist<GuarMessage> ackPendingList = UtlPlist.create();
            private UtlPlist.Element<GuarMessage> last;
            private long sno;

            GuaranteedQueue() {
            }

            final GuaranteedQueue reset() {
                this.last = null;
                return this;
            }

            final GuaranteedQueue enque(LoopbackMessageChannel channel, XString topic, Object message, MessageMetadata metadata, long originTs, long preWireTs) {
                if (this.ackPendingList.count() < AgentQueue.this.parameters.getQueueCapacity()) {
                    ++this.sno;
                    this.ackPendingMap.put(this.sno, (Object)this.ackPendingList.append((Object)((GuarMessage)AgentQueue.this.messagePool.get(null)).init(this.sno, channel, topic, message, metadata, originTs, preWireTs, LoopbackBus.this.onActivity())));
                } else if (AgentQueue.this.parameters.getErrorOnQueueFull()) {
                    throw new IllegalStateException("queue is full");
                }
                return this;
            }

            final void onAck(long sno) {
                UtlPlist.Element element = (UtlPlist.Element)this.ackPendingMap.remove(sno);
                if (element != null) {
                    LoopbackBus.this.onActivityQuieten(((GuarMessage)element.getObject()).activityRecord);
                    GuarMessage msg = (GuarMessage)element.getObject();
                    msg.onAck();
                    this.ackPendingList.remove(element);
                    if (this.last == element) {
                        this.last = null;
                    }
                    msg.dispose();
                } else {
                    LoopbackBus.this.onActivityQuieten(null);
                }
            }

            final void play() throws Exception {
                UtlPlist.Element element;
                UtlPlist.Element element2 = element = this.last == null ? this.ackPendingList.first() : (UtlPlist.Element)this.last.next();
                while (element != null) {
                    GuarMessage message = (GuarMessage)element.getObject();
                    message.topic.acquire();
                    if (!AgentQueue.this.dispatch(message.sno, message.channel, message.topic, message.message, message.metadata, false, message.originTs, message.preWireTs)) break;
                    this.last = element;
                    element = (UtlPlist.Element)element.next();
                }
            }

            final void replay() throws Exception {
                Replayer replayer = new Replayer();
                replayer.setName("X-Loopback-GuarQueueReplayer-" + AgentQueue.this.name + "-" + AgentQueue.this.addr);
                replayer.start();
            }

            final void dropUndeliveredOrphanMessages() {
                UtlPlist.Element pendingGuarElement = this.ackPendingList.first();
                while (pendingGuarElement != null) {
                    boolean matches = false;
                    GuarMessage message = (GuarMessage)pendingGuarElement.getObject();
                    HstrTable.Node node = LoopbackBus.this.forwardingTable.get(message.topic.getValue());
                    if (node != null) {
                        ForwardingEntry entry = (ForwardingEntry)node.getObject();
                        if (entry.set != null) {
                            Object[] elements = entry.set.elements();
                            int size = entry.set.size();
                            if (size > 0) {
                                for (int i = 0; i < size; ++i) {
                                    ForwardingElement element = (ForwardingElement)elements[i];
                                    if (element.queue == null || element.queue.guarQueue != this) continue;
                                    matches = true;
                                    break;
                                }
                            }
                        }
                    }
                    UtlPlist.Element current = pendingGuarElement;
                    pendingGuarElement = (UtlPlist.Element)pendingGuarElement.next();
                    if (matches) continue;
                    if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                        LoopbackBus.this.tracer.log("Discarding orphaned guaranteed message: " + current.getObject(), Tracer.Level.DEBUG);
                    }
                    this.onAck(((GuarMessage)current.getObject()).sno);
                }
            }

            private final class Replayer
            extends Thread {
                private Replayer() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public final void run() {
                    try {
                        GuaranteedQueue guaranteedQueue = GuaranteedQueue.this;
                        synchronized (guaranteedQueue) {
                            GuaranteedQueue.this.play();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private final class Processor
        implements EventHandler<Event> {
            private Processor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void onEvent(Event event, long sequence, boolean endOfBatch) throws Exception {
                if (event.isPublishCompletion()) {
                    AgentQueue.this.agent.onPublishCompletionEvent(event);
                } else {
                    try {
                        AgentQueue.this.agent.onMessageEvent((XString)event.getTopic(), event.getSno(), event.getMessage(), event.getMessageMetadata(), event.ackRequired(), event.getOriginTs(), event.getPreWireTs());
                    }
                    finally {
                        event.getTopic().dispose();
                    }
                }
                LoopbackBus.this.onActivityQuieten(event.getActivityRecord());
                if (endOfBatch) {
                    GuaranteedQueue guaranteedQueue = AgentQueue.this.guarQueue;
                    synchronized (guaranteedQueue) {
                        AgentQueue.this.guarQueue.play();
                    }
                }
            }
        }

        private final class Event {
            private LoopbackMessageChannel channel;
            private Topic topic;
            private MessageView view;
            private Object message;
            private MessageMetadata metadata;
            private boolean isPublishCompletion;
            private Exception publishCompletionStatus;
            private long sno;
            private long originTs;
            private long preWireTs;
            private ActivityTracker.ActivityRecord activityRecord;

            private Event() {
            }

            public final Event init() {
                this.channel = null;
                this.view = null;
                this.message = null;
                this.metadata = null;
                this.isPublishCompletion = false;
                this.publishCompletionStatus = null;
                this.sno = 0L;
                this.originTs = 0L;
                this.preWireTs = 0L;
                this.setActivityRecord(null);
                return this;
            }

            public final Event setSno(long sno) {
                this.sno = sno;
                return this;
            }

            public final long getSno() {
                return this.sno;
            }

            public final Event setChannel(LoopbackMessageChannel channel) {
                this.channel = channel;
                return this;
            }

            public final LoopbackMessageChannel getChannel() {
                return this.channel;
            }

            public final boolean ackRequired() {
                return this.channel != null && this.channel.getQos() == MessageChannel.Qos.Guaranteed;
            }

            public final Event setTopic(Topic topic) {
                this.topic = topic;
                return this;
            }

            public final Topic getTopic() {
                return this.topic;
            }

            public final Event setMessageView(MessageView view) {
                this.view = view;
                if (this.view != null) {
                    this.view.acquire();
                }
                return this;
            }

            public final MessageView getMessageView() {
                return this.view;
            }

            public final Event setMessage(Object message) {
                this.message = message;
                if (message instanceof IOBuffer) {
                    ((IOBuffer)message).acquire();
                }
                return this;
            }

            public final Object getMessage() {
                return this.message;
            }

            public final Event setMessageMetadata(MessageMetadata metadata) {
                this.metadata = metadata;
                if (metadata != null) {
                    this.metadata.acquire();
                }
                return this;
            }

            public final MessageMetadata getMessageMetadata() {
                return this.metadata;
            }

            public final Event setPublishCompletionStatus(Exception status) {
                this.isPublishCompletion = true;
                this.publishCompletionStatus = status;
                return this;
            }

            public final boolean isPublishCompletion() {
                return this.isPublishCompletion;
            }

            public final Exception getPublishCompletionStatus() {
                return this.publishCompletionStatus;
            }

            public final Event setOriginTs(long ts) {
                this.originTs = ts;
                return this;
            }

            public final long getOriginTs() {
                return this.originTs;
            }

            public final Event setPreWireTs(long ts) {
                this.preWireTs = ts;
                return this;
            }

            public final long getPreWireTs() {
                return this.preWireTs;
            }

            public final Event setActivityRecord(ActivityTracker.ActivityRecord record) {
                this.activityRecord = record;
                if (record != null) {
                    record.setDescription(this.toString());
                }
                return this;
            }

            public ActivityTracker.ActivityRecord getActivityRecord() {
                return this.activityRecord;
            }

            public final String toString() {
                return "Event [channel=" + this.channel.getName() + ", sno=" + this.sno + ", isCompletion=" + this.isPublishCompletion + "]";
            }
        }

        private final class GuarMessage
        implements UtlPool.Item<GuarMessage> {
            final Topic topic;
            long sno;
            LoopbackMessageChannel channel;
            Object message;
            MessageMetadata metadata;
            long originTs;
            long preWireTs;
            ActivityTracker.ActivityRecord activityRecord;
            AtomicLong pendingGuarCount;
            UtlPool<GuarMessage> pool;

            GuarMessage() {
                this.topic = (Topic)LoopbackBus.this.topicFactory.create(true);
            }

            public final GuarMessage init(long sno, LoopbackMessageChannel channel, XString topic, Object message, MessageMetadata metadata, long originTs, long preWireTs, ActivityTracker.ActivityRecord activityRecord) {
                this.sno = sno;
                this.channel = channel;
                this.topic.setValue(topic);
                this.message = message;
                this.metadata = metadata;
                this.metadata.acquire();
                this.originTs = originTs;
                this.preWireTs = preWireTs;
                this.activityRecord = activityRecord;
                this.pendingGuarCount = LoopbackBus.this.pendingGuarCount;
                if (activityRecord != null) {
                    this.activityRecord.setDescription(this.toString());
                }
                this.pendingGuarCount.incrementAndGet();
                if (message != null && message instanceof IOBuffer) {
                    ((IOBuffer)message).acquire();
                }
                return this;
            }

            public GuarMessage init() {
                this.sno = 0L;
                this.channel = null;
                this.topic.reset();
                this.message = null;
                this.metadata = null;
                this.originTs = 0L;
                this.preWireTs = 0L;
                this.activityRecord = null;
                this.pendingGuarCount = null;
                return this;
            }

            public GuarMessage setPool(UtlPool<GuarMessage> pool) {
                this.pool = pool;
                return this;
            }

            public UtlPool<GuarMessage> getPool() {
                return this.pool;
            }

            public void dispose() {
                block4: {
                    this.metadata.dispose();
                    if (this.message != null && this.message instanceof IOBuffer) {
                        ((IOBuffer)this.message).dispose();
                    }
                    if (this.pool != null) {
                        try {
                            this.pool.put((UtlPool.Item)this);
                        }
                        catch (IllegalStateException re) {
                            if (!this.pool.isClosed() || AgentQueue.this.state != AgentQueueState.Started) break block4;
                            throw re;
                        }
                    }
                }
            }

            public final String toString() {
                return "Message [channel=" + this.channel.getName() + ", topic=" + (Object)((Object)this.topic) + ", sno=" + this.sno + "]";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void onAck() {
                long pendingGuars = this.pendingGuarCount.decrementAndGet();
                if (pendingGuars < 0L) {
                    throw new IllegalStateException(AgentQueue.this.toString() + ": Negative pending guar count onAck: " + pendingGuars);
                }
                if (pendingGuars == 0L && LoopbackBus.this.waitingForPendingAcks > 0) {
                    Object object = LoopbackBus.this.pendingGuarNotify;
                    synchronized (object) {
                        LoopbackBus.this.pendingGuarNotify.notifyAll();
                    }
                }
            }

            public void dump(StringBuilder sb) {
                MessageViewFactory factory;
                sb.append("  Channel....").append(this.metadata.getMessageChannelName()).append("\n");
                sb.append("  Topic......").append((CharSequence)((Object)this.topic)).append("\n");
                sb.append("  SeqNo......").append(this.metadata.getMessageSno()).append("\n");
                if (this.preWireTs > 0L) {
                    sb.append("  PreWireTs...").append(new Date(this.preWireTs)).append("\n");
                }
                if ((factory = MessageViewFactoryRegistry.getInstance().getMessageViewFactory(this.metadata.getMessageViewFactory())) != null) {
                    short type = this.metadata.getMessageViewType();
                    byte encodingType = this.metadata.getMessageEncodingType();
                    Object smaMessage = this.message;
                    switch (encodingType) {
                        case 1: {
                            smaMessage = this.message != null ? ((IOBuffer)this.message).getBufferUnsafe() : null;
                            break;
                        }
                        case 3: 
                        case 6: 
                        case 7: {
                            smaMessage = this.message != null ? ((IOBuffer)this.message).getBufferUnsafe() : null;
                            break;
                        }
                        case 4: {
                            smaMessage = this.message != null ? ((IOBuffer)this.message).getBufferUnsafe() : null;
                        }
                    }
                    MessageView view = factory.wrap(type, encodingType, smaMessage);
                    view.setPreWireTs(this.preWireTs);
                    view.setOriginTs(this.originTs);
                    view.setMessageChannel(this.metadata.getMessageChannelName());
                    view.setMessageSender(this.metadata.getMessageSender());
                    view.setMessageFlow(this.metadata.getMessageFlow());
                    view.setMessageSequenceNumber(this.sno);
                    sb.append("  Payload...").append(view.toString()).append("\n");
                } else {
                    sb.append("  Payload...").append(this.message).append("\n");
                }
            }
        }
    }

    private static enum AgentQueueState {
        Init,
        Starting,
        Started,
        Stopping,
        Stopped;

    }

    public final class AgentTestController {
        private final String agentName;
        private boolean failNextPublishWithException;
        private boolean failNextPublish;
        private boolean failNextConnect;
        private boolean failNextConnectPermanent;
        private boolean failAllConnects;
        private boolean failNextStart;
        private boolean congested;
        private boolean dropNextAck;
        private boolean dupNextAck;
        private int oooAckGap;

        AgentTestController(String agentName) {
            this.agentName = agentName;
        }

        public final String getAgentName() {
            return this.agentName;
        }

        public final AgentTestController failNextConnect(boolean val, boolean permanent) {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Setting failNextConnect=" + val + " (permanent=" + permanent + ") for agent " + this.agentName + ".", Tracer.Level.DEBUG);
            }
            if (permanent) {
                this.failNextConnectPermanent = val;
            } else {
                this.failNextConnect = val;
            }
            return this;
        }

        public final boolean failNextConnect() {
            return this.failNextConnect;
        }

        public final boolean failNextConnectPermanent() {
            return this.failNextConnectPermanent;
        }

        public final AgentTestController failAllConnects(boolean val, boolean permanent) {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Setting failAllConnects=" + val + " (permanent=" + permanent + ") for agent " + this.agentName + ".", Tracer.Level.DEBUG);
            }
            this.failNextConnect(val, permanent);
            this.failAllConnects = true;
            return this;
        }

        public final boolean failAllConnects() {
            return this.failNextConnect && this.failAllConnects;
        }

        public final boolean failAllConnectsPermanent() {
            return this.failNextConnectPermanent && this.failAllConnects;
        }

        public final AgentTestController failNextStart(boolean val) {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Setting failNextStart=" + val + " for agent " + this.agentName + ".", Tracer.Level.DEBUG);
            }
            this.failNextStart = true;
            return this;
        }

        public final boolean failNextStart() {
            return this.failNextStart;
        }

        public final AgentTestController failNextPublish(boolean val) {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Setting failNextPublish=" + val + " for agent " + this.agentName + ".", Tracer.Level.DEBUG);
            }
            this.failNextPublish = val;
            return this;
        }

        public final AgentTestController failNextPublishWithException(boolean val) {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Setting failNextPublishWithException=" + val + " for agent " + this.agentName + ".", Tracer.Level.DEBUG);
            }
            this.failNextPublishWithException = val;
            return this;
        }

        public final boolean failNextPublish() {
            return this.failNextPublish;
        }

        public final boolean failNextPublishWithException() {
            return this.failNextPublishWithException;
        }

        public final AgentTestController failConnection() throws SmaException {
            Agent agent = LoopbackBus.this.getAgent(this.agentName);
            if (agent == null) {
                throw new IllegalStateException("agent is not connected to the bus");
            }
            agent.fail();
            return this;
        }

        public final AgentTestController setCongested(boolean val) {
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Setting congestion=" + val + " for agent " + this.agentName + ".", Tracer.Level.DEBUG);
            }
            this.congested = val;
            return this;
        }

        public final boolean isCongested() {
            return this.congested;
        }

        public final AgentTestController dropNextAck(boolean val) {
            if (this.dupNextAck) {
                throw new IllegalStateException("'dup next ack' is set. cannot configure 'dup next ack' and 'drop next ack' together");
            }
            if (this.oooAckGap > 0) {
                throw new IllegalStateException("'ooo gap size' is set. cannot configure 'drop next ack' and 'ooo ack dispatch' together");
            }
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Setting 'drop next ack'=" + val + " for agent " + this.agentName + ".", Tracer.Level.DEBUG);
            }
            this.dropNextAck = val;
            return this;
        }

        public final boolean dropNextAck() {
            return this.dropNextAck;
        }

        public final AgentTestController dupNextAck(boolean val) {
            if (this.dropNextAck) {
                throw new IllegalStateException("'drop next ack' is set. cannot configure 'dup next ack' and 'drop next ack' together");
            }
            if (this.oooAckGap > 0) {
                throw new IllegalStateException("'ooo gap size' is set. cannot configure 'dup next ack' and 'ooo ack dispatch' together");
            }
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Setting 'dup next ack'=" + val + " for agent " + this.agentName + ".", Tracer.Level.DEBUG);
            }
            this.dupNextAck = val;
            return this;
        }

        public final boolean dupNextAck() {
            return this.dupNextAck;
        }

        public final AgentTestController oooAckGap(int val) {
            if (val > 0 && this.dupNextAck) {
                throw new IllegalStateException("'dup next ack' is set. cannot configure 'dup next ack' and 'ooo ack dispatch' together");
            }
            if (val > 0 && this.dropNextAck) {
                throw new IllegalStateException("'drop next ack' is set. cannot configure 'dup next ack' and 'ooo ack dispatch' together");
            }
            if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "Setting 'out of order ack gap size'=" + val + " for agent " + this.agentName + ".", Tracer.Level.DEBUG);
            }
            this.oooAckGap = val;
            return this;
        }

        public final int oooAckGap() {
            return this.oooAckGap;
        }
    }

    public final class TestController {
        public final void forward(LoopbackMessageChannel channel, XString topic, Object message, MessageMetadata metadata, long originTs, long preWireTs) throws Exception {
            LoopbackBus.this.forward(null, channel, topic, message, metadata, originTs, preWireTs);
        }
    }

    public final class AgentParameters {
        private int queueCapacity = Integer.MAX_VALUE;
        private boolean errorOnQueueFull = false;
        private AgentQueueWaitStrategy queueWaitStrategy = AgentQueueWaitStrategy.Sleeping;

        public final void setQueueCapacity(int val) {
            if (val < 0) {
                throw new IllegalArgumentException("capacity must be >= 0");
            }
            this.queueCapacity = val;
        }

        public final int getQueueCapacity() {
            return this.queueCapacity;
        }

        public final void setErrorOnQueueFull(boolean val) {
            this.errorOnQueueFull = val;
        }

        public final boolean getErrorOnQueueFull() {
            return this.errorOnQueueFull;
        }

        public final void setQueueWaitStrategy(AgentQueueWaitStrategy val) {
            this.queueWaitStrategy = val;
        }

        public final AgentQueueWaitStrategy getQueueWaitStrategy() {
            return this.queueWaitStrategy;
        }
    }

    public static enum AgentQueueWaitStrategy {
        Blocking,
        BusySpin,
        Sleeping,
        Yielding;

    }

    private final class SubscriptionTable
    extends OpenIntObjectHashMap {
        private static final long serialVersionUID = 3947454293545394843L;

        private SubscriptionTable() {
        }

        private final void update(int addr, String topic, boolean flgAdd) {
            HashSet<String> subscriptionSet = this.get(addr);
            if (flgAdd) {
                if (subscriptionSet == null) {
                    subscriptionSet = new HashSet<String>();
                    this.put(addr, subscriptionSet);
                }
                subscriptionSet.add(topic);
            } else if (subscriptionSet != null) {
                subscriptionSet.remove(topic);
                if (subscriptionSet.isEmpty()) {
                    this.removeKey(addr);
                }
            }
        }

        public Set<String> get(int address) {
            return (Set)super.get(address);
        }
    }

    private final class ForwardingTable
    extends HstrTable<ForwardingEntry> {
        ForwardingTable() {
            super(null, 0);
        }

        final ForwardingEntry update(String topic, boolean flgAddRemove, AgentQueue queue) throws EHstrFormatException {
            ForwardingEntry entry;
            HstrTable.Node node = this.get(topic);
            ForwardingEntry forwardingEntry = entry = node == null ? null : (ForwardingEntry)this.get(topic).getObject();
            if (node != null && entry == null) {
                throw new InternalError("HSTR table returned a node with a null entry!");
            }
            if (entry == null && flgAddRemove) {
                if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                    LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "  c[" + topic + "]", Tracer.Level.DEBUG);
                }
                entry = new ForwardingEntry();
                this.put(topic, entry);
                LinkedHashMap map = this.matches(topic);
                for (Map.Entry mapEntry : map.entrySet()) {
                    ForwardingEntry matchEntry = (ForwardingEntry)((HstrTable.Node)mapEntry.getValue()).getObject();
                    if (matchEntry.set == null) continue;
                    Object[] elements = matchEntry.set.elements();
                    for (int i = 0; i < matchEntry.set.size(); ++i) {
                        ForwardingElement element = (ForwardingElement)elements[i];
                        if (!element.explicit) continue;
                        int count = entry.add(element.queue, false);
                        if (!((LoopbackBus)LoopbackBus.this).tracer.debug) continue;
                        LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "  +i" + count + "[" + topic + ", " + element.queue + "] via '" + (String)mapEntry.getKey() + "'", Tracer.Level.DEBUG);
                    }
                }
            }
            if (entry != null && queue != null) {
                LinkedHashMap map;
                if (flgAddRemove) {
                    if (!entry.contains(queue.addr, true)) {
                        int count = entry.add(queue, true);
                        if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                            LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "  +e" + count + "[" + topic + ", " + queue + "]", Tracer.Level.DEBUG);
                        }
                        map = this.matches(topic);
                        for (Map.Entry mapEntry : map.entrySet()) {
                            ForwardingEntry matchEntry = (ForwardingEntry)((HstrTable.Node)mapEntry.getValue()).getObject();
                            count = matchEntry.add(queue, false);
                            if (!((LoopbackBus)LoopbackBus.this).tracer.debug) continue;
                            LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "  +i" + count + "[" + (String)mapEntry.getKey() + ", " + queue + "] via '" + topic + "'", Tracer.Level.DEBUG);
                        }
                    } else if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                        LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "  !d[" + topic + ", " + queue + "]", Tracer.Level.DEBUG);
                    }
                } else if (entry.contains(queue.addr, true)) {
                    int count = entry.remove(queue.addr, true);
                    if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                        LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "  -e" + count + "[" + topic + ", " + queue + "]", Tracer.Level.DEBUG);
                    }
                    map = this.matches(topic);
                    Iterator matchesIterator = map.entrySet().iterator();
                    ArrayList matchEntriesToRemove = new ArrayList();
                    while (matchesIterator.hasNext()) {
                        Map.Entry mapEntry = matchesIterator.next();
                        ForwardingEntry forwardingEntry2 = (ForwardingEntry)((HstrTable.Node)mapEntry.getValue()).getObject();
                        count = forwardingEntry2.remove(queue.addr, false);
                        if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                            LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "  -i" + count + "[" + (String)mapEntry.getKey() + ", " + queue + "] via '" + topic + "'", Tracer.Level.DEBUG);
                        }
                        if (!forwardingEntry2.isEmpty() || forwardingEntry2.isPinned()) continue;
                        matchEntriesToRemove.add(mapEntry);
                    }
                    for (Map.Entry entry2 : matchEntriesToRemove) {
                        if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                            LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "  d[" + (String)entry2.getKey() + "]", Tracer.Level.DEBUG);
                        }
                        this.remove((String)entry2.getKey());
                    }
                } else if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                    LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "  !x[" + topic + ", " + queue + "]", Tracer.Level.DEBUG);
                }
                if (entry.isEmpty() && !entry.isPinned()) {
                    if (((LoopbackBus)LoopbackBus.this).tracer.debug) {
                        LoopbackBus.this.tracer.log(LoopbackBus.this.tracePrefix + "  d[" + topic + "]", Tracer.Level.DEBUG);
                    }
                    this.remove(topic);
                }
            }
            return entry;
        }
    }

    private final class ForwardingEntry {
        ForwardingSet set;
        boolean pinned;

        private ForwardingEntry() {
        }

        final int add(AgentQueue queue, boolean explicit) {
            if (this.set == null) {
                this.set = new ForwardingSet();
            }
            return this.set.add(queue, explicit);
        }

        final boolean contains(int addr, boolean explicit) {
            ForwardingElement element;
            ForwardingElement forwardingElement = element = this.set != null ? this.set.get(addr) : null;
            if (element != null) {
                return !explicit || element.explicit;
            }
            return false;
        }

        final int remove(int addr, boolean explicit) {
            int ret = -1;
            if (this.set != null) {
                ret = this.set.remove(addr, explicit);
                if (this.set.isEmpty()) {
                    this.set = null;
                }
            }
            return ret;
        }

        final void setPinned(boolean val) {
            this.pinned = val;
        }

        final boolean isPinned() {
            return this.pinned;
        }

        final boolean isEmpty() {
            return this.set == null;
        }
    }

    private final class ForwardingSet {
        private final ObjectArrayList list = new ObjectArrayList();
        private final OpenIntObjectHashMap map = new OpenIntObjectHashMap();

        ForwardingSet() {
        }

        final int add(AgentQueue queue, boolean explicit) {
            ForwardingElement element = (ForwardingElement)this.map.get(queue.addr);
            if (element == null) {
                element = new ForwardingElement(queue);
                this.list.add((Object)element);
                this.map.put(queue.addr, (Object)element);
            } else if (!explicit || !element.explicit) {
                ++element.refCount;
            }
            element.explicit |= explicit;
            return element.refCount;
        }

        final ForwardingElement get(int addr) {
            return (ForwardingElement)this.map.get(addr);
        }

        final int size() {
            return this.list.size();
        }

        final boolean isEmpty() {
            return this.size() == 0;
        }

        final int remove(int addr, boolean explicit) {
            int ret = -1;
            ForwardingElement element = (ForwardingElement)this.map.get(addr);
            if (element != null) {
                if (!explicit || element.explicit) {
                    if (--element.refCount == 0) {
                        int index = this.list.indexOf((Object)element, true);
                        this.list.removeFromTo(index, index);
                        this.map.removeKey(element.queue.addr);
                    }
                    if (explicit) {
                        element.explicit = false;
                    }
                }
                ret = element.refCount;
            }
            return ret;
        }

        final Object[] elements() {
            return this.list.elements();
        }
    }

    private final class ForwardingElement {
        final AgentQueue queue;
        int refCount;
        boolean explicit;

        ForwardingElement(AgentQueue queue) {
            this.queue = queue;
            this.refCount = 1;
        }

        final void setExplicit(boolean val) {
            this.explicit = val;
        }

        public final boolean equals(Object obj) {
            return ((ForwardingElement)obj).queue.equals(this.queue);
        }

        public final int hashCode() {
            return this.queue.hashCode();
        }
    }

    static final class Topic
    extends XAbstractPooledString<Topic> {
        protected Topic(boolean isNative, boolean mutable, int initialLength) {
            super(isNative, mutable, initialLength);
        }

        static final class Factory
        extends XAbstractPooledString.PooledStringFactory<Topic> {
            Factory() {
            }

            protected final String getTypeName() {
                return "sma.loopback.topic";
            }

            protected final Class<Topic> getType() {
                return Topic.class;
            }

            protected final Topic create(boolean isNative, boolean mutable, int initialLength) {
                return new Topic(isNative, mutable, initialLength);
            }

            protected final Topic[] newArray(int size) {
                return new Topic[size];
            }

            protected int getDefaultInitialStringLength() {
                return 64;
            }
        }
    }
}

