/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.event;

import com.neeve.event.Event;
import com.neeve.event.EventFactory;
import com.neeve.event.IEventAcknowledger;
import com.neeve.event.IEventSource;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import com.neeve.sma.event.MessageChannelEvent;
import java.util.Properties;

public final class MessageEvent
extends Event
implements MessageChannelEvent {
    private MessageChannel channel;
    private MessageView view;
    private boolean autoAck;

    private MessageEvent() {
        super((short)105);
    }

    public static Event create(Properties props) {
        return new MessageEvent();
    }

    public static MessageEvent create(MessageBusBinding binding, MessageChannel channel, MessageView view, IEventAcknowledger acknowledger) {
        return ((MessageEvent)EventFactory.getInstance().createEvent((short)105)).init(binding, channel, view, acknowledger);
    }

    private final MessageEvent init(MessageBusBinding binding, MessageChannel channel, MessageView view, IEventAcknowledger acknowledger) {
        super.init((IEventSource)binding, acknowledger);
        this.channel = channel;
        this.view = view;
        this.autoAck = true;
        return this;
    }

    protected final void reset() {
        this.channel = null;
        this.view = null;
        this.autoAck = false;
    }

    protected final void preDispose() {
        IEventAcknowledger acknowledger = this.getAcknowledger();
        if (acknowledger != null && this.getAutoAck()) {
            try {
                acknowledger.ack();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.view != null) {
            this.view.dispose();
        }
    }

    @Override
    public final MessageChannel getMessageChannel() {
        return this.channel;
    }

    public final MessageView getMessageView() {
        return this.view;
    }

    public final void setAutoAck(boolean val) {
        this.autoAck = val;
    }

    public final boolean getAutoAck() {
        return this.autoAck;
    }

    @Override
    public final boolean isLocal() {
        return this.view == null || this.view.getMessageChannelAsRaw() == null || this.view.getMessageChannelAsRaw().isNull();
    }

    public final String toString() {
        return "[event=MESSAGE, " + super.toString() + ", channel=" + (this.channel == null ? "null" : this.channel.getName()) + ", view=" + (this.view != null ? this.view.getClass().getName() : "null") + ", autoAck=" + this.getAutoAck() + ", local=" + this.isLocal() + "]";
    }
}

