/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.sma.MessagingProvider;
import com.neeve.sma.MessagingProviderDescriptor;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.sma.SmaPermanentException;
import com.neeve.trace.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;

public final class MessagingProviderRegistry
extends SmaObject {
    private static final MessagingProviderRegistry instance = new MessagingProviderRegistry();
    private final HashMap<String, MessagingProvider> providers = new HashMap();

    private MessagingProviderRegistry() {
        super(null);
    }

    public static final MessagingProviderRegistry getInstance() {
        return instance;
    }

    private final MessagingProvider createProvider(String className, String name, Properties props) throws SmaException {
        Class<?> providerClass = null;
        try {
            providerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SmaException("Messaging provider class [" + className + "] could not be found");
        }
        catch (UnsupportedClassVersionError e) {
            throw new SmaException("Messaging provider class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
        }
        Method providerCreateMethod = null;
        try {
            Class[] parameterTypes = new Class[]{Class.forName("java.lang.String"), Class.forName("java.util.Properties")};
            providerCreateMethod = providerClass.getMethod("create", parameterTypes);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Failed to load java.util.Properties during instantiation of messaging provider class [" + className + "]");
        }
        catch (SecurityException e) {
            throw new SmaException("Access to instantiation method in messaging provider class [" + className + "] is denied");
        }
        catch (NoSuchMethodException e) {
            throw new SmaException("Instantiation method in messaging provider class [" + className + "] could not be found");
        }
        MessagingProvider provider = null;
        try {
            try {
                Object[] parameters = new Object[]{name, props};
                provider = (MessagingProvider)providerCreateMethod.invoke(null, parameters);
                if (provider == null) {
                    throw new SmaException("Instantiation method in messaging provider class [" + className + "] returned a null object");
                }
            }
            catch (ClassCastException e) {
                throw new SmaException("Instantiation method in messaging provider class [" + className + "] returned object of incorrect type");
            }
        }
        catch (IllegalAccessException e) {
            throw new SmaException("Access to instantiation method in messaging provider class [" + className + "] is denied");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof SmaException) {
                throw (SmaException)e.getCause();
            }
            throw new SmaException(e.getCause());
        }
        return provider;
    }

    private final MessagingProvider createProvider(String name) throws SmaException {
        if (MessagingProviderDescriptor.exists(name)) {
            try {
                MessagingProviderDescriptor descriptor = MessagingProviderDescriptor.load(name);
                return this.createProvider(descriptor.getClassName(), descriptor.getName(), descriptor.getProperties());
            }
            catch (SmaException e) {
                throw new SmaPermanentException("Failed to load provider descriptor from configuration repository [" + e.toString() + "]");
            }
        }
        throw new SmaPermanentException("invalid provider '" + name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerProvider(MessagingProvider provider) throws SmaException {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        HashMap<String, MessagingProvider> hashMap = this.providers;
        synchronized (hashMap) {
            if (this.tracer.debug) {
                this.tracer.log("[MessagingProviderRegistry] Registering provider '" + provider.getName() + "'...", Tracer.Level.DEBUG);
            }
            this.providers.put(provider.getName(), provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessagingProvider getProvider(String name) throws SmaException {
        if (name == null) {
            throw new IllegalArgumentException("provider name cannot be null");
        }
        HashMap<String, MessagingProvider> hashMap = this.providers;
        synchronized (hashMap) {
            MessagingProvider provider;
            if (this.tracer.debug) {
                this.tracer.log("[MessagingProviderRegistry] Getting provider '" + name + "'...", Tracer.Level.DEBUG);
            }
            if ((provider = this.providers.get(name)) == null) {
                if (this.tracer.debug) {
                    this.tracer.log("[MessagingProviderRegistry] Messaging provider not created. Creating...", Tracer.Level.DEBUG);
                }
                provider = this.createProvider(name);
                this.providers.put(name, provider);
            } else if (this.tracer.debug) {
                this.tracer.log("[MessagingProviderRegistry] Messaging provider already created. Returning...", Tracer.Level.DEBUG);
            }
            return provider;
        }
    }
}

