/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public final class XbufVariableLongField
extends XbufField {
    private final Value value = new Value();

    private XbufVariableLongField(short id, String name) {
        super(XbufField.Type.VARLONG, id, name, false, false);
    }

    public static XbufVariableLongField create(short id, String name) {
        return new XbufVariableLongField(id, name);
    }

    final int serializedLength(long val) {
        return CodedOutputStream.computeRawVarint64Size((long)val);
    }

    final int serialize(PktBuffer buffer, int offset, long val) {
        return XbufVariableLongField.syncVarint64(val, buffer, offset);
    }

    final long deserialize(PktBuffer buffer, int offset) {
        return XbufVariableLongField.desyncVarint64(buffer, offset, this.varintDesyncLength);
    }

    final String toString(long val) {
        return String.valueOf(val);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        return this.serialize(buffer, offset, this.getValue());
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return this.varintDesyncLength.value;
    }

    @Override
    protected final int contentLength() {
        return this.serializedLength(this.getValue());
    }

    @Override
    protected final String contentAsString() {
        return this.toString(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        this.value.val = 0L;
        return this.container.clearValue(this);
    }

    public final void setValue(long val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.val = val;
        this.container.setValue(this, this.value);
    }

    public final void setValueFrom(XbufVariableLongField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final long getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : 0L;
    }

    static final int serializeField(PktBuffer buffer, int offset, short id, long v) {
        int headerLength = XbufVariableLongField.syncHeader(buffer, offset, id, XbufField.Type.VARLONG, CodedOutputStream.computeRawVarint64Size((long)v));
        int valLength = XbufVariableLongField.syncVarint64(v, buffer, offset + headerLength);
        return headerLength + valLength;
    }

    public static int serializedFieldLength(short id, short v) {
        int len = CodedOutputStream.computeRawVarint64Size((long)v);
        return len + XbufVariableLongField.headerLength(id, XbufField.Type.VARLONG, len);
    }

    static final long deserializeValue(PktBuffer buffer, int offset, XbufField.VarintDesyncLength varintDesyncLength) {
        return XbufVariableLongField.desyncVarint64(buffer, offset, varintDesyncLength);
    }

    static final long deserializeField(PktBuffer buffer, int offset, short id, XbufField.VarintDesyncLength varintDesyncLength) {
        int tag = XbufVariableLongField.desyncVarint32(buffer, offset, varintDesyncLength);
        int tagLength = varintDesyncLength.value;
        if (id != XbufVariableLongField.fieldId(tag)) {
            throw new IllegalArgumentException("attempt to desync a field using a different field on the wire!");
        }
        long value = XbufVariableLongField.deserializeValue(buffer, offset + tagLength, varintDesyncLength);
        varintDesyncLength.value += tagLength;
        return value;
    }

    private final class Value {
        long val;

        private Value() {
        }
    }
}

