/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.lang.XIntArrayIterator;
import com.neeve.lang.XIntIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableLengthField;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class XbufIntArrayField
extends XbufVariableLengthField<int[]> {
    private final Iterator iterator = new Iterator();

    private XbufIntArrayField(short id, String name) {
        super(XbufField.Type.INTEGER_ARRAY, id, name);
    }

    public static XbufIntArrayField create(short id, String name) {
        return new XbufIntArrayField(id, name);
    }

    @Override
    protected final int serializedLength(int[] val) {
        return val == null ? 0 : val.length * 4;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, int[] val) {
        buffer.putFrom(offset, val, 0, val.length);
        return val.length * 4;
    }

    @Override
    protected final int[] deserialize(PktBuffer buffer, int offset, int length) {
        int[] val = new int[length / 4];
        if (length > 0) {
            buffer.getTo(offset, val, 0, val.length);
        }
        return val;
    }

    public final void setValues(int[] values) {
        super.setValue(values);
    }

    public final int[] getValues() {
        return (int[])super.getValue();
    }

    public final int[] getValuesAsArray() {
        return (int[])super.getValue();
    }

    public final void setValuesFrom(XIntIterator val) {
        int[] v;
        if (val instanceof Iterator) {
            v = ((Iterator)val).array();
        } else if (val instanceof XIntArrayIterator) {
            XIntArrayIterator a = (XIntArrayIterator)val;
            v = a.array();
            if (v.length != a.length()) {
                v = new int[a.length()];
                System.arraycopy(a.array(), a.offset(), v, 0, a.length());
            }
        } else {
            int size = 0;
            val.toFirst();
            while (val.hasNext()) {
                ++size;
                val.next();
            }
            v = new int[size];
            val.toFirst();
            for (int i = 0; i < v.length; ++i) {
                v[i] = val.next();
            }
        }
        this.setValue(v);
        val.toFirst();
    }

    public final void addValue(int val) {
        int[] vArray;
        int[] existing = (int[])this.getValue();
        if (this.getValue() == null) {
            vArray = new int[1];
        } else {
            vArray = new int[existing.length + 1];
            System.arraycopy(existing, 0, vArray, 0, existing.length);
            vArray[vArray.length - 1] = val;
        }
        this.setValue(vArray);
    }

    public final Iterator getValueIterator() {
        return this.iterator.toFirst();
    }

    @Override
    protected final String toString(int[] val) {
        return Arrays.toString(val);
    }

    public final class Iterator
    implements XIntIterator {
        int current = 0;

        public int[] array() {
            return (int[])XbufIntArrayField.this.getValue();
        }

        public final boolean hasNext() {
            int[] value = (int[])XbufIntArrayField.this.getValue();
            return value != null && this.current < value.length;
        }

        public int next() {
            int[] val = (int[])XbufIntArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            return ((int[])XbufIntArrayField.this.getValue())[this.current++];
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final Iterator toFirst() {
            this.current = 0;
            return this;
        }
    }
}

