/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.lang.XByteArrayIterator;
import com.neeve.lang.XByteIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableLengthField;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class XbufByteArrayField
extends XbufVariableLengthField<byte[]> {
    private final Iterator iterator = new Iterator();

    private XbufByteArrayField(short id, String name) {
        super(XbufField.Type.BYTE_ARRAY, id, name);
    }

    public static XbufByteArrayField create(short id, String name) {
        return new XbufByteArrayField(id, name);
    }

    @Override
    protected final int serializedLength(byte[] val) {
        return val == null ? 0 : val.length * 1;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, byte[] val) {
        buffer.putFrom(offset, val, 0, val.length);
        return val.length;
    }

    @Override
    protected final byte[] deserialize(PktBuffer buffer, int offset, int length) {
        byte[] val = new byte[length];
        if (length > 0) {
            buffer.getTo(offset, val, 0, val.length);
        }
        return val;
    }

    public final void setValues(byte[] values) {
        super.setValue(values);
    }

    public final byte[] getValuesAsArray() {
        return (byte[])super.getValue();
    }

    public final void setValuesFrom(XByteIterator val) {
        byte[] v;
        if (val instanceof Iterator) {
            v = ((Iterator)val).array();
        } else if (val instanceof XByteArrayIterator) {
            XByteArrayIterator a = (XByteArrayIterator)val;
            v = a.array();
            if (v.length != a.length()) {
                v = new byte[a.length()];
                System.arraycopy(a.array(), a.offset(), v, 0, a.length());
            }
        } else {
            int size = 0;
            val.toFirst();
            while (val.hasNext()) {
                ++size;
                val.next();
            }
            v = new byte[size];
            val.toFirst();
            for (int i = 0; i < v.length; ++i) {
                v[i] = val.next();
            }
        }
        this.setValue(v);
        val.toFirst();
    }

    public final void addValue(byte val) {
        byte[] vArray;
        byte[] existing = (byte[])this.getValue();
        if (this.getValue() == null) {
            vArray = new byte[1];
        } else {
            vArray = new byte[existing.length + 1];
            System.arraycopy(existing, 0, vArray, 0, existing.length);
            vArray[vArray.length - 1] = val;
        }
        this.setValue(vArray);
    }

    public final Iterator getValueIterator() {
        return this.iterator.toFirst();
    }

    @Override
    protected final String toString(byte[] val) {
        return Arrays.toString(val);
    }

    public final class Iterator
    implements XByteIterator {
        int current = 0;

        public byte[] array() {
            return (byte[])XbufByteArrayField.this.getValue();
        }

        public final boolean hasNext() {
            byte[] value = (byte[])XbufByteArrayField.this.getValue();
            return value != null && this.current < value.length;
        }

        public byte next() {
            byte[] val = (byte[])XbufByteArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            return ((byte[])XbufByteArrayField.this.getValue())[this.current++];
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final Iterator toFirst() {
            this.current = 0;
            return this;
        }
    }
}

