/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.lang.XBooleanArrayIterator;
import com.neeve.lang.XBooleanIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableLengthField;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class XbufBooleanArrayField
extends XbufVariableLengthField<boolean[]> {
    private final Iterator iterator = new Iterator();

    private XbufBooleanArrayField(short id, String name) {
        super(XbufField.Type.BOOLEAN_ARRAY, id, name);
    }

    public static XbufBooleanArrayField create(short id, String name) {
        return new XbufBooleanArrayField(id, name);
    }

    @Override
    protected final int serializedLength(boolean[] val) {
        return val == null ? 0 : val.length * 1;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, boolean[] val) {
        for (int i = 0; i < val.length; ++i) {
            buffer.put(offset + i, (byte)(val[i] ? 1 : 0));
        }
        return val.length;
    }

    @Override
    protected final boolean[] deserialize(PktBuffer buffer, int offset, int length) {
        boolean[] val = new boolean[length];
        for (int i = 0; i < length; ++i) {
            val[i] = buffer.get(offset + i) > 0;
        }
        return val;
    }

    public final void setValues(boolean[] values) {
        super.setValue(values);
    }

    public final boolean[] getValuesAsArray() {
        return (boolean[])super.getValue();
    }

    public final void setValuesFrom(XBooleanIterator val) {
        boolean[] v;
        if (val instanceof Iterator) {
            v = ((Iterator)val).array();
        } else if (val instanceof XBooleanArrayIterator) {
            XBooleanArrayIterator a = (XBooleanArrayIterator)val;
            v = a.array();
            if (v.length != a.length()) {
                v = new boolean[a.length()];
                System.arraycopy(a.array(), a.offset(), v, 0, a.length());
            }
        } else {
            int size = 0;
            val.toFirst();
            while (val.hasNext()) {
                ++size;
                val.next();
            }
            v = new boolean[size];
            val.toFirst();
            for (int i = 0; i < v.length; ++i) {
                v[i] = val.next();
            }
        }
        this.setValue(v);
        val.toFirst();
    }

    public final void addValue(boolean val) {
        boolean[] vArray;
        boolean[] existing = (boolean[])this.getValue();
        if (this.getValue() == null) {
            vArray = new boolean[1];
        } else {
            vArray = new boolean[existing.length + 1];
            System.arraycopy(existing, 0, vArray, 0, existing.length);
            vArray[vArray.length - 1] = val;
        }
        this.setValue(vArray);
    }

    public final Iterator getValueIterator() {
        return this.iterator.toFirst();
    }

    @Override
    protected final String toString(boolean[] val) {
        return Arrays.toString(val);
    }

    public final class Iterator
    implements XBooleanIterator {
        int current = 0;

        public boolean[] array() {
            return (boolean[])XbufBooleanArrayField.this.getValue();
        }

        public final boolean hasNext() {
            boolean[] value = (boolean[])XbufBooleanArrayField.this.getValue();
            return value != null && this.current < value.length;
        }

        public boolean next() {
            boolean[] val = (boolean[])XbufBooleanArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            return ((boolean[])XbufBooleanArrayField.this.getValue())[this.current++];
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final Iterator toFirst() {
            this.current = 0;
            return this;
        }
    }
}

