/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit;

import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmXMLParser;
import com.neeve.adm.AdmXMLWriter;
import com.neeve.adm.EAdmException;
import com.neeve.adm.test.unit.AdmXMLParserTest;
import com.neeve.build.codegen.CgResourceChangeTracker;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.test.UnitTest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AdmXMLWriterTest
extends UnitTest {
    private static File testSourceDir = null;
    public File tempDir = new File(AdmXMLWriterTest.getTestbedRoot(), "adm-xml-writer-test");
    private static final ProductInfo productInfo = ManifestProductInfo.loadProductInfo((String)"nvx-rumi-adm");

    @BeforeClass
    public static void setup() throws IOException {
        testSourceDir = new File(AdmXMLWriterTest.getProjectBaseDirectory(), "test/java/" + AdmXMLParserTest.class.getPackage().getName().replace(".", "/")).getCanonicalFile();
    }

    @Test
    public void testDirectivesPersistence() throws IOException, EAdmException, ParserConfigurationException, SAXException {
        String encValue;
        StringBuilder sb;
        AdmModel model = this.parseModel("full_model.xml");
        if (!model.validateModel(sb = new StringBuilder())) {
            Assert.fail((String)("Model validation failed: " + sb.toString()));
        }
        this.tempDir.mkdirs();
        File targetFile = new File(this.tempDir, "persisted_model.xml");
        AdmXMLWriter.writeModel(model, targetFile);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(targetFile);
        NodeList directives = doc.getElementsByTagName("directives");
        if (directives == null || directives.getLength() == 0) {
            Assert.fail((String)"directives not persisted");
        }
        Element directivesElement = (Element)directives.item(0);
        HashMap<String, String> directivesMap = new HashMap<String, String>();
        NodeList directiveElements = directivesElement.getChildNodes();
        for (int i = 0; i < directiveElements.getLength(); ++i) {
            Node childNode = directiveElements.item(i);
            if (childNode.getNodeType() != 1) continue;
            directivesMap.put(childNode.getNodeName(), childNode.getFirstChild().getNodeValue());
        }
        if (directivesMap.containsKey("apexStyle")) {
            Assert.fail((String)"apexStyle transient directive persisted");
        }
        if (directivesMap.containsKey("modelBundleOutputDir")) {
            Assert.fail((String)"modelBundleOutputDir transient directive persisted");
        }
        if (!directivesMap.containsKey("encodingType")) {
            Assert.fail((String)"encodingType non-transient directive not persisted");
        }
        if (!(encValue = (String)directivesMap.get("encodingType")).equals(AdmEncodingType.Xbuf.toString())) {
            Assert.fail((String)("encodingType non-transient directive incorrectly persisted" + encValue));
        }
    }

    private final AdmModel parseModel(String modelFileName) throws EAdmException {
        URL modelUrl = ((Object)((Object)this)).getClass().getResource(modelFileName);
        CgResourceChangeTracker parseContext = CgResourceChangeTracker.forNewCodeGeneration((File)testSourceDir.getAbsoluteFile(), (URL)modelUrl, null, (ProductInfo)productInfo);
        return AdmXMLParser.parse(((Object)((Object)this)).getClass().getResource(modelFileName), testSourceDir, null, parseContext);
    }
}

