/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit;

import com.neeve.build.codegen.CgResourceChangeTracker;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.test.UnitTest;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AdmParseContextTest
extends UnitTest {
    private static final File folder = new File(AdmParseContextTest.getTestbedRoot(), "adm-parse-context-test");
    private static File destModelFile = null;
    private static final ProductInfo productInfo = ManifestProductInfo.loadProductInfo((String)"nvx-rumi-adm");

    @BeforeClass
    public static void setUpClass() {
        if (!folder.exists()) {
            folder.mkdirs();
        }
        destModelFile = new File(folder, "test_parse_context.xml");
    }

    @Before
    public void setUp() throws IOException {
        try (PrintWriter writer = new PrintWriter(destModelFile);){
            writer.print("This is ou mock model file. The contents is not relevant.");
        }
    }

    @Test
    public void testChangingInputOptionsChangesContext() throws Exception {
        HashMap<String, String> parseInfoMock = new HashMap<String, String>();
        parseInfoMock.put("testChangingInputOptionsChangesContext", "testChangingInputOptionsChangesContext");
        CgResourceChangeTracker context = CgResourceChangeTracker.forNewCodeGeneration((File)folder, (URL)destModelFile.toURI().toURL(), parseInfoMock, (ProductInfo)productInfo);
        context.save();
        parseInfoMock.put("additional key makes a difference", "so context will change");
        CgResourceChangeTracker loadedContext = CgResourceChangeTracker.fromPreviousCodeGeneration((File)folder, (URL)destModelFile.toURI().toURL(), parseInfoMock, (ProductInfo)productInfo);
        if (loadedContext.isChanged()) {
            Assert.assertTrue((String)"Context reported as unchanged.", (boolean)loadedContext.isChanged());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangingModelFileChangesContext() throws Exception {
        HashMap<String, String> parseInfoMock = new HashMap<String, String>();
        parseInfoMock.put("testChangingModelFileChangesContext", "testChangingModelFileChangesContext");
        CgResourceChangeTracker context = CgResourceChangeTracker.forNewCodeGeneration((File)folder, (URL)destModelFile.toURI().toURL(), parseInfoMock, (ProductInfo)productInfo);
        context.save();
        try (PrintWriter writer = new PrintWriter(destModelFile);){
            writer.println("We overwrite model file which should be detected as model change");
        }
        CgResourceChangeTracker loadedContext = CgResourceChangeTracker.fromPreviousCodeGeneration((File)folder, (URL)destModelFile.toURI().toURL(), parseInfoMock, (ProductInfo)productInfo);
        if (loadedContext.isChanged()) {
            Assert.assertTrue((String)"Context reported as unchanged.", (boolean)loadedContext.isChanged());
        }
    }

    @Test
    public void testNotChangingAnythingReportsUnchanged() throws Exception {
        HashMap<String, String> parseInfoMock = new HashMap<String, String>();
        parseInfoMock.put("testNotChangingAnythingReportsUnchanged", "testNotChangingAnythingReportsUnchanged");
        CgResourceChangeTracker context = CgResourceChangeTracker.forNewCodeGeneration((File)folder, (URL)destModelFile.toURI().toURL(), parseInfoMock, (ProductInfo)productInfo);
        context.save();
        CgResourceChangeTracker loadedContext = CgResourceChangeTracker.fromPreviousCodeGeneration((File)folder, (URL)destModelFile.toURI().toURL(), parseInfoMock, (ProductInfo)productInfo);
        if (loadedContext.isChanged()) {
            Assert.assertFalse((String)"Context reported as changed.", (boolean)loadedContext.isChanged());
        }
    }
}

